/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.console;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.launching.DebugConsoleMonitor;
import org.eclipse.php.internal.debug.core.launching.PHPHyperLink;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.ui.console.PHPFileLink;
import org.eclipse.ui.console.IHyperlink;

public class PHPConsoleListener
implements IPHPConsoleEventListener {
    protected ILaunch fLaunch;
    protected DebugConsoleMonitor fConsoleMonitor;
    protected PHPHyperLink fPHPHyperLink;

    public void init(ILaunch iLaunch, DebugConsoleMonitor debugConsoleMonitor, PHPHyperLink pHPHyperLink) {
        this.fLaunch = iLaunch;
        this.fConsoleMonitor = debugConsoleMonitor;
        this.fPHPHyperLink = pHPHyperLink;
    }

    public void handleEvent(DebugError debugError) {
        IHyperlink iHyperlink = this.createLink(debugError);
        String string = debugError.toString().trim();
        this.fPHPHyperLink.addLink(iHyperlink, string, string.length() - debugError.getErrorTextLength());
        this.fConsoleMonitor.append(String.valueOf(debugError.toString()) + '\n');
    }

    protected IHyperlink createLink(DebugError debugError) {
        PHPFileLink pHPFileLink = null;
        String string = debugError.getFullPathName();
        int n = debugError.getLineNumber();
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
        if (iFile == null) {
            Object object = null;
            if (ExternalFilesRegistry.getInstance().isEntryExist(new Path(string).toOSString())) {
                object = ExternalFilesRegistry.getInstance().getFileEntry(new Path(string).toOSString());
            } else {
                iFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(string);
                if (iFile != null) {
                    object = iFile;
                } else {
                    File file;
                    PHPFileData pHPFileData = null;
                    try {
                        pHPFileData = PHPWorkspaceModelManager.getInstance().getModelForFile(string);
                    }
                    catch (Exception exception) {}
                    object = pHPFileData != null ? pHPFileData : ((file = new File(string)).exists() ? file : ExternalFileWrapper.createFile((String)string));
                }
            }
            if (object != null) {
                pHPFileLink = new PHPFileLink(object, -1, -1, n);
            }
        } else {
            pHPFileLink = new PHPFileLink(iFile, -1, -1, n);
        }
        return pHPFileLink;
    }
}

