/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.wizards.ClosableWizardDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeEditDialog;
import org.eclipse.php.internal.debug.ui.wizards.PHPExeWizard;
import org.eclipse.php.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledPHPsBlock {
    private static final String[] PHP_CANDIDATE_BIN = new String[]{"php", "php-cli", "php-cgi", "php.exe", "php-cli.exe", "php-cgi.exe"};
    private Button fAddButton;
    private Composite fControl;
    private Button fEditButton;
    private TableViewer fPHPExeList;
    private final List<PHPexeItem> fPHPexes = new ArrayList<PHPexeItem>();
    private Button fRemoveButton;
    private boolean fResizingTable = false;
    private Button fSearchButton;
    private Button fSetDefaultButton;
    private final ListenerList fSelectionListeners = new ListenerList(1);
    private int fSortColumn = 0;
    private float fWeight1 = 0.375f;
    private float fWeight2 = 0.25f;
    private float fWeight3 = 0.375f;
    PHPexes phpExes = PHPexes.getInstance();

    private void addPHPexe() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        PHPexeItem pHPexeItem = null;
        PHPExeWizard pHPExeWizard = new PHPExeWizard(this.phpExes.getAllItems());
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)pHPExeWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
        pHPexeItem = (PHPexeItem)pHPExeWizard.getRootFragment().getWizardModel().getObject("phpExe");
        this.fPHPexes.add(pHPexeItem);
        this.phpExes.addItem(pHPexeItem);
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.add((Object)iSelectionChangedListener);
    }

    protected void configureTableResizing(final Composite composite, final Composite composite2, final Table table, final TableColumn tableColumn, final TableColumn tableColumn2, final TableColumn tableColumn3) {
        composite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                InstalledPHPsBlock.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2, tableColumn3);
            }
        });
        table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                table.removeListener(9, (Listener)this);
                InstalledPHPsBlock.this.resizeTable(composite, composite2, table, tableColumn, tableColumn2, tableColumn3);
            }
        });
        tableColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight1 = InstalledPHPsBlock.this.getColumnWeight(0);
                }
            }
        });
        tableColumn2.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn2.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight2 = InstalledPHPsBlock.this.getColumnWeight(1);
                }
            }
        });
        tableColumn3.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent controlEvent) {
                if (tableColumn3.getWidth() > 0 && !InstalledPHPsBlock.this.fResizingTable) {
                    InstalledPHPsBlock.this.fWeight3 = InstalledPHPsBlock.this.getColumnWeight(2);
                }
            }
        });
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        Font font = composite.getFont();
        composite2.setFont(font);
        this.fControl = composite2;
        Label label = new Label(composite2, 0);
        label.setText(PHPDebugUIMessages.InstalledPHPsBlock_15);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        Table table = new Table(composite2, 67586);
        gridData = new GridData(1808);
        table.setLayoutData((Object)gridData);
        table.setFont(font);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        table.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PHPDebugUIMessages.InstalledPHPsBlock_0);
        tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstalledPHPsBlock.this.sortByName();
            }
        });
        TableColumn tableColumn2 = new TableColumn(table, 0);
        tableColumn2.setText(PHPDebugUIMessages.InstalledPHPsBlock_17);
        tableColumn2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstalledPHPsBlock.this.sortByDebugger();
            }
        });
        TableColumn tableColumn3 = new TableColumn(table, 0);
        tableColumn3.setText(PHPDebugUIMessages.InstalledPHPsBlock_1);
        tableColumn3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstalledPHPsBlock.this.sortByLocation();
            }
        });
        this.fPHPExeList = new CheckboxTableViewer(table);
        this.fPHPExeList.setLabelProvider((IBaseLabelProvider)new PHPExeLabelProvider());
        this.fPHPExeList.setContentProvider((IContentProvider)new PHPsContentProvider());
        this.fPHPExeList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                InstalledPHPsBlock.this.enableButtons();
            }
        });
        this.fPHPExeList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                if (!InstalledPHPsBlock.this.fPHPExeList.getSelection().isEmpty()) {
                    InstalledPHPsBlock.this.editPHPexe();
                }
            }
        });
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.character == '\u007f' && keyEvent.stateMask == 0) {
                    InstalledPHPsBlock.this.removePHPexes();
                }
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(2));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        this.fAddButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_3);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.addPHPexe();
            }
        });
        this.fEditButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_4);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.editPHPexe();
            }
        });
        this.fRemoveButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_5);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.removePHPexes();
            }
        });
        this.fSetDefaultButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_setDefault);
        this.fSetDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPexeItem pHPexeItem = (PHPexeItem)((IStructuredSelection)InstalledPHPsBlock.this.fPHPExeList.getSelection()).getFirstElement();
                InstalledPHPsBlock.this.phpExes.setDefaultItem(pHPexeItem);
                InstalledPHPsBlock.this.commitChanges();
                InstalledPHPsBlock.this.setPHPs(InstalledPHPsBlock.this.phpExes.getAllItems());
            }
        });
        Label label2 = new Label(composite3, 0);
        label2.setVisible(false);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.verticalAlignment = 1;
        gridData2.heightHint = 4;
        label2.setLayoutData((Object)gridData2);
        this.fSearchButton = this.createPushButton(composite3, PHPDebugUIMessages.InstalledPHPsBlock_6);
        this.fSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                InstalledPHPsBlock.this.search();
            }
        });
        this.configureTableResizing(composite2, composite3, table, tableColumn, tableColumn2, tableColumn3);
        this.fillWithWorkspacePHPs();
        this.sortByDebugger();
        this.enableButtons();
    }

    protected Button createPushButton(Composite composite, String string) {
        return SWTUtil.createPushButton((Composite)composite, (String)string, null);
    }

    private void editPHPexe() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem pHPexeItem = (PHPexeItem)iStructuredSelection.getFirstElement();
        if (pHPexeItem == null) {
            return;
        }
        PHPexeItem pHPexeItem2 = new PHPexeItem(pHPexeItem.getName(), pHPexeItem.getExecutable(), pHPexeItem.getINILocation(), pHPexeItem.getDebuggerID(), pHPexeItem.isEditable());
        PHPExeEditDialog pHPExeEditDialog = new PHPExeEditDialog(this.getShell(), pHPexeItem2, this.phpExes.getAllItems());
        pHPExeEditDialog.setTitle(PHPDebugUIMessages.InstalledPHPsBlock_8);
        if (pHPExeEditDialog.open() != 0) {
            return;
        }
        pHPexeItem.setName(pHPexeItem2.getName());
        pHPexeItem.setExecutable(pHPexeItem2.getExecutable());
        pHPexeItem.setINILocation(pHPexeItem2.getINILocation());
        pHPexeItem.setDebuggerID(pHPexeItem2.getDebuggerID());
        this.fPHPExeList.refresh();
        this.commitChanges();
    }

    private void enableButtons() {
        PHPexeItem pHPexeItem;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPExeList.getSelection();
        Object[] objectArray = iStructuredSelection.toArray();
        boolean bl = true;
        int n = 0;
        while (bl && n < objectArray.length) {
            pHPexeItem = (PHPexeItem)objectArray[n];
            bl &= pHPexeItem.isEditable();
            ++n;
        }
        n = iStructuredSelection.size();
        this.fRemoveButton.setEnabled(bl && n > 0);
        pHPexeItem = (PHPexeItem)((IStructuredSelection)this.fPHPExeList.getSelection()).getFirstElement();
        this.fSetDefaultButton.setEnabled(n == 1 && pHPexeItem != null && !pHPexeItem.isDefault());
    }

    protected void fillWithWorkspacePHPs() {
        PHPexeItem[] pHPexeItemArray = this.phpExes.getAllItems();
        this.setPHPs(pHPexeItemArray);
    }

    private float getColumnWeight(int n) {
        Table table;
        int n2 = table.getSize().x;
        table = this.fPHPExeList.getTable();
        int n3 = table.getColumn(n).getWidth();
        if (n2 > n3) {
            return (float)n3 / (float)n2;
        }
        return 0.33333334f;
    }

    public Control getControl() {
        return this.fControl;
    }

    public PHPexeItem[] getPHPs() {
        return this.fPHPexes.toArray(new PHPexeItem[this.fPHPexes.size()]);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public boolean isDuplicateName(String string) {
        int n = 0;
        while (n < this.fPHPexes.size()) {
            PHPexeItem pHPexeItem = this.fPHPexes.get(n);
            if (pHPexeItem.getName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void removePHPexes() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fPHPExeList.getSelection();
        PHPexeItem[] pHPexeItemArray = new PHPexeItem[iStructuredSelection.size()];
        Iterator iterator = iStructuredSelection.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            pHPexeItemArray[n] = (PHPexeItem)iterator.next();
            ++n;
        }
        this.removePHPs(pHPexeItemArray);
        this.commitChanges();
    }

    public void commitChanges() {
        this.phpExes.save();
    }

    public void removePHPs(PHPexeItem[] pHPexeItemArray) {
        PHPexeItem[] pHPexeItemArray2 = pHPexeItemArray;
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem pHPexeItem = pHPexeItemArray2[n2];
            this.fPHPexes.remove(pHPexeItem);
            this.phpExes.removeItem(pHPexeItem);
            ++n2;
        }
        this.fPHPExeList.refresh();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.fSelectionListeners.remove((Object)iSelectionChangedListener);
    }

    private void resizeTable(Composite composite, Composite composite2, Table table, TableColumn tableColumn, TableColumn tableColumn2, TableColumn tableColumn3) {
        Point point;
        Rectangle rectangle;
        this.fResizingTable = true;
        int n = -1;
        int n2 = -1;
        if (composite.isVisible()) {
            rectangle = composite.getClientArea();
            n = rectangle.width;
            n2 = rectangle.height;
        } else {
            rectangle = composite.computeSize(-1, -1);
            n = rectangle.x;
            n2 = rectangle.y;
        }
        rectangle = table.computeSize(-1, -1);
        int n3 = n - 2 * table.getBorderWidth();
        if (rectangle.y > n2) {
            point = table.getVerticalBar().getSize();
            n3 -= point.x;
        }
        point = table.getSize();
        if (point.x > (n3 -= composite2.getSize().x)) {
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
            tableColumn3.setWidth(Math.round((float)n3 * this.fWeight3));
            table.setSize(n3, n2);
        } else {
            table.setSize(n3, n2);
            tableColumn.setWidth(Math.round((float)n3 * this.fWeight1));
            tableColumn2.setWidth(Math.round((float)n3 * this.fWeight2));
            tableColumn3.setWidth(Math.round((float)n3 * this.fWeight3));
        }
        this.fResizingTable = false;
    }

    public void restoreColumnSettings(IDialogSettings iDialogSettings, String string) {
        this.fWeight1 = this.restoreColumnWeight(iDialogSettings, string, 0);
        this.fWeight2 = this.restoreColumnWeight(iDialogSettings, string, 1);
        this.fWeight3 = this.restoreColumnWeight(iDialogSettings, string, 2);
        this.fPHPExeList.getTable().layout(true);
        try {
            this.fSortColumn = iDialogSettings.getInt(String.valueOf(string) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByDebugger();
                break;
            }
            case 3: {
                this.sortByLocation();
                break;
            }
            case 4: {
                this.sortByType();
            }
        }
    }

    private float restoreColumnWeight(IDialogSettings iDialogSettings, String string, int n) {
        try {
            return iDialogSettings.getFloat(String.valueOf(string) + ".column" + n);
        }
        catch (NumberFormatException numberFormatException) {
            switch (n) {
                case 1: {
                    return 0.25f;
                }
            }
            return 0.375f;
        }
    }

    public void saveColumnSettings(IDialogSettings iDialogSettings, String string) {
        int n = 0;
        while (n < 3) {
            iDialogSettings.put(String.valueOf(string) + ".column" + n, this.getColumnWeight(n));
            ++n;
        }
        iDialogSettings.put(String.valueOf(string) + ".sortColumn", this.fSortColumn);
    }

    protected void search() {
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell());
        directoryDialog.setMessage(PHPDebugUIMessages.InstalledPHPsBlock_9);
        directoryDialog.setText(PHPDebugUIMessages.InstalledPHPsBlock_10);
        String string = directoryDialog.open();
        if (string == null) {
            return;
        }
        final HashSet<File> hashSet = new HashSet<File>();
        Iterator<PHPexeItem> iterator = this.fPHPexes.iterator();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next().getExecutable().getParentFile());
        }
        final File file = new File(string);
        final ArrayList arrayList = new ArrayList();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) {
                iProgressMonitor.beginTask(PHPDebugUIMessages.InstalledPHPsBlock_11, -1);
                InstalledPHPsBlock.this.search(file, arrayList, hashSet, iProgressMonitor);
                iProgressMonitor.done();
            }
        };
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, true, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            PHPDebugUIPlugin.log(invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        if (arrayList.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.InstalledPHPsBlock_12, (String)MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_13, string));
        } else {
            for (File file2 : arrayList) {
                PHPexeItem pHPexeItem = new PHPexeItem(null, file2, null, PHPDebuggersRegistry.getDefaultDebuggerId(), true);
                String string2 = new String(pHPexeItem.getName());
                int n = 1;
                while (this.isDuplicateName(string2)) {
                    string2 = String.valueOf(pHPexeItem.getName()) + '[' + n++ + ']';
                }
                if (pHPexeItem.getExecutable() == null) continue;
                this.fPHPexes.add(pHPexeItem);
                this.phpExes.addItem(pHPexeItem);
                this.fPHPExeList.refresh();
            }
        }
    }

    protected void search(File file, List<File> list, Set<File> set, IProgressMonitor iProgressMonitor) {
        Object object;
        String[] stringArray;
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (!set.contains(file) && (stringArray = InstalledPHPsBlock.findPHPExecutable(file)) != null) {
            list.add((File)stringArray);
        }
        if ((stringArray = file.list()) == null) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = stringArray2[n2];
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            File file2 = new File(file, (String)object);
            if (file2.isDirectory()) {
                try {
                    iProgressMonitor.subTask(MessageFormat.format(PHPDebugUIMessages.InstalledPHPsBlock_14, Integer.toString(list.size()), file2.getCanonicalPath()));
                }
                catch (IOException iOException) {}
                if (!set.contains(file2)) {
                    if (iProgressMonitor.isCanceled()) {
                        return;
                    }
                    File file3 = InstalledPHPsBlock.findPHPExecutable(file2);
                    if (file3 != null) {
                        list.add(file3);
                        set.add(file2);
                    }
                    arrayList.add(file2);
                }
            }
            ++n2;
        }
        while (!arrayList.isEmpty()) {
            object = (File)arrayList.remove(0);
            this.search((File)object, list, set, iProgressMonitor);
            if (!iProgressMonitor.isCanceled()) continue;
            return;
        }
    }

    private static File findPHPExecutable(File file) {
        String[] stringArray = PHP_CANDIDATE_BIN;
        int n = PHP_CANDIDATE_BIN.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            File file2 = new File(file, string);
            if (file2.exists() && !file2.isDirectory()) {
                return file2;
            }
            ++n2;
        }
        return null;
    }

    protected void setPHPs(PHPexeItem[] pHPexeItemArray) {
        this.fPHPexes.clear();
        PHPexeItem[] pHPexeItemArray2 = pHPexeItemArray;
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            PHPexeItem pHPexeItem = pHPexeItemArray2[n2];
            this.fPHPexes.add(pHPexeItem);
            ++n2;
        }
        this.fPHPExeList.setInput(this.fPHPexes);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                InstalledPHPsBlock.this.fPHPExeList.refresh();
            }
        });
    }

    private void sortByLocation() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    return pHPexeItem.getExecutable().getAbsolutePath().compareToIgnoreCase(pHPexeItem2.getExecutable().getAbsolutePath());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void sortByDebugger() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    String string = PHPDebuggersRegistry.getDebuggerName((String)pHPexeItem.getDebuggerID());
                    String string2 = PHPDebuggersRegistry.getDebuggerName((String)pHPexeItem2.getDebuggerID());
                    return string2.compareToIgnoreCase(string);
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    private void sortByName() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    private void sortByType() {
        this.fPHPExeList.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object, Object object2) {
                if (object instanceof PHPexeItem && object2 instanceof PHPexeItem) {
                    String string;
                    PHPexeItem pHPexeItem = (PHPexeItem)object;
                    PHPexeItem pHPexeItem2 = (PHPexeItem)object2;
                    String string2 = pHPexeItem.getName();
                    int n = string2.compareToIgnoreCase(string = pHPexeItem2.getName());
                    if (n != 0) {
                        return n;
                    }
                    return pHPexeItem.getName().compareToIgnoreCase(pHPexeItem2.getName());
                }
                return super.compare(viewer, object, object2);
            }

            public boolean isSorterProperty(Object object, String string) {
                return true;
            }
        });
        this.fSortColumn = 3;
    }

    class PHPExeLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IFontProvider {
        PHPExeLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            if (object instanceof PHPexeItem) {
                PHPexeItem pHPexeItem = (PHPexeItem)object;
                switch (n) {
                    case 0: {
                        if (this.isDefault(object)) {
                            return String.valueOf(pHPexeItem.getName()) + ' ' + PHPDebugUIMessages.PHPsPreferencePage_WorkspaceDefault;
                        }
                        return pHPexeItem.getName();
                    }
                    case 1: {
                        String string = PHPDebuggersRegistry.getDebuggerName((String)pHPexeItem.getDebuggerID());
                        if (string == null) {
                            string = "";
                        }
                        return string;
                    }
                    case 2: {
                        return pHPexeItem.getExecutable().getAbsolutePath();
                    }
                }
            }
            return object.toString();
        }

        public Font getFont(Object object) {
            if (this.isDefault(object)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
            return null;
        }

        private boolean isDefault(Object object) {
            if (object instanceof PHPexeItem) {
                return ((PHPexeItem)object).isDefault();
            }
            return false;
        }
    }

    class PHPsContentProvider
    implements IStructuredContentProvider {
        PHPsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            return InstalledPHPsBlock.this.fPHPexes.toArray();
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }
}

