/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.archiveoperations;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.internal.ejb.archiveoperations.IEJBClientJarFileMoveDataModelProperties;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class EJBClientJarFileMoveOperation
extends AbstractDataModelOperation
implements IEJBClientJarFileMoveDataModelProperties {
    protected IProject clientProject;
    protected IProject ejbProject;
    protected IWorkspace workspace;
    protected IProgressMonitor monitor;
    protected IProgressMonitor moveResourceMonitor;
    protected Map javaFilesToMove = new HashMap();

    public EJBClientJarFileMoveOperation(IDataModel model) {
        super(model);
        this.initialize();
    }

    public IStatus execute(IProgressMonitor aMonitor, IAdaptable info) throws ExecutionException {
        this.monitor = aMonitor;
        return this.moveRequiredFiles();
    }

    protected void initialize() {
        this.ejbProject = this.getEJBProject(this.model.getStringProperty("IEJBClientJarFileMoveDataModelProperties.EJB_PROJECT_NAME"));
        if (this.ejbProject == null) {
            return;
        }
        this.workspace = this.ejbProject.getWorkspace();
        this.clientProject = this.workspace.getRoot().getProject(this.model.getStringProperty("IEJBClientJarFileMoveDataModelProperties.CLIENT_PROJECT_NAME"));
        this.javaFilesToMove = (Map)this.model.getProperty("IEJBClientJarFileMoveDataModelProperties.FILES_TO_MOVE_MAP");
    }

    private IStatus moveRequiredFiles() {
        IStatus status = OK_STATUS;
        try {
            this.moveResourceMonitor = this.createSubProgressMonitor(1);
            for (Map.Entry entry : this.javaFilesToMove.entrySet()) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)entry.getKey();
                Set types = (Set)entry.getValue();
                try {
                    if (packageFragmentRoot.getKind() == 1) {
                        this.moveFiles(packageFragmentRoot, types);
                        continue;
                    }
                    this.moveClassFiles(packageFragmentRoot, types);
                }
                catch (JavaModelException e) {
                    Logger.getLogger().logError((Throwable)e);
                }
            }
            IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)this.clientProject);
            javaProject.close();
            javaProject.open(null);
        }
        catch (CoreException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return status;
    }

    private void moveFiles(IPackageFragmentRoot packageFragmentRoot, Set types) throws CoreException {
        IFile file2 = null;
        int leadSegmentsToTruncate = -1;
        IFolder sourceSourceFolder = this.getSourceFolder(packageFragmentRoot);
        if (sourceSourceFolder == null) {
            return;
        }
        IFolder targetSourceFolder = this.getOrCreateTargetSourceFolder(sourceSourceFolder);
        if (targetSourceFolder == null) {
            return;
        }
        IPath sourceFolderPath = targetSourceFolder.getFullPath();
        try {
            leadSegmentsToTruncate = packageFragmentRoot.getUnderlyingResource().getFullPath().segmentCount();
        }
        catch (JavaModelException ex) {
            Logger.getLogger().logError((Throwable)ex);
            return;
        }
        for (IFile file2 : types) {
            IPath relPath = file2.getFullPath().removeFirstSegments(leadSegmentsToTruncate);
            IPath newPath = sourceFolderPath.append(relPath);
            this.mkdirs(newPath, this.workspace.getRoot());
            IFile existing = this.workspace.getRoot().getFile(newPath);
            if (existing.exists()) continue;
            file2.move(newPath, true, this.moveResourceMonitor);
        }
    }

    private IFolder getOrCreateTargetSourceFolder(IFolder sourceSourceFolder) throws CoreException {
        IFolder targetFolder = this.clientProject.getFolder(sourceSourceFolder.getProjectRelativePath());
        if (targetFolder == null || !targetFolder.exists()) {
            this.mkFolders(targetFolder.getFullPath(), this.workspace.getRoot());
            JemProjectUtilities.appendJavaClassPath((IProject)this.clientProject, (IClasspathEntry)JavaCore.newSourceEntry((IPath)targetFolder.getFullPath()));
        }
        return targetFolder;
    }

    protected void mkFolders(IPath newPath, IWorkspaceRoot root) throws CoreException {
        if (newPath.segmentCount() <= 1) {
            return;
        }
        IFolder folder = root.getFolder(newPath);
        IPath parentPath = newPath.removeLastSegments(1);
        if (!folder.exists()) {
            this.mkFolders(parentPath, root);
            folder.create(true, true, null);
        }
    }

    private IFolder getSourceFolder(IPackageFragmentRoot packageFragmentRoot) {
        IResource res = null;
        try {
            res = packageFragmentRoot.getUnderlyingResource();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (res != null && res instanceof IFolder) {
            return (IFolder)res;
        }
        return null;
    }

    private void moveClassFiles(IPackageFragmentRoot packageFragmentRoot, Set types) throws CoreException {
        IFolder folder = this.clientProject.getFolder("imported_classes");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        try {
            JemProjectUtilities.appendJavaClassPath((IProject)this.clientProject, (IClasspathEntry)JavaCore.newLibraryEntry((IPath)folder.getFullPath(), null, null, (boolean)true));
        }
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
        }
        this.moveFiles(packageFragmentRoot, types);
    }

    protected void mkdirs(IPath newPath, IWorkspaceRoot root) throws CoreException {
        if (newPath.segmentCount() <= 2) {
            return;
        }
        IPath parentPath = newPath.removeLastSegments(1);
        IFolder folder = root.getFolder(parentPath);
        if (!folder.exists()) {
            this.mkdirs(parentPath, root);
            folder.create(true, true, null);
        }
    }

    protected IProject getEJBProject(String aProjectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(aProjectName);
    }

    protected IProgressMonitor createSubProgressMonitor(int ticks) {
        return new SubProgressMonitor(this.monitor, ticks);
    }
}

