/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.validation.caret;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.parts.DocumentEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.BasicPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IETablePositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionMediator;
import org.eclipse.jst.pagedesigner.validation.caret.IPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.IValidationRule;
import org.eclipse.jst.pagedesigner.validation.caret.JSFRootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.RootContainerPositionRule;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.eclipse.jst.pagedesigner.validation.caret.WhitespacePositionMoveRule;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultPositionValidator
implements IPositionMediator {
    private List _rules = new ArrayList();
    protected final ActionData _actionData;

    public ActionData getActionData() {
        return this._actionData;
    }

    protected DefaultPositionValidator(ActionData actionData) {
        this._actionData = actionData;
        this.initRules();
    }

    protected void initRules() {
        this._rules.clear();
        this.addRule(new BasicPositionRule(this, this._actionData));
        this.addRule(new IETablePositionRule(this, this._actionData));
        this.addRule(new RootContainerPositionRule(this, this._actionData));
        this.addRule(new JSFRootContainerPositionRule(this, this._actionData));
        this.addRule(new WhitespacePositionMoveRule(this, this._actionData));
    }

    public List getRules() {
        return Collections.unmodifiableList(this._rules);
    }

    protected void addRule(IValidationRule rule) {
        this._rules.add(rule);
    }

    public boolean hasEditableArea(Target target) {
        boolean result = true;
        List rules = this.getRules();
        int i = 0;
        int n = rules.size();
        while (i < n) {
            Object rule = rules.get(i);
            if (rule instanceof IPositionRule) {
                result &= ((IPositionRule)rule).hasEditableArea(target);
            }
            if (!result) break;
            ++i;
        }
        return result;
    }

    public boolean isEditable(Target target) {
        Node node = target.getNode();
        boolean result = true;
        List rules = this.getRules();
        int i = 0;
        int n = rules.size();
        while (i < n) {
            Object rule = rules.get(i);
            if (rule instanceof IPositionRule) {
                result &= ((IPositionRule)rule).isEditable(new Target(node));
            }
            if (!result) break;
            ++i;
        }
        return result;
    }

    public boolean isValidPosition(DesignPosition position) {
        return this.isValidPosition(DOMPositionHelper.toDOMPosition(position));
    }

    public boolean isValidPosition(IDOMPosition position) {
        position = EditHelper.ensureDOMPosition(position);
        boolean refLeft = true;
        boolean refRight = true;
        boolean result = true;
        if (position == null) {
            return false;
        }
        List rules = this.getRules();
        int i = 0;
        int n = rules.size();
        while (i < n) {
            Object rule = rules.get(i);
            if (rule instanceof IPositionRule) {
                if (!(result &= ((IPositionRule)rule).isEditable(new Target(position.getContainerNode())))) break;
                if (!position.isText()) {
                    Node node = EditModelQuery.getInstance().getSibling(position, true);
                    if (node != null & refLeft) {
                        refLeft &= ((IPositionRule)rule).canReference(new Target(node), false);
                    }
                    if ((node = EditModelQuery.getInstance().getSibling(position, false)) != null & refRight) {
                        refRight = ((IPositionRule)rule).canReference(new Target(node), true);
                    }
                    if (!(refLeft | refRight)) {
                        result = false;
                        break;
                    }
                }
            }
            ++i;
        }
        return result & (refLeft | refRight);
    }

    /*
     * Unable to fully structure code
     */
    public EditPart getEditableContainer(Target target) {
        part = target.getPart();
        if (!this.hasEditableArea(target)) ** GOTO lbl7
        return target.getPart();
        while (!this.hasEditableArea(target)) {
            part = part.getParent();
            target = new Target(part);
lbl7:
            // 2 sources

            if (part != null && !(part instanceof DocumentEditPart)) continue;
        }
        if (part instanceof DocumentEditPart && RootContainerPositionRule.hasBasicContainers((Document)part.getModel())) {
            node = RootContainerPositionRule.getBasicContainer((Document)part.getModel());
            part = Target.resolvePart(node);
        }
        return part;
    }

    public boolean canReference(Target target, boolean atRight) {
        boolean result = true;
        List rules = this.getRules();
        int i = 0;
        int n = rules.size();
        while (i < n) {
            Object rule = rules.get(i);
            if (rule instanceof IPositionRule) {
                result &= ((IPositionRule)rule).canReference(target, atRight);
            }
            if (!result) break;
            ++i;
        }
        return result;
    }
}

