/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.ui.actions.FindExceptionOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindImplementOccurrencesAction;
import org.eclipse.jdt.ui.actions.FindOccurrencesInFileAction;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.keys.IBindingService;

public class OccurrencesSearchGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private JavaEditor fEditor;
    private IActionBars fActionBars;
    private String fGroupId;
    private FindOccurrencesInFileAction fOccurrencesInFileAction;
    private FindExceptionOccurrencesAction fExceptionOccurrencesAction;
    private FindImplementOccurrencesAction fFindImplementorOccurrencesAction;
    static /* synthetic */ Class class$0;

    public OccurrencesSearchGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fGroupId = "group.search";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(site);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(site);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(site);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        ISelection selection = provider.getSelection();
        this.registerAction(this.fOccurrencesInFileAction, provider, selection);
        this.registerAction(this.fExceptionOccurrencesAction, provider, selection);
        this.registerAction(this.fFindImplementorOccurrencesAction, provider, selection);
    }

    public OccurrencesSearchGroup(JavaEditor editor) {
        this.fEditor = editor;
        this.fSite = this.fEditor.getSite();
        this.fGroupId = "group.find";
        this.fOccurrencesInFileAction = new FindOccurrencesInFileAction(this.fEditor);
        this.fOccurrencesInFileAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file");
        this.fOccurrencesInFileAction.setText(SearchMessages.Search_FindOccurrencesInFile_shortLabel);
        this.fEditor.setAction("SearchOccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
        this.fExceptionOccurrencesAction = new FindExceptionOccurrencesAction(this.fEditor);
        this.fExceptionOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences");
        this.fEditor.setAction("SearchExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
        this.fFindImplementorOccurrencesAction = new FindImplementOccurrencesAction(this.fEditor);
        this.fFindImplementorOccurrencesAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences");
        this.fEditor.setAction("SearchImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
    }

    private void registerAction(SelectionDispatchAction action, ISelectionProvider provider, ISelection selection) {
        action.update(selection);
        provider.addSelectionChangedListener((ISelectionChangedListener)action);
    }

    private IAction[] getActions() {
        IAction[] actions = new IAction[]{this.fOccurrencesInFileAction, this.fExceptionOccurrencesAction, this.fFindImplementorOccurrencesAction};
        return actions;
    }

    public void fillContextMenu(IMenuManager manager) {
        String menuText = SearchMessages.group_occurrences;
        String shortcut = this.getShortcutString();
        if (shortcut != null) {
            menuText = String.valueOf(menuText) + '\t' + shortcut;
        }
        MenuManager javaSearchMM = new MenuManager(menuText, "group.search");
        IAction[] actions = this.getActions();
        int i = 0;
        while (i < actions.length) {
            IAction action = actions[i];
            if (action.isEnabled()) {
                javaSearchMM.add(action);
            }
            ++i;
        }
        if (!javaSearchMM.isEmpty()) {
            manager.appendToGroup(this.fGroupId, (IContributionItem)javaSearchMM);
        }
    }

    private String getShortcutString() {
        IBindingService bindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((bindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return null;
        }
        return bindingService.getBestActiveBindingFormattedFor("org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file.quickMenu");
    }

    public void fillActionBars(IActionBars actionBars) {
        Assert.isNotNull((Object)actionBars);
        super.fillActionBars(actionBars);
        this.fActionBars = actionBars;
        this.updateGlobalActionHandlers();
    }

    public void dispose() {
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        if (provider != null) {
            this.disposeAction(this.fFindImplementorOccurrencesAction, provider);
            this.disposeAction(this.fExceptionOccurrencesAction, provider);
            this.disposeAction(this.fOccurrencesInFileAction, provider);
        }
        super.dispose();
        this.fFindImplementorOccurrencesAction = null;
        this.fExceptionOccurrencesAction = null;
        this.fOccurrencesInFileAction = null;
        this.updateGlobalActionHandlers();
    }

    private void updateGlobalActionHandlers() {
        if (this.fActionBars != null) {
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.OccurrencesInFile", (IAction)this.fOccurrencesInFileAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ExceptionOccurrences", (IAction)this.fExceptionOccurrencesAction);
            this.fActionBars.setGlobalActionHandler("org.eclipse.jdt.ui.actions.ImplementOccurrences", (IAction)this.fFindImplementorOccurrencesAction);
        }
    }

    private void disposeAction(ISelectionChangedListener action, ISelectionProvider provider) {
        if (action != null) {
            provider.removeSelectionChangedListener(action);
        }
    }
}

