/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui;

import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignerState;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.DesignerUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSourceWizardInfo;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIExtensionManifest;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSourceWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class NewDataSourceWizardBase
extends NewConnectionProfileWizard
implements IExecutableExtension {
    private String m_odaDataSourceId;
    private String m_odaDesignerPluginId;
    private Properties m_profileProps = new Properties();
    private DataSourceWizardPage m_startPage;
    private UIExtensionManifest m_manifest;
    private boolean m_isInDesignSession = false;
    private DataSourceDesign m_dataSourceDesign;
    private DesignerState m_responseDesignerState;
    private LinkedProfile m_linkedProfile;
    private static final String ODA_UI_EXT_PT = "org.eclipse.datatools.connectivity.oda.design.ui.dataSource";
    private static final String sm_className;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected NewDataSourceWizardBase(String odaDataSourceId) throws OdaException {
        this.initialize(odaDataSourceId, null, Messages.wizard_dataSource_defaultTitle);
    }

    protected NewDataSourceWizardBase() {
    }

    public void setInitializationData(IConfigurationElement newWizardElement, String classAttribute, Object data) throws CoreException {
        String odaDataSourceId = newWizardElement.getAttribute("profile");
        if (odaDataSourceId == null || odaDataSourceId.length() == 0) {
            throw new CoreException((IStatus)new Status(4, newWizardElement.getNamespaceIdentifier(), 0, Messages.wizard_missingDataSourceId, null));
        }
        String odaDesignerPluginId = newWizardElement.getNamespaceIdentifier();
        String wizardName = newWizardElement.getAttribute("name");
        try {
            this.initialize(odaDataSourceId, odaDesignerPluginId, wizardName);
        }
        catch (OdaException ex) {
            throw new CoreException((IStatus)new Status(4, odaDesignerPluginId, 0, Messages.wizard_invalidManifest, (Throwable)ex));
        }
    }

    protected void initialize(String odaDataSourceId, String odaDesignerId, String defaultWizardTitle) throws OdaException {
        this.m_odaDataSourceId = odaDataSourceId;
        this.initProviderID(this.m_odaDataSourceId);
        this.m_manifest = UIManifestExplorer.getInstance().getExtensionManifest(this.m_odaDataSourceId);
        if (this.m_manifest == null) {
            String errorMessage = Messages.bind((String)Messages.extension_missingManifestElement, (Object)ODA_UI_EXT_PT);
            OdaException odaEx = new OdaException(errorMessage);
            odaEx.initCause((Throwable)new IllegalArgumentException(this.m_odaDataSourceId));
            throw odaEx;
        }
        this.m_odaDesignerPluginId = odaDesignerId != null && odaDesignerId.length() > 0 ? odaDesignerId : this.m_manifest.getNamespace();
        DataSourceWizardInfo wizardInfo = this.m_manifest.getDataSourceWizardInfo();
        if (!$assertionsDisabled && wizardInfo == null) {
            throw new AssertionError();
        }
        this.setNeedsProgressMonitor(wizardInfo.includesProgressMonitor());
        String windowTitle = wizardInfo.getWindowTitle();
        if (windowTitle == null || windowTitle.length() == 0) {
            windowTitle = defaultWizardTitle;
        }
        this.setWindowTitle(windowTitle);
    }

    public void addPages() {
        if (this.getPageCount() > 0) {
            return;
        }
        super.addPages();
    }

    public void addCustomPages() {
        if (this.m_startPage != null) {
            return;
        }
        DataSourceWizardInfo wizardInfo = this.m_manifest.getDataSourceWizardInfo();
        if (!$assertionsDisabled && wizardInfo == null) {
            throw new AssertionError();
        }
        String wizardPageClassName = wizardInfo.getPageClassName();
        String pageTitle = wizardInfo.getPageTitle();
        this.m_startPage = this.createWizardPage(wizardPageClassName, pageTitle);
        this.addPage((IWizardPage)this.m_startPage);
    }

    protected DataSourceWizardPage createWizardPage(String wizardPageClassName, String pageTitle) {
        Object pageInstance = DesignerUtil.createInstanceWithStringArg(this.m_odaDesignerPluginId, wizardPageClassName, wizardPageClassName);
        if (!(pageInstance instanceof DataSourceWizardPage)) {
            throw new RuntimeException(Messages.bind((String)Messages.extension_mustInheritFromODAPage, (Object)wizardPageClassName, (Object)DataSourceWizardPage.class.getName()));
        }
        if (pageTitle != null && pageTitle.length() > 0) {
            ((DataSourceWizardPage)((Object)pageInstance)).setTitle(pageTitle);
        }
        return (DataSourceWizardPage)((Object)pageInstance);
    }

    public IWizardPage getCustomStartingPage() {
        return this.getCustomWizardPage();
    }

    protected DataSourceWizardPage getCustomWizardPage() {
        if (!$assertionsDisabled && this.m_startPage == null) {
            throw new AssertionError();
        }
        return this.m_startPage;
    }

    public void refreshPropertiesIfExist(Properties dataSourceProps) {
        if (dataSourceProps != null && !dataSourceProps.isEmpty()) {
            this.setInitialProperties(dataSourceProps);
        }
        this.getCustomWizardPage().refresh();
    }

    private void setInitialProperties(Properties props) {
        this.m_profileProps = props;
        this.getCustomWizardPage().setInitialProperties(this.m_profileProps);
    }

    public void setLinkedProfile(String profileName, File storageFile) {
        this.m_linkedProfile = new LinkedProfile(profileName, storageFile);
    }

    public void unsetLinkedProfile() {
        this.m_linkedProfile = null;
    }

    private boolean hasLinkToProfile() {
        return this.m_linkedProfile != null && this.m_linkedProfile.hasLinkAttributes();
    }

    public Properties getProfileProperties() {
        if (!$assertionsDisabled && this.m_profileProps == null) {
            throw new AssertionError();
        }
        this.m_profileProps = this.collectCustomProperties();
        return this.m_profileProps;
    }

    protected Properties collectCustomProperties() {
        if (this.m_startPage != null) {
            return this.m_startPage.collectCustomProperties();
        }
        return this.m_profileProps;
    }

    private static boolean hasLinkedProfileProperties(Properties customProperties) {
        if (customProperties.containsKey("OdaConnProfileName")) {
            return true;
        }
        return customProperties.containsKey("OdaConnProfileStorePath");
    }

    public String getOdaDataSourceId() {
        return this.m_odaDataSourceId;
    }

    public String getOdaDesignerId() {
        return this.m_odaDesignerPluginId;
    }

    public boolean isInOdaDesignSession() {
        return this.m_isInDesignSession;
    }

    public void setInOdaDesignSession(boolean value) {
        this.m_isInDesignSession = value;
    }

    boolean isSessionEditable() {
        return !this.hasLinkToProfile();
    }

    public boolean performFinish() {
        if (!this.isInOdaDesignSession()) {
            return super.performFinish();
        }
        try {
            this.finishDataSourceDesign();
        }
        catch (OdaException ex) {
            DesignerLogger logger = DesignerLogger.getInstance("org.eclipse.datatools.connectivity.oda.design.ui");
            logger.warning(sm_className, "performFinish", "Caught exception while finishDataSourceDesign.", ex);
            return false;
        }
        return true;
    }

    public DataSourceDesign finishDataSourceDesign() throws OdaException {
        if (!this.isInOdaDesignSession()) {
            throw new OdaException(Messages.common_notInDesignSession);
        }
        this.m_dataSourceDesign = this.createDataSourceDesign();
        this.setInOdaDesignSession(false);
        return this.m_dataSourceDesign;
    }

    public DataSourceDesign getDataSourceDesign() {
        if (!this.isInOdaDesignSession()) {
            return this.m_dataSourceDesign;
        }
        return null;
    }

    private DataSourceDesign createDataSourceDesign() throws OdaException {
        DataSourceDesign newDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        newDesign.setOdaExtensionId(this.getOdaDataSourceId());
        try {
            newDesign.setName(this.getProfileName());
            newDesign.setDisplayName(this.getProfileDescription());
        }
        catch (RuntimeException ex) {
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "createDataSourceDesign", "Caught exception while copying profile attributes from wizard profile page.", ex);
            newDesign.setName(this.getOdaDataSourceId());
        }
        Properties customPropertyValues = this.getProfileProperties();
        newDesign.setPublicProperties(DesignSessionUtil.createDataSourcePublicProperties(this.getOdaDataSourceId(), customPropertyValues));
        newDesign.setPrivateProperties(DesignSessionUtil.createDataSourceNonPublicProperties(this.getOdaDataSourceId(), customPropertyValues));
        if (this.hasLinkToProfile() && !NewDataSourceWizardBase.hasLinkedProfileProperties(customPropertyValues)) {
            if (!$assertionsDisabled && this.m_linkedProfile == null) {
                throw new AssertionError();
            }
            newDesign.setLinkedProfileName(this.m_linkedProfile.getProfileName());
            newDesign.setLinkedProfileStoreFile(this.m_linkedProfile.getStorageFile());
        }
        return this.getCustomWizardPage().finishDataSourceDesign(newDesign);
    }

    public DesignerState getResponseDesignerState() {
        return this.m_responseDesignerState;
    }

    protected void setResponseDesignerState(DesignerState customDesignerState) {
        this.m_responseDesignerState = customDesignerState;
    }

    static {
        $assertionsDisabled = !NewDataSourceWizardBase.class.desiredAssertionStatus();
        sm_className = NewDataSourceWizardBase.class.getName();
    }

    private class LinkedProfile {
        private String m_profileName;
        private File m_storageFile;

        public LinkedProfile(String profileName, File storageFile) {
            this.m_profileName = profileName;
            this.m_storageFile = storageFile;
        }

        public boolean hasLinkAttributes() {
            return this.m_profileName != null && this.m_profileName.length() > 0;
        }

        public String getProfileName() {
            return this.m_profileName;
        }

        public File getStorageFile() {
            return this.m_storageFile;
        }
    }
}

