/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.w3c.dom.Node;

public class DBGpBoolValue
extends DBGpValue {
    String[] allowedValues = new String[]{"false", "true"};

    public DBGpBoolValue(DBGpVariable dBGpVariable, Node node) {
        super(dBGpVariable, node);
        this.setModifiable(true);
    }

    public String getReferenceTypeName() throws DebugException {
        return "bool";
    }

    void genValueString(String string) {
        this.setValueString("<Invalid>");
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                if (1 == n) {
                    this.setValueString("true");
                } else if (n == 0) {
                    this.setValueString("false");
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public void setValue(String string) throws DebugException {
        String string2 = string.equals("true") ? "1" : (string.equals("false") ? "0" : string);
        this.genValueString(string2);
    }

    boolean verifyValue(String string) throws DebugException {
        boolean bl = false;
        int n = 0;
        while (n < this.allowedValues.length && !bl) {
            if (string.equals(this.allowedValues[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }
}

