/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DBGpResponse {
    public static final String STATUS_STARTING = "starting";
    public static final String STATUS_STOPPING = "stopping";
    public static final String STATUS_STOPPED = "stopped";
    public static final String STATUS_RUNNING = "running";
    public static final String STATUS_BREAK = "break";
    public static final String REASON_OK = "ok";
    public static final String REASON_ERROR = "error";
    public static final String REASON_ABORTED = "aborted";
    public static final String REASON_EXCEPTION = "exception";
    private DocumentBuilder db;
    private Document doc;
    private Node parent;
    public static final int PARSE_FAILURE = 0;
    public static final int INIT = 1;
    public static final int RESPONSE = 2;
    public static final int STREAM = 3;
    public static final int UNKNOWN_TYPE = 99;
    int type;
    private String idekey;
    private String session;
    private String engineVersion;
    private String fileUri;
    private String id;
    private String command;
    private String status;
    private String reason;
    public static final int ERROR_OK = 0;
    public static final int ERROR_CANT_GET_PROPERTY = 300;
    public static final int ERROR_UNKNOWN_ERROR_CODE = 10000;
    public static final int ERROR_UNKNOWN_TYPE = 10001;
    public static final int ERROR_PARSE_FAILURE = 10002;
    public static final int ERROR_INVALID_RESPONSE = 10003;
    int errorCode;
    String errorMessage;
    private String streamType;
    private String streamData;
    private byte[] rawXML;

    public DBGpResponse() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.db = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            DBGpLogger.logException(null, this, parserConfigurationException);
        }
    }

    public void parseResponse(byte[] byArray) {
        this.rawXML = byArray;
        if (this.db != null && byArray != null) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.parseResponse(byteArrayInputStream);
        } else {
            this.type = 0;
            this.errorCode = 10002;
        }
    }

    private void parseResponse(InputStream inputStream) {
        this.id = null;
        this.command = null;
        this.type = 99;
        this.errorCode = 10001;
        try {
            this.doc = this.db.parse(inputStream);
            this.parent = this.doc.getFirstChild();
            String string = this.parent.getNodeName();
            if (string.equals("response")) {
                this.parseResponseType();
            } else if (string.equals("init")) {
                this.parseInitType();
            } else if (string.equals("stream")) {
                this.parseStreamType();
            }
        }
        catch (SAXException sAXException) {
            DBGpLogger.logException(null, this, sAXException);
            this.type = 0;
            this.errorCode = 10002;
        }
        catch (IOException iOException) {
            DBGpLogger.logException(null, this, iOException);
            this.type = 0;
            this.errorCode = 10002;
        }
    }

    private void parseStreamType() {
        this.type = 3;
        this.streamType = this.getTopAttribute("type");
        Node node = this.parent.getFirstChild();
        if (node != null) {
            this.streamData = node.getNodeValue();
        }
        this.errorCode = this.streamType.length() != 0 ? 0 : 10003;
    }

    private void parseInitType() {
        this.type = 1;
        this.idekey = this.getTopAttribute("idekey");
        this.session = this.getTopAttribute("session");
        if (this.session.trim().length() == 0) {
            this.session = null;
        }
        this.fileUri = this.getTopAttribute("fileuri");
        NodeList nodeList = this.parent.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeName().equals("engine")) {
                this.engineVersion = DBGpResponse.getAttribute(node, "version");
                n = nodeList.getLength();
            }
            ++n;
        }
        this.errorCode = this.idekey.length() != 0 && this.fileUri.length() != 0 ? 0 : 10003;
    }

    private void parseResponseType() {
        this.type = 2;
        this.id = this.getTopAttribute("transaction_id");
        this.command = this.getTopAttribute("command");
        this.status = this.getTopAttribute("status");
        this.reason = this.getTopAttribute("reason");
        Node node = this.parent.getFirstChild();
        if (node != null && node.getNodeName().equals(REASON_ERROR)) {
            Node node2;
            String string = DBGpResponse.getAttribute(node, "code");
            try {
                this.errorCode = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.errorCode = 10000;
            }
            Node node3 = node.getFirstChild();
            if (node3 != null && (node2 = node3.getFirstChild()) != null) {
                this.errorMessage = node2.getNodeValue();
            }
        } else {
            this.errorCode = this.id.length() != 0 ? 0 : 10003;
        }
    }

    public Node getParentNode() {
        return this.doc.getFirstChild();
    }

    public String getTopAttribute(String string) {
        return DBGpResponse.getAttribute(this.parent, string);
    }

    public static String getAttribute(Node node, String string) {
        NamedNodeMap namedNodeMap;
        Node node2;
        String string2 = "";
        if (node != null && node.hasAttributes() && (node2 = (namedNodeMap = node.getAttributes()).getNamedItem(string)) != null) {
            string2 = node2.getNodeValue();
        }
        return string2;
    }

    public String getCommand() {
        return this.command;
    }

    public String getId() {
        return this.id;
    }

    public String getReason() {
        return this.reason;
    }

    public String getStatus() {
        return this.status;
    }

    public int getType() {
        return this.type;
    }

    public String getFileUri() {
        return this.fileUri;
    }

    public String getIdekey() {
        return this.idekey;
    }

    public String getSession() {
        return this.session;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public String getStreamData() {
        return this.streamData;
    }

    public String getStreamType() {
        return this.streamType;
    }

    public byte[] getRawXML() {
        return this.rawXML;
    }
}

