/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;

public class ExclusivePositionUpdater
implements IPositionUpdater {
    private final String _category;

    public ExclusivePositionUpdater(String category) {
        this._category = category;
    }

    public void update(DocumentEvent event) {
        int eventOffset = event.getOffset();
        int eventOldLength = event.getLength();
        int eventNewLength = event.getText() == null ? 0 : event.getText().length();
        int deltaLength = eventNewLength - eventOldLength;
        try {
            Position[] positions = event.getDocument().getPositions(this._category);
            for (int i = 0; i != positions.length; ++i) {
                Position position = positions[i];
                if (position.isDeleted()) continue;
                int offset = position.getOffset();
                int length = position.getLength();
                int end = offset + length;
                if (offset >= eventOffset + eventOldLength) {
                    position.setOffset(offset + deltaLength);
                    continue;
                }
                if (end <= eventOffset) continue;
                if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                    position.setLength(length + deltaLength);
                    continue;
                }
                if (offset < eventOffset) {
                    int newEnd = eventOffset;
                    position.setLength(newEnd - offset);
                    continue;
                }
                if (end > eventOffset + eventOldLength) {
                    int newOffset = eventOffset + eventNewLength;
                    position.setOffset(newOffset);
                    position.setLength(end - newOffset);
                    continue;
                }
                position.delete();
            }
        }
        catch (BadPositionCategoryException e) {
            // empty catch block
        }
    }

    public String getCategory() {
        return this._category;
    }
}

