/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.editor;

import java.util.ArrayList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTDeployable;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParam;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLParamDefList;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorResources;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.CCPActionGroup;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.DeployAction;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLLabelProvider;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLMarkerLabelDecorator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SQLOutlinePage
extends ContentOutlinePage
implements ISelectionProvider {
    private SQLEditor _editor;
    private Node _input;
    private OutlineViewer _viewer;
    private CCPActionGroup _actionGroups;
    private DeployAction _deployAction;
    private IAction _fUndo;
    private IAction _fRedo;

    public SQLOutlinePage(SQLEditor editor) {
        this._editor = editor;
        this._fUndo = this._editor.getAction(ITextEditorActionConstants.UNDO);
        this._fRedo = this._editor.getAction(ITextEditorActionConstants.REDO);
    }

    public void createControl(Composite parent) {
        this._viewer = new OutlineViewer(parent, 0x2000302);
        this._viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this._viewer.getControl().addMouseTrackListener((MouseTrackListener)new TooltipPresenter());
        this._viewer.setContentProvider((IContentProvider)new SQLContentProvider());
        SQLLabelProvider labelProvider = new SQLLabelProvider();
        labelProvider.addLabelDecorator(new SQLMarkerLabelDecorator(this._editor));
        this._viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                SQLOutlinePage.this.fillMenu(manager);
            }
        });
        Menu contextMenu = menuManager.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(contextMenu);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this._actionGroups = new CCPActionGroup((Page)this);
        this._deployAction = new DeployAction((IWorkbenchSite)this.getSite());
        this._deployAction.setImageDescriptor(SQLEditorResources.getImageDescriptor("save_to_database"));
        this.addSelectionChangedListener(this._deployAction);
        IActionBars bars = this.getSite().getActionBars();
        bars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this._fUndo);
        bars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this._fRedo);
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction", this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction"));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction", this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
        bars.setGlobalActionHandler("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction", this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        this._actionGroups.fillActionBars(bars);
        if (this._input != null) {
            this._viewer.setInput(this._input);
            this._viewer.expandToLevel(2);
            this._viewer.setAutoExpandLevel(2);
        }
    }

    public void setInput(Node node) {
        this.update(node);
    }

    public void update(Node node) {
        this._input = node;
        if (this._viewer == null || this._viewer.getControl().isDisposed()) {
            return;
        }
        Object[] exp = this._viewer.getExpandedElements();
        this._viewer.setInput(this._input);
        if (exp.length > 1) {
            ArrayList<Node> nexp = new ArrayList<Node>();
            for (int i = 0; i < exp.length; ++i) {
                Node nnode = null;
                nnode = node.equals(exp[i]) ? node : this.findNode(node, (Node)exp[i]);
                if (nnode == null) continue;
                nexp.add(nnode);
            }
            if (nexp.size() > 1) {
                this._viewer.setExpandedElements(nexp.toArray());
                return;
            }
        }
        this._viewer.expandToLevel(2);
    }

    public void setFocus() {
        if (this._viewer != null) {
            this._viewer.getControl().setFocus();
        }
    }

    public void dispose() {
        super.dispose();
        if (this._actionGroups != null) {
            this._actionGroups.dispose();
        }
        this.removeSelectionChangedListener(this._deployAction);
        this._editor.outlinePageClosed();
    }

    public Control getControl() {
        return this._viewer != null ? this._viewer.getControl() : null;
    }

    protected void fillMenu(IMenuManager manager) {
        this._actionGroups.fillContextMenu(manager);
        manager.add((IContributionItem)new Separator("group.sqleditor.source"));
        manager.appendToGroup("group.sqleditor.source", this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.toggleCommentAction"));
        manager.add((IContributionItem)new Separator());
        if (this._editor.getSQLType() != 100) {
            manager.add((IAction)this._deployAction);
        }
        manager.add(this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSelectionAction"));
        manager.add(this._editor.getAction("org.eclipse.datatools.sqltools.sqleditor.ExecuteSQLAction"));
    }

    public void setSelection(ISelection selection) {
        if (this._viewer != null) {
            this._viewer.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        if (this._viewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this._viewer.getSelection();
    }

    protected TreeViewer getTreeViewer() {
        return this._viewer;
    }

    private Node findNode(Node pnode, Node cnode) {
        for (int i = 0; i < pnode.jjtGetNumChildren(); ++i) {
            if (pnode.jjtGetChild(i).equals(cnode)) {
                return pnode.jjtGetChild(i);
            }
            Node nnode = this.findNode(pnode.jjtGetChild(i), cnode);
            if (nnode == null) continue;
            return nnode;
        }
        return null;
    }

    private class TooltipPresenter
    extends MouseTrackAdapter {
        private TooltipPresenter() {
        }

        public void mouseHover(MouseEvent e) {
            if (SQLOutlinePage.this._viewer != null && !SQLOutlinePage.this._viewer.getControl().isDisposed()) {
                Tree tree = (Tree)e.widget;
                TreeItem item = tree.getItem(new Point(e.x, e.y));
                if (item != null && item.getData() != null) {
                    String tooltip = ((Node)item.getData()).getSQLText();
                    tooltip = SQLUtil.describeSQL((String)tooltip, (int)40);
                    tree.setToolTipText(tooltip);
                } else {
                    tree.setToolTipText(null);
                }
            }
        }
    }

    private class OutlineViewer
    extends TreeViewer {
        public OutlineViewer(Composite parent, int style) {
            super(parent, style);
        }

        protected void createTreeItem(Widget parent, Object element, int index) {
            super.createTreeItem(parent, element, index);
        }
    }

    private class SQLContentProvider
    implements ITreeContentProvider {
        private SQLContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (!this.hasChildren(parentElement)) {
                return null;
            }
            if (parentElement instanceof SimpleNode) {
                SimpleNode parent = (SimpleNode)parentElement;
                ArrayList<Node> children = new ArrayList<Node>();
                for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                    if (this.dontShowMe(parent.jjtGetChild(i))) continue;
                    children.add(parent.jjtGetChild(i));
                }
                return children.toArray();
            }
            return null;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof SimpleNode) {
                SimpleNode parent = (SimpleNode)inputElement;
                ArrayList<Node> children = new ArrayList<Node>();
                for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                    if (this.dontShowMe(parent.jjtGetChild(i))) continue;
                    children.add(parent.jjtGetChild(i));
                }
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof SimpleNode) {
                SimpleNode e = (SimpleNode)element;
                return e.jjtGetParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (this.dontGoDown(element)) {
                return false;
            }
            if (element instanceof SimpleNode) {
                SimpleNode parent = (SimpleNode)element;
                for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                    if (this.dontShowMe(parent.jjtGetChild(i))) continue;
                    return true;
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        private boolean dontGoDown(Object element) {
            return element instanceof IASTSQLParam;
        }

        private boolean dontShowMe(Object element) {
            return !(element instanceof IASTDeployable) && !(element instanceof IASTSQLStatement) && !(element instanceof IASTSQLParamDefList) && !(element instanceof IASTSQLParam);
        }
    }
}

