/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.compare;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.php.internal.ui.compare.MergeSourceViewer;
import org.eclipse.php.internal.ui.compare.TextEditorPropertyAction;

public class ShowWhitespaceAction
extends TextEditorPropertyAction {
    private Map fPainters;
    private boolean isWhitespaceShowing;

    public ShowWhitespaceAction(MergeSourceViewer[] mergeSourceViewerArray) {
        super(CompareMessages.ShowWhitespaceAction_0, mergeSourceViewerArray, "showWhitespaceCharacters");
    }

    protected void toggleState(boolean bl) {
        if (bl) {
            this.showWhitespace();
        } else {
            this.hideWhitespace();
        }
    }

    private synchronized Map getPainters() {
        if (this.fPainters == null) {
            this.fPainters = new HashMap();
        }
        return this.fPainters;
    }

    private void showWhitespace() {
        if (this.isWhitespaceShowing) {
            return;
        }
        try {
            Map map = this.getPainters();
            MergeSourceViewer[] mergeSourceViewerArray = this.getViewers();
            int n = 0;
            while (n < mergeSourceViewerArray.length) {
                MergeSourceViewer mergeSourceViewer = mergeSourceViewerArray[n];
                WhitespaceCharacterPainter whitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)mergeSourceViewer);
                mergeSourceViewer.addPainter((IPainter)whitespaceCharacterPainter);
                map.put(mergeSourceViewer, whitespaceCharacterPainter);
                ++n;
            }
        }
        finally {
            this.isWhitespaceShowing = true;
        }
    }

    private void hideWhitespace() {
        Map map = this.getPainters();
        for (MergeSourceViewer mergeSourceViewer : map.keySet()) {
            WhitespaceCharacterPainter whitespaceCharacterPainter = (WhitespaceCharacterPainter)map.get((Object)mergeSourceViewer);
            if (whitespaceCharacterPainter == null) continue;
            mergeSourceViewer.removePainter((IPainter)whitespaceCharacterPainter);
            whitespaceCharacterPainter.deactivate(true);
        }
        map.clear();
        this.isWhitespaceShowing = false;
    }
}

