/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;

public class BreakpointSet {
    private IProject fProject;
    private ArrayList<String> fDirectories;
    private ArrayList<IProject> fProjects;

    public BreakpointSet(IProject iProject, boolean bl) {
        IIncludePathEntry[] iIncludePathEntryArray;
        PHPProjectOptions pHPProjectOptions;
        this.fProject = iProject;
        this.fDirectories = new ArrayList();
        this.fProjects = new ArrayList();
        if (iProject != null && (pHPProjectOptions = PHPProjectOptions.forProject((IProject)iProject)) != null && (iIncludePathEntryArray = pHPProjectOptions.readRawIncludePath()) != null) {
            IIncludePathEntry[] iIncludePathEntryArray2 = iIncludePathEntryArray;
            int n = iIncludePathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file;
                Object object;
                IPath iPath;
                IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray2[n2];
                if (iIncludePathEntry.getEntryKind() == 1) {
                    iPath = iIncludePathEntry.getPath();
                    object = new File(iPath.toOSString());
                    this.fDirectories.add(((File)object).getAbsolutePath());
                } else if (iIncludePathEntry.getEntryKind() == 2) {
                    iPath = iIncludePathEntry.getResource();
                    if (iPath instanceof IProject) {
                        this.fProjects.add((IProject)iPath);
                    }
                } else if (iIncludePathEntry.getEntryKind() == 4 && (file = this.getVariableFile((String)(object = (iPath = iIncludePathEntry.getPath()).toOSString()))) != null && file.isDirectory()) {
                    this.fDirectories.add(file.getAbsolutePath());
                }
                ++n2;
            }
        }
    }

    public boolean supportsBreakpoint(IBreakpoint iBreakpoint) {
        if (this.fProject == null) {
            return true;
        }
        PHPLineBreakpoint pHPLineBreakpoint = (PHPLineBreakpoint)iBreakpoint;
        IMarker iMarker = pHPLineBreakpoint.getMarker();
        IResource iResource = null;
        if (iBreakpoint instanceof PHPRunToLineBreakpoint) {
            return true;
        }
        iResource = iMarker.getResource();
        if (iResource instanceof IWorkspaceRoot) {
            String string;
            String string2 = iMarker.getAttribute("org.eclipse.php.debug.core.Storage_Type", "");
            if (string2.equals("org.eclipse.php.debug.core.Include") && !"".equals(string = iMarker.getAttribute("org.eclipse.php.debug.core.Include_Path_Basedir", ""))) {
                Object[] objectArray;
                Object[] objectArray2 = objectArray = this.fDirectories.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray2[n2];
                    if (string.equals(object)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            return true;
        }
        IProject iProject = iResource.getProject();
        if (this.fProject.equals((Object)iProject) || this.fProject.equals((Object)PHPWorkspaceModelManager.getDefaultPHPProjectModel().getProject())) {
            return true;
        }
        return this.fProjects.contains(iProject);
    }

    private File getVariableFile(String string) {
        IPath iPath;
        int n = string.indexOf(47);
        String string2 = "";
        if (n != -1) {
            if (n + 1 < string.length()) {
                string2 = string.substring(n + 1);
            }
            string = string.substring(0, n);
        }
        if ((iPath = PHPProjectOptions.getIncludePathVariable((String)string)) == null) {
            return null;
        }
        iPath = iPath.append(string2);
        return iPath.toFile();
    }
}

