/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpElement;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpThread;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.w3c.dom.Node;

public class DBGpStackFrame
extends DBGpElement
implements IStackFrame {
    private DBGpThread owningThread;
    private String qualifiedFile = "";
    private String stackLevel;
    private String fileName;
    private int lineNo;
    private String name = "";

    public DBGpStackFrame(DBGpThread dBGpThread, Node node) {
        super(dBGpThread.getDebugTarget());
        this.owningThread = dBGpThread;
        String string = DBGpResponse.getAttribute(node, "lineno");
        this.stackLevel = DBGpResponse.getAttribute(node, "level");
        this.lineNo = Integer.parseInt(string);
        this.qualifiedFile = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(node, "filename"));
        this.qualifiedFile = ((DBGpTarget)this.getDebugTarget()).mapToWorkspaceFileIfRequired(this.qualifiedFile);
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(this.qualifiedFile));
        if (iFile != null) {
            this.fileName = iFile.getProjectRelativePath().toString();
            this.name = String.valueOf(this.fileName) + "." + DBGpResponse.getAttribute(node, "where") + " : lineno " + this.lineNo;
        } else {
            this.fileName = null;
            this.name = String.valueOf(this.qualifiedFile) + "." + DBGpResponse.getAttribute(node, "where") + " : lineno " + this.lineNo;
        }
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getLineNumber() throws DebugException {
        DBGpLogger.debug(String.valueOf(this.hashCode()) + "::DBGpStackFrame=" + this.lineNo);
        return this.lineNo;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public IThread getThread() {
        return this.owningThread;
    }

    public IVariable[] getVariables() throws DebugException {
        DBGpLogger.debug("getting variables for stackframe on line: " + this.lineNo);
        IVariable[] iVariableArray = ((DBGpTarget)this.getDebugTarget()).getVariables(this.stackLevel);
        return iVariableArray;
    }

    public boolean hasVariables() throws DebugException {
        IVariable[] iVariableArray = this.getVariables();
        return iVariableArray != null && iVariableArray.length > 0;
    }

    public boolean canStepInto() {
        return this.owningThread.canStepInto();
    }

    public boolean canStepOver() {
        return this.owningThread.canStepOver();
    }

    public boolean canStepReturn() {
        return this.owningThread.canStepReturn();
    }

    public boolean isStepping() {
        return this.owningThread.isStepping();
    }

    public void stepInto() throws DebugException {
        this.owningThread.stepInto();
    }

    public void stepOver() throws DebugException {
        this.owningThread.stepOver();
    }

    public void stepReturn() throws DebugException {
        this.owningThread.stepReturn();
    }

    public boolean canResume() {
        return this.owningThread.canResume();
    }

    public boolean canSuspend() {
        return this.owningThread.canSuspend();
    }

    public boolean isSuspended() {
        return this.owningThread.isSuspended();
    }

    public void resume() throws DebugException {
        this.owningThread.resume();
    }

    public void suspend() throws DebugException {
        this.owningThread.suspend();
    }

    public boolean canTerminate() {
        return this.owningThread.canTerminate();
    }

    public boolean isTerminated() {
        return this.owningThread.isTerminated();
    }

    public void terminate() throws DebugException {
        this.owningThread.terminate();
    }

    public String getSourceName() {
        return this.fileName;
    }

    public boolean equals(Object object) {
        if (object instanceof DBGpStackFrame) {
            DBGpStackFrame dBGpStackFrame = (DBGpStackFrame)((Object)object);
            try {
                boolean bl = dBGpStackFrame.getQualifiedFile().equals(this.getQualifiedFile()) && dBGpStackFrame.stackLevel.equals(this.stackLevel);
                return bl;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public int hashCode() {
        return this.getQualifiedFile().hashCode() + this.stackLevel.hashCode();
    }

    public String getQualifiedFile() {
        return this.qualifiedFile;
    }

    public String getStackLevel() {
        return this.stackLevel;
    }
}

