/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.containers.LocalFileStorage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPExeLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection iSelection, String string) {
        if (iSelection instanceof IStructuredSelection) {
            PHPExeLaunchShortcut.searchAndLaunch(((IStructuredSelection)iSelection).toArray(), string, this.getPHPExeLaunchConfigType());
        }
    }

    public void launch(IEditorPart iEditorPart, String string) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        IFile iFile = (IFile)iEditorInput.getAdapter(IFile.class);
        if (iFile == null) {
            IPath iPath = null;
            if (iEditorInput instanceof IStorageEditorInput) {
                IStorageEditorInput iStorageEditorInput = (IStorageEditorInput)iEditorInput;
                try {
                    LocalFileStorage localFileStorage = (LocalFileStorage)iStorageEditorInput.getStorage();
                    iPath = localFileStorage.getFullPath();
                }
                catch (CoreException coreException) {
                    Logger.logException(coreException);
                }
            } else if (iEditorInput instanceof IURIEditorInput) {
                iPath = URIUtil.toPath((URI)((IURIEditorInput)iEditorInput).getURI());
            } else if (iEditorInput instanceof NonExistingPHPFileEditorInput) {
                try {
                    if (iEditorPart instanceof ITextEditor) {
                        ITextEditor iTextEditor = (ITextEditor)iEditorPart;
                        TextFileDocumentProvider textFileDocumentProvider = (TextFileDocumentProvider)iTextEditor.getDocumentProvider();
                        IDocument iDocument = textFileDocumentProvider.getDocument((Object)iEditorInput);
                        textFileDocumentProvider.saveDocument(null, (Object)iEditorInput, iDocument, true);
                        iDocument.replace(0, 0, "");
                    }
                }
                catch (Exception exception) {
                    Logger.logException(exception);
                }
                iPath = ((NonExistingPHPFileEditorInput)iEditorInput).getPath();
            }
            if (iPath != null) {
                iFile = ExternalFilesRegistry.getInstance().isEntryExist(iPath.toOSString()) ? ExternalFilesRegistry.getInstance().getFileEntry(iPath.toOSString()) : ExternalFileWrapper.createFile((String)iPath.toOSString());
            }
        }
        if (iFile != null) {
            PHPExeLaunchShortcut.searchAndLaunch(new Object[]{iFile}, string, this.getPHPExeLaunchConfigType());
        }
    }

    private void copyBreakPoints(IPath iPath, int[] nArray) throws CoreException {
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath);
        int n = 0;
        while (n < nArray.length) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint(PHPDebugTarget.createBreakpoint((IResource)iFile, (int)nArray[n]));
            ++n;
        }
    }

    private int[] getBreakpointLines(IPath iPath) throws CoreException {
        IBreakpoint[] iBreakpointArray = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.php.debug.core");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < iBreakpointArray.length) {
            PHPConditionalBreakpoint pHPConditionalBreakpoint = (PHPConditionalBreakpoint)iBreakpointArray[n];
            if (pHPConditionalBreakpoint.getRuntimeBreakpoint().getFileName().equals(iPath.toString())) {
                arrayList.add(pHPConditionalBreakpoint.getLineNumber());
            }
            ++n;
        }
        int[] nArray = new int[arrayList.size()];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = (Integer)arrayList.get(n2);
            ++n2;
        }
        return nArray;
    }

    protected ILaunchConfigurationType getPHPExeLaunchConfigType() {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        return iLaunchManager.getLaunchConfigurationType("org.eclipse.php.debug.core.launching.PHPExeLaunchConfigurationType");
    }

    public static void searchAndLaunch(Object[] objectArray, String string, ILaunchConfigurationType iLaunchConfigurationType) {
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                Object object;
                try {
                    ILaunchConfiguration iLaunchConfiguration;
                    IContentType iContentType;
                    IFile iFile;
                    String string2 = null;
                    object = null;
                    IProject iProject = null;
                    Object object2 = objectArray[n2];
                    if (object2 instanceof PHPCodeData) {
                        object2 = PHPModelUtil.getResource((Object)object2);
                    }
                    if (object2 instanceof IFile) {
                        iFile = (IFile)object2;
                        iProject = iFile.getProject();
                        iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
                        if (iContentType.isAssociatedWith(iFile.getName())) {
                            string2 = new File(iFile.getFullPath().toOSString()).exists() ? iFile.getFullPath().toOSString() : iFile.getFullPath().toString();
                            iLaunchConfiguration = iFile.getLocation();
                            object = iLaunchConfiguration != null ? iLaunchConfiguration.toOSString() : iFile.getFullPath().toString();
                        }
                    }
                    if (string2 == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_target, null));
                    }
                    iFile = PHPExeLaunchShortcut.getDefaultPHPExe(iProject);
                    if (iFile == null) {
                        iFile = PHPExeLaunchShortcut.getWorkspaceDefaultExe();
                    }
                    String string3 = iContentType = iFile != null ? iFile.getExecutable().getAbsolutePath().toString() : null;
                    if (iContentType == null) {
                        MessageDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_noexe_msg_title, (String)PHPDebugUIMessages.launch_noexe_msg_text);
                        PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)"org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage", null, null).open();
                        return;
                    }
                    iLaunchConfiguration = PHPExeLaunchShortcut.findLaunchConfiguration(iProject, string2, (String)object, (PHPexeItem)iFile, string, iLaunchConfigurationType);
                    if (iLaunchConfiguration != null) {
                        DebugUITools.launch((ILaunchConfiguration)iLaunchConfiguration, (String)string);
                        break block10;
                    }
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.php.debug.ui", 0, PHPDebugUIMessages.launch_failure_no_config, null));
                }
                catch (CoreException coreException) {
                    object = coreException.getStatus();
                    Display.getDefault().asyncExec(new Runnable((IStatus)object){
                        private final /* synthetic */ IStatus val$stat;
                        {
                            this.val$stat = iStatus;
                        }

                        public void run() {
                            ErrorDialog.openError((Shell)PHPDebugUIPlugin.getActiveWorkbenchShell(), (String)PHPDebugUIMessages.launch_failure_msg_title, (String)PHPDebugUIMessages.launch_failure_exec_msg_text, (IStatus)this.val$stat);
                        }
                    });
                }
            }
            ++n2;
        }
    }

    private static PHPexeItem getWorkspaceDefaultExe() {
        String string = PHPDebugPlugin.getCurrentDebuggerId();
        return PHPexes.getInstance().getDefaultItem(string);
    }

    private static PHPexeItem getDefaultPHPExe(IProject iProject) {
        IEclipsePreferences iEclipsePreferences;
        IScopeContext[] iScopeContextArray;
        String string = PHPDebugPlugin.getCurrentDebuggerId();
        PHPexeItem pHPexeItem = PHPexes.getInstance().getDefaultItem(string);
        if (pHPexeItem == null) {
            return null;
        }
        String string2 = pHPexeItem.getName();
        if (iProject != null && (iScopeContextArray = PHPExeLaunchShortcut.createPreferenceScopes(iProject))[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(PHPProjectPreferences.getPreferenceNodeQualifier())) != null) {
            string = iEclipsePreferences.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, string);
            string2 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string2);
        }
        return PHPexes.getInstance().getItem(string, string2);
    }

    private static IScopeContext[] createPreferenceScopes(IProject iProject) {
        if (iProject != null) {
            return new IScopeContext[]{new ProjectScope(iProject), new InstanceScope(), new DefaultScope()};
        }
        return new IScopeContext[]{new InstanceScope(), new DefaultScope()};
    }

    protected static ILaunchConfiguration findLaunchConfiguration(IProject iProject, String string, String string2, PHPexeItem pHPexeItem, String string3, ILaunchConfigurationType iLaunchConfigurationType) {
        ILaunchConfiguration iLaunchConfiguration = null;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(iLaunchConfigurationType);
            int n = iLaunchConfigurationArray == null ? 0 : iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string4 = iLaunchConfigurationArray[n2].getAttribute("ATTR_FILE", null);
                String string5 = iLaunchConfigurationArray[n2].getAttribute("ATTR_LOCATION", null);
                String string6 = iLaunchConfigurationArray[n2].getAttribute("ATTR_INI_LOCATION", null);
                PHPexeItem pHPexeItem2 = PHPexes.getInstance().getItemForFile(string5, string6);
                if (string.equals(string4) && pHPexeItem.equals((Object)pHPexeItem2)) {
                    iLaunchConfiguration = iLaunchConfigurationArray[n2].getWorkingCopy();
                    break;
                }
                ++n2;
            }
            if (iLaunchConfiguration == null) {
                iLaunchConfiguration = PHPExeLaunchShortcut.createConfiguration(iProject, string, string2, pHPexeItem, iLaunchConfigurationType);
            }
        }
        catch (CoreException coreException) {
            coreException.printStackTrace();
        }
        return iLaunchConfiguration;
    }

    protected static ILaunchConfiguration createConfiguration(IProject iProject, String string, String string2, PHPexeItem pHPexeItem, ILaunchConfigurationType iLaunchConfigurationType) throws CoreException {
        ILaunchConfiguration iLaunchConfiguration = null;
        ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, PHPExeLaunchShortcut.getNewConfigurationName(string));
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, pHPexeItem.getDebuggerID());
        AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)pHPexeItem.getDebuggerID());
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, abstractDebuggerConfiguration.getScriptLaunchDelegateClass());
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE", string);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_FILE_FULL_PATH", string2);
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_LOCATION", pHPexeItem.getExecutable().getAbsolutePath().toString());
        String string3 = pHPexeItem.getINILocation() != null ? pHPexeItem.getINILocation().toString() : null;
        iLaunchConfigurationWorkingCopy.setAttribute("ATTR_INI_LOCATION", string3);
        iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", PHPDebugPlugin.getDebugInfoOption());
        iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine((IProject)iProject));
        iLaunchConfiguration = iLaunchConfigurationWorkingCopy.doSave();
        return iLaunchConfiguration;
    }

    protected static String getNewConfigurationName(String string) {
        String string2 = "New_configuration";
        try {
            IPath iPath = Path.fromOSString((String)string);
            String string3 = iPath.getFileExtension();
            String string4 = iPath.lastSegment();
            if (string4 != null) {
                if (string3 != null) {
                    string4 = string4.replaceFirst("." + string3, "");
                }
                string2 = string4;
            }
        }
        catch (Exception exception) {
            Logger.log(202, "Could not generate configuration name for " + string + ".\nThe default name will be used.", exception);
        }
        return DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(string2);
    }
}

