/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.PHPIncludePathPage;
import org.eclipse.php.internal.ui.wizards.PHPProjectWizardBasePage;
import org.eclipse.php.internal.ui.wizards.PHPWizardPagesRegistry;
import org.eclipse.php.internal.ui.wizards.WizardPageFactory;
import org.eclipse.php.internal.ui.wizards.operations.PHPCreationDataModelProvider;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizard;
import org.osgi.service.prefs.BackingStoreException;

public class PHPProjectCreationWizard
extends DataModelWizard
implements IExecutableExtension,
INewWizard {
    private static final String ID = "org.eclipse.php.ui.wizards.PHPProjectCreationWizard";
    protected PHPIncludePathPage includePathPage;
    protected PHPProjectWizardBasePage basePage;
    protected final ArrayList wizardPagesList = new ArrayList();
    private IProject createdProject = null;
    protected IConfigurationElement configElement;
    private List wizardPageFactories = new ArrayList();

    public PHPProjectCreationWizard(IDataModel iDataModel) {
        super(iDataModel);
        this.populateWizardFactoryList();
    }

    public PHPProjectCreationWizard() {
        this.populateWizardFactoryList();
    }

    protected IDataModelProvider getDefaultProvider() {
        return new PHPCreationDataModelProvider(this.wizardPageFactories);
    }

    public void doAddPages() {
        if (this.addDeafaultPages()) {
            this.addContributedPages();
        }
    }

    protected void addContributedPages() {
        for (WizardPageFactory wizardPageFactory : this.wizardPageFactories) {
            IWizardPage iWizardPage = wizardPageFactory.createPage(this.getDataModel());
            this.addPage(iWizardPage);
        }
    }

    protected boolean addDeafaultPages() {
        this.basePage = new PHPProjectWizardBasePage(this.getDataModel(), "page1");
        this.addPage((IWizardPage)this.basePage);
        this.includePathPage = new PHPIncludePathPage(this.getDataModel(), "page2");
        this.addPage((IWizardPage)this.includePathPage);
        return true;
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        this.configElement = iConfigurationElement;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(PHPUIMessages.getString("PHPProjectCreationWizard_PageTile"));
        this.setDefaultPageImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_PROJECT);
    }

    protected boolean prePerformFinish() {
        this.createdProject = (IProject)this.getDataModel().getProperty("IProjectCreationPropertiesNew.PROJECT");
        this.getDataModel().setProperty("org.eclipse.php.core.includePath", (Object)this.includePathPage.getIncludePathsBlock().getIncludepathEntries());
        this.basePage.setProjectOptionInModel(this.getDataModel());
        return super.prePerformFinish();
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.createdProject != null) {
            try {
                new ProjectScope(this.createdProject).getNode("org.eclipse.php.core").flush();
            }
            catch (BackingStoreException backingStoreException) {
                Logger.logException((Throwable)backingStoreException);
            }
        }
        UIJob uIJob = new UIJob(""){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)PHPProjectCreationWizard.this.configElement);
                return Status.OK_STATUS;
            }
        };
        uIJob.setUser(false);
        uIJob.schedule();
    }

    private void populateWizardFactoryList() {
        WizardPageFactory[] wizardPageFactoryArray = PHPWizardPagesRegistry.getPageFactories(ID);
        if (wizardPageFactoryArray != null) {
            WizardPageFactory[] wizardPageFactoryArray2 = wizardPageFactoryArray;
            int n = wizardPageFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                WizardPageFactory wizardPageFactory;
                WizardPageFactory wizardPageFactory2 = wizardPageFactory = wizardPageFactoryArray2[n2];
                this.wizardPageFactories.add(wizardPageFactory2);
                ++n2;
            }
        }
    }
}

