/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.binding;

import org.eclipse.php.internal.core.ast.binding.Attribute;
import org.eclipse.php.internal.core.ast.binding.ProgramScope;
import org.eclipse.php.internal.core.ast.binding.Scope;
import org.eclipse.php.internal.core.ast.binding.ScopeBase;
import org.eclipse.php.internal.core.ast.binding.ScopeType;

public class GlobalScope
extends ScopeBase {
    public final Scope parentScope;
    public GlobalScope childScope;

    protected GlobalScope(int n, Scope scope, GlobalScope globalScope, ProgramScope programScope) {
        super(n, programScope);
        assert (scope != null);
        this.parentScope = scope;
    }

    public static GlobalScope createRootScope(int n, ProgramScope programScope) {
        GlobalScope globalScope = new GlobalScope(n, programScope, null, programScope);
        return globalScope;
    }

    public GlobalScope enterScope(int n) {
        GlobalScope globalScope;
        this.childScope = globalScope = new GlobalScope(n, this, null, this.programScope);
        this.length = n - this.start;
        return globalScope;
    }

    public Scope getChild() {
        return this.childScope;
    }

    public Scope getParent() {
        return this.parentScope;
    }

    public Scope getScope(int n) {
        switch (this.compareTo(n)) {
            case 0: {
                return this;
            }
            case -1: {
                return this.getChild();
            }
            case 1: {
                return this.getParent();
            }
        }
        throw new IllegalArgumentException();
    }

    protected int compareTo(int n) {
        return this.start <= n ? (this.start + this.length > n ? 0 : 1) : -1;
    }

    public ScopeType getScopeType() {
        return ScopeType.GLOBAL_SCOPE;
    }

    public Attribute lookup(String string) {
        return null;
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<Scope");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">");
        super.toString(stringBuffer, String.valueOf(string) + "\t");
        stringBuffer.append("\n");
        Scope scope = this.getChild();
        if (scope != null) {
            scope.toString(stringBuffer, String.valueOf(string) + "\t");
        }
        stringBuffer.append(string).append("</Scope>\n");
    }
}

