/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class ContinueStatement
extends Statement {
    private final Expression expr;

    public ContinueStatement(int n, int n2) {
        this(n, n2, null);
    }

    public ContinueStatement(int n, int n2, Expression expression) {
        super(n, n2);
        this.expr = expression;
        if (expression != null) {
            expression.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        if (this.expr != null) {
            this.expr.accept(visitor);
        }
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        if (this.expr != null) {
            this.expr.traverseTopDown(visitor);
        }
    }

    public void traverseBottomUp(Visitor visitor) {
        if (this.expr != null) {
            this.expr.traverseBottomUp(visitor);
        }
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<ContinueStatement");
        this.appendInterval(stringBuffer);
        stringBuffer.append(">\n");
        if (this.expr != null) {
            this.expr.toString(stringBuffer, "\t" + string);
            stringBuffer.append("\n");
        }
        stringBuffer.append(string).append("</ContinueStatement>");
    }

    public int getType() {
        return 18;
    }

    public Expression getExpr() {
        return this.expr;
    }
}

