/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser.management;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.IParserClientFactory;
import org.eclipse.php.internal.core.phpModel.parser.IProjectModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManagerProvider;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserClientComposite;
import org.eclipse.php.internal.core.preferences.IPreferencesPropagatorListener;
import org.eclipse.php.internal.core.preferences.PreferencesPropagatorEvent;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionChangedHandler;
import org.eclipse.php.internal.core.project.properties.handlers.PhpVersionProjectPropertyHandler;
import org.eclipse.php.internal.core.project.properties.handlers.UseAspTagsHandler;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;

class ProjectParsingManager
implements IProjectModelListener {
    private Collection parserClientFactoryCollection = new HashSet();
    private PHPParserManager parserManager;
    private IProject project;
    private PhpVersionListener phpVersionListener;

    ProjectParsingManager(IProject iProject) {
        this.project = iProject;
        String string = PhpVersionProjectPropertyHandler.getVersion(iProject);
        this.setPHPVersion(string);
        this.phpVersionListener = new PhpVersionListener();
        PhpVersionChangedHandler.getInstance().addPhpVersionChangedListener(this.phpVersionListener);
    }

    private void setPHPVersion(String string) {
        PHPLanguageManager pHPLanguageManager = PHPLanguageManagerProvider.instance().getPHPLanguageManager(string);
        this.parserManager = pHPLanguageManager.createPHPParserManager();
    }

    public void fileAdded(IFile iFile) {
        InputStreamReader inputStreamReader;
        Pattern[] patternArray;
        Object object;
        if (!iFile.exists() && !((File)(object = new File(iFile.getFullPath().toOSString()))).exists()) {
            return;
        }
        object = this.buildParserClient(iFile, 1);
        if (object == null) {
            return;
        }
        try {
            patternArray = null;
            if (!iFile.exists()) {
                try {
                    patternArray = new FileInputStream(iFile.getFullPath().toOSString());
                }
                catch (IOException iOException) {}
            } else {
                patternArray = iFile.getContents();
            }
            inputStreamReader = new InputStreamReader((InputStream)patternArray, iFile.getCharset());
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log(coreException);
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            PHPCorePlugin.log(unsupportedEncodingException);
            return;
        }
        patternArray = TaskPatternsProvider.getInstance().getPatternsForProject(iFile.getProject());
        String string = iFile.getFullPath().toString();
        if (new File(string).exists()) {
            string = iFile.getFullPath().toOSString();
        }
        try {
            this.parserManager.parseNow(inputStreamReader, string, iFile.getModificationStamp(), (ParserClient)object, patternArray, UseAspTagsHandler.useAspTagsAsPhp(this.project));
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return;
        }
    }

    private ParserClient buildParserClient(IFile iFile, int n) {
        ParserClientComposite parserClientComposite = new ParserClientComposite();
        for (IParserClientFactory iParserClientFactory : this.parserClientFactoryCollection) {
            if (!iParserClientFactory.isParsable(iFile.getFullPath().toString(), n)) continue;
            ParserClient parserClient = iParserClientFactory.create();
            parserClientComposite.add(parserClient);
        }
        if (parserClientComposite.isEmpty()) {
            return null;
        }
        return parserClientComposite;
    }

    public void fileRemoved(IFile iFile) {
    }

    public void fileChanged(IFile iFile, IDocument iDocument) {
        ParserClient parserClient = this.buildParserClient(iFile, 2);
        if (parserClient == null) {
            return;
        }
        try {
            DocumentReader documentReader = new DocumentReader(iDocument);
            IProject iProject = null;
            if (iFile.exists()) {
                iProject = iFile.getProject();
            } else if (ExternalFilesRegistry.getInstance().isEntryExist(iFile)) {
                iProject = ExternalFilesRegistry.getInstance().getExternalFilesProject();
            }
            if (iProject == null) {
                return;
            }
            Pattern[] patternArray = TaskPatternsProvider.getInstance().getPatternsForProject(iProject);
            String string = iFile.getFullPath().toString();
            if (new File(string).exists()) {
                string = iFile.getFullPath().toOSString();
            }
            this.parserManager.parseNow((Reader)documentReader, string, iFile.getModificationStamp(), parserClient, patternArray, UseAspTagsHandler.useAspTagsAsPhp(iProject));
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
            return;
        }
    }

    public void addParserClient(IParserClientFactory iParserClientFactory) {
        this.parserClientFactoryCollection.add(iParserClientFactory);
    }

    public void removeParserClient(IParserClientFactory iParserClientFactory) {
        this.parserClientFactoryCollection.remove(iParserClientFactory);
    }

    public IProject getProject() {
        return this.project;
    }

    public void dispose() {
        this.parserClientFactoryCollection.clear();
        this.parserClientFactoryCollection = null;
        this.parserManager = null;
        PhpVersionChangedHandler.getInstance().removePhpVersionChangedListener(this.phpVersionListener);
        this.phpVersionListener = null;
        this.project = null;
    }

    private class PhpVersionListener
    implements IPreferencesPropagatorListener {
        private PhpVersionListener() {
        }

        public void preferencesEventOccured(PreferencesPropagatorEvent preferencesPropagatorEvent) {
            String string = (String)preferencesPropagatorEvent.getNewValue();
            ProjectParsingManager.this.setPHPVersion(string);
        }

        public IProject getProject() {
            return ProjectParsingManager.this.project;
        }
    }
}

