/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.stringsubstitution;

import com.ibm.icu.text.MessageFormat;
import java.net.URI;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.stringsubstitution.StringSubstitutionMessages;

public class ResourceResolver
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        IResource resource = null;
        resource = argument == null ? this.getSelectedResource(variable) : this.getWorkspaceRoot().findMember((IPath)new Path(argument));
        if (resource != null && resource.exists() && (resource = this.translateSelectedResource(resource)) != null && resource.exists()) {
            return this.translateToValue(resource, variable);
        }
        this.abort(MessageFormat.format((String)StringSubstitutionMessages.ResourceResolver_6, (Object[])new String[]{this.getReferenceExpression(variable, argument)}), null);
        return null;
    }

    protected IResource translateSelectedResource(IResource resource) {
        return resource;
    }

    protected IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected String getReferenceExpression(IDynamicVariable variable, String argument) {
        StringBuffer reference = new StringBuffer();
        reference.append("${");
        reference.append(variable.getName());
        if (argument != null) {
            reference.append(":");
            reference.append(argument);
        }
        reference.append("}");
        return reference.toString();
    }

    protected void abort(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, message, exception));
    }

    protected IResource getSelectedResource(IDynamicVariable variable) throws CoreException {
        IResource resource = SelectedResourceManager.getDefault().getSelectedResource();
        if (resource == null) {
            this.abort(MessageFormat.format((String)StringSubstitutionMessages.ResourceResolver_7, (Object[])new String[]{this.getReferenceExpression(variable, null)}), null);
        }
        return resource;
    }

    protected String translateToValue(IResource resource, IDynamicVariable variable) throws CoreException {
        String name = variable.getName();
        IPath path = null;
        URI uri = null;
        if (name.endsWith("_loc")) {
            uri = resource.getLocationURI();
            if (uri != null && (path = new Path(uri.getPath())) != null) {
                return path.toOSString();
            }
        } else if (name.endsWith("_path")) {
            path = resource.getFullPath();
            if (path != null) {
                return path.toOSString();
            }
        } else if (name.endsWith("_name")) {
            return resource.getName();
        }
        this.abort(MessageFormat.format((String)StringSubstitutionMessages.ResourceResolver_8, (Object[])new String[]{this.getReferenceExpression(variable, null)}), null);
        return null;
    }
}

