/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.SWT;
import org.eclipse.swt.program.Program;

public class URLHyperlink
implements IHyperlink {
    private String fURLString;
    private IRegion fRegion;

    public URLHyperlink(IRegion region, String urlString) {
        Assert.isNotNull((Object)urlString);
        Assert.isNotNull((Object)region);
        this.fRegion = region;
        this.fURLString = urlString;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (this.fURLString != null) {
            String platform = SWT.getPlatform();
            if ("motif".equals(platform) || "gtk".equals(platform)) {
                Program program = Program.findProgram((String)"html");
                if (program == null) {
                    program = Program.findProgram((String)"htm");
                }
                if (program != null) {
                    program.execute(this.fURLString);
                }
            } else {
                Program.launch((String)this.fURLString);
            }
            this.fURLString = null;
            return;
        }
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getURLString() {
        return this.fURLString;
    }
}

