/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.phpIni;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class INIFileModifier {
    private static final String GLOBAL_SECTION = "__global__";
    private static final Pattern SECTION_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");
    private static final Pattern NAME_VAL_PATTERN = Pattern.compile("(\\w+)=(.*)");
    private File configFile;
    private List<INIFileSection> sections;

    public INIFileModifier(String string) throws IOException {
        this(new File(string));
    }

    public INIFileModifier(File file) throws IOException {
        this.configFile = file;
        this.sections = new LinkedList<INIFileSection>();
        this.read();
    }

    public void addEntry(String string, String string2) {
        this.addEntry(GLOBAL_SECTION, string, string2, false, null);
    }

    public void addEntry(String string, String string2, String string3) {
        this.addEntry(string, string2, string3, false, null);
    }

    public void addEntry(String string, String string2, String string3, boolean bl, String string4) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        for (INIFileSection iNIFileSection : this.sections) {
            if (!iNIFileSection.name.equals(string)) continue;
            if (bl) {
                int n = 0;
                while (n < iNIFileSection.lines.size()) {
                    Matcher matcher = NAME_VAL_PATTERN.matcher(iNIFileSection.lines.get(n));
                    if (matcher.matches()) {
                        String string5 = matcher.group(1);
                        String string6 = matcher.group(2);
                        if (string5.equals(string2) && (string4 == null || string6.matches(string4))) {
                            iNIFileSection.lines.set(n, String.valueOf(string2) + '=' + this.quoteString(string3));
                        }
                    }
                    ++n;
                }
                break;
            }
            iNIFileSection.lines.add(String.valueOf(string2) + '=' + this.quoteString(string3));
            break;
        }
    }

    private String quoteString(String string) {
        if (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'")) {
            return string;
        }
        return String.valueOf('\"') + string + '\"';
    }

    public boolean removeEntry(String string, String string2) {
        return this.removeEntry(GLOBAL_SECTION, string, string2);
    }

    public boolean removeAllEntries(String string) {
        return this.removeEntry(null, string, null);
    }

    public boolean removeAllEntries(String string, String string2) {
        return this.removeEntry(null, string, string2);
    }

    public boolean removeEntry(String string, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        boolean bl = false;
        for (INIFileSection iNIFileSection : this.sections) {
            if (string != null && !iNIFileSection.name.equals(string)) continue;
            int n = 0;
            while (n < iNIFileSection.lines.size()) {
                Matcher matcher = NAME_VAL_PATTERN.matcher(iNIFileSection.lines.get(n));
                if (matcher.matches()) {
                    String string4 = matcher.group(1);
                    String string5 = matcher.group(2);
                    if (string4.equals(string2) && (string3 == null || string5.matches(string3))) {
                        iNIFileSection.lines.remove(n--);
                        bl = true;
                    }
                }
                ++n;
            }
            if (string != null) break;
        }
        return bl;
    }

    public void commentEntry(String string, String string2) {
        this.commentEntry(GLOBAL_SECTION, string, string2);
    }

    public void commentAllEntries(String string, String string2) {
        this.commentEntry(null, string, string2);
    }

    public void commentEntry(String string, String string2, String string3) {
        if (string2 == null) {
            throw new NullPointerException();
        }
        for (INIFileSection iNIFileSection : this.sections) {
            if (string != null && !iNIFileSection.name.equals(string)) continue;
            int n = 0;
            while (n < iNIFileSection.lines.size()) {
                String string4 = iNIFileSection.lines.get(n);
                Matcher matcher = NAME_VAL_PATTERN.matcher(string4);
                if (matcher.matches()) {
                    String string5 = matcher.group(1);
                    String string6 = matcher.group(2);
                    if (!string4.startsWith(";") && string5.equals(string2) && (string3 == null || string6.matches(string3))) {
                        iNIFileSection.lines.set(n, String.valueOf(';') + string4);
                    }
                }
                ++n;
            }
            if (string != null) break;
        }
    }

    public void close() throws IOException {
        this.flush();
    }

    protected void read() throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.configFile));
        INIFileSection iNIFileSection = new INIFileSection(GLOBAL_SECTION);
        this.sections.add(iNIFileSection);
        while ((string = bufferedReader.readLine()) != null) {
            Matcher matcher = SECTION_PATTERN.matcher(string = string.trim());
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                iNIFileSection = new INIFileSection(string2);
                this.sections.add(iNIFileSection);
                continue;
            }
            iNIFileSection.lines.add(string);
        }
        bufferedReader.close();
    }

    protected void flush() throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.configFile));
        for (INIFileSection iNIFileSection : this.sections) {
            if (iNIFileSection.name != GLOBAL_SECTION) {
                printWriter.println(String.valueOf('[') + iNIFileSection.name + ']');
            }
            for (String string : iNIFileSection.lines) {
                printWriter.println(string);
            }
        }
        printWriter.close();
    }

    class INIFileSection {
        String name;
        List<String> lines;

        public INIFileSection(String string) {
            this.name = string;
            this.lines = new LinkedList<String>();
        }
    }
}

