/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;

public class ResolveBlackList {
    private Map<VirtualPath, Type> list = new HashMap<VirtualPath, Type>();

    public void add(VirtualPath virtualPath, Type type) {
        this.list.put(virtualPath, type);
    }

    public boolean containsEntry(String string) {
        if (!VirtualPath.isAbsolute(string)) {
            return false;
        }
        for (VirtualPath virtualPath : this.list.keySet()) {
            VirtualPath virtualPath2 = new VirtualPath(string);
            Type type = this.list.get(virtualPath);
            if (type == Type.FILE) {
                if (!virtualPath.equals(virtualPath2)) continue;
                return true;
            }
            if (type == Type.FOLDER) {
                virtualPath2.removeLastSegment();
                if (!virtualPath.equals(virtualPath2)) continue;
                return true;
            }
            if (type != Type.RECURSIVE || !virtualPath.isPrefixOf(virtualPath2)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        FILE,
        FOLDER,
        RECURSIVE;

    }
}

