/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.debug.core.IPHPConsoleEventListener;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.model.SimpleDebugHandler;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugError;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.StartLock;

public class ServerDebugHandler
extends SimpleDebugHandler {
    private IRemoteDebugger fRemoteDebugger;
    private boolean fStatus;
    protected PHPDebugTarget fDebugTarget;
    protected DebugConnectionThread fConnectionThread;

    protected IRemoteDebugger createRemoteDebugger() {
        return new RemoteDebugger(this, this.fConnectionThread);
    }

    public IRemoteDebugger getRemoteDebugger() {
        return this.fRemoteDebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionStarted(String string, String string2, String string3, String string4) {
        Object object;
        super.sessionStarted(string, string2, string3, string4);
        if (this.isUsingPathMapper()) {
            try {
                object = new File(string);
                if (((File)object).exists()) {
                    string = ((File)object).getCanonicalPath();
                }
            }
            catch (Exception exception) {}
            this.fDebugTarget.mapFirstDebugFile(string);
        }
        this.fDebugTarget.setLastFileName(string);
        if (!this.fDebugTarget.isPHPCGI()) {
            this.fDebugTarget.setServerWindows(false);
        }
        Object object2 = object = this.fDebugTarget.getStartLock();
        synchronized (object2) {
            if (((StartLock)object).isRunStart()) {
                ((StartLock)object).setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "PHPDebugTarget: debugger.start return false");
                    try {
                        this.fDebugTarget.disconnect();
                    }
                    catch (DebugException debugException) {
                        Logger.logException(debugException);
                    }
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                ((StartLock)object).setRunStart(true);
            }
        }
    }

    protected boolean isUsingPathMapper() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEstablished() {
        StartLock startLock;
        super.connectionEstablished();
        StartLock startLock2 = startLock = this.fDebugTarget.getStartLock();
        synchronized (startLock2) {
            if (startLock.isRunStart()) {
                startLock.setStarted(true);
                this.fDebugTarget.started();
                this.fStatus = this.getRemoteDebugger().start(this.fDebugTarget.getStartResponseHandler());
                if (!this.fStatus) {
                    Logger.log(4, "PHPDebugTarget: debugger.start return false");
                }
                this.fDebugTarget.setLastCommand("start");
            } else {
                startLock.setRunStart(true);
            }
        }
    }

    public void ready(String string, int n) {
        super.ready(string, n);
        this.fDebugTarget.setLastStop(n);
        this.fDebugTarget.setLastFileName(string);
        String string2 = this.fDebugTarget.getLastCommand();
        Logger.debugMSG("[" + this + "] PHPDebugTarget: lastCMD " + string2);
        this.fDebugTarget.setBreakpoints(new IBreakpoint[0]);
        ILaunchConfiguration iLaunchConfiguration = this.fDebugTarget.getLaunch().getLaunchConfiguration();
        try {
            this.fDebugTarget.setExpressionManager(new DefaultExpressionsManager(this.fRemoteDebugger, iLaunchConfiguration.getAttribute("debugTransferEncoding", "")));
        }
        catch (CoreException coreException) {}
        if (string2.equals("start")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), n);
        } else if (string2.equals("resume")) {
            this.fDebugTarget.breakpointHit(this.fDebugTarget.getLastFileName(), n);
        } else if (string2.equals("suspend")) {
            this.fDebugTarget.suspended(32);
        } else if (string2.equals("stepReturn")) {
            this.fDebugTarget.suspended(4);
        } else if (string2.equals("stepOver")) {
            this.fDebugTarget.suspended(2);
        } else if (string2.equals("stepInto")) {
            this.fDebugTarget.suspended(1);
        } else if (string2.equals("terminate")) {
            this.fRemoteDebugger.finish();
            this.fDebugTarget.terminated();
        } else if (!string2.equals("breakpointAdded")) {
            string2.equals("breakpointRemoved");
        }
    }

    public void sessionEnded() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Starting sessionEnded()");
        super.sessionEnded();
    }

    public void connectionClosed() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget:Starting connectionClosed()");
        super.connectionClosed();
        this.fRemoteDebugger.finish();
        Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling Terminated()");
        this.fDebugTarget.terminated();
    }

    public void handleScriptEnded() {
        Logger.debugMSG("[" + this + "] PHPDebugTarget: handleScriptEnded");
        try {
            Logger.debugMSG("[" + this + "] PHPDebugTarget: Calling Terminate()");
            this.fDebugTarget.terminate();
        }
        catch (DebugException debugException) {
            Logger.logException("PHPDebugTarget: terminate failed", debugException);
        }
    }

    public void multipleBindOccured() {
        super.multipleBindOccured();
        Logger.log(2, "PHPDebugTarget: Multiple Bind Occured");
        String string = PHPDebugCoreMessages.DebuggerDebugPortInUse_1;
        this.fRemoteDebugger.closeConnection();
        this.fDebugTarget.fireError(string, null);
        this.fDebugTarget.terminated();
    }

    public void parsingErrorOccured(DebugError debugError) {
        Object[] objectArray;
        super.parsingErrorOccured(debugError);
        String string = ((RemoteDebugger)this.fRemoteDebugger).convertToLocalFilename(debugError.getFullPathName(), null, null);
        if (string == null) {
            string = debugError.getFullPathName();
        }
        debugError.setFileName(string);
        this.fDebugTarget.getDebugErrors().add(debugError);
        Object[] objectArray2 = objectArray = this.fDebugTarget.getConsoleEventListeners().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            ((IPHPConsoleEventListener)object).handleEvent(debugError);
            ++n2;
        }
    }

    public void wrongDebugServer() {
        super.wrongDebugServer();
        this.fDebugTarget.fireError("Incompatible Debug Server version.", null);
        this.fRemoteDebugger.finish();
    }

    public void newOutput(String string) {
        super.newOutput(string);
        this.fDebugTarget.getOutputBufffer().append(string);
        this.fDebugTarget.getOutputBufffer().incrementUpdateCount();
    }

    public void newHeaderOutput(String string) {
        super.newHeaderOutput(string);
        this.fDebugTarget.getOutputBufffer().append(string);
        this.fDebugTarget.getOutputBufffer().incrementUpdateCount();
    }

    public void setDebugTarget(PHPDebugTarget pHPDebugTarget) {
        this.fDebugTarget = pHPDebugTarget;
        this.fConnectionThread = this.fDebugTarget.getConnectionThread();
        this.fRemoteDebugger = this.createRemoteDebugger();
        this.fConnectionThread.getCommunicationAdministrator().connectionEstablished();
    }

    public PHPDebugTarget getDebugTarget() {
        return this.fDebugTarget;
    }
}

