/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.locator;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ArrayAccess;
import org.eclipse.php.internal.core.ast.nodes.Dispatch;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.GlobalStatement;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.nodes.StaticDispatch;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;

public class PhpElementConciliator {
    private static final String THIS = "this";
    public static final int CONCILIATOR_UNKNOWN = 0;
    public static final int CONCILIATOR_GLOBAL_VARIABLE = 1;
    public static final int CONCILIATOR_FUNCTION = 2;
    public static final int CONCILIATOR_LOCAL_VARIABLE = 3;
    public static final int CONCILIATOR_CLASSNAME = 4;
    public static final int CONCILIATOR_CONSTANT = 5;
    public static final int CONCILIATOR_CLASS_MEMBER = 6;
    public static final int CONCILIATOR_PROGRAM = 7;

    public static int concile(ASTNode aSTNode) {
        if (aSTNode == null || PhpElementConciliator.isProgram(aSTNode)) {
            return 7;
        }
        if (PhpElementConciliator.isGlobalVariable(aSTNode)) {
            return 1;
        }
        if (PhpElementConciliator.isFunction(aSTNode)) {
            return 2;
        }
        if (PhpElementConciliator.isClassName(aSTNode)) {
            return 4;
        }
        if (PhpElementConciliator.isConstant(aSTNode)) {
            return 5;
        }
        if (PhpElementConciliator.isLocalVariable(aSTNode)) {
            return 3;
        }
        if (PhpElementConciliator.isDispatch(aSTNode)) {
            return 6;
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isDispatch(ASTNode var0) {
        if (!PhpElementConciliator.$assertionsDisabled && var0 == null) {
            throw new AssertionError();
        }
        if (var0.getType() != 33) {
            return false;
        }
        var1_1 = var0.getParent();
        if (var1_1.getType() == 29) {
            return var1_1.getParent() != null && (var1_1 = var1_1.getParent()).getType() == 42;
        }
        if (var1_1.getType() == 60) {
            var2_2 = (Identifier)var0;
            var3_3 = (Variable)var1_1;
            if (var2_2.getName().equals("this") && var3_3.isDollared()) {
                return false;
            }
            if (var1_1.getParent().getType() == 25) {
                return true;
            }
        }
        if (var1_1.getType() != 11) ** GOTO lbl20
        return true;
lbl-1000:
        // 1 sources

        {
            if (var1_1 instanceof Dispatch || var1_1 instanceof StaticDispatch) {
                return true;
            }
            var1_1 = var1_1.getParent();
lbl20:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl21:
        // 1 sources

        return false;
    }

    private static boolean isConstant(ASTNode aSTNode) {
        assert (aSTNode != null);
        if (aSTNode.getType() != 51) {
            return false;
        }
        Scalar scalar = (Scalar)aSTNode;
        if (scalar.getScalarType() != 2 || scalar.getStringValue() == null) {
            return false;
        }
        int n = scalar.getStringValue().length() - 1;
        char c = scalar.getStringValue().charAt(0);
        char c2 = scalar.getStringValue().charAt(n);
        if (!PhpElementConciliator.detectString(c2) && !PhpElementConciliator.detectString(c)) {
            return true;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2.getType() != 30) {
            return false;
        }
        FunctionInvocation functionInvocation = (FunctionInvocation)aSTNode2;
        if (functionInvocation.getFunctionName().getFunctionName().getType() != 33) {
            return false;
        }
        Identifier identifier = (Identifier)functionInvocation.getFunctionName().getFunctionName();
        return "define".equalsIgnoreCase(identifier.getName());
    }

    private static boolean isClassName(ASTNode aSTNode) {
        StaticDispatch staticDispatch;
        assert (aSTNode != null);
        if (aSTNode.getType() != 33) {
            return false;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        int n = aSTNode2.getType();
        if (n == 14 || n == 12 || n == 40 || n == 9 || n == 27) {
            return true;
        }
        return (n == 53 || n == 52 || n == 10) && (staticDispatch = (StaticDispatch)aSTNode2).getClassName() == aSTNode;
    }

    private static boolean isLocalVariable(ASTNode aSTNode) {
        assert (aSTNode != null);
        if (aSTNode.getType() != 33) {
            return false;
        }
        Identifier identifier = (Identifier)aSTNode;
        if (identifier.getParent().getType() != 60) {
            return false;
        }
        Variable variable = (Variable)identifier.getParent();
        if (!variable.isDollared() || identifier.getName().equals(THIS) || variable.getType() == 25) {
            return false;
        }
        ASTNode aSTNode2 = variable;
        while (aSTNode2 != null) {
            int n = ((ASTNode)aSTNode2).getType();
            if (n == 29) {
                return true;
            }
            aSTNode2 = aSTNode2.getParent();
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isGlobalVariable(ASTNode var0) {
        if (!PhpElementConciliator.$assertionsDisabled && var0 == null) {
            throw new AssertionError();
        }
        if (var0.getType() == 51) {
            var1_1 = (Scalar)var0;
            return PhpElementConciliator.checkGLOBALS(var1_1);
        }
        if (var0.getType() != 33) {
            return false;
        }
        var1_2 = (Identifier)var0;
        var2_3 = var0.getParent();
        if (var2_3.getType() != 60) {
            return false;
        }
        var3_4 = (Variable)var2_3;
        if (!var3_4.isDollared() || var3_4.getParent().getType() == 25) {
            return false;
        }
        if (var2_3.getParent().getType() != 52 || (var4_5 = (StaticFieldAccess)var2_3.getParent()).getMember() != var3_4) ** GOTO lbl23
        return false;
lbl-1000:
        // 1 sources

        {
            if (var2_3.getType() == 29) {
                var4_6 = var2_3.getEnd();
                var5_7 = new GlobalSeacher(var4_6, var1_2);
                var2_3.accept(var5_7);
                return var5_7.offset <= var1_2.getStart();
            }
            var2_3 = var2_3.getParent();
lbl23:
            // 2 sources

            ** while (var2_3 != null)
        }
lbl24:
        // 1 sources

        return var2_3 == null;
    }

    private static boolean checkGLOBALS(Scalar scalar) {
        Identifier identifier;
        Variable variable;
        ArrayAccess arrayAccess;
        Expression expression;
        String string = scalar.getStringValue();
        if (scalar.getScalarType() != 2 || string.length() < 3) {
            return false;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(string.length() - 1);
        if (!PhpElementConciliator.detectString(c) || !PhpElementConciliator.detectString(c2)) {
            return false;
        }
        return scalar.getParent().getType() == 0 && (expression = (arrayAccess = (ArrayAccess)scalar.getParent()).getVariableName()).getType() == 60 && (variable = (Variable)expression).isDollared() && variable.getVariableName().getType() == 33 && (identifier = (Identifier)variable.getVariableName()).getName().equals("GLOBALS");
    }

    private static boolean checkGlobal(Identifier identifier, GlobalStatement globalStatement) {
        Variable[] variableArray;
        Variable[] variableArray2 = variableArray = globalStatement.getVariables();
        int n = variableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray2[n2];
            assert (variable.getVariableName().getType() == 33);
            Identifier identifier2 = (Identifier)variable.getVariableName();
            if (identifier2.getName().equals(identifier.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static final boolean detectString(char c) {
        return c == '\'' || c == '\"';
    }

    private static boolean isFunction(ASTNode aSTNode) {
        int n;
        assert (aSTNode != null);
        if (aSTNode.getType() != 33) {
            return false;
        }
        Identifier identifier = (Identifier)aSTNode;
        ASTNode aSTNode2 = identifier.getParent();
        if (aSTNode2.getType() != 29 && aSTNode2.getType() != 31) {
            return false;
        }
        int n2 = aSTNode2.getParent().getType();
        return !(n2 == 30 ? (n = aSTNode2.getParent().getParent().getType()) == 42 || n == 53 : n2 == 42);
    }

    private static boolean isProgram(ASTNode aSTNode) {
        assert (aSTNode != null);
        return aSTNode.getType() == 46;
    }

    public static boolean constantAlreadyExists(Program program, String string) {
        assert (program != null && string != null);
        DefinedSearcher definedSearcher = new DefinedSearcher(string);
        program.accept(definedSearcher);
        return definedSearcher.constantAlreadyExists();
    }

    public static boolean classNameAlreadyExists(Program program, String string) {
        assert (program != null && string != null);
        ClassSearcher classSearcher = new ClassSearcher(string);
        program.accept(classSearcher);
        return classSearcher.classNameAlreadyExists();
    }

    public static boolean localVariableAlreadyExists(FunctionDeclaration functionDeclaration, String string) {
        assert (functionDeclaration != null && string != null);
        LocalVariableSearcher localVariableSearcher = new LocalVariableSearcher(string);
        functionDeclaration.accept(localVariableSearcher);
        return localVariableSearcher.localVariableAlreadyExists();
    }

    public static boolean functionAlreadyExists(Program program, String string) {
        assert (program != null && string != null);
        FunctionSearcher functionSearcher = new FunctionSearcher(string);
        program.accept(functionSearcher);
        return functionSearcher.functionAlreadyExists();
    }

    public static boolean globalVariableAlreadyExists(Program program, String string) {
        assert (program != null && string != null);
        GlobalVariableSearcher globalVariableSearcher = new GlobalVariableSearcher(string);
        program.accept(globalVariableSearcher);
        return globalVariableSearcher.globalVariableAlreadyExists();
    }

    private static class ClassSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public ClassSearcher(String string) {
            this.name = string;
        }

        public void apply(ASTNode aSTNode) {
            if (this.exists) {
                return;
            }
            if (aSTNode.getType() == 12 || aSTNode.getType() == 40) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)aSTNode;
                if (typeDeclaration.getName().getName().equals(this.name)) {
                    this.exists = true;
                }
            } else {
                aSTNode.childrenAccept(this);
            }
        }

        public boolean classNameAlreadyExists() {
            return this.exists;
        }
    }

    private static class DefinedSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public DefinedSearcher(String string) {
            this.name = string;
        }

        public void apply(ASTNode aSTNode) {
            if (this.exists) {
                return;
            }
            if (aSTNode.getType() == 51) {
                Scalar scalar = (Scalar)aSTNode;
                String string = scalar.getStringValue();
                if (scalar.getScalarType() != 2 || string == null) {
                    return;
                }
                int n = string.length() - 1;
                if (string.charAt(0) != '\"' && string.charAt(n) != '\"' && string.equals(this.name)) {
                    this.exists = true;
                }
            } else if (aSTNode.getType() == 30) {
                FunctionInvocation functionInvocation = (FunctionInvocation)aSTNode;
                Expression expression = functionInvocation.getFunctionName().getFunctionName();
                if (expression.getType() != 33) {
                    return;
                }
                Identifier identifier = (Identifier)expression;
                Expression[] expressionArray = functionInvocation.getParameters();
                if (!"define".equalsIgnoreCase(identifier.getName()) || expressionArray == null || expressionArray.length == 0) {
                    return;
                }
                Expression expression2 = expressionArray[0];
                if (expression2.getType() != 51) {
                    return;
                }
                Scalar scalar = (Scalar)expression2;
                String string = scalar.getStringValue();
                if (string.length() < 2 || string.charAt(0) != '\"') {
                    return;
                }
                this.exists = this.name.equals(string.substring(1, string.length() - 1));
            } else {
                aSTNode.childrenAccept(this);
            }
        }

        public boolean constantAlreadyExists() {
            return this.exists;
        }
    }

    private static class FunctionSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public FunctionSearcher(String string) {
            this.name = string;
        }

        public void apply(ASTNode aSTNode) {
            if (this.exists) {
                return;
            }
            if (aSTNode.getType() != 12) {
                if (aSTNode.getType() == 29) {
                    FunctionDeclaration functionDeclaration = (FunctionDeclaration)aSTNode;
                    Identifier identifier = functionDeclaration.getFunctionName();
                    if (identifier.getName().equalsIgnoreCase(this.name)) {
                        this.exists = true;
                    }
                } else {
                    aSTNode.childrenAccept(this);
                }
            }
        }

        public boolean functionAlreadyExists() {
            return this.exists;
        }
    }

    private static class GlobalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private boolean isGlobalScope = true;
        private final String name;

        public GlobalVariableSearcher(String string) {
            this.name = string;
        }

        public void apply(ASTNode aSTNode) {
            if (this.exists) {
                return;
            }
            if (aSTNode.getType() == 12 || aSTNode.getType() == 29) {
                this.isGlobalScope = false;
                aSTNode.childrenAccept(this);
                this.isGlobalScope = true;
            } else if (aSTNode.getType() == 33) {
                Variable variable;
                Identifier identifier = (Identifier)aSTNode;
                if (identifier.getParent().getType() == 60 && (variable = (Variable)identifier.getParent()).isDollared() && this.isGlobalScope && this.name.equals(identifier.getName())) {
                    this.exists = true;
                }
            } else if (aSTNode.getType() == 32) {
                Variable[] variableArray;
                GlobalStatement globalStatement = (GlobalStatement)aSTNode;
                Variable[] variableArray2 = variableArray = globalStatement.getVariables();
                int n = variableArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Identifier identifier;
                    Variable variable = variableArray2[n2];
                    Expression expression = variable.getVariableName();
                    if (variable.isDollared() && expression.getType() == 33 && this.name.equals((identifier = (Identifier)expression).getName())) {
                        this.exists = true;
                    }
                    ++n2;
                }
            } else {
                aSTNode.childrenAccept(this);
            }
        }

        public boolean globalVariableAlreadyExists() {
            return this.exists;
        }
    }

    private static class LocalVariableSearcher
    extends ApplyAll {
        private boolean exists = false;
        private final String name;

        public LocalVariableSearcher(String string) {
            this.name = string;
        }

        public void apply(ASTNode aSTNode) {
            if (this.exists) {
                return;
            }
            if (aSTNode.getType() == 60) {
                Variable variable = (Variable)aSTNode;
                if (variable.isDollared()) {
                    assert (variable.getVariableName().getType() == 33);
                    Identifier identifier = (Identifier)variable.getVariableName();
                    if (identifier.getName().equals(this.name)) {
                        this.exists = true;
                    }
                }
            } else {
                aSTNode.childrenAccept(this);
            }
        }

        public boolean localVariableAlreadyExists() {
            return this.exists;
        }
    }
}

