/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class Scalar
extends Expression {
    public static final int TYPE_INT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_SYSTEM = 4;
    private final String stringValue;
    private final int scalarType;

    public Scalar(int n, int n2, String string, int n3) {
        super(n, n2);
        this.stringValue = string;
        this.scalarType = n3;
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
    }

    public void traverseBottomUp(Visitor visitor) {
    }

    public void traverseTopDown(Visitor visitor) {
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<Scalar");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" type='").append(Scalar.getType(this.scalarType)).append("'");
        if (this.stringValue != null) {
            stringBuffer.append(" value='").append(Scalar.getXmlStringValue(this.stringValue)).append("'");
        }
        stringBuffer.append("/>");
    }

    public static String getType(int n) {
        switch (n) {
            case 0: {
                return "int";
            }
            case 1: {
                return "real";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "unknown";
            }
            case 4: {
                return "system";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 51;
    }

    public int getScalarType() {
        return this.scalarType;
    }

    public String getStringValue() {
        return this.stringValue;
    }
}

