/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.IPHPLanguageModel;
import org.eclipse.php.internal.core.phpModel.IPHPModelExtension;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPLanguageManager;
import org.eclipse.php.internal.core.phpModel.parser.PHPParserManager;
import org.eclipse.php.internal.core.phpModel.parser.ParserClient;
import org.eclipse.php.internal.core.phpModel.parser.ParserExecuter;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.osgi.framework.Bundle;

public abstract class PHPLanguageModel
implements IPHPLanguageModel {
    protected PHPFunctionData[] functions = PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY;
    protected Map<String, PHPFunctionData> functionsHash = new HashMap<String, PHPFunctionData>(3000);
    protected PHPClassData[] classes = PHPCodeDataFactory.EMPTY_CLASS_DATA_ARRAY;
    protected Map<String, PHPClassData> classesHash = new HashMap<String, PHPClassData>(10);
    protected PHPConstantData[] constants = PHPCodeDataFactory.EMPTY_CONSTANT_DATA_ARRAY;
    protected IPHPMarker[] markers = PHPCodeDataFactory.EMPTY_MARKERS_DATA_ARRAY;
    protected PHPVariableData[] phpVariables;
    protected PHPVariableData[] serverVariables;
    protected PHPVariableData[] sessionVariables;
    protected PHPVariableData[] classVariables;

    public PHPLanguageModel(PHPLanguageManager pHPLanguageManager) {
        this.loadFiles(pHPLanguageManager);
        this.initVariables();
    }

    public PHPVariableData[] getPHPVariables() {
        return this.phpVariables;
    }

    public PHPVariableData[] getServerVariables() {
        return this.serverVariables;
    }

    public PHPVariableData[] getSessionVariables() {
        return this.sessionVariables;
    }

    public PHPVariableData[] getClassVariables() {
        return this.classVariables;
    }

    public CodeData[] getFunctions() {
        return this.functions;
    }

    public CodeData[] getFunction(String string) {
        PHPFunctionData pHPFunctionData = this.getFunction(null, string);
        if (pHPFunctionData == null) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return new PHPFunctionData[]{pHPFunctionData};
    }

    public PHPFunctionData getFunction(String string, String string2) {
        return this.functionsHash.get(string2);
    }

    public CodeData[] getFunctions(String string) {
        return ModelSupport.getCodeDataStartingWith(this.getFunctions(), string);
    }

    public CodeData[] getClasses() {
        return this.classes;
    }

    public CodeData[] getClasses(String string) {
        return ModelSupport.getCodeDataStartingWith(this.classes, string);
    }

    public CodeData[] getConstants() {
        return this.constants;
    }

    public CodeData[] getConstants(String string, boolean bl) {
        return bl ? ModelSupport.getCodeDataStartingWithCS(this.getConstants(), string) : ModelSupport.getCodeDataStartingWith(this.getConstants(), string);
    }

    public PHPConstantData getConstant(String string, String string2) {
        return null;
    }

    public CodeData[] getFileDatas() {
        return null;
    }

    public CodeData[] getNonPHPFiles(String string) {
        return null;
    }

    public PHPFileData getFileData(String string) {
        return null;
    }

    public PHPClassData getClass(String string, String string2) {
        return this.classesHash.get(this.getNormalizedString(string2));
    }

    public CodeData[] getClass(String string) {
        PHPClassData pHPClassData = this.getClass(null, string);
        if (pHPClassData == null) {
            return PHPCodeDataFactory.EMPTY_CODE_DATA_ARRAY;
        }
        return new CodeData[]{pHPClassData};
    }

    public CodeData[] getGlobalVariables(String string, String string2, boolean bl) {
        return this.phpVariables;
    }

    public CodeData[] getVariables(String string, PHPCodeContext pHPCodeContext, String string2, boolean bl) {
        String string3 = pHPCodeContext.getContainerClassName();
        if (string3 == null || string3.equals("")) {
            return this.phpVariables;
        }
        return ModelSupport.merge(this.phpVariables, this.classVariables);
    }

    public String getVariableType(String string, PHPCodeContext pHPCodeContext, String string2, int n, boolean bl) {
        return null;
    }

    public CodeData[] getConstant(String string) {
        return null;
    }

    public IPHPMarker[] getMarkers() {
        return this.markers;
    }

    public void clear() {
    }

    public void dispose() {
    }

    public void initialize(IProject iProject) {
    }

    private final String getNormalizedString(String string) {
        return string == null ? null : string.trim().toLowerCase();
    }

    private void initVariables() {
        this.phpVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("_GET", null, null), PHPCodeDataFactory.createPHPVariableData("_POST", null, null), PHPCodeDataFactory.createPHPVariableData("_COOKIE", null, null), PHPCodeDataFactory.createPHPVariableData("_SESSION", null, null), PHPCodeDataFactory.createPHPVariableData("_SERVER", null, null), PHPCodeDataFactory.createPHPVariableData("_ENV", null, null), PHPCodeDataFactory.createPHPVariableData("_REQUEST", null, null), PHPCodeDataFactory.createPHPVariableData("_FILES", null, null), PHPCodeDataFactory.createPHPVariableData("GLOBALS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_GET_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_POST_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_COOKIE_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_SESSION_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_SERVER_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ENV_VARS", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_POST_FILES", null, null)};
        Arrays.sort(this.phpVariables);
        this.serverVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("DOCUMENT_ROOT", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT_ENCODING", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_ACCEPT_LANGUAGE", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_CONNECTION", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_HOST", null, null), PHPCodeDataFactory.createPHPVariableData("HTTP_USER_AGENT", null, null), PHPCodeDataFactory.createPHPVariableData("REMOTE_ADDR", null, null), PHPCodeDataFactory.createPHPVariableData("SCRIPT_FILENAME", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_NAME", null, null), PHPCodeDataFactory.createPHPVariableData("GATEWAY_INTERFACE", null, null), PHPCodeDataFactory.createPHPVariableData("REQUEST_METHOD", null, null), PHPCodeDataFactory.createPHPVariableData("QUERY_STRING", null, null), PHPCodeDataFactory.createPHPVariableData("REQUEST_URI", null, null), PHPCodeDataFactory.createPHPVariableData("SCRIPT_NAME", null, null), PHPCodeDataFactory.createPHPVariableData("PHP_SELF", null, null), PHPCodeDataFactory.createPHPVariableData("PATH", null, null), PHPCodeDataFactory.createPHPVariableData("REMOTE_PORT", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_ADDR", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_ADMIN", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_PORT", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_SIGNATURE", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_SOFTWARE", null, null), PHPCodeDataFactory.createPHPVariableData("SERVER_PROTOCOL", null, null), PHPCodeDataFactory.createPHPVariableData("PATH_TRANSLATED", null, null)};
        Arrays.sort(this.serverVariables);
        this.classVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("this", null, null)};
        Arrays.sort(this.classVariables);
        this.sessionVariables = new PHPVariableData[]{PHPCodeDataFactory.createPHPVariableData("SID", null, null)};
    }

    protected void loadFiles(PHPLanguageManager pHPLanguageManager) {
        try {
            IConfigurationElement[] iConfigurationElementArray;
            PHPParserManager pHPParserManager = pHPLanguageManager.createPHPParserManager();
            String string = pHPLanguageManager.getPHPFunctionPath();
            InputStreamReader inputStreamReader = new InputStreamReader(FileLocator.openStream((Bundle)PHPCorePlugin.getDefault().getBundle(), (IPath)new Path(string), (boolean)false));
            InnerParserClient innerParserClient = new InnerParserClient();
            ParserExecuter parserExecuter = new ParserExecuter(pHPParserManager, null, innerParserClient, string, inputStreamReader, new Pattern[0], 0L, false);
            parserExecuter.run();
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor("org.eclipse.php.core", "phpModelExtensions");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
                if ("model".equals(iConfigurationElement.getName())) {
                    String string2 = iConfigurationElement.getAttribute("id");
                    try {
                        String string3 = iConfigurationElement.getAttribute("enabled");
                        boolean bl = string3 == null ? true : Boolean.parseBoolean(string3);
                        String string4 = iConfigurationElement.getAttribute("file");
                        String string5 = iConfigurationElement.getAttribute("phpVersion");
                        if (iConfigurationElement.getAttribute("class") != null) {
                            IPHPModelExtension iPHPModelExtension = (IPHPModelExtension)iConfigurationElement.createExecutableExtension("class");
                            bl = iPHPModelExtension.isEnabled();
                            if (iPHPModelExtension.getFile() != null) {
                                string4 = iPHPModelExtension.getFile();
                            }
                            if (iPHPModelExtension.getPHPVersion() != null) {
                                string5 = iPHPModelExtension.getPHPVersion();
                            }
                        }
                        if (bl && this.getPHPVersion().equals(string5)) {
                            inputStreamReader = new InputStreamReader(FileLocator.openStream((Bundle)Platform.getBundle((String)iConfigurationElement.getNamespaceIdentifier()), (IPath)new Path(string4), (boolean)false));
                            innerParserClient = new InnerParserClient();
                            parserExecuter = new ParserExecuter(pHPParserManager, null, innerParserClient, string4, inputStreamReader, new Pattern[0], 0L, false);
                            parserExecuter.run();
                        }
                    }
                    catch (CoreException coreException) {
                        PHPCorePlugin.logErrorMessage(NLS.bind((String)"Error loading PHP model extension ID {0}", (Object)string2));
                    }
                }
                ++n2;
            }
            Arrays.sort(this.functions);
            Arrays.sort(this.classes);
            Arrays.sort(this.constants);
        }
        catch (IOException iOException) {
            PHPCorePlugin.log(iOException);
        }
    }

    protected class InnerParserClient
    implements ParserClient {
        private String className = "";
        private List<PHPFunctionData> functionsList = new ArrayList<PHPFunctionData>(3000);
        private List<PHPClassConstData> classConstsList = new ArrayList<PHPClassConstData>();
        private List<PHPClassVarData> classVarsList = new ArrayList<PHPClassVarData>();
        private List<PHPFunctionData> classFunctionsList = new ArrayList<PHPFunctionData>();
        private List<PHPClassData> classesList = new ArrayList<PHPClassData>();
        private List<PHPConstantData> constansList = new ArrayList<PHPConstantData>(2000);
        private List<PHPFunctionData.PHPFunctionParameter> functionParametersList = new ArrayList<PHPFunctionData.PHPFunctionParameter>();

        protected InnerParserClient() {
        }

        public void dispose() {
            this.functionsList.clear();
            this.classConstsList.clear();
            this.classVarsList.clear();
            this.classFunctionsList.clear();
            this.classesList.clear();
            this.constansList.clear();
            this.functionParametersList.clear();
        }

        public void handleFunctionParameter(String string, String string2, boolean bl, boolean bl2, String string3, int n, int n2, int n3, int n4) {
            string2 = string2.substring(1);
            this.functionParametersList.add(PHPCodeDataFactory.createPHPFunctionParameter(string2, null, bl, bl2, string, string3));
        }

        public void hadleClassDeclarationStarts(String string, int n) {
            this.className = string;
        }

        private PHPFunctionData.PHPFunctionParameter getParameter(PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray, String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            if (string.charAt(0) == '&') {
                string = string.substring(1);
            }
            if (string.charAt(0) == '$') {
                string = string.substring(1);
            }
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray2 = pHPFunctionParameterArray;
            int n = pHPFunctionParameterArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPFunctionData.PHPFunctionParameter pHPFunctionParameter = pHPFunctionParameterArray2[n2];
                if (string.equalsIgnoreCase(pHPFunctionParameter.getName())) {
                    return pHPFunctionParameter;
                }
                ++n2;
            }
            return null;
        }

        public void handleFunctionDeclarationStarts(String string) {
        }

        public void handleFunctionDeclaration(String string, boolean bl, int n, PHPDocBlock pHPDocBlock, int n2, int n3, int n4) {
            Object object;
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = new PHPFunctionData.PHPFunctionParameter[this.functionParametersList.size()];
            this.functionParametersList.toArray(pHPFunctionParameterArray);
            this.functionParametersList.clear();
            String string2 = null;
            if (pHPDocBlock != null) {
                Iterator<PHPDocTag> iterator;
                object = pHPDocBlock.getTags(7);
                while (object.hasNext()) {
                    String string3;
                    PHPFunctionData.PHPFunctionParameter pHPFunctionParameter;
                    iterator = object.next();
                    String string4 = iterator.getValue().trim();
                    String[] stringArray = string4.split(" ");
                    String string5 = null;
                    String string6 = null;
                    int n5 = stringArray.length > 2 ? 2 : stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        if (stringArray[n6].startsWith("$")) {
                            string5 = stringArray[n6];
                        } else {
                            string6 = stringArray[n6];
                        }
                        ++n6;
                    }
                    if (string5 == null) {
                        string5 = stringArray[0];
                    }
                    if ((pHPFunctionParameter = this.getParameter(pHPFunctionParameterArray, string5)) == null) {
                        string6 = stringArray[0];
                        string5 = stringArray.length > 1 ? stringArray[1] : null;
                        pHPFunctionParameter = this.getParameter(pHPFunctionParameterArray, string6);
                    }
                    if (pHPFunctionParameter == null || string6 == null || string6.length() <= 0 || (string3 = pHPFunctionParameter.getClassType()) != null && string3.length() != 0) continue;
                    pHPFunctionParameter.setClassType(string6);
                }
                iterator = pHPDocBlock.getTags(6);
                String string7 = string2 = iterator.hasNext() ? ((PHPDocTag)iterator.next()).getValue() : null;
            }
            if (string2 == null) {
                string2 = bl && string.equals(this.className) ? this.className : "void";
            }
            object = PHPCodeDataFactory.createPHPFuctionData(string, n, pHPDocBlock, null, pHPFunctionParameterArray, string2);
            if (bl) {
                this.classFunctionsList.add((PHPFunctionData)object);
            } else {
                this.functionsList.add((PHPFunctionData)object);
            }
        }

        public void handleFunctionDeclarationEnds(String string, boolean bl, int n) {
        }

        public void handleClassDeclaration(String string, int n, String string2, String string3, PHPDocBlock pHPDocBlock, int n2, int n3, int n4) {
            PHPClassData.PHPInterfaceNameData[] pHPInterfaceNameDataArray;
            Object object;
            PHPClassData.PHPSuperClassNameData pHPSuperClassNameData;
            if (string2 != null) {
                int n5 = string2.indexOf(93);
                string2 = string2.substring(n5 + 1);
                pHPSuperClassNameData = PHPCodeDataFactory.createPHPSuperClassNameData(string2, null);
            } else {
                pHPSuperClassNameData = PHPCodeDataFactory.createPHPSuperClassNameData(string2, null);
            }
            if (string3 != null) {
                object = string3.split(",");
                pHPInterfaceNameDataArray = new PHPClassData.PHPInterfaceNameData[((String[])object).length];
                int n6 = 0;
                while (n6 < ((String[])object).length) {
                    String string4 = object[n6];
                    int n7 = string4.indexOf(93);
                    string4 = string4.substring(n7 + 1);
                    pHPInterfaceNameDataArray[n6] = PHPCodeDataFactory.createPHPInterfaceNameData(string4, null);
                    ++n6;
                }
            } else {
                pHPInterfaceNameDataArray = PHPCodeDataFactory.EMPTY_INTERFACES_DATA_ARRAY;
            }
            object = PHPCodeDataFactory.createPHPClassData(string, n, pHPDocBlock, null, pHPSuperClassNameData, pHPInterfaceNameDataArray, PHPCodeDataFactory.EMPTY_CLASS_VAR_DATA_ARRAY, PHPCodeDataFactory.EMPTY_CLASS_CONST_DATA_ARRAY, PHPCodeDataFactory.EMPTY_FUNCTIONS_DATA_ARRAY);
            this.classesList.add((PHPClassData)object);
        }

        public void handleClassDeclarationEnds(String string, int n) {
            PHPCodeDataFactory.PHPClassDataImp pHPClassDataImp;
            if (this.classesList.size() > 0 && (pHPClassDataImp = (PHPCodeDataFactory.PHPClassDataImp)this.classesList.get(this.classesList.size() - 1)).getName().equals(string)) {
                Object[] objectArray = new PHPClassConstData[this.classConstsList.size()];
                this.classConstsList.toArray(objectArray);
                Arrays.sort(objectArray);
                Object[] objectArray2 = new PHPClassVarData[this.classVarsList.size()];
                this.classVarsList.toArray(objectArray2);
                Arrays.sort(objectArray2);
                Object[] objectArray3 = new PHPFunctionData[this.classFunctionsList.size()];
                this.classFunctionsList.toArray(objectArray3);
                Arrays.sort(objectArray3);
                int n2 = 0;
                while (n2 < objectArray.length) {
                    ((PHPCodeDataFactory.PHPClassConstDataImp)objectArray[n2]).setContainer(pHPClassDataImp);
                    ++n2;
                }
                Object[] objectArray4 = objectArray2;
                int n3 = objectArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray4[n4];
                    ((PHPCodeDataFactory.PHPClassVarDataImp)object).setContainer(pHPClassDataImp);
                    ++n4;
                }
                objectArray4 = objectArray3;
                n3 = objectArray3.length;
                n4 = 0;
                while (n4 < n3) {
                    Object object = objectArray4[n4];
                    ((PHPCodeDataFactory.PHPFunctionDataImp)object).setContainer(pHPClassDataImp);
                    ++n4;
                }
                pHPClassDataImp.setConsts((PHPClassConstData[])objectArray);
                pHPClassDataImp.setFunctions((PHPFunctionData[])objectArray3);
                pHPClassDataImp.setVars((PHPClassVarData[])objectArray2);
            }
            this.classConstsList.clear();
            this.classVarsList.clear();
            this.classFunctionsList.clear();
            this.className = "";
        }

        public void handleClassVariablesDeclaration(String string, int n, PHPDocBlock pHPDocBlock, int n2, int n3, int n4) {
            Object object;
            Object object2;
            Object object3;
            String string2 = null;
            if (pHPDocBlock != null) {
                object3 = pHPDocBlock.getTags(12);
                while (object3.hasNext()) {
                    object2 = (PHPDocTag)object3.next();
                    object = object2.getValue().trim();
                    String[] stringArray = ((String)object).split(" ");
                    string2 = stringArray[0];
                }
            }
            object3 = new StringTokenizer(string, ",", false);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().substring(1);
                object = PHPCodeDataFactory.createPHPClassVarData((String)object2, n, string2, pHPDocBlock, null);
                this.handleObjectInstansiation((String)object2, string2, null, 0, 0, false);
                this.classVarsList.add((PHPClassVarData)object);
            }
        }

        public void handleClassConstDeclaration(String string, String string2, PHPDocBlock pHPDocBlock, int n, int n2, int n3) {
            PHPClassConstData pHPClassConstData = PHPCodeDataFactory.createPHPClassConstData(string, string2, pHPDocBlock, null);
            this.classConstsList.add(pHPClassConstData);
        }

        public void handleIncludedFile(String string, String string2, PHPDocBlock pHPDocBlock, int n, int n2, int n3, int n4) {
        }

        public void haveReturnValue() {
        }

        public void handleObjectInstansiation(String string, String string2, String string3, int n, int n2, boolean bl) {
        }

        public void handleVariableName(String string, int n) {
        }

        public void handleGlobalVar(String string) {
        }

        public void handleStaticVar(String string) {
        }

        public void startParsing(String string) {
        }

        public void finishParsing(int n, int n2, long l) {
            PHPFunctionData[] pHPFunctionDataArray = new PHPFunctionData[this.functionsList.size() + PHPLanguageModel.this.functions.length];
            this.functionsList.toArray(pHPFunctionDataArray);
            System.arraycopy(PHPLanguageModel.this.functions, 0, pHPFunctionDataArray, this.functionsList.size(), PHPLanguageModel.this.functions.length);
            PHPLanguageModel.this.functions = pHPFunctionDataArray;
            for (PHPFunctionData pHPFunctionData : this.functionsList) {
                PHPLanguageModel.this.functionsHash.put(pHPFunctionData.getName(), pHPFunctionData);
            }
            PHPClassData[] pHPClassDataArray = new PHPClassData[this.classesList.size() + PHPLanguageModel.this.classes.length];
            this.classesList.toArray(pHPClassDataArray);
            System.arraycopy(PHPLanguageModel.this.classes, 0, pHPClassDataArray, this.classesList.size(), PHPLanguageModel.this.classes.length);
            PHPLanguageModel.this.classes = pHPClassDataArray;
            for (PHPClassData pHPClassData : this.classesList) {
                PHPLanguageModel.this.classesHash.put(PHPLanguageModel.this.getNormalizedString(pHPClassData.getName()), pHPClassData);
            }
            PHPConstantData[] pHPConstantDataArray = new PHPConstantData[this.constansList.size() + PHPLanguageModel.this.constants.length];
            this.constansList.toArray(pHPConstantDataArray);
            System.arraycopy(PHPLanguageModel.this.constants, 0, pHPConstantDataArray, this.constansList.size(), PHPLanguageModel.this.constants.length);
            PHPLanguageModel.this.constants = pHPConstantDataArray;
        }

        public void handleDefine(String string, String string2, PHPDocBlock pHPDocBlock, int n, int n2, int n3) {
            if (string.startsWith("\"") || string.startsWith("'")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"") || string.endsWith("'")) {
                string = string.substring(0, string.length() - 1);
            }
            this.constansList.add(PHPCodeDataFactory.createPHPConstantData(string, string2, null, pHPDocBlock));
        }

        public void handleError(String string, int n, int n2, int n3) {
        }

        public void handleSyntaxError(int n, String string, short[] sArray, int n2, int n3, int n4) {
        }

        public void handleTask(String string, String string2, int n, int n2, int n3) {
        }

        public void handlePHPStart(int n, int n2) {
        }

        public void handlePHPEnd(int n, int n2) {
        }

        public void setFirstDocBlock(PHPDocBlock pHPDocBlock) {
        }
    }
}

