/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesBlock
extends AbstractPHPPreferencePageBlock {
    private static final String DEBUGGERS_PAGE_ID = "org.eclipse.php.debug.ui.installedDebuggersPage";
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultDebugger;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private Collection<String> debuggersIds;
    private EncodingSettings fDebugEncodingSettings;
    private EncodingSettings fOutputEncodingSettings;
    private PreferencePage propertyPage;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addProjectPreferenceSubsection(composite2);
    }

    public void initializeValues(PreferencePage preferencePage) {
        String string;
        IEclipsePreferences iEclipsePreferences;
        this.propertyPage = preferencePage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(preferencePage);
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        String string2 = PHPDebuggersRegistry.getDebuggerName((String)preferences.getString(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID));
        String string3 = ServersManager.getDefaultServer(null).getName();
        PHPexes pHPexes = PHPexes.getInstance();
        String string4 = PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined;
        if (pHPexes.hasItems(PHPDebugPlugin.getCurrentDebuggerId())) {
            string4 = pHPexes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId()).getName();
        }
        String string5 = preferences.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        String string6 = preferences.getString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        boolean bl2 = false;
        if (iScopeContextArray[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(preferencePage) != null && !(string = ServersManager.getDefaultServer((IProject)this.getProject(preferencePage)).getName()).equals("")) {
            String string7 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            string2 = PHPDebuggersRegistry.getDebuggerName((String)string7);
            string3 = string;
            bl = iEclipsePreferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, bl);
            string5 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "");
            string6 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, "");
            if (PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(string4 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string4)) && pHPexes.hasItems(string7)) {
                string4 = pHPexes.getDefaultItem(string7).getName();
                iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string4);
                try {
                    iEclipsePreferences.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.loadPHPExes(this.fDefaultPHPExe, pHPexes.getItems(iEclipsePreferences.get(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId())));
            bl2 = true;
        }
        if (!bl2) {
            this.loadPHPExes(this.fDefaultPHPExe, pHPexes.getItems(PHPDebugPlugin.getCurrentDebuggerId()));
        }
        this.fStopAtFirstLine.setSelection(bl);
        this.fDefaultDebugger.select(this.fDefaultDebugger.indexOf(string2));
        this.fDefaultServer.select(this.fDefaultServer.indexOf(string3));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(string4));
        this.fDebugEncodingSettings.setIANATag(string5);
        this.fOutputEncodingSettings.setIANATag(string6);
    }

    public boolean performOK(boolean bl) {
        this.savePreferences(bl);
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.loadDebuggers(this.fDefaultDebugger);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPlugin.getCurrentDebuggerId()));
        this.fDebugEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
        this.fOutputEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        this.addLabelControl(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger, PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        this.fDefaultDebugger = this.addCombo(composite2, 2);
        this.addLink(composite2, "<a>Configure...</a>", DEBUGGERS_PAGE_ID);
        this.addLabelControl(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        this.fDefaultServer = this.addCombo(composite2, 2);
        this.addLink(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        this.fDefaultPHPExe = this.addCombo(composite2, 2);
        this.addLink(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        new Label(composite, 0);
        this.addLabelControl(composite, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.fDebugEncodingSettings = this.addEncodingSettings(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.addLabelControl(composite, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)new GridLayout(3, false));
        this.fOutputEncodingSettings = this.addEncodingSettings(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        this.fDefaultDebugger.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = PHPDebugPreferencesBlock.this.getSelectedDebuggerId();
                PHPexeItem[] pHPexeItemArray = PHPexes.getInstance().getItems(string);
                PHPDebugPreferencesBlock.this.loadPHPExes(PHPDebugPreferencesBlock.this.fDefaultPHPExe, pHPexeItemArray);
            }
        });
    }

    private void loadPHPExes(Combo combo, PHPexeItem[] pHPexeItemArray) {
        PHPexeItem pHPexeItem;
        combo.removeAll();
        if (pHPexeItemArray == null || pHPexeItemArray.length == 0) {
            combo.add(PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined);
            combo.select(0);
            return;
        }
        PHPexeItem[] pHPexeItemArray2 = pHPexeItemArray;
        int n = pHPexeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            pHPexeItem = pHPexeItemArray2[n2];
            combo.add(pHPexeItem.getName());
            ++n2;
        }
        if (this.fDefaultDebugger.getItemCount() > 0) {
            String string;
            pHPexeItem = PHPexes.getInstance().getDefaultItem(this.getSelectedDebuggerId());
            if (pHPexeItem != null) {
                string = pHPexeItem.getName();
            } else {
                string = PHPDebugUIMessages.PHPDebuggersTable_notDefined;
                if (combo.indexOf(string) == -1) {
                    combo.add(string, 0);
                    combo.select(0);
                }
            }
            n = combo.indexOf(string);
            if (n > -1) {
                combo.select(n);
            } else if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] serverArray = ServersManager.getServers();
        if (serverArray != null) {
            Server[] serverArray2 = serverArray;
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                Server server = serverArray2[n2];
                combo.add(server.getName());
                ++n2;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadDebuggers(Combo combo) {
        this.debuggersIds = PHPDebuggersRegistry.getDebuggersIds();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        combo.removeAll();
        Iterator<String> iterator = this.debuggersIds.iterator();
        int n = 0;
        int n2 = 0;
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string.equals(string2)) {
                n = n2;
            } else {
                ++n2;
            }
            String string3 = PHPDebuggersRegistry.getDebuggerName((String)string2);
            combo.add(string3);
        }
        if (combo.getItemCount() > 0) {
            combo.select(n);
        }
    }

    private void addLink(Composite composite, String string, final String string2) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesBlock.this.propertyPage.getShell(), (String)string2, null, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.addPageChangedListener(new IPageChangedListener(){

                    public void pageChanged(PageChangedEvent pageChangedEvent) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                String string = PHPDebugPreferencesBlock.this.fDefaultDebugger.getText();
                                String string2 = PHPDebugPreferencesBlock.this.fDefaultServer.getText();
                                String string3 = PHPDebugPreferencesBlock.this.fDefaultPHPExe.getText();
                                PHPDebugPreferencesBlock.this.loadDebuggers(PHPDebugPreferencesBlock.this.fDefaultDebugger);
                                PHPDebugPreferencesBlock.this.loadServers(PHPDebugPreferencesBlock.this.fDefaultServer);
                                PHPDebugPreferencesBlock.this.loadPHPExes(PHPDebugPreferencesBlock.this.fDefaultPHPExe, PHPexes.getInstance().getItems(PHPDebugPreferencesBlock.this.getSelectedDebuggerId()));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultDebugger, PHPDebugPreferencesBlock.this.fDefaultDebugger.indexOf(string));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultServer, PHPDebugPreferencesBlock.this.fDefaultServer.indexOf(string2));
                                PHPDebugPreferencesBlock.this.selectComboItem(PHPDebugPreferencesBlock.this.fDefaultPHPExe, PHPDebugPreferencesBlock.this.fDefaultPHPExe.indexOf(string3));
                            }
                        });
                    }
                });
                preferenceDialog.open();
            }
        });
    }

    private void selectComboItem(Combo combo, int n) {
        if (n < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(n);
        }
    }

    private EncodingSettings addEncodingSettings(Composite composite, String string) {
        EncodingSettings encodingSettings = new EncodingSettings(composite, string);
        GridData gridData = (GridData)encodingSettings.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 0;
        gridData.verticalIndent = -5;
        gridData.horizontalIndent = -5;
        encodingSettings.setLayoutData((Object)gridData);
        return encodingSettings;
    }

    private Combo addCombo(Composite composite, int n) {
        Combo combo = new Combo(composite, 2060);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private void savePreferences(boolean bl) {
        Preferences preferences;
        String string = this.fDefaultPHPExe.getText();
        PHPexes pHPexes = PHPexes.getInstance();
        if (pHPexes.getItem(this.getSelectedDebuggerId(), string) == null) {
            preferences = pHPexes.getDefaultItem(this.getSelectedDebuggerId());
            string = preferences != null ? preferences.getName() : "";
        }
        preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier());
        IProject iProject = this.getProject(this.propertyPage);
        if (bl && iEclipsePreferences != null && iScopeContextArray[0] instanceof ProjectScope && iProject != null) {
            iEclipsePreferences.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            ServersManager.setDefaultServer((IProject)iProject, (String)this.fDefaultServer.getText());
        } else if (iProject == null) {
            preferences.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            preferences.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            preferences.setValue(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            preferences.setValue(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
            pHPexes.setDefaultItem(this.getSelectedDebuggerId(), string);
            ServersManager.setDefaultServer(null, (String)this.fDefaultServer.getText());
        } else if (iEclipsePreferences != null) {
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)iProject, null);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID);
        }
        try {
            iEclipsePreferences.flush();
            pHPexes.save();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException(backingStoreException);
        }
    }

    private String getSelectedDebuggerId() {
        int n = this.fDefaultDebugger.getSelectionIndex();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        if (n > -1 && this.debuggersIds.size() > n) {
            string = this.debuggersIds.toArray()[n].toString();
        }
        return string;
    }
}

