/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.validation;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.IPHPMarker;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.FileBufferModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationMessage;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Text;

public class PHPValidator
implements IValidator,
ISourceValidator {
    private IDocument document;
    private IFile file;

    public void connect(IDocument iDocument) {
        if (iDocument == null) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.0"));
        }
        this.document = iDocument;
        if (!(iDocument instanceof IStructuredDocument)) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.1"));
        }
        if (FileBufferModelManager.getInstance().calculateId(iDocument) == null) {
            this.document = null;
            return;
        }
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getModelForRead((IStructuredDocument)iDocument);
        if (iStructuredModel == null) {
            throw new IllegalStateException(PHPUIMessages.getString("PHPValidator.2"));
        }
        try {
            assert (iStructuredModel instanceof DOMModelForPHP);
            DOMModelForPHP dOMModelForPHP = (DOMModelForPHP)iStructuredModel;
            this.file = dOMModelForPHP.getIFile();
            if (this.file == null) {
                throw new IllegalStateException(String.valueOf(PHPUIMessages.getString("PHPValidator.3")) + dOMModelForPHP.getBaseLocation());
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    public void disconnect(IDocument iDocument) {
        this.document = null;
    }

    public void validate(IRegion iRegion, IValidationContext iValidationContext, IReporter iReporter) {
        PHPFileData pHPFileData;
        if (iValidationContext == null || this.document == null || this.file == null) {
            return;
        }
        if (iReporter != null && iReporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(this.file.getProject());
        if (ExternalFilesRegistry.getInstance().isEntryExist(this.file)) {
            pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        if (pHPProjectModel == null) {
            return;
        }
        pHPProjectModel.fileWasChanged(this.file, this.document);
        String string = "";
        IPath iPath = this.file.getFullPath();
        if (iPath != null) {
            string = iPath.toString();
        }
        if ((pHPFileData = pHPProjectModel.getFileData(this.file.getFullPath().toString())) == null) {
            return;
        }
        IPHPMarker[] iPHPMarkerArray = pHPFileData.getMarkers();
        if (iPHPMarkerArray == null) {
            return;
        }
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
        if (iStructuredModel == null) {
            return;
        }
        try {
            IndexedRegion indexedRegion = this.getNode(iRegion, iStructuredModel);
            if (indexedRegion instanceof INodeNotifier) {
                HTMLValidationAdapterFactory hTMLValidationAdapterFactory = HTMLValidationAdapterFactory.getInstance();
                ValidationAdapter validationAdapter = (ValidationAdapter)hTMLValidationAdapterFactory.adapt((INodeNotifier)indexedRegion);
                if (validationAdapter == null) {
                    return;
                }
                if (iReporter != null) {
                    HTMLValidationReporter hTMLValidationReporter = null;
                    hTMLValidationReporter = this.getReporter(iReporter, this.file, (IDOMModel)iStructuredModel);
                    hTMLValidationReporter.clear();
                    validationAdapter.setReporter((ValidationReporter)hTMLValidationReporter);
                    (new String[1])[0] = string;
                    IPHPMarker[] iPHPMarkerArray2 = iPHPMarkerArray;
                    int n = iPHPMarkerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPHPMarker iPHPMarker = iPHPMarkerArray2[n2];
                        if (!iPHPMarker.getType().equals("TASK")) {
                            UserData userData = iPHPMarker.getUserData();
                            String string2 = iPHPMarker.getDescription();
                            int n3 = userData.getStartPosition();
                            int n4 = userData.getEndPosition() - n3;
                            ValidationMessage validationMessage = new ValidationMessage(string2, n3, n4, 1);
                            hTMLValidationReporter.report(validationMessage);
                        }
                        ++n2;
                    }
                }
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
    }

    protected HTMLValidationReporter getReporter(IReporter iReporter, IFile iFile, IDOMModel iDOMModel) {
        return new HTMLValidationReporter((IValidator)this, iReporter, iFile, (IStructuredModel)iDOMModel);
    }

    private IndexedRegion getNode(IRegion iRegion, IStructuredModel iStructuredModel) {
        IndexedRegion indexedRegion = this.getCoveringNode(iRegion);
        if (indexedRegion instanceof Text) {
            while (indexedRegion != null && indexedRegion instanceof Text) {
                indexedRegion = iStructuredModel.getIndexedRegion(indexedRegion.getEndOffset());
            }
        }
        return indexedRegion;
    }

    private IndexedRegion getCoveringNode(IRegion iRegion) {
        IndexedRegion indexedRegion = null;
        if (this.document instanceof IStructuredDocument) {
            IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
            try {
                if (iStructuredModel != null) {
                    IStructuredDocumentRegion[] iStructuredDocumentRegionArray = ((IStructuredDocument)this.document).getStructuredDocumentRegions(iRegion.getOffset(), iRegion.getLength());
                    indexedRegion = this.getLargest(iStructuredDocumentRegionArray);
                }
            }
            finally {
                if (iStructuredModel != null) {
                    iStructuredModel.releaseFromRead();
                }
            }
        }
        return indexedRegion;
    }

    protected IndexedRegion getLargest(IStructuredDocumentRegion[] iStructuredDocumentRegionArray) {
        if (iStructuredDocumentRegionArray == null || iStructuredDocumentRegionArray.length == 0) {
            return null;
        }
        IndexedRegion indexedRegion = this.getCorrespondingNode(iStructuredDocumentRegionArray[0]);
        int n = 0;
        while (n < iStructuredDocumentRegionArray.length) {
            if (!iStructuredDocumentRegionArray[n].isDeleted()) {
                IndexedRegion indexedRegion2 = this.getCorrespondingNode(iStructuredDocumentRegionArray[n]);
                if (indexedRegion instanceof Text) {
                    indexedRegion = indexedRegion2;
                }
                if (indexedRegion2 != null && !(indexedRegion2 instanceof Text) && indexedRegion2.getStartOffset() <= indexedRegion.getStartOffset() && indexedRegion2.getEndOffset() >= indexedRegion.getEndOffset()) {
                    indexedRegion = indexedRegion2;
                }
            }
            ++n;
        }
        return indexedRegion;
    }

    protected IndexedRegion getCorrespondingNode(IStructuredDocumentRegion iStructuredDocumentRegion) {
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getExistingModelForRead(this.document);
        IndexedRegion indexedRegion = null;
        try {
            if (iStructuredModel != null) {
                indexedRegion = iStructuredModel.getIndexedRegion(iStructuredDocumentRegion.getStart());
            }
        }
        finally {
            if (iStructuredModel != null) {
                iStructuredModel.releaseFromRead();
            }
        }
        return indexedRegion;
    }

    public void cleanup(IReporter iReporter) {
    }

    public void validate(IValidationContext iValidationContext, IReporter iReporter) throws ValidationException {
    }

    protected boolean shouldValidate(IFile iFile) {
        IFile iFile2 = iFile;
        do {
            if (!iFile2.isDerived() && !iFile2.isTeamPrivateMember() && iFile2.isAccessible() && iFile2.getName().charAt(0) != '.') continue;
            return false;
        } while (((iFile2 = iFile2.getParent()).getType() & 4) == 0);
        return true;
    }
}

