/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.ast.nodes;

import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.ast.visitor.Visitor;

public class PostfixExpression
extends Expression {
    public static final int OP_INC = 0;
    public static final int OP_DEC = 1;
    private final VariableBase variable;
    private final int operator;

    public PostfixExpression(int n, int n2, VariableBase variableBase, int n3) {
        super(n, n2);
        assert (variableBase != null);
        this.variable = variableBase;
        this.operator = n3;
        variableBase.setParent(this);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public void childrenAccept(Visitor visitor) {
        this.variable.accept(visitor);
    }

    public void traverseTopDown(Visitor visitor) {
        this.accept(visitor);
        this.variable.traverseTopDown(visitor);
    }

    public void traverseBottomUp(Visitor visitor) {
        this.variable.traverseBottomUp(visitor);
        this.accept(visitor);
    }

    public void toString(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string).append("<PostfixExpression");
        this.appendInterval(stringBuffer);
        stringBuffer.append(" operator='").append(PostfixExpression.getOperator(this.operator)).append("'>\n");
        this.variable.toString(stringBuffer, "\t" + string);
        stringBuffer.append("\n").append(string).append("</PostfixExpression>");
    }

    public static String getOperator(int n) {
        switch (n) {
            case 1: {
                return "--";
            }
            case 0: {
                return "++";
            }
        }
        throw new IllegalArgumentException();
    }

    public int getType() {
        return 44;
    }

    public int getOperator() {
        return this.operator;
    }

    public VariableBase getVariable() {
        return this.variable;
    }
}

