/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.phpModel.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.core.documentModel.IWorkspaceModelListener;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.ModelListener;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPUserModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.project.build.FullPhpProjectBuildVisitor;
import org.eclipse.php.internal.core.resources.ExternalFileWrapper;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;
import org.eclipse.php.internal.core.util.project.observer.ProjectRemovedObserversAttacher;
import org.eclipse.wst.sse.core.utils.StringUtils;

public class PHPWorkspaceModelManager
implements ModelListener {
    protected static final PHPWorkspaceModelManager instance = new PHPWorkspaceModelManager();
    protected static final HashMap models = new HashMap();
    protected static PHPProjectModel defaultModel;
    private static final Set<ModelListener> modelListeners;
    private static final Map workspaceModelListeners;
    private static final Set<IWorkspaceModelListener> globalWorkspaceModelListeners;

    static {
        modelListeners = new HashSet<ModelListener>(3);
        workspaceModelListeners = Collections.synchronizedMap(new HashMap(2));
        globalWorkspaceModelListeners = new HashSet<IWorkspaceModelListener>(2);
    }

    private PHPWorkspaceModelManager() {
    }

    public static PHPWorkspaceModelManager getInstance() {
        return instance;
    }

    public void startup() {
        this.initGlobalModelListeners();
        this.runBuild();
        this.attachProjectOpenObserver();
    }

    private void initGlobalModelListeners() {
        IConfigurationElement[] iConfigurationElementArray;
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core.workspaceModelListener");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n2];
            if (iConfigurationElement.getName().equals("workspaceModelListener")) {
                WorkspaceModelListenerProxy workspaceModelListenerProxy = new WorkspaceModelListenerProxy(iConfigurationElement);
                IWorkspaceModelListener iWorkspaceModelListener = workspaceModelListenerProxy.getListener();
                this.addWorkspaceModelListener(iWorkspaceModelListener);
            }
            ++n2;
        }
    }

    private void attachProjectOpenObserver() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
                IResourceDelta[] iResourceDeltaArray;
                IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
                if (iResourceDelta == null) {
                    return;
                }
                IResourceDelta[] iResourceDeltaArray2 = iResourceDeltaArray = iResourceDelta.getAffectedChildren(4);
                int n = iResourceDeltaArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResourceDelta iResourceDelta2;
                    iResourceDelta = iResourceDelta2 = iResourceDeltaArray2[n2];
                    IResource iResource = iResourceDelta.getResource();
                    IProject iProject = (IProject)iResource;
                    int n3 = iResourceDelta.getFlags();
                    if ((n3 & 0x4000) != 0 && iProject.isOpen()) {
                        try {
                            if (iProject.hasNature("org.eclipse.php.core.PHPNature")) {
                                PHPWorkspaceModelManager.this.runBuild(iProject);
                            }
                        }
                        catch (CoreException coreException) {}
                    }
                    ++n2;
                }
            }
        });
    }

    public void runBuild(final IProject iProject) {
        WorkspaceJob workspaceJob = new WorkspaceJob(NLS.bind((String)CoreMessages.getString("PHPWorkspaceModelManager_4"), (Object)iProject.getName())){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    PHPWorkspaceModelManager.getInstance().getModelForProject(iProject, true);
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        workspaceJob.setPriority(40);
        workspaceJob.setUser(false);
        workspaceJob.schedule();
    }

    private void runBuild() {
        Object object;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        final ArrayList<IProject> arrayList = new ArrayList<IProject>();
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = iProjectArray2[n2];
            if (object.isOpen()) {
                try {
                    if (object.hasNature("org.eclipse.php.core.PHPNature")) {
                        arrayList.add((IProject)object);
                    }
                }
                catch (CoreException coreException) {
                    PHPCorePlugin.log(coreException);
                }
            }
            ++n2;
        }
        if (arrayList.isEmpty()) {
            return;
        }
        object = new WorkspaceJob(CoreMessages.getString("PHPWorkspaceModelManager_5")){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask(CoreMessages.getString("PHPWorkspaceModelManager_5"), arrayList.size());
                    for (IProject iProject : arrayList) {
                        if (iProject.isOpen()) {
                            PHPWorkspaceModelManager.getInstance().getModelForProject(iProject, true);
                            if (iProgressMonitor.isCanceled()) {
                                break;
                            }
                        }
                        iProgressMonitor.worked(1);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
                return Status.OK_STATUS;
            }
        };
        object.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        object.setPriority(40);
        object.setUser(false);
        object.schedule();
    }

    public void shutdown() {
        IProject[] iProjectArray;
        IProject[] iProjectArray2 = iProjectArray = this.listProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            this.removeModel(iProject);
            ++n2;
        }
    }

    public static final PHPProjectModel getDefaultPHPProjectModel() {
        if (defaultModel == null) {
            defaultModel = new PHPProjectModel();
            PHPWorkspaceModelManager.getInstance().putModel(ExternalFilesRegistry.getInstance().getExternalFilesProject(), defaultModel);
        }
        return defaultModel;
    }

    public IProject getProjectForFileData(PHPFileData pHPFileData, IProject iProject) {
        if (pHPFileData == null) {
            return null;
        }
        IResource iResource = PHPModelUtil.getResource(pHPFileData);
        if (iResource != null) {
            if (iResource instanceof ExternalFileWrapper) {
                return PHPWorkspaceModelManager.getDefaultPHPProjectModel().getProject();
            }
            IProject iProject2 = iResource.getProject();
            if (iProject2.isAccessible()) {
                return iProject2;
            }
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        ArrayList<IProject> arrayList = new ArrayList<IProject>((Collection)Arrays.asList(iWorkspaceRoot.getProjects()));
        if (iProject != null) {
            arrayList.remove(iProject);
            arrayList.add(0, iProject);
        }
        String string = new Path(pHPFileData.getName()).toOSString();
        for (IProject iProject2 : arrayList) {
            PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getInstance().getModelForProject(iProject2);
            if (pHPProjectModel == null || (pHPFileData = pHPProjectModel.getFileData(string)) == null) continue;
            return iProject2;
        }
        return null;
    }

    public PHPFileData getModelForFile(String string, boolean bl) {
        IFile iFile;
        PHPProjectModel pHPProjectModel;
        Path path = new Path(string);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(path.segment(0));
        if (!iProject.isAccessible()) {
            iProject = null;
            pHPProjectModel = null;
        } else {
            pHPProjectModel = this.getModelForProject(iProject, bl);
        }
        PHPFileData pHPFileData = null;
        if (pHPProjectModel == null) {
            iFile = iWorkspaceRoot.getProjects();
            String string2 = new Path(string).toOSString();
            int n = 0;
            while (n < ((IProject[])iFile).length) {
                PHPProjectModel pHPProjectModel2;
                iProject = iFile[n];
                if (iProject.exists() && iProject.isAccessible() && (pHPProjectModel2 = PHPWorkspaceModelManager.getInstance().getModelForProject((IProject)iFile[n])) != null) {
                    String string3 = "";
                    IPath iPath = iFile[n].getLocation();
                    string3 = iPath == null ? iFile[n].getLocationURI().toString() : iFile[n].getLocation().toOSString();
                    String string4 = string2.startsWith(string3) ? new Path(StringUtils.replace((String)string2, (String)string3, (String)"")).toPortableString() : string2;
                    pHPFileData = pHPProjectModel2.getFileData(string4);
                    if (pHPFileData != null) break;
                }
                ++n;
            }
        } else {
            pHPFileData = pHPProjectModel.getFileData(string);
        }
        if (pHPFileData == null && bl && pHPProjectModel != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path)).exists()) {
            this.addFileToModel(iFile);
            pHPFileData = pHPProjectModel.getFileData(string);
        }
        return pHPFileData;
    }

    private synchronized PHPFileData getModelForExternalFile(IFile iFile) {
        if (!PHPModelUtil.isPhpFile(iFile)) {
            return null;
        }
        PHPFileData pHPFileData = null;
        PHPProjectModel pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        if (pHPProjectModel.getPHPUserModel() == null) {
            pHPProjectModel.addFileToModel(iFile);
        }
        if ((pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toOSString())) == null) {
            pHPProjectModel.addFileToModel(iFile);
            pHPFileData = pHPProjectModel.getFileData(iFile.getFullPath().toOSString());
        }
        return pHPFileData;
    }

    public PHPFileData getModelForFile(IFile iFile, boolean bl) {
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject(), bl);
        if (pHPProjectModel == null) {
            if (iFile instanceof ExternalFileWrapper && ExternalFilesRegistry.getInstance().isEntryExist(iFile.getFullPath().toOSString())) {
                return this.getModelForExternalFile(iFile);
            }
            return null;
        }
        String string = iFile.getFullPath().toString();
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        if (pHPFileData == null && bl) {
            this.addFileToModel(iFile);
            pHPFileData = pHPProjectModel.getFileData(string);
        }
        return pHPFileData;
    }

    public PHPFileData getModelForFile(String string) {
        IPath iPath = Path.fromOSString((String)string);
        IFile iFile = ExternalFilesRegistry.getInstance().isEntryExist(iPath.toOSString()) ? ExternalFilesRegistry.getInstance().getFileEntry(iPath.toOSString()) : ExternalFileWrapper.createFile(iPath.toOSString());
        PHPFileData pHPFileData = null;
        pHPFileData = this.getModelForFile(string, false);
        if (pHPFileData == null && iFile != null && ExternalFilesRegistry.getInstance().isEntryExist(iFile)) {
            pHPFileData = this.getModelForExternalFile(iFile);
        }
        return pHPFileData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PHPProjectModel getModelForProject(IProject iProject, boolean bl) {
        PHPProjectModel pHPProjectModel = (PHPProjectModel)models.get(iProject);
        if (pHPProjectModel != null) return pHPProjectModel;
        if (!bl) return pHPProjectModel;
        IProject iProject2 = iProject;
        synchronized (iProject2) {
            pHPProjectModel = (PHPProjectModel)models.get(iProject);
            if (pHPProjectModel != null) return pHPProjectModel;
            if (iProject.isOpen() && iProject.exists() && iProject.isAccessible()) {
                boolean bl2;
                try {
                    bl2 = iProject.hasNature("org.eclipse.rse.ui.remoteSystemsTempNature") || iProject.hasNature("org.eclipse.php.core.PHPNature");
                }
                catch (CoreException coreException) {
                    PHPCorePlugin.log(coreException);
                    return null;
                }
                if (!bl2) return pHPProjectModel;
                pHPProjectModel = new PHPProjectModel();
                this.putModel(iProject, pHPProjectModel);
                this.attachProjectCloseObserver(iProject);
            } else {
                if (iProject.exists()) return pHPProjectModel;
                if (!iProject.equals((Object)ExternalFilesRegistry.getInstance().getExternalFilesProject())) return pHPProjectModel;
                pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
                this.putModel(iProject, pHPProjectModel);
                this.attachProjectCloseObserver(iProject);
            }
            return pHPProjectModel;
        }
    }

    private void attachProjectCloseObserver(final IProject iProject) {
        ProjectRemovedObserversAttacher.getInstance().addProjectClosedObserver(iProject, new IProjectClosedObserver(){

            public void closed() {
                PHPWorkspaceModelManager.this.removeModel(iProject);
            }
        });
    }

    public PHPProjectModel getModelForProject(IProject iProject) {
        return this.getModelForProject(iProject, false);
    }

    public IProject getProjectForModel(PHPProjectModel pHPProjectModel) {
        if (pHPProjectModel.equals(PHPWorkspaceModelManager.getDefaultPHPProjectModel())) {
            return ExternalFilesRegistry.getInstance().getExternalFilesProject();
        }
        for (IProject iProject : models.keySet()) {
            PHPProjectModel pHPProjectModel2 = this.getModelForProject(iProject);
            if (!pHPProjectModel.equals(pHPProjectModel2)) continue;
            return iProject;
        }
        return null;
    }

    public IProject[] listProjects() {
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        for (IProject iProject : models.keySet()) {
            if (!iProject.exists() || !iProject.isOpen()) continue;
            arrayList.add(iProject);
        }
        IProject[] iProjectArray = arrayList.toArray(new IProject[arrayList.size()]);
        return iProjectArray;
    }

    public PHPProjectModel[] listModels() {
        int n = 0;
        PHPProjectModel[] pHPProjectModelArray = new PHPProjectModel[models.size()];
        Iterator iterator = models.values().iterator();
        while (iterator.hasNext()) {
            pHPProjectModelArray[n++] = (PHPProjectModel)iterator.next();
        }
        return pHPProjectModelArray;
    }

    public void removeModel(IProject iProject) {
        PHPProjectModel pHPProjectModel = this.getModelForProject(iProject);
        if (pHPProjectModel != null) {
            pHPProjectModel.getPHPUserModel().removeModelListener(this);
            pHPProjectModel.dispose();
        }
        models.remove(iProject);
        this.fireProjectModelRemoved(iProject);
    }

    private void putModel(final IProject iProject, PHPProjectModel pHPProjectModel) {
        PHPProjectModel pHPProjectModel2 = (PHPProjectModel)models.get(iProject);
        models.put(iProject, pHPProjectModel);
        pHPProjectModel.initialize(iProject);
        if (pHPProjectModel2 == null) {
            pHPProjectModel.getPHPUserModel().addModelListener(this);
        } else {
            this.copyUserModelListeners(pHPProjectModel.getPHPUserModel(), pHPProjectModel2.getPHPUserModel().getModelListenerList());
        }
        this.fireProjectModelAdded(iProject);
        if (pHPProjectModel.isBuildNeeded()) {
            boolean bl;
            Job job = Job.getJobManager().currentJob();
            boolean bl2 = bl = job == null || job.getRule() != ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
            if (bl) {
                WorkspaceJob workspaceJob = new WorkspaceJob(NLS.bind((String)CoreMessages.getString("PHPWorkspaceModelManager_4"), (Object)iProject.getName())){

                    public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                        PHPWorkspaceModelManager.this.buildModel(iProgressMonitor, iProject);
                        return Status.OK_STATUS;
                    }
                };
                workspaceJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
                workspaceJob.setUser(false);
                workspaceJob.schedule();
            } else {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                this.buildModel((IProgressMonitor)nullProgressMonitor, iProject);
            }
        } else if (iProject.exists()) {
            this.fireProjectModelChanged(iProject);
        }
    }

    private void buildModel(IProgressMonitor iProgressMonitor, IProject iProject) {
        try {
            try {
                iProject.accept((IResourceVisitor)new FullPhpProjectBuildVisitor(iProgressMonitor));
                this.fireProjectModelChanged(iProject);
            }
            catch (CoreException coreException) {
                Logger.logException(coreException);
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void copyUserModelListeners(PHPUserModel pHPUserModel, List list) {
        for (ModelListener modelListener : list) {
            pHPUserModel.addModelListener(modelListener);
        }
    }

    public synchronized void addModelListener(ModelListener modelListener) {
        modelListeners.add(modelListener);
    }

    public synchronized void removeModelListener(ModelListener modelListener) {
        modelListeners.remove(modelListener);
    }

    private synchronized ModelListener[] getModelListenersIteratorCopy() {
        ModelListener[] modelListenerArray = new ModelListener[modelListeners.size()];
        modelListeners.toArray(modelListenerArray);
        return modelListenerArray;
    }

    public void fileDataChanged(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray;
        ModelListener[] modelListenerArray2 = modelListenerArray = this.getModelListenersIteratorCopy();
        int n = modelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = modelListenerArray2[n2];
            modelListener.fileDataChanged(pHPFileData);
            ++n2;
        }
    }

    public void fileDataAdded(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray;
        ModelListener[] modelListenerArray2 = modelListenerArray = this.getModelListenersIteratorCopy();
        int n = modelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = modelListenerArray2[n2];
            modelListener.fileDataAdded(pHPFileData);
            ++n2;
        }
    }

    public void fileDataRemoved(PHPFileData pHPFileData) {
        ModelListener[] modelListenerArray;
        ModelListener[] modelListenerArray2 = modelListenerArray = this.getModelListenersIteratorCopy();
        int n = modelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = modelListenerArray2[n2];
            modelListener.fileDataRemoved(pHPFileData);
            ++n2;
        }
    }

    public void dataCleared() {
        ModelListener[] modelListenerArray;
        ModelListener[] modelListenerArray2 = modelListenerArray = this.getModelListenersIteratorCopy();
        int n = modelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelListener modelListener = modelListenerArray2[n2];
            modelListener.dataCleared();
            ++n2;
        }
    }

    public void addWorkspaceModelListener(String string, IWorkspaceModelListener iWorkspaceModelListener) {
        List<IWorkspaceModelListener> list = (List<IWorkspaceModelListener>)workspaceModelListeners.get(string);
        if (list == null) {
            list = Collections.synchronizedList(new ArrayList(2));
            workspaceModelListeners.put(string, list);
        }
        if (!list.contains(iWorkspaceModelListener)) {
            list.add(iWorkspaceModelListener);
        }
    }

    public void removeWorkspaceModelListener(String string, IWorkspaceModelListener iWorkspaceModelListener) {
        List list = (List)workspaceModelListeners.get(string);
        if (list == null) {
            return;
        }
        list.remove(iWorkspaceModelListener);
    }

    public void addFileToModel(IFile iFile) {
        if (!PHPModelUtil.isPhpFile(iFile)) {
            return;
        }
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject());
        if (pHPProjectModel != null) {
            pHPProjectModel.addFileToModel(iFile);
        }
    }

    public void removeFileFromModel(IFile iFile) {
        if (iFile == null) {
            return;
        }
        PHPProjectModel pHPProjectModel = this.getModelForProject(iFile.getProject());
        if (pHPProjectModel == null && !iFile.exists() && (pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel()).getFileData(iFile.getFullPath().toOSString()) == null) {
            return;
        }
        if (pHPProjectModel == null) {
            return;
        }
        pHPProjectModel.removeFileFromModel(iFile);
    }

    public synchronized void addWorkspaceModelListener(IWorkspaceModelListener iWorkspaceModelListener) {
        if (iWorkspaceModelListener == null) {
            throw new IllegalArgumentException("Error registering IWorkspaceModelListener");
        }
        globalWorkspaceModelListeners.add(iWorkspaceModelListener);
    }

    public synchronized void removeWorkspaceModelListener(IWorkspaceModelListener iWorkspaceModelListener) {
        if (iWorkspaceModelListener == null) {
            throw new IllegalArgumentException("Error registering IWorkspaceModelListener");
        }
        globalWorkspaceModelListeners.remove(iWorkspaceModelListener);
    }

    private synchronized IWorkspaceModelListener[] getGlobalWorkspaceModelListeners() {
        return globalWorkspaceModelListeners.toArray(new IWorkspaceModelListener[globalWorkspaceModelListeners.size()]);
    }

    public void fireProjectModelAdded(IProject iProject) {
        Object object;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = this.getGlobalWorkspaceModelListeners();
        Object object2 = iWorkspaceModelListenerArray;
        int n = iWorkspaceModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            object.projectModelAdded(iProject);
            ++n2;
        }
        object = (List)workspaceModelListeners.get(iProject.getName());
        if (object == null) {
            return;
        }
        Object[] objectArray = object.toArray();
        n = 0;
        while (n < objectArray.length) {
            object2 = (IWorkspaceModelListener)objectArray[n];
            object2.projectModelAdded(iProject);
            ++n;
        }
    }

    public void fireProjectModelRemoved(IProject iProject) {
        Object object;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = this.getGlobalWorkspaceModelListeners();
        Object object2 = iWorkspaceModelListenerArray;
        int n = iWorkspaceModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            object.projectModelRemoved(iProject);
            ++n2;
        }
        object = (List)workspaceModelListeners.get(iProject.getName());
        if (object == null) {
            return;
        }
        Object[] objectArray = object.toArray();
        n = 0;
        while (n < objectArray.length) {
            object2 = (IWorkspaceModelListener)objectArray[n];
            object2.projectModelRemoved(iProject);
            ++n;
        }
    }

    public void fireProjectModelChanged(IProject iProject) {
        Object object;
        IWorkspaceModelListener[] iWorkspaceModelListenerArray = this.getGlobalWorkspaceModelListeners();
        Object object2 = iWorkspaceModelListenerArray;
        int n = iWorkspaceModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            object.projectModelChanged(iProject);
            ++n2;
        }
        object = (List)workspaceModelListeners.get(iProject.getName());
        if (object == null) {
            return;
        }
        Object[] objectArray = object.toArray();
        n = 0;
        while (n < objectArray.length) {
            object2 = (IWorkspaceModelListener)objectArray[n];
            object2.projectModelChanged(iProject);
            ++n;
        }
    }

    private class WorkspaceModelListenerProxy {
        private final IConfigurationElement element;
        private IWorkspaceModelListener listener;

        public WorkspaceModelListenerProxy(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public IWorkspaceModelListener getListener() {
            if (this.listener == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable("Error creation PhpModel for extension-point org.eclipse.php.internal.core.workspaceModelListener"){

                    public void run() throws Exception {
                        WorkspaceModelListenerProxy.this.listener = (IWorkspaceModelListener)WorkspaceModelListenerProxy.this.element.createExecutableExtension("class");
                    }
                });
            }
            return this.listener;
        }
    }
}

