/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.util.DefaultCacheManager;
import org.eclipse.php.internal.core.util.MapXMLReader;
import org.eclipse.php.internal.core.util.MapXMLWriter;
import org.xml.sax.InputSource;

public class IncludeCacheManager {
    private static final String INCLUDES_MAP_XML = "includes.xml";
    private Object lock = new Object();
    private File includeXMLFile;
    private DefaultCacheManager cacheManager;

    public IncludeCacheManager(DefaultCacheManager defaultCacheManager) {
        this.cacheManager = defaultCacheManager;
        this.includeXMLFile = new File(defaultCacheManager.getSharedCacheDirectory(), INCLUDES_MAP_XML);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map includePathChanged(IProject iProject, List list) {
        Map map = null;
        Object object = this.lock;
        synchronized (object) {
            String string = iProject.getName();
            map = this.getCachedMap();
            List list2 = map.put(string, list);
            if (list2 != null) {
                this.checkPaths(list2, map);
                this.deletePaths(list2);
            }
            this.saveMap(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map projectRemoved(IProject iProject) {
        Map map = null;
        Object object = this.lock;
        synchronized (object) {
            String string = iProject.getName();
            map = this.getCachedMap();
            List list = (List)map.remove(string);
            if (list != null) {
                this.checkPaths(list, map);
                this.deletePaths(list);
            }
            this.saveMap(map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map phpVersionChanged(IProject iProject, String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Map map = null;
        Object object = this.lock;
        synchronized (object) {
            String string3 = iProject.getName();
            map = this.getCachedMap();
            List list = (List)map.get(string3);
            if (list != null) {
                ArrayList<String> arrayList = new ArrayList<String>(list.size());
                int n = 0;
                while (n < list.size()) {
                    arrayList.add(((String)list.get(n)).replaceAll(string, string2));
                    ++n;
                }
                map.put(string3, arrayList);
                this.checkPaths(list, map);
                this.deletePaths(list);
            }
            this.saveMap(map);
        }
        return map;
    }

    public void checkCache() {
        Map map = this.getCachedMap();
        IProject[] iProjectArray = PHPWorkspaceModelManager.getInstance().listProjects();
        HashMap<String, IProject> hashMap = new HashMap<String, IProject>();
        int n = 0;
        while (n < iProjectArray.length) {
            hashMap.put(iProjectArray[n].getName(), iProjectArray[n]);
            ++n;
        }
        ArrayList arrayList = new ArrayList();
        Set set = map.keySet();
        Object[] objectArray = new Object[set.size()];
        set.toArray(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (!hashMap.containsKey(objectArray[n2])) {
                List list = (List)map.remove(objectArray[n2]);
                arrayList.addAll(list);
            }
            ++n2;
        }
        this.checkPaths(arrayList, map);
        this.deletePaths(arrayList);
    }

    private void deletePaths(List list) {
        Iterator iterator = list.iterator();
        File file = this.cacheManager.getSharedCacheDirectory();
        while (iterator.hasNext()) {
            File file2 = new File(file, (String)iterator.next());
            file2.delete();
        }
    }

    private void checkPaths(List list, Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Iterator iterator2 = ((List)iterator.next()).iterator();
            while (iterator2.hasNext()) {
                hashMap.put(iterator2.next(), "dummy");
            }
        }
        int n = list.size() - 1;
        while (n >= 0) {
            if (hashMap.containsKey(list.get(n))) {
                list.remove(n);
            }
            --n;
        }
    }

    private void saveMap(Map map) {
        PrintWriter printWriter = null;
        try {
            try {
                printWriter = new MapXMLWriter(new FileOutputStream(this.includeXMLFile));
                ((MapXMLWriter)printWriter).writeMap(map);
            }
            catch (Exception exception) {
                PHPCorePlugin.log(exception);
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
            }
        }
        finally {
            if (printWriter != null) {
                printWriter.flush();
                printWriter.close();
            }
        }
    }

    private Map getCachedMap() {
        Map map = null;
        try {
            if (this.includeXMLFile.exists()) {
                map = MapXMLReader.readMap(new InputSource(new InputStreamReader((InputStream)new FileInputStream(this.includeXMLFile), "UTF8")));
            }
        }
        catch (Exception exception) {
            PHPCorePlugin.log(exception);
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }
}

