/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathEntrySelectionDialog
extends FilteredItemsSelectionDialog {
    private static final String DIALOG_SETTINGS = "org.eclipse.php.internal.debug.core.pathmapper.PathEntrySelectionDialogSettings";
    private PathEntry[] pathEntries;
    private Comparator<PathEntry> comparator;
    private ILabelProvider detailsLabelProvider;

    public PathEntrySelectionDialog(Shell shell, VirtualPath virtualPath, PathEntry[] pathEntryArray) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.pathEntries = pathEntryArray;
        this.comparator = Collections.reverseOrder(new BestMatchPathComparator(virtualPath));
        this.setSelectionHistory(new FilteredItemsSelectionDialog.SelectionHistory(){

            protected Object restoreItemFromMemento(IMemento iMemento) {
                return null;
            }

            protected void storeItemToMemento(Object object, IMemento iMemento) {
            }
        });
        this.setTitle("Select local resource that matches remote file");
        this.setMessage(NLS.bind((String)"Select local resource that matches remote file ''{0}''\n\nUse pattern to filter results (? = any character, * = any string):", (Object)virtualPath.toString()));
        this.setListLabelProvider(this.createListLabelProvider());
        this.setDetailsLabelProvider(this.createDetailsLabelProvider());
    }

    protected ILabelProvider createListLabelProvider() {
        return new LabelProvider();
    }

    protected ILabelProvider createDetailsLabelProvider() {
        if (this.detailsLabelProvider == null) {
            this.detailsLabelProvider = new DetailsLabelProvider();
        }
        return this.detailsLabelProvider;
    }

    protected Control createExtendedContentArea(Composite composite) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new EntriesFilter();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider abstractContentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor iProgressMonitor) throws CoreException {
        int n = 0;
        while (n < this.pathEntries.length) {
            abstractContentProvider.add((Object)this.pathEntries[n], itemsFilter);
            ++n;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (iDialogSettings == null) {
            iDialogSettings = IDEWorkbenchPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return iDialogSettings;
    }

    public String getElementName(Object object) {
        if (object instanceof PathEntry) {
            return ((PathEntry)object).getAbstractPath().getLastSegment();
        }
        return null;
    }

    protected Comparator<?> getItemsComparator() {
        return this.comparator;
    }

    protected IStatus validateItem(Object object) {
        return Status.OK_STATUS;
    }

    protected class DetailsLabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        private PHPUILabelProvider phpLabelProvider = new PHPUILabelProvider();

        protected DetailsLabelProvider() {
        }

        public Image getImage(Object object) {
            if (!(object instanceof PathEntry)) {
                return super.getImage(object);
            }
            PathEntry pathEntry = (PathEntry)object;
            if (pathEntry.getType() == PathEntry.Type.EXTERNAL) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            if (pathEntry.getType() == PathEntry.Type.INCLUDE_VAR) {
                return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
            }
            if (pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
            }
            return this.phpLabelProvider.getImage(pathEntry.getContainer());
        }

        public String getText(Object object) {
            if (!(object instanceof PathEntry)) {
                return super.getText(object);
            }
            PathEntry pathEntry = (PathEntry)object;
            if (pathEntry.getType() == PathEntry.Type.EXTERNAL) {
                return ((File)pathEntry.getContainer()).getPath();
            }
            if (pathEntry.getContainer() instanceof IncludePathEntry) {
                IPath iPath;
                String string;
                String string2 = new File(pathEntry.getPath()).getParentFile().getAbsolutePath();
                IncludePathEntry includePathEntry = (IncludePathEntry)pathEntry.getContainer();
                if (includePathEntry.getEntryKind() == 4 && string2.startsWith(string = (iPath = IncludePathVariableManager.instance().getIncludePathVariable(includePathEntry.getPath().toString())).toFile().getAbsolutePath())) {
                    String string3 = string2.substring(string.length());
                    if (string3.startsWith("/")) {
                        string3 = string3.substring(1);
                    }
                    return String.valueOf(includePathEntry.getPath().toString()) + '/' + string3;
                }
                return string2;
            }
            if (pathEntry.getContainer() instanceof IResource) {
                String string = ((IResource)pathEntry.getContainer()).getFullPath().toPortableString();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
                return string;
            }
            return this.phpLabelProvider.getText(pathEntry.getContainer());
        }
    }

    public class EntriesFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public EntriesFilter() {
            super((FilteredItemsSelectionDialog)PathEntrySelectionDialog.this, new SearchPattern(){

                public void setPattern(String string) {
                    if (!string.startsWith("*")) {
                        string = "*" + string;
                    }
                    super.setPattern(string);
                }
            });
        }

        public boolean isConsistentItem(Object object) {
            return true;
        }

        public boolean matchItem(Object object) {
            if (object instanceof PathEntry) {
                return this.matches(((PathEntry)object).getAbstractPath().toString());
            }
            return true;
        }
    }

    protected class LabelProvider
    extends org.eclipse.jface.viewers.LabelProvider {
        protected LabelProvider() {
        }

        public Image getImage(Object object) {
            if (!(object instanceof PathEntry)) {
                return super.getImage(object);
            }
            return PHPPluginImages.get((String)"org.eclipse.php.ui.phpfile.gif");
        }

        public String getText(Object object) {
            if (!(object instanceof PathEntry)) {
                return super.getText(object);
            }
            PathEntry pathEntry = (PathEntry)object;
            return NLS.bind((String)"{0} - {1}", (Object)pathEntry.getAbstractPath().getLastSegment(), (Object)PathEntrySelectionDialog.this.createDetailsLabelProvider().getText(object));
        }
    }
}

