/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.PHPDebugUIPlugin;
import org.eclipse.php.internal.debug.ui.preferences.phps.InstalledPHPsBlock;
import org.eclipse.php.internal.ui.preferences.AbstractPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PHPsPreferencePage
extends AbstractPreferencePage
implements IWorkbenchPreferencePage {
    public static String ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private InstalledPHPsBlock fPHPBlock;

    public PHPsPreferencePage() {
        this.setTitle(PHPDebugUIMessages.PHPsPreferencePage_1);
        this.setDescription(PHPDebugUIMessages.PHPsPreferencePage_2);
    }

    public void init(IWorkbench iWorkbench) {
    }

    protected Preferences getModelPreferences() {
        return PHPProjectPreferences.getModelPreferences();
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        this.fPHPBlock = new InstalledPHPsBlock();
        this.fPHPBlock.createControl(composite);
        Control control = this.fPHPBlock.getControl();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        control.setLayoutData((Object)gridData);
        this.fPHPBlock.restoreColumnSettings(PHPDebugUIPlugin.getDefault().getDialogSettings(), PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        this.initDefaultPHP();
        this.applyDialogFont(composite);
        return composite;
    }

    public boolean performOk() {
        IDialogSettings iDialogSettings = PHPDebugUIPlugin.getDefault().getDialogSettings();
        this.fPHPBlock.saveColumnSettings(iDialogSettings, PHPDebugCorePreferenceNames.DIALOG_COLUMN_WIDTH);
        this.fPHPBlock.commitChanges();
        return super.performOk();
    }

    private void verifyDefaultPHP(PHPexeItem pHPexeItem) {
        boolean bl;
        if (pHPexeItem != null && !(bl = pHPexeItem.getExecutable().exists())) {
            this.fPHPBlock.removePHPs(new PHPexeItem[]{pHPexeItem});
            ErrorDialog.openError((Shell)this.getControl().getShell(), (String)PHPDebugUIMessages.PHPsPreferencePage_1, (String)PHPDebugUIMessages.PHPsPreferencePage_10, (IStatus)new Status(4, "org.eclipse.php.debug.ui", 10001, PHPDebugUIMessages.PHPsPreferencePage_11, null));
            return;
        }
    }

    private void initDefaultPHP() {
        PHPexeItem pHPexeItem = PHPexes.getInstance().getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
        if (pHPexeItem != null) {
            PHPexeItem[] pHPexeItemArray;
            PHPexeItem[] pHPexeItemArray2 = pHPexeItemArray = this.fPHPBlock.getPHPs();
            int n = pHPexeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem pHPexeItem2 = pHPexeItemArray2[n2];
                if (pHPexeItem2.equals((Object)pHPexeItem)) {
                    this.verifyDefaultPHP(pHPexeItem2);
                    break;
                }
                ++n2;
            }
        }
    }
}

