/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.pathmapper;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.IPathEntryFilter;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugSearchEngine {
    private static PHPFilenameFilter PHP_FILTER = new PHPFilenameFilter();
    private static IPathEntryFilter[] filters;

    public static PathEntry find(String string, IDebugTarget iDebugTarget) {
        return DebugSearchEngine.find(string, iDebugTarget, null, null);
    }

    public static PathEntry find(String string, IDebugTarget iDebugTarget, String string2, String string3) {
        Object object;
        if (string == null) {
            throw new NullPointerException();
        }
        PathEntry pathEntry = null;
        ILaunchConfiguration iLaunchConfiguration = iDebugTarget.getLaunch().getLaunchConfiguration();
        IProject iProject = null;
        if (string3 != null && (object = ResourcesPlugin.getWorkspace().getRoot().findMember(string3)) != null) {
            iProject = object.getProject();
        }
        if (iProject == null) {
            try {
                object = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
                if (object != null) {
                    iProject = ResourcesPlugin.getWorkspace().getRoot().getProject((String)object);
                }
            }
            catch (CoreException coreException) {
                PHPDebugPlugin.log(coreException);
            }
        }
        if (!VirtualPath.isAbsolute(string)) {
            if (iProject != null && string2 != null && string3 != null) {
                object = PHPSearchEngine.find((String)string, (String)string2, (String)string3, (IProject)iProject);
                if (object instanceof PHPSearchEngine.ExternalFileResult) {
                    PHPSearchEngine.ExternalFileResult externalFileResult = (PHPSearchEngine.ExternalFileResult)object;
                    return new PathEntry(((File)externalFileResult.getFile()).getAbsolutePath(), PathEntry.Type.EXTERNAL, externalFileResult.getContainer());
                }
                if (object instanceof PHPSearchEngine.IncludedFileResult) {
                    PHPSearchEngine.IncludedFileResult includedFileResult = (PHPSearchEngine.IncludedFileResult)object;
                    IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)includedFileResult.getContainer();
                    PathEntry.Type type = iIncludePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
                    return new PathEntry(((File)includedFileResult.getFile()).getAbsolutePath(), type, (Object)iIncludePathEntry);
                }
                if (object != null) {
                    PHPSearchEngine.ResourceResult resourceResult = (PHPSearchEngine.ResourceResult)object;
                    IResource iResource = (IResource)resourceResult.getFile();
                    return new PathEntry(iResource.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)iResource.getParent());
                }
            }
            return null;
        }
        object = PathMapperRegistry.getByLaunchConfiguration(iLaunchConfiguration);
        if (object != null) {
            pathEntry = DebugSearchEngine.find((PathMapper)object, string, iProject, iDebugTarget);
        }
        return pathEntry;
    }

    private static PathEntry find(final PathMapper pathMapper, final String string, final IProject iProject, final IDebugTarget iDebugTarget) {
        final PathEntry[] pathEntryArray = new PathEntry[1];
        Job job = new Job("Searching for local file..."){

            protected IStatus run(IProgressMonitor iProgressMonitor) {
                IPath iPath;
                Object object;
                Object[] objectArray;
                pathEntryArray[0] = pathMapper.getLocalFile(string);
                if (pathEntryArray[0] != null) {
                    return Status.OK_STATUS;
                }
                VirtualPath virtualPath = new VirtualPath(string);
                VirtualPath virtualPath2 = virtualPath.clone();
                virtualPath2.removeLastSegment();
                if (pathMapper.getLocalPathMapping(virtualPath2) != null) {
                    return Status.OK_STATUS;
                }
                LinkedList linkedList = new LinkedList();
                if (iProject != null) {
                    objectArray = PHPSearchEngine.buildIncludePath((IProject)iProject);
                } else {
                    IPath iPath2;
                    object = new HashSet();
                    iPath = iPath2 = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    int n = ((IProject[])iPath).length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject iProject2 = iPath[n2];
                        PHPSearchEngine.buildIncludePath((IProject)iProject2, (Set)object);
                        ++n2;
                    }
                    objectArray = object.toArray();
                }
                Object[] objectArray2 = objectArray;
                int n = objectArray.length;
                int n3 = 0;
                while (n3 < n) {
                    object = objectArray2[n3];
                    if (object instanceof IContainer) {
                        try {
                            DebugSearchEngine.find((IResource)((IContainer)object), virtualPath, linkedList);
                        }
                        catch (InterruptedException interruptedException) {
                            PHPDebugPlugin.log(interruptedException);
                        }
                    } else if (object instanceof IIncludePathEntry) {
                        File file;
                        IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                        iPath = iIncludePathEntry.getPath();
                        if (iIncludePathEntry.getEntryKind() == 1) {
                            if (iIncludePathEntry.getContentKind() != 2) {
                                file = iPath.toFile();
                                DebugSearchEngine.find(file, virtualPath, iIncludePathEntry, linkedList);
                            }
                        } else if (iIncludePathEntry.getEntryKind() == 2) {
                            file = (IProject)iIncludePathEntry.getResource();
                            if (file.isAccessible()) {
                                try {
                                    DebugSearchEngine.find((IResource)file, virtualPath, linkedList);
                                }
                                catch (InterruptedException interruptedException) {
                                    PHPDebugPlugin.log(interruptedException);
                                }
                            }
                        } else if (iIncludePathEntry.getEntryKind() == 4) {
                            iPath = IncludePathVariableManager.instance().resolveVariablePath(iPath.toString());
                            file = iPath.toFile();
                            DebugSearchEngine.find(file, virtualPath, iIncludePathEntry, linkedList);
                        }
                    }
                    ++n3;
                }
                boolean bl = linkedList.size() > 0;
                DebugSearchEngine.searchOpenedEditors(linkedList, virtualPath);
                if (!bl && linkedList.size() == 1 && virtualPath.equals(((PathEntry)linkedList.getFirst()).getAbstractPath())) {
                    pathEntryArray[0] = (PathEntry)linkedList.getFirst();
                } else if (linkedList.size() > 0) {
                    Collections.sort(linkedList, new BestMatchPathComparator(virtualPath));
                    pathEntryArray[0] = DebugSearchEngine.filterItems(virtualPath, linkedList.toArray(new PathEntry[linkedList.size()]), iDebugTarget);
                    if (pathEntryArray[0] != null) {
                        pathMapper.addEntry(string, pathEntryArray[0]);
                        PathMapperRegistry.storeToPreferences();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        return pathEntryArray[0];
    }

    private static void searchOpenedEditors(LinkedList<PathEntry> linkedList, VirtualPath virtualPath) {
        ArrayList arrayList = new ArrayList(0);
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        Object object = iWorkbenchWindowArray;
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] iWorkbenchPageArray;
            IWorkbenchWindow iWorkbenchWindow = object[n2];
            IWorkbenchPage[] iWorkbenchPageArray2 = iWorkbenchPageArray = iWorkbenchWindow.getPages();
            int n3 = iWorkbenchPageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IWorkbenchPage iWorkbenchPage = iWorkbenchPageArray2[n4];
                IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                arrayList.addAll(Arrays.asList(iEditorReferenceArray));
                ++n4;
            }
            ++n2;
        }
        for (IWorkbenchWindow iWorkbenchWindow : arrayList) {
            IEditorInput iEditorInput = null;
            try {
                iEditorInput = iWorkbenchWindow.getEditorInput();
            }
            catch (PartInitException partInitException) {
                continue;
            }
            if (!(iEditorInput instanceof FileStoreEditorInput) || !((File)(object = new File(((IURIEditorInput)iEditorInput).getURI()))).exists() || !((File)object).getName().equalsIgnoreCase(virtualPath.getLastSegment())) continue;
            linkedList.add(new PathEntry(((File)object).getAbsolutePath(), PathEntry.Type.EXTERNAL, (Object)((File)object).getParentFile()));
        }
    }

    private static PathEntry filterItems(VirtualPath virtualPath, PathEntry[] pathEntryArray, IDebugTarget iDebugTarget) {
        IPathEntryFilter[] iPathEntryFilterArray = DebugSearchEngine.initializePathEntryFilters();
        int n = 0;
        while (n < iPathEntryFilterArray.length) {
            pathEntryArray = iPathEntryFilterArray[n].filter(pathEntryArray, virtualPath, iDebugTarget);
            ++n;
        }
        return pathEntryArray.length > 0 ? pathEntryArray[0] : null;
    }

    private static synchronized IPathEntryFilter[] initializePathEntryFilters() {
        if (filters == null) {
            IConfigurationElement iConfigurationElement;
            IConfigurationElement[] iConfigurationElementArray;
            HashMap<String, IPathEntryFilter> hashMap = new HashMap<String, IPathEntryFilter>();
            IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(PHPDebugPlugin.getID(), "pathEntryFilters");
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string;
                iConfigurationElement = iConfigurationElementArray2[n2];
                if ("filter".equals(iConfigurationElement.getName()) && !hashMap.containsKey(string = iConfigurationElement.getAttribute("id"))) {
                    String string2 = iConfigurationElement.getAttribute("overridesId");
                    if (string2 != null) {
                        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", ");
                        while (stringTokenizer.hasMoreTokens()) {
                            hashMap.put(stringTokenizer.nextToken(), null);
                        }
                    }
                    try {
                        hashMap.put(string, (IPathEntryFilter)iConfigurationElement.createExecutableExtension("class"));
                    }
                    catch (CoreException coreException) {
                        PHPDebugPlugin.log(coreException);
                    }
                }
                ++n2;
            }
            iConfigurationElement = hashMap.values();
            iConfigurationElement.remove(null);
            filters = iConfigurationElement.toArray(new IPathEntryFilter[hashMap.size()]);
        }
        return filters;
    }

    private static void find(File file, VirtualPath virtualPath, IIncludePathEntry iIncludePathEntry, List<PathEntry> list) {
        if (!file.isDirectory() && file.getName().equals(virtualPath.getLastSegment())) {
            PathEntry.Type type = iIncludePathEntry.getEntryKind() == 4 ? PathEntry.Type.INCLUDE_VAR : PathEntry.Type.INCLUDE_FOLDER;
            PathEntry pathEntry = new PathEntry(file.getAbsolutePath(), type, (Object)iIncludePathEntry);
            list.add(pathEntry);
            return;
        }
        File[] fileArray = file.listFiles(PHP_FILTER);
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                DebugSearchEngine.find(fileArray[n], virtualPath, iIncludePathEntry, list);
                ++n;
            }
        }
    }

    private static void find(final IResource iResource, final VirtualPath virtualPath, final List<PathEntry> list) throws InterruptedException {
        if (iResource == null || !iResource.exists() || !iResource.isAccessible()) {
            return;
        }
        WorkspaceJob workspaceJob = new WorkspaceJob(""){

            public IStatus runInWorkspace(IProgressMonitor iProgressMonitor) throws CoreException {
                iResource.accept(new IResourceVisitor(){

                    public boolean visit(IResource iResource) throws CoreException {
                        if (!iResource.isAccessible()) {
                            return false;
                        }
                        if (iResource instanceof IFile && iResource.getName().equals(virtualPath.getLastSegment())) {
                            PathEntry pathEntry = new PathEntry(iResource.getFullPath().toString(), PathEntry.Type.WORKSPACE, (Object)iResource.getParent());
                            list.add(pathEntry);
                        }
                        return true;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        workspaceJob.schedule();
        workspaceJob.join();
    }

    private static class PHPFilenameFilter
    implements FileFilter,
    IContentTypeManager.IContentTypeChangeListener {
        private Pattern phpFilePattern;

        public PHPFilenameFilter() {
            this.buildPHPFilePattern();
            Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        }

        private void buildPHPFilePattern() {
            IContentType iContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP);
            String[] stringArray = iContentType.getFileSpecs(8);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(".*\\.(");
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuilder.append("|");
                }
                stringBuilder.append(stringArray[n]);
                ++n;
            }
            stringBuilder.append(')');
            this.phpFilePattern = Pattern.compile(stringBuilder.toString(), 2);
        }

        public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent contentTypeChangeEvent) {
            this.buildPHPFilePattern();
        }

        public boolean accept(File file) {
            return file.isDirectory() || this.phpFilePattern.matcher(file.getName()).matches();
        }
    }
}

