/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.Hashtable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpCommand;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpUtils;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.Event;
import org.w3c.dom.Node;

public class DBGpSession {
    public static final String DEFAULT_SESSION_ENCODING = "ISO-8859-1";
    private Socket DBGpSocket;
    private AsyncResponseHandlerJob responseHandler;
    private DBGpCommand DBGpCmd;
    private DataInputStream DBGpReader;
    private boolean socketClosed = false;
    private DBGpTarget debugTarget;
    private Hashtable savedResponses = new Hashtable();
    private String ideKey;
    private String sessionId;
    private String initialScript;
    private long creationTime = System.currentTimeMillis();
    private String sessionEncoding;

    public long getCreationTime() {
        return this.creationTime;
    }

    public DBGpSession(Socket socket) {
        this.DBGpSocket = socket;
        this.sessionEncoding = DEFAULT_SESSION_ENCODING;
        boolean bl = false;
        try {
            this.DBGpCmd = new DBGpCommand(this.DBGpSocket);
            this.DBGpReader = new DataInputStream(this.DBGpSocket.getInputStream());
            this.socketClosed = false;
            byte[] byArray = this.readResponse();
            if (byArray != null) {
                DBGpResponse dBGpResponse = new DBGpResponse();
                dBGpResponse.parseResponse(byArray);
                if (1 == dBGpResponse.getType()) {
                    this.ideKey = dBGpResponse.getIdekey();
                    this.sessionId = dBGpResponse.getSession();
                    this.initialScript = DBGpUtils.getFilenameFromURIString(dBGpResponse.getFileUri());
                    bl = true;
                } else {
                    DBGpLogger.logError("Init response not received. XML=" + dBGpResponse.getRawXML(), this, null);
                }
            } else {
                DBGpLogger.logError("Unexpected null from readResponse waiting for Init", this, null);
            }
            if (!bl) {
                this.endSession();
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DBGpLogger.logException("UnsupportedEncodingException - 1", this, unsupportedEncodingException);
            this.endSession();
        }
        catch (IOException iOException) {
            DBGpLogger.logException("IOException - 1", this, iOException);
            this.endSession();
        }
    }

    public void startSession() {
        this.responseHandler = new AsyncResponseHandlerJob();
        this.responseHandler.schedule();
    }

    public void sendAsyncCmd(String string) {
        this.sendAsyncCmd(string, null);
    }

    public DBGpResponse sendSyncCmd(String string) {
        return this.sendSyncCmd(string, null);
    }

    public void sendAsyncCmd(String string, String string2) {
        int n = DBGpCommand.getNextId();
        try {
            this.DBGpCmd.send(string, string2, n, this.sessionEncoding);
        }
        catch (IOException iOException) {
            this.endSession();
        }
    }

    public DBGpResponse sendSyncCmd(String string, String string2) {
        int n = DBGpCommand.getNextId();
        Event event = new Event();
        Integer n2 = new Integer(n);
        this.savedResponses.put(n2, event);
        try {
            this.DBGpCmd.send(string, string2, n, this.sessionEncoding);
            event.waitForEvent();
            return (DBGpResponse)this.savedResponses.remove(n2);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (IOException iOException) {
            this.endSession();
            return null;
        }
    }

    public DBGpResponse sendSyncCmdOnResponseThread(String string, String string2) {
        this.sendAsyncCmd(string, string2);
        byte[] byArray = this.readResponse();
        DBGpResponse dBGpResponse = null;
        if (byArray != null) {
            dBGpResponse = new DBGpResponse();
            dBGpResponse.parseResponse(byArray);
        }
        return dBGpResponse;
    }

    private byte[] readResponse() {
        byte[] byArray;
        int n = 0;
        try {
            byte by;
            while ((by = this.DBGpReader.readByte()) != 0) {
                n = n * 10 + by - 48;
            }
            byArray = new byte[n];
            int n2 = 0;
            while (n > 0) {
                int n3 = this.DBGpReader.read(byArray, n2, n);
                n -= n3;
                n2 += n3;
            }
            if (this.DBGpReader.readByte() != 0) {
                this.endSession();
                return null;
            }
        }
        catch (IOException iOException) {
            this.endSession();
            return null;
        }
        try {
            if (DBGpLogger.debugResp()) {
                DBGpLogger.debug("Response: " + new String(byArray, this.sessionEncoding));
            }
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            DBGpLogger.logException("UnsupportedEncodingException - 2", this, unsupportedEncodingException);
            this.endSession();
            return null;
        }
    }

    public synchronized void endSession() {
        if (!this.socketClosed) {
            try {
                this.DBGpSocket.shutdownInput();
            }
            catch (IOException iOException) {}
            try {
                this.DBGpSocket.shutdownOutput();
            }
            catch (IOException iOException) {}
            try {
                this.socketClosed = true;
                this.DBGpSocket.close();
            }
            catch (IOException iOException) {
                DBGpLogger.debugException(iOException);
            }
        }
        if (this.debugTarget != null) {
            this.debugTarget.sessionEnded();
            this.debugTarget = null;
        }
    }

    public String getIdeKey() {
        return this.ideKey;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public boolean isActive() {
        return !this.socketClosed;
    }

    public String getInitialScript() {
        return this.initialScript;
    }

    public DBGpTarget getDebugTarget() {
        return this.debugTarget;
    }

    public void setDebugTarget(DBGpTarget dBGpTarget) {
        this.debugTarget = dBGpTarget;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getIdeKey());
        if (this.getSessionId() != null) {
            stringBuffer.append(" - Session:");
            stringBuffer.append(this.getSessionId());
        } else {
            stringBuffer.append(" - Web Server Session");
        }
        return stringBuffer.toString();
    }

    public String getSessionEncoding() {
        return this.sessionEncoding;
    }

    public void setSessionEncoding(String string) {
        this.sessionEncoding = string;
    }

    private class AsyncResponseHandlerJob
    extends Job {
        public AsyncResponseHandlerJob() {
            super("DBGp Response Handler");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            byte[] byArray = null;
            while (!DBGpSession.this.socketClosed) {
                try {
                    byArray = DBGpSession.this.readResponse();
                    if (byArray == null) continue;
                    DBGpResponse dBGpResponse = new DBGpResponse();
                    dBGpResponse.parseResponse(byArray);
                    int n = dBGpResponse.getErrorCode();
                    if (n == 0 || n == 10003) {
                        int n2 = dBGpResponse.getType();
                        if (n2 == 2) {
                            if (dBGpResponse.getStatus().equals("stopped")) {
                                this.handleStopStatus();
                            } else if (dBGpResponse.getStatus().equals("break")) {
                                this.handleBreakStatus(dBGpResponse);
                            }
                        } else if (n2 == 3 && n != 10003) {
                            this.handleStreamData(dBGpResponse);
                        } else {
                            DBGpLogger.logWarning("Unknown type of XML: " + byArray, DBGpSession.this, null);
                        }
                    }
                    this.unblockSyncCaller(dBGpResponse);
                }
                catch (Throwable throwable) {
                    DBGpLogger.logException("Unexpected exception. Terminating the debug session", (Object)this, throwable);
                    DBGpSession.this.endSession();
                    DBGpResponse dBGpResponse = new DBGpResponse();
                    dBGpResponse.parseResponse((byte[])null);
                    this.unblockSyncCaller(dBGpResponse);
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
            DBGpSession.this.endSession();
            return Status.OK_STATUS;
        }

        private void unblockSyncCaller(DBGpResponse dBGpResponse) {
            Integer n = null;
            try {
                n = new Integer(dBGpResponse.getId());
            }
            catch (NumberFormatException numberFormatException) {
                n = new Integer(DBGpSession.this.DBGpCmd.getLastIdSent());
            }
            if (DBGpSession.this.savedResponses.containsKey(n)) {
                Event event = (Event)DBGpSession.this.savedResponses.get(n);
                DBGpSession.this.savedResponses.put(n, dBGpResponse);
                event.signalEvent();
            } else {
                DBGpUtils.isGoodDBGpResponse((Object)this, dBGpResponse);
            }
        }

        private void handleStreamData(DBGpResponse dBGpResponse) {
        }

        private void handleStopStatus() {
            DBGpSession.this.endSession();
        }

        private void handleBreakStatus(DBGpResponse dBGpResponse) {
            if (dBGpResponse.getStatus().equals("break") && dBGpResponse.getReason().equals("ok")) {
                String string = dBGpResponse.getCommand();
                if (string.equals("run")) {
                    this.processBreakpointHit();
                } else if (string.equals("step_into") || string.equals("step_out") || string.equals("step_over")) {
                    DBGpSession.this.debugTarget.suspended(8);
                }
            }
        }

        private void processBreakpointHit() {
            DBGpResponse dBGpResponse = DBGpSession.this.sendSyncCmdOnResponseThread("stack_get", null);
            if (dBGpResponse != null) {
                if (dBGpResponse.getStatus().equals("stopped")) {
                    this.handleStopStatus();
                } else {
                    Node node = dBGpResponse.getParentNode().getFirstChild();
                    String string = DBGpResponse.getAttribute(node, "lineno");
                    int n = 0;
                    try {
                        n = Integer.parseInt(string);
                        String string2 = DBGpUtils.getFilenameFromURIString(DBGpResponse.getAttribute(node, "filename"));
                        string2 = DBGpSession.this.debugTarget.mapToWorkspaceFileIfRequired(string2);
                        DBGpSession.this.debugTarget.breakpointHit(string2, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        DBGpLogger.logException("Unexpected number format exception", (Object)this, numberFormatException);
                    }
                }
            }
        }
    }
}

