/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.debug.core.debugger.IDebugHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugNotificationMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugRequestMessage;
import org.eclipse.php.debug.core.debugger.messages.IDebugResponseMessage;
import org.eclipse.php.internal.core.util.PHPSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.DebugSearchEngine;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapper;
import org.eclipse.php.internal.debug.core.pathmapper.PathMapperRegistry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.communication.DebugConnectionThread;
import org.eclipse.php.internal.debug.core.zend.communication.ResponseHandler;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.Debugger;
import org.eclipse.php.internal.debug.core.zend.debugger.IRemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPstack;
import org.eclipse.php.internal.debug.core.zend.debugger.StackLayer;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddBreakpointRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AddBreakpointResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.AssignValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelAllBreakpointsRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelAllBreakpointsResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelBreakpointRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.CancelBreakpointResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.DebugSessionClosedNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.EvalRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.EvalResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCallStackRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetCallStackResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetStackVariableValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetStackVariableValueResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetVariableValueRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GetVariableValueResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GoRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.GoResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.PauseDebuggerRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.PauseDebuggerResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.SetProtocolResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepIntoRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepIntoResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOutRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOutResponse;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOverRequest;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StepOverResponse;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class RemoteDebugger
implements IRemoteDebugger {
    public static final int PROTOCOL_ID_2006040701 = 2006040701;
    public static final int PROTOCOL_ID_2006040703 = 2006040703;
    private static final String EVAL_ERROR = "[Error]";
    protected boolean isDebugMode = System.getProperty("loggingDebug") != null;
    private DebugConnectionThread connection;
    private IDebugHandler debugHandler;
    private Map<String, String> resolvedFiles;
    private int currentProtocolId = 0;

    public RemoteDebugger(IDebugHandler iDebugHandler, DebugConnectionThread debugConnectionThread) {
        this.connection = debugConnectionThread;
        this.debugHandler = iDebugHandler;
        this.connection.setCommunicationAdministrator(this);
        this.connection.setCommunicationClient(this);
        this.resolvedFiles = new HashMap<String, String>();
    }

    public IDebugHandler getDebugHandler() {
        return this.debugHandler;
    }

    public DebugConnectionThread getConnectionThread() {
        return this.connection;
    }

    public void closeConnection() {
        this.connection.closeConnection();
    }

    public void setPeerResponseTimeout(int n) {
        this.connection.setPeerResponseTimeout(n);
    }

    public void connectionEstablished() {
        this.debugHandler.connectionEstablished();
    }

    public void connectionClosed() {
        this.debugHandler.connectionClosed();
    }

    public void closeDebugSession() {
        if (this.connection.isConnected()) {
            this.connection.sendNotification(new DebugSessionClosedNotification());
        }
    }

    public void handleMultipleBindings() {
        this.debugHandler.multipleBindOccured();
    }

    public void handlePeerResponseTimeout() {
        this.debugHandler.connectionTimedout();
    }

    public String sendCWDRequest() {
        try {
            String string;
            EvalRequest evalRequest = new EvalRequest();
            evalRequest.setCommand("getcwd()");
            IDebugResponseMessage iDebugResponseMessage = this.sendCustomRequest(evalRequest);
            if (iDebugResponseMessage != null && iDebugResponseMessage instanceof EvalResponse && !EVAL_ERROR.equals(string = ((EvalResponse)iDebugResponseMessage).getResult())) {
                return string;
            }
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
        return null;
    }

    public String getCurrentWorkingDirectory() {
        PathEntry pathEntry;
        PathMapper pathMapper;
        PHPDebugTarget pHPDebugTarget = this.debugHandler.getDebugTarget();
        String string = this.sendCWDRequest();
        if (string != null && (pathMapper = PathMapperRegistry.getByLaunchConfiguration(pHPDebugTarget.getLaunch().getLaunchConfiguration())) != null && (pathEntry = pathMapper.getLocalFile(string)) != null) {
            string = pathEntry.getResolvedPath();
        }
        return string;
    }

    public boolean setCurrentWorkingDirectory(String string) {
        try {
            String string2;
            EvalRequest evalRequest = new EvalRequest();
            evalRequest.setCommand(String.format("chdir('%1$s')", string));
            IDebugResponseMessage iDebugResponseMessage = this.sendCustomRequest(evalRequest);
            if (iDebugResponseMessage != null && iDebugResponseMessage instanceof EvalResponse && !EVAL_ERROR.equals(string2 = ((EvalResponse)iDebugResponseMessage).getResult())) {
                return true;
            }
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
        return false;
    }

    public String convertToLocalFilename(String string) {
        String string2 = null;
        PHPstack pHPstack = this.getCallStack();
        if (pHPstack.getSize() > 0) {
            string2 = pHPstack.getLayer(pHPstack.getSize() - 1).getResolvedCalledFileName();
        }
        return this.convertToLocalFilename(string, this.getCurrentWorkingDirectory(), string2);
    }

    public String convertToLocalFilename(String string, String string2, String string3) {
        PHPDebugTarget pHPDebugTarget = this.debugHandler.getDebugTarget();
        if (pHPDebugTarget.getContextManager().isResolveBlacklisted(string)) {
            return string;
        }
        if (ResourcesPlugin.getWorkspace().getRoot().findMember(string) != null) {
            return string;
        }
        String string4 = string + string2 + string3;
        if (!this.resolvedFiles.containsKey(string4)) {
            Object object;
            String string5 = null;
            if (pHPDebugTarget.isPHPCGI() && new File(string).exists()) {
                object = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(string));
                string5 = object != null ? object.getFullPath().toString() : string;
            }
            if (string5 == null) {
                PathEntry pathEntry;
                object = null;
                if (string3 != null) {
                    object = new Path(string3).removeLastSegments(1).toString();
                }
                if ((pathEntry = DebugSearchEngine.find(string, pHPDebugTarget, string2, object)) != null) {
                    string5 = pathEntry.getResolvedPath();
                }
            }
            this.resolvedFiles.put(string4, string5);
        }
        return this.resolvedFiles.get(string4);
    }

    public static String convertToRemoteFilename(String string, PHPDebugTarget pHPDebugTarget) {
        String string2;
        Object object;
        IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(string));
        if (pHPDebugTarget.isPHPCGI() && iFile.exists() && iFile.getLocation() != null && ((File)(object = iFile.getLocation().toFile())).exists()) {
            return ((File)object).getAbsolutePath();
        }
        if (VirtualPath.isAbsolute(string) && (object = PathMapperRegistry.getByLaunchConfiguration(pHPDebugTarget.getLaunch().getLaunchConfiguration())) != null && (string2 = ((PathMapper)object).getRemoteFile(string)) != null) {
            return string2;
        }
        return string;
    }

    public IDebugResponseMessage sendCustomRequest(IDebugRequestMessage iDebugRequestMessage) {
        if (this.isDebugMode) {
            System.out.println("Sending custome request: " + iDebugRequestMessage + " (type = " + iDebugRequestMessage.getType() + ')');
        }
        IDebugResponseMessage iDebugResponseMessage = null;
        if (this.isActive()) {
            try {
                Object object = this.connection.sendRequest(iDebugRequestMessage);
                if (object instanceof IDebugResponseMessage) {
                    iDebugResponseMessage = (IDebugResponseMessage)object;
                }
                if (this.isDebugMode && iDebugResponseMessage != null) {
                    System.out.println("Response to custom request: " + iDebugResponseMessage + " (type = " + iDebugResponseMessage.getType() + ')');
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return iDebugResponseMessage;
    }

    public boolean sendCustomNotification(IDebugNotificationMessage iDebugNotificationMessage) {
        if (this.isActive()) {
            try {
                this.connection.sendNotification(iDebugNotificationMessage);
                return true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return false;
    }

    public boolean addBreakpoint(Breakpoint breakpoint, Debugger.BreakpointAddedResponseHandler breakpointAddedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            AddBreakpointRequest addBreakpointRequest = new AddBreakpointRequest();
            Breakpoint breakpoint2 = (Breakpoint)breakpoint.clone();
            String string = breakpoint2.getFileName();
            breakpoint2.setFileName(string);
            addBreakpointRequest.setBreakpoint(breakpoint2);
            this.connection.sendRequest(addBreakpointRequest, new ThisHandleResponse(breakpointAddedResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        if (!this.isActive()) {
            return;
        }
        try {
            AddBreakpointRequest addBreakpointRequest = new AddBreakpointRequest();
            Breakpoint breakpoint2 = (Breakpoint)breakpoint.clone();
            String string = breakpoint2.getFileName();
            breakpoint2.setFileName(string);
            addBreakpointRequest.setBreakpoint(breakpoint2);
            AddBreakpointResponse addBreakpointResponse = (AddBreakpointResponse)this.connection.sendRequest(addBreakpointRequest);
            if (addBreakpointResponse != null && addBreakpointResponse.getStatus() == 0) {
                breakpoint.setID(addBreakpointResponse.getBreakpointID());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean removeBreakpoint(int n, Debugger.BreakpointRemovedResponseHandler breakpointRemovedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelBreakpointRequest cancelBreakpointRequest = new CancelBreakpointRequest();
        cancelBreakpointRequest.setBreakpointID(n);
        this.connection.sendRequest(cancelBreakpointRequest, new ThisHandleResponse(breakpointRemovedResponseHandler));
        return true;
    }

    public boolean removeBreakpoint(int n) {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelBreakpointRequest cancelBreakpointRequest = new CancelBreakpointRequest();
            cancelBreakpointRequest.setBreakpointID(n);
            CancelBreakpointResponse cancelBreakpointResponse = (CancelBreakpointResponse)this.connection.sendRequest(cancelBreakpointRequest);
            return cancelBreakpointResponse != null && cancelBreakpointResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean removeBreakpoint(Breakpoint breakpoint, Debugger.BreakpointRemovedResponseHandler breakpointRemovedResponseHandler) {
        return this.removeBreakpoint(breakpoint.getID(), breakpointRemovedResponseHandler);
    }

    public boolean removeBreakpoint(Breakpoint breakpoint) {
        return this.removeBreakpoint(breakpoint.getID());
    }

    public boolean removeAllBreakpoints(Debugger.AllBreakpointRemovedResponseHandler allBreakpointRemovedResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        CancelAllBreakpointsRequest cancelAllBreakpointsRequest = new CancelAllBreakpointsRequest();
        this.connection.sendRequest(cancelAllBreakpointsRequest, new ThisHandleResponse(allBreakpointRemovedResponseHandler));
        return true;
    }

    public boolean removeAllBreakpoints() {
        if (!this.isActive()) {
            return false;
        }
        try {
            CancelAllBreakpointsRequest cancelAllBreakpointsRequest = new CancelAllBreakpointsRequest();
            CancelAllBreakpointsResponse cancelAllBreakpointsResponse = (CancelAllBreakpointsResponse)this.connection.sendRequest(cancelAllBreakpointsRequest);
            return cancelAllBreakpointsResponse != null && cancelAllBreakpointsResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepInto(Debugger.StepIntoResponseHandler stepIntoResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        StepIntoRequest stepIntoRequest = new StepIntoRequest();
        this.connection.sendRequest(stepIntoRequest, new ThisHandleResponse(stepIntoResponseHandler));
        return true;
    }

    public boolean stepInto() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepIntoRequest stepIntoRequest = new StepIntoRequest();
            StepIntoResponse stepIntoResponse = (StepIntoResponse)this.connection.sendRequest(stepIntoRequest);
            return stepIntoResponse != null && stepIntoResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOver(Debugger.StepOverResponseHandler stepOverResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest stepOverRequest = new StepOverRequest();
            this.connection.sendRequest(stepOverRequest, new ThisHandleResponse(stepOverResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOver() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOverRequest stepOverRequest = new StepOverRequest();
            StepOverResponse stepOverResponse = (StepOverResponse)this.connection.sendRequest(stepOverRequest);
            return stepOverResponse != null && stepOverResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOut(Debugger.StepOutResponseHandler stepOutResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest stepOutRequest = new StepOutRequest();
            this.connection.sendRequest(stepOutRequest, new ThisHandleResponse(stepOutResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean stepOut() {
        if (!this.isActive()) {
            return false;
        }
        try {
            StepOutRequest stepOutRequest = new StepOutRequest();
            StepOutResponse stepOutResponse = (StepOutResponse)this.connection.sendRequest(stepOutRequest);
            return stepOutResponse != null && stepOutResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean go(Debugger.GoResponseHandler goResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest goRequest = new GoRequest();
            this.connection.sendRequest(goRequest, new ThisHandleResponse(goResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean go() {
        if (!this.isActive()) {
            return false;
        }
        try {
            GoRequest goRequest = new GoRequest();
            GoResponse goResponse = (GoResponse)this.connection.sendRequest(goRequest);
            return goResponse != null && goResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean start(Debugger.StartResponseHandler startResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        if (!this.detectProtocolID()) {
            return false;
        }
        this.debugHandler.getDebugTarget().installDeferredBreakpoints();
        StartRequest startRequest = new StartRequest();
        try {
            this.connection.sendRequest(startRequest, new ThisHandleResponse(startResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean start() {
        if (!this.isActive()) {
            return false;
        }
        if (!this.detectProtocolID()) {
            return false;
        }
        StartRequest startRequest = new StartRequest();
        try {
            StartResponse startResponse = (StartResponse)this.connection.sendRequest(startRequest);
            return startResponse != null && startResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected boolean detectProtocolID() {
        if (this.setProtocol(2006040703)) {
            return true;
        }
        if (this.setProtocol(2006040701)) {
            RemoteDebugger.warnOlderDebugVersion();
            return true;
        }
        this.getDebugHandler().wrongDebugServer();
        return false;
    }

    public static void warnOlderDebugVersion() {
        final IPreferenceStore iPreferenceStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("DontShowOlderDebuggerWarning");
        if (!"always".equals(string)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MessageDialogWithToggle.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Old Zend Debugger Protocol ID", (String)"The Zend Debugger protocol ID is older than the one you are using.\n\nSome debugging features may not work properly!", (String)"Don't show this message", (boolean)false, (IPreferenceStore)iPreferenceStore, (String)"DontShowOlderDebuggerWarning");
                }
            });
        }
    }

    public boolean setProtocol(int n) {
        int n2;
        SetProtocolRequest setProtocolRequest = new SetProtocolRequest();
        setProtocolRequest.setProtocolID(n);
        IDebugResponseMessage iDebugResponseMessage = this.sendCustomRequest(setProtocolRequest);
        if (iDebugResponseMessage != null && iDebugResponseMessage instanceof SetProtocolResponse && (n2 = ((SetProtocolResponse)iDebugResponseMessage).getProtocolID()) == n) {
            this.currentProtocolId = n;
            return true;
        }
        return false;
    }

    public int getCurrentProtocolID() {
        return this.currentProtocolId;
    }

    public boolean pause(Debugger.PauseResponseHandler pauseResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest pauseDebuggerRequest = new PauseDebuggerRequest();
        try {
            this.connection.sendRequest(pauseDebuggerRequest, new ThisHandleResponse(pauseResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean pause() {
        if (!this.isActive()) {
            return false;
        }
        PauseDebuggerRequest pauseDebuggerRequest = new PauseDebuggerRequest();
        try {
            PauseDebuggerResponse pauseDebuggerResponse = (PauseDebuggerResponse)this.connection.sendRequest(pauseDebuggerRequest);
            return pauseDebuggerResponse != null && pauseDebuggerResponse.getStatus() == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean eval(String string, Debugger.EvalResponseHandler evalResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        EvalRequest evalRequest = new EvalRequest();
        evalRequest.setCommand(string);
        try {
            this.connection.sendRequest(evalRequest, new ThisHandleResponse(evalResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean assignValue(String string, String string2, int n, String[] stringArray, Debugger.AssignValueResponseHandler assignValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest assignValueRequest = new AssignValueRequest();
        assignValueRequest.setVar(string);
        assignValueRequest.setValue(string2);
        assignValueRequest.setDepth(n);
        assignValueRequest.setPath(stringArray);
        assignValueRequest.setTransferEncoding(this.getTransferEncoding());
        try {
            this.connection.sendRequest(assignValueRequest, new ThisHandleResponse(assignValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private String getTransferEncoding() {
        IProject iProject = this.debugHandler.getDebugTarget().getProject();
        return iProject == null ? null : PHPProjectPreferences.getTransferEncoding(iProject);
    }

    public boolean assignValue(String string, String string2, int n, String[] stringArray) {
        if (!this.isActive()) {
            return false;
        }
        AssignValueRequest assignValueRequest = new AssignValueRequest();
        assignValueRequest.setVar(string);
        assignValueRequest.setValue(string2);
        assignValueRequest.setDepth(n);
        assignValueRequest.setPath(stringArray);
        assignValueRequest.setTransferEncoding(this.getTransferEncoding());
        try {
            this.connection.sendRequest(assignValueRequest);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String eval(String string) {
        if (!this.isActive()) {
            return null;
        }
        EvalRequest evalRequest = new EvalRequest();
        evalRequest.setCommand(string);
        try {
            EvalResponse evalResponse = (EvalResponse)this.connection.sendRequest(evalRequest);
            String string2 = null;
            if (evalResponse != null) {
                string2 = evalResponse.getStatus() == 0 ? evalResponse.getResult() : "---ERROR---";
            }
            return string2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void finish() {
        this.connection.closeConnection();
    }

    public boolean isActive() {
        return this.connection != null && this.connection.isConnected();
    }

    public boolean getVariableValue(String string, int n, String[] stringArray, Debugger.VariableValueResponseHandler variableValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetVariableValueRequest getVariableValueRequest = new GetVariableValueRequest();
        getVariableValueRequest.setVar(string);
        getVariableValueRequest.setDepth(n);
        getVariableValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(getVariableValueRequest, new ThisHandleResponse(variableValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public byte[] getVariableValue(String string, int n, String[] stringArray) throws IllegalArgumentException {
        if (!this.isActive()) {
            return null;
        }
        GetVariableValueRequest getVariableValueRequest = new GetVariableValueRequest();
        getVariableValueRequest.setVar(string);
        getVariableValueRequest.setDepth(n);
        getVariableValueRequest.setPath(stringArray);
        GetVariableValueResponse getVariableValueResponse = null;
        try {
            getVariableValueResponse = (GetVariableValueResponse)this.connection.sendRequest(getVariableValueRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (getVariableValueResponse == null || getVariableValueResponse.getStatus() != 0) {
            return null;
        }
        return getVariableValueResponse.getVarResult();
    }

    public boolean getCallStack(Debugger.GetCallStackResponseHandler getCallStackResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetCallStackRequest getCallStackRequest = new GetCallStackRequest();
        try {
            this.connection.sendRequest(getCallStackRequest, new ThisHandleResponse(getCallStackResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public PHPstack getCallStack() {
        if (!this.isActive()) {
            return null;
        }
        GetCallStackRequest getCallStackRequest = new GetCallStackRequest();
        PHPstack pHPstack = null;
        try {
            GetCallStackResponse getCallStackResponse = (GetCallStackResponse)this.connection.sendRequest(getCallStackRequest);
            if (getCallStackResponse != null) {
                pHPstack = getCallStackResponse.getPHPstack();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.convertToSystem(pHPstack);
        return pHPstack;
    }

    private void convertToSystem(PHPstack pHPstack) {
        if (pHPstack != null) {
            String string = this.getCurrentWorkingDirectory();
            int n = 0;
            while (n < pHPstack.getSize()) {
                StackLayer stackLayer = pHPstack.getLayer(n);
                stackLayer.setCallerLineNumber(stackLayer.getCallerLineNumber() - 1);
                stackLayer.setCalledLineNumber(stackLayer.getCalledLineNumber() - 1);
                stackLayer.setResolvedCalledFileName(stackLayer.getCalledFileName());
                if (n > 0) {
                    String string2 = pHPstack.getLayer(n - 1).getResolvedCalledFileName();
                    String string3 = ".";
                    int n2 = Math.max(string2.lastIndexOf(47), string2.lastIndexOf(92));
                    if (n2 != -1) {
                        string3 = string2.substring(0, n2);
                    }
                    IProject iProject = null;
                    IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember(string2);
                    iProject = iResource != null ? iResource.getProject() : this.debugHandler.getDebugTarget().getProject();
                    if (stackLayer.getCalledFileName() != null && string != null && iProject != null) {
                        PHPSearchEngine.Result result = PHPSearchEngine.find((String)stackLayer.getCalledFileName(), (String)string, (String)string3, (IProject)iProject);
                        if (result instanceof PHPSearchEngine.ResourceResult) {
                            stackLayer.setResolvedCalledFileName(((IFile)((PHPSearchEngine.ResourceResult)result).getFile()).getFullPath().toString());
                        } else if (result instanceof PHPSearchEngine.IncludedFileResult) {
                            stackLayer.setResolvedCalledFileName(((File)((PHPSearchEngine.IncludedFileResult)result).getFile()).getAbsolutePath());
                        } else if (result instanceof PHPSearchEngine.ExternalFileResult) {
                            stackLayer.setResolvedCalledFileName(((File)((PHPSearchEngine.ExternalFileResult)result).getFile()).getAbsolutePath());
                        }
                    }
                }
                ++n;
            }
        }
    }

    public boolean getStackVariableValue(int n, String string, int n2, String[] stringArray, Debugger.GetStackVariableValueResponseHandler getStackVariableValueResponseHandler) {
        if (!this.isActive()) {
            return false;
        }
        GetStackVariableValueRequest getStackVariableValueRequest = new GetStackVariableValueRequest();
        getStackVariableValueRequest.setVar(string);
        getStackVariableValueRequest.setDepth(n2);
        getStackVariableValueRequest.setLayerDepth(n);
        getStackVariableValueRequest.setPath(stringArray);
        try {
            this.connection.sendRequest(getStackVariableValueRequest, new ThisHandleResponse(getStackVariableValueResponseHandler));
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public byte[] getStackVariableValue(int n, String string, int n2, String[] stringArray) {
        if (!this.isActive()) {
            return null;
        }
        GetStackVariableValueRequest getStackVariableValueRequest = new GetStackVariableValueRequest();
        getStackVariableValueRequest.setVar(string);
        getStackVariableValueRequest.setDepth(n2);
        getStackVariableValueRequest.setLayerDepth(n);
        getStackVariableValueRequest.setPath(stringArray);
        GetStackVariableValueResponse getStackVariableValueResponse = null;
        try {
            getStackVariableValueResponse = (GetStackVariableValueResponse)this.connection.sendRequest(getStackVariableValueRequest);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (getStackVariableValueResponse == null || getStackVariableValueResponse.getStatus() != 0) {
            return null;
        }
        return getStackVariableValueResponse.getVarResult();
    }

    private class ThisHandleResponse
    implements ResponseHandler {
        Object responseHandler;

        public ThisHandleResponse(Object object) {
            this.responseHandler = object;
        }

        public void handleResponse(Object object, Object object2) {
            boolean bl;
            boolean bl2 = bl = object2 != null && ((IDebugResponseMessage)object2).getStatus() == 0;
            if (object instanceof AddBreakpointRequest) {
                AddBreakpointRequest addBreakpointRequest = (AddBreakpointRequest)object;
                Breakpoint breakpoint = addBreakpointRequest.getBreakpoint();
                String string = breakpoint.getFileName();
                int n = breakpoint.getLineNumber();
                int n2 = -1;
                if (object2 != null) {
                    n2 = ((AddBreakpointResponse)object2).getBreakpointID();
                }
                ((Debugger.BreakpointAddedResponseHandler)this.responseHandler).breakpointAdded(string, n, n2, bl);
            } else if (object instanceof CancelBreakpointRequest) {
                ((Debugger.BreakpointRemovedResponseHandler)this.responseHandler).breakpointRemoved(((CancelBreakpointRequest)object).getBreakpointID(), bl);
            } else if (object instanceof CancelAllBreakpointsRequest) {
                ((Debugger.AllBreakpointRemovedResponseHandler)this.responseHandler).allBreakpointRemoved(bl);
            } else if (object instanceof StartRequest) {
                ((Debugger.StartResponseHandler)this.responseHandler).started(bl);
            } else if (object instanceof EvalRequest) {
                ((Debugger.EvalResponseHandler)this.responseHandler).evaled(((EvalRequest)object).getCommand(), bl ? ((EvalResponse)object2).getResult() : null, bl);
            } else if (object instanceof StepIntoRequest) {
                ((Debugger.StepIntoResponseHandler)this.responseHandler).stepInto(bl);
            } else if (object instanceof StepOverRequest) {
                ((Debugger.StepOverResponseHandler)this.responseHandler).stepOver(bl);
            } else if (object instanceof StepOutRequest) {
                ((Debugger.StepOutResponseHandler)this.responseHandler).stepOut(bl);
            } else if (object instanceof GoRequest) {
                ((Debugger.GoResponseHandler)this.responseHandler).go(bl);
            } else if (object instanceof PauseDebuggerRequest) {
                ((Debugger.PauseResponseHandler)this.responseHandler).pause(bl);
            } else if (object instanceof AssignValueRequest) {
                AssignValueRequest assignValueRequest = (AssignValueRequest)object;
                String string = assignValueRequest.getVar();
                String string2 = assignValueRequest.getValue();
                int n = assignValueRequest.getDepth();
                String[] stringArray = assignValueRequest.getPath();
                ((Debugger.AssignValueResponseHandler)this.responseHandler).valueAssigned(string, string2, n, stringArray, bl);
            } else if (object instanceof GetVariableValueRequest) {
                GetVariableValueRequest getVariableValueRequest = (GetVariableValueRequest)object;
                String string = getVariableValueRequest.getVar();
                int n = getVariableValueRequest.getDepth();
                String[] stringArray = getVariableValueRequest.getPath();
                String string3 = null;
                if (object2 != null) {
                    try {
                        string3 = new String(((GetVariableValueResponse)object2).getVarResult(), ((IDebugMessage)object2).getTransferEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                ((Debugger.VariableValueResponseHandler)this.responseHandler).variableValue(string, n, stringArray, string3, bl);
            } else if (object instanceof GetCallStackRequest) {
                PHPstack pHPstack = null;
                if (object2 != null) {
                    pHPstack = ((GetCallStackResponse)object2).getPHPstack();
                }
                RemoteDebugger.this.convertToSystem(pHPstack);
                ((Debugger.GetCallStackResponseHandler)this.responseHandler).callStack(pHPstack, bl);
            } else if (object instanceof GetStackVariableValueRequest) {
                GetStackVariableValueRequest getStackVariableValueRequest = (GetStackVariableValueRequest)object;
                int n = getStackVariableValueRequest.getLayerDepth();
                String string = getStackVariableValueRequest.getVar();
                int n3 = getStackVariableValueRequest.getDepth();
                String[] stringArray = getStackVariableValueRequest.getPath();
                String string4 = null;
                if (object2 != null) {
                    try {
                        string4 = new String(((GetStackVariableValueResponse)object2).getVarResult(), ((IDebugMessage)object2).getTransferEncoding());
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                ((Debugger.GetStackVariableValueResponseHandler)this.responseHandler).stackVariableValue(n, string, n3, stringArray, string4, bl);
            }
        }
    }
}

