/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.AbstractDebuggerConfiguration;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.launching.LaunchUtilities;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.server.ui.ClosableWizardDialog;
import org.eclipse.php.internal.server.ui.ServerEditDialog;
import org.eclipse.php.internal.server.ui.ServerWizard;
import org.eclipse.php.internal.ui.preferences.ScrolledCompositeImpl;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    protected IFile selectedFile = null;
    protected Text fFile;
    protected Label fURLLabel;
    protected Text fURLHost;
    protected Text fURLPath;
    protected Button projectButton;
    protected Button fileButton;
    protected Button publish;
    protected Button createNewServer;
    protected Button configureServers;
    protected Button breakOnFirstLine;
    protected Button autoGeneratedURL;
    protected String[] serverTypeIds;
    protected Combo fDebuggersCombo;
    protected Combo serverCombo;
    protected Server server;
    protected boolean serverCanPublish = false;
    protected List<Server> servers;
    protected boolean init = true;
    private static final String READ_ONLY = "read-only";
    public static final String AUTO_GENERATED_URL = "auto_generated_url";
    protected WidgetListener fListener = new WidgetListener();
    private boolean saveWorkingCopy;
    private Set<String> fDebuggerIds;

    public void createControl(Composite composite) {
        ScrolledCompositeImpl scrolledCompositeImpl = new ScrolledCompositeImpl(composite, 512);
        Composite composite2 = new Composite((Composite)scrolledCompositeImpl, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.createServerControl(composite2);
        this.createFileComponent(composite2);
        this.createBreakControl(composite2);
        this.createURLControl(composite2);
        this.createExtensionControls(composite2);
        Dialog.applyDialogFont((Control)composite2);
        scrolledCompositeImpl.setContent((Control)composite2);
        Point point = composite2.computeSize(-1, -1);
        scrolledCompositeImpl.setMinSize(point.x, point.y);
        this.setControl((Control)scrolledCompositeImpl);
    }

    public void createExtensionControls(Composite composite) {
    }

    public void createURLControl(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPServerUIMessages.getString("ServerTab.url");
        group.setText(string);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.autoGeneratedURL = new Button((Composite)group, 32);
        this.autoGeneratedURL.setText(PHPServerUIMessages.getString("ServerTab.autoGenerate"));
        this.autoGeneratedURL.setSelection(true);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.autoGeneratedURL.setLayoutData((Object)gridData);
        this.autoGeneratedURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.initializeURLControl();
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fURLLabel = new Label((Composite)group, 0);
        this.fURLLabel.setText(PHPServerUIMessages.getString("ServerTab.urlLabel"));
        gridData = new GridData();
        gridData.horizontalIndent = 20;
        gridData.horizontalSpan = 1;
        this.fURLLabel.setLayoutData((Object)gridData);
        Composite composite2 = new Composite((Composite)group, 0);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        composite2.setLayout((Layout)gridLayout2);
        gridData = new GridData(768);
        composite2.setLayoutData((Object)gridData);
        this.fURLHost = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fURLHost.setLayoutData((Object)gridData);
        this.fURLHost.setEnabled(false);
        this.fURLPath = new Text(composite2, 2052);
        gridData = new GridData(768);
        this.fURLPath.setLayoutData((Object)gridData);
        this.fURLPath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void createServerSelectionControl(Composite composite) {
        Font font = composite.getFont();
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        Group group = new Group(composite2, 0);
        group.setText(PHPServerUIMessages.getString("ServerTab.server"));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 1;
        GridData gridData2 = new GridData(768);
        group.setLayout((Layout)gridLayout2);
        group.setLayoutData((Object)gridData2);
        Composite composite3 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(2, false);
        composite3.setLayout((Layout)gridLayout);
        composite3.setFont(font);
        Label label = new Label(composite3, 64);
        gridData = new GridData(1);
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        label.setText("Server Debugger:");
        this.fDebuggersCombo = new Combo(composite3, 12);
        this.fDebuggersCombo.setFont(font);
        gridData = new GridData(768);
        gridData.widthHint = 100;
        this.fDebuggersCombo.setLayoutData((Object)gridData);
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        Composite composite4 = new Composite((Composite)group, 0);
        gridLayout = new GridLayout(4, false);
        composite4.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        composite4.setLayoutData((Object)gridData);
        composite4.setFont(font);
        label = new Label(composite4, 64);
        gridData = new GridData(1);
        gridData.widthHint = 100;
        label.setLayoutData((Object)gridData);
        label.setFont(font);
        label.setText("PHP Server:");
        this.serverCombo = new Combo(composite4, 2060);
        gridData = new GridData(768);
        gridData.widthHint = 250;
        this.serverCombo.setLayoutData((Object)gridData);
        this.serverCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.handleServerSelection();
            }
        });
        this.createNewServer = this.createPushButton(composite4, PHPServerUIMessages.getString("ServerTab.new"), null);
        this.createNewServer.addSelectionListener((SelectionListener)this.fListener);
        this.configureServers = this.createPushButton(composite4, PHPServerUIMessages.getString("ServerTab.configure"), null);
        this.configureServers.addSelectionListener((SelectionListener)this.fListener);
        this.servers = new ArrayList<Server>();
        this.populateServerList(this.servers);
        if (!this.servers.isEmpty()) {
            int n = 0;
            while (n < this.servers.size()) {
                Server server = this.servers.get(n);
                this.serverCombo.add(server.getName());
                ++n;
            }
        }
        if (this.serverCombo.getItemCount() > 0) {
            this.serverCombo.select(0);
        }
        this.fillDebuggers();
        this.serverCombo.forceFocus();
    }

    protected void fillDebuggers() {
        String string2;
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String string2 : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName((String)string2));
        }
        string2 = PHPDebuggersRegistry.getDebuggerName((String)PHPDebuggersRegistry.getDefaultDebuggerId());
        int n = this.fDebuggersCombo.indexOf(string2);
        if (n > -1) {
            this.fDebuggersCombo.select(n);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    protected void populateServerList(List<Server> list) {
        Server[] serverArray = ServersManager.getServers();
        if (list == null) {
            list = new ArrayList<Server>();
        }
        if (serverArray != null) {
            int n = serverArray.length;
            int n2 = 0;
            while (n2 < n) {
                list.add(serverArray[n2]);
                ++n2;
            }
        }
    }

    public void createServerControl(Composite composite) {
        this.createServerSelectionControl(composite);
        GridData gridData = new GridData(256);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)gridData);
        this.handleServerSelection();
    }

    protected void createFileComponent(Composite composite) {
        Group group = new Group(composite, 0);
        String string = PHPServerUIMessages.getString("ServerTab.file_project");
        group.setText(string);
        GridLayout gridLayout = new GridLayout(3, false);
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.fFile = new Text((Composite)group, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fFile.setLayoutData((Object)gridData);
        this.fFile.addModifyListener((ModifyListener)this.fListener);
        this.fileButton = this.createPushButton((Composite)group, PHPServerUIMessages.getString("ServerTab.browse"), null);
        gridData = (GridData)this.fileButton.getLayoutData();
        gridData.horizontalSpan = 1;
        this.fileButton.addSelectionListener((SelectionListener)this.fListener);
        this.handleServerSelection();
    }

    public String[] getRequiredNatures() {
        return null;
    }

    protected void handleServerButtonSelected() {
        final Server server = this.getServerFromWizard();
        if (server != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ServerLaunchConfigurationTab.this.servers.add(server);
                    ServerLaunchConfigurationTab.this.serverCombo.add(server.getName());
                    ServerLaunchConfigurationTab.this.serverCombo.select(ServerLaunchConfigurationTab.this.serverCombo.indexOf(server.getName()));
                    ServerLaunchConfigurationTab.this.handleServerSelection();
                }
            });
        }
    }

    protected void handleConfigureButtonSelected() {
        int n = this.serverCombo.getSelectionIndex();
        Server server = this.servers.get(n);
        String string = server.getName();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        ServerEditDialog serverEditDialog = new ServerEditDialog(shell, server);
        if (serverEditDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return;
        }
        ServersManager.save();
        String string2 = server.getName();
        if (!string2.equals(string)) {
            this.serverCombo.remove(n);
            this.serverCombo.add(string2, n);
            this.serverCombo.select(n);
        }
        this.saveWorkingCopy = true;
        this.handleServerSelection();
    }

    public String[] getFileExtensions() {
        return null;
    }

    private IResource getFileFromDialog(IProject iProject) {
        return LaunchUtilities.getFileFromDialog((IProject)iProject, (Shell)this.getShell(), (String[])this.getFileExtensions(), (String[])this.getRequiredNatures(), (boolean)false);
    }

    protected void handleFileButtonSelected() {
        IResource iResource = null;
        iResource = this.getFileFromDialog(null);
        if (iResource == null) {
            return;
        }
        String string = iResource.getFullPath().toString();
        this.fFile.setText(string);
        if (this.autoGeneratedURL.getSelection()) {
            this.updateURLComponents(this.computeURL(string));
        }
    }

    protected void updateURLComponents(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getPort() == -1 ? "" : ":" + uRL.getPort();
            this.fURLHost.setText(String.valueOf(uRL.getProtocol()) + "://" + uRL.getHost() + string2 + "/");
            this.fURLPath.setText(uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logException((Throwable)malformedURLException);
        }
    }

    protected IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        if (iProjectArray == null || iProjectArray.length == 0) {
            return null;
        }
        IProject[] iProjectArray2 = iProjectArray;
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray2[n2];
            if (iProject.getName().equals(string)) {
                return iProject;
            }
            ++n2;
        }
        return null;
    }

    protected void handleServerSelection() {
        Server server;
        int n = this.serverCombo.getItemCount();
        int n2 = this.serverCombo.getSelectionIndex();
        if (!this.servers.isEmpty() && (server = this.servers.get(this.serverCombo.getSelectionIndex())) != null && server instanceof Server) {
            this.server = this.servers.get(this.serverCombo.getSelectionIndex());
            this.initializeURLControl();
        }
        if (this.server == null && n2 + 1 != n) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.noSelectedServerError"));
        } else {
            this.setErrorMessage(null);
        }
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        this.setErrorMessage(null);
        try {
            this.selectDefaultServer((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
            this.selectDefaultDebugger((ILaunchConfiguration)iLaunchConfigurationWorkingCopy);
        }
        catch (CoreException coreException) {
            Logger.logException((Throwable)coreException);
        }
    }

    public void initializeFrom(ILaunchConfiguration iLaunchConfiguration) {
        this.serverCombo.setEnabled(true);
        this.setErrorMessage(null);
        try {
            String string = iLaunchConfiguration.getAttribute("file_name", "");
            String string2 = iLaunchConfiguration.getAttribute("base_url", "");
            boolean bl = iLaunchConfiguration.getAttribute(AUTO_GENERATED_URL, true);
            this.initializeDebuggerControl(iLaunchConfiguration);
            this.initializeServerControl(iLaunchConfiguration);
            this.fFile.setText(string);
            if (bl) {
                this.autoGeneratedURL.setSelection(true);
                String string3 = this.computeURL(string);
                this.fURLLabel.setEnabled(false);
                this.updateURLComponents(string3);
                this.fURLPath.setEnabled(false);
            } else {
                this.autoGeneratedURL.setSelection(false);
                this.fURLLabel.setEnabled(true);
                this.updateURLComponents(string2);
                this.fURLPath.setEnabled(true);
            }
            if (this.breakOnFirstLine != null) {
                this.breakOnFirstLine.setSelection(iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPDebugPlugin.getStopAtFirstLine()));
            }
        }
        catch (CoreException coreException) {}
        this.initializeExtensionControls(iLaunchConfiguration);
        this.isValid(iLaunchConfiguration);
    }

    protected void initializeExtensionControls(ILaunchConfiguration iLaunchConfiguration) {
    }

    protected String computeURL(String string) {
        if (this.server == null) {
            return "";
        }
        String string2 = this.server.getBaseURL();
        if (string2.equals("")) {
            string2 = "http://localhost";
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        if (!string.equals("")) {
            stringBuffer.append(this.formatFileName(string));
        }
        return stringBuffer.toString();
    }

    private String formatFileName(String string) {
        String string2 = null;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember(string);
        if (iResource == null) {
            return string;
        }
        int n = iResource.getType();
        if (n == 1 || n == 2) {
            string2 = iResource.getProjectRelativePath().toString();
        } else if (iResource.getType() == 4) {
            string2 = "/";
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        return string2;
    }

    protected void initializeURLControl() {
        if (this.fFile == null || this.fURLPath == null || this.fURLHost == null) {
            return;
        }
        String string = this.autoGeneratedURL.getSelection() ? this.fFile.getText() : this.fURLPath.getText();
        this.updateURLComponents(this.computeURL(string));
    }

    protected void initializeServerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute("name", "");
            if (string != null && !string.equals("")) {
                this.server = ServersManager.getServer((String)string);
                if (this.server == null) {
                    this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.invalidServerError"));
                    this.selectDefaultServer(iLaunchConfiguration);
                } else {
                    this.serverCombo.setText(this.server.getName());
                }
            } else {
                this.selectDefaultServer(iLaunchConfiguration);
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.serverCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    protected void initializeDebuggerControl(ILaunchConfiguration iLaunchConfiguration) {
        try {
            String string = iLaunchConfiguration.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, "");
            if (string != null && !string.equals("")) {
                this.fDebuggersCombo.setText(PHPDebuggersRegistry.getDebuggerName((String)string));
            } else {
                this.selectDefaultDebugger(iLaunchConfiguration);
            }
            if (iLaunchConfiguration.getAttribute(READ_ONLY, false)) {
                this.fDebuggersCombo.setEnabled(false);
            }
        }
        catch (Exception exception) {}
    }

    private void selectDefaultServer(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.serverCombo != null && this.serverCombo.getItemCount() > 0) {
            Server server;
            int n;
            String string = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            IProject iProject = null;
            if (string != null) {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string);
            }
            if ((n = this.serverCombo.indexOf((server = ServersManager.getDefaultServer(iProject)).getName())) > -1) {
                this.serverCombo.select(n);
            } else {
                this.serverCombo.select(0);
            }
            this.server = ServersManager.getServer((String)this.serverCombo.getText());
        }
    }

    private void selectDefaultDebugger(ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        if (this.fDebuggersCombo != null && this.fDebuggersCombo.getItemCount() > 0) {
            String string;
            String string2;
            int n;
            String string3 = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.PHP_Project", null);
            IProject iProject = null;
            if (string3 != null) {
                iProject = ResourcesPlugin.getWorkspace().getRoot().getProject(string3);
            }
            if ((n = this.fDebuggersCombo.indexOf(string2 = PHPDebuggersRegistry.getDebuggerName((String)(string = PHPProjectPreferences.getDefaultDebuggerID(iProject))))) > -1) {
                this.fDebuggersCombo.select(n);
            } else {
                this.fDebuggersCombo.select(0);
            }
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, this.getSelectedDebuggerId());
        if (this.server != null) {
            iLaunchConfigurationWorkingCopy.setAttribute("name", this.server.getName());
        } else {
            iLaunchConfigurationWorkingCopy.setAttribute("name", null);
        }
        String string = this.fFile.getText();
        String string2 = this.fURLPath.getText().replace('\\', '/');
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        String string3 = String.valueOf(this.fURLHost.getText()) + string2;
        iLaunchConfigurationWorkingCopy.setAttribute("file_name", string);
        iLaunchConfigurationWorkingCopy.setAttribute("base_url", string3);
        iLaunchConfigurationWorkingCopy.setAttribute(AUTO_GENERATED_URL, this.autoGeneratedURL.getSelection());
        iLaunchConfigurationWorkingCopy.setAttribute("firstLineBreakpoint", this.breakOnFirstLine.getSelection());
        boolean bl = this.autoGeneratedURL.getSelection();
        this.fURLLabel.setEnabled(!bl);
        this.fURLPath.setEnabled(!bl);
        this.applyExtension(iLaunchConfigurationWorkingCopy);
        if (this.saveWorkingCopy) {
            try {
                iLaunchConfigurationWorkingCopy.doSave();
            }
            catch (CoreException coreException) {}
            this.saveWorkingCopy = false;
        }
        this.applyLaunchDelegateConfiguration(iLaunchConfigurationWorkingCopy);
    }

    protected void applyLaunchDelegateConfiguration(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
        String string = null;
        try {
            string = iLaunchConfigurationWorkingCopy.getAttribute(PHPDebugCorePreferenceNames.PHP_DEBUGGER_ID, PHPDebugPlugin.getCurrentDebuggerId());
            AbstractDebuggerConfiguration abstractDebuggerConfiguration = PHPDebuggersRegistry.getDebuggerConfiguration((String)string);
            iLaunchConfigurationWorkingCopy.setAttribute(PHPDebugCorePreferenceNames.CONFIGURATION_DELEGATE_CLASS, abstractDebuggerConfiguration.getWebLaunchDelegateClass());
        }
        catch (Exception exception) {
            Logger.logException((Throwable)exception);
        }
    }

    protected void createBreakControl(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Breakpoint");
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)gridLayout);
        group.setLayoutData((Object)gridData);
        this.breakOnFirstLine = this.createCheckButton((Composite)group, "Break at First Line");
        this.breakOnFirstLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ServerLaunchConfigurationTab.this.setDirty(true);
                ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        String string = this.getLaunchConfigurationDialog().getMode();
        boolean bl = "debug".equals(string);
        this.breakOnFirstLine.setEnabled(bl);
    }

    protected void applyExtension(ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy) {
    }

    public boolean isValid(ILaunchConfiguration iLaunchConfiguration) {
        Object object;
        block6: {
            this.setMessage(null);
            this.setErrorMessage(null);
            try {
                ILaunchConfiguration[] iLaunchConfigurationArray;
                String string = iLaunchConfiguration.getAttribute("name", "");
                if (string.equals("") || (object = ServersManager.getServer((String)string)) != null) break block6;
                this.deleteLaunchConfiguration(iLaunchConfiguration);
                ILaunchConfiguration[] iLaunchConfigurationArray2 = iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
                int n = iLaunchConfigurationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfigurationArray2[n2];
                    iLaunchConfiguration = iLaunchConfiguration2;
                    string = iLaunchConfiguration.getAttribute("name", "");
                    if (!string.equals("") && ServersManager.getServer((String)string) == null) {
                        this.deleteLaunchConfiguration(iLaunchConfiguration);
                    }
                    ++n2;
                }
                return false;
            }
            catch (CoreException coreException) {}
        }
        object = iLaunchConfiguration.getAttribute("file_name", "");
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((String)object);
        if (!(iResource instanceof IFile)) {
            this.setErrorMessage(PHPServerUIMessages.getString("ServerTab.file_project_doesNotExist"));
            return false;
        }
        return this.isValidExtension(iLaunchConfiguration);
    }

    private void deleteLaunchConfiguration(final ILaunchConfiguration iLaunchConfiguration) throws CoreException {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ILaunchConfiguration iLaunchConfiguration2 = iLaunchConfiguration;
                try {
                    if (iLaunchConfiguration2 instanceof ILaunchConfigurationWorkingCopy) {
                        iLaunchConfiguration2 = ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration2).getOriginal();
                    }
                    if (iLaunchConfiguration2 != null) {
                        iLaunchConfiguration2.delete();
                    }
                }
                catch (CoreException coreException) {}
            }
        });
    }

    protected boolean isValidExtension(ILaunchConfiguration iLaunchConfiguration) {
        return true;
    }

    public Image getImage() {
        return null;
    }

    public String getName() {
        return PHPServerUIMessages.getString("ServerTab.server");
    }

    public void addControlAccessibleListener(Control control, String string) {
        String[] stringArray = string.split("&");
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            stringBuffer.append(string2);
            ++n2;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stringBuffer.toString()));
    }

    private String getSelectedDebuggerId() {
        int n = this.fDebuggersCombo.getSelectionIndex();
        String string = "org.eclipse.php.debug.core.zendDebugger";
        if (n > -1 && this.fDebuggerIds.size() > n) {
            string = this.fDebuggerIds.toArray()[n].toString();
        }
        return string;
    }

    protected Server getServerFromWizard() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        Server server = null;
        ServerWizard serverWizard = new ServerWizard();
        ClosableWizardDialog closableWizardDialog = new ClosableWizardDialog(shell, (IWizard)serverWizard);
        if (closableWizardDialog.open() == 1) {
            nullProgressMonitor.setCanceled(true);
            return null;
        }
        server = (Server)serverWizard.getRootFragment().getWizardModel().getObject("server");
        if (server != null) {
            ServersManager.addServer((Server)server);
            ServersManager.save();
        }
        return server;
    }

    private class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String string) {
            this.controlName = string;
        }

        public void getName(AccessibleEvent accessibleEvent) {
            accessibleEvent.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent modifyEvent) {
            ServerLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            ServerLaunchConfigurationTab.this.initializeURLControl();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ServerLaunchConfigurationTab.this.setDirty(true);
            Object object = selectionEvent.getSource();
            if (object == ServerLaunchConfigurationTab.this.fileButton) {
                ServerLaunchConfigurationTab.this.handleFileButtonSelected();
            } else if (object == ServerLaunchConfigurationTab.this.createNewServer) {
                ServerLaunchConfigurationTab.this.handleServerButtonSelected();
            } else if (object == ServerLaunchConfigurationTab.this.configureServers) {
                ServerLaunchConfigurationTab.this.handleConfigureButtonSelected();
            }
        }
    }
}

