/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.dom.Utils;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.CodeDataFilter;
import org.eclipse.php.internal.core.phpModel.parser.IPhpModel;
import org.eclipse.php.internal.core.phpModel.parser.ModelSupport;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeContext;
import org.eclipse.php.internal.core.phpModel.parser.PHPCodeDataFactory;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileDataUtilities;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPVariableData;
import org.eclipse.php.internal.core.util.Visitor;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.contentassist.CodeDataCompletionProposal;
import org.eclipse.php.internal.ui.editor.contentassist.CompletionProposalGroup;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionRendererVisitor;
import org.eclipse.php.internal.ui.editor.contentassist.PHPProposalComperator;
import org.eclipse.php.internal.ui.editor.templates.PHPTemplateCompletionProcessor;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.ui.editor.contentassist.IContentAssistSupport;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;

public class ContentAssistSupport
implements IContentAssistSupport {
    protected static final char[] phpDelimiters = new char[]{'?', ':', ';', '|', '^', '&', '<', '>', '+', '-', '.', '*', '/', '%', '!', '~', '[', ']', '(', ')', '{', '}', '@', '\n', '\t', ' ', ',', '$', '\'', '\"'};
    protected static final String CLASS_FUNCTIONS_TRIGGER = "::";
    protected static final String OBJECT_FUNCTIONS_TRIGGER = "->";
    private static final Pattern extendsPattern = Pattern.compile("\\Wextends\\W", 2);
    private static final Pattern implementsPattern = Pattern.compile("\\Wimplements", 2);
    private static final Pattern catchPattern = Pattern.compile("catch\\s[^{]*", 2);
    private static final Pattern globalPattern = Pattern.compile("\\$GLOBALS[\\s]*\\[[\\s]*[\\'\\\"][\\w]+[\\'\\\"][\\s]*\\]");
    public static final ICompletionProposal[] EMPTY_CompletionProposal_ARRAY = new ICompletionProposal[0];
    public static final CodeDataCompletionProposal[] EMPTY_CodeDataCompletionProposal_ARRAY = new CodeDataCompletionProposal[0];
    private static final PHPProposalComperator proposalsComperator = new PHPProposalComperator();
    private static String[] CLASS_KEYWORDS = new String[]{"abstract", "const", "function", "private", "protected", "public", "static", "var"};
    protected boolean showVariablesFromOtherFiles;
    protected boolean groupCompletionOptions;
    protected boolean cutCommonPrefix;
    public boolean determineObjectTypeFromOtherFile;
    protected boolean disableConstants;
    protected boolean showClassNamesInGlobalList;
    protected boolean showNonStrictOptions;
    protected boolean constantCaseSensitive;
    protected boolean autoShowVariables;
    protected boolean autoShowFunctionsKeywordsConstants;
    protected boolean autoShowClassNames;
    protected char[] autoActivationTriggers;
    private PHPTemplateCompletionProcessor templateCompletionProcessor;
    protected IPropertyChangeListener prefChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent != null) {
                ContentAssistSupport.this.initPreferences(propertyChangeEvent.getProperty());
            }
        }
    };
    protected CompletionProposalGroup completionProposalGroup;
    protected ICompletionProposal[] templateProposals;
    protected CompletionProposalGroup phpCompletionProposalGroup = new PHPCompletionProposalGroup();
    protected CompletionProposalGroup regularPHPCompletionProposalGroup = new RegularPHPCompletionProposalGroup();
    protected CompletionProposalGroup classConstructorCompletionProposalGroup = new ClassConstructorCompletionProposalGroup();
    protected CompletionProposalGroup newStatementCompletionProposalGroup = new NewStatementCompletionProposalGroup();
    protected CompletionProposalGroup arrayCompletionProposalGroup = new ArrayCompletionProposalGroup();
    protected CompletionProposalGroup classStaticCallCompletionProposalGroup = new ClassStaticCallCompletionProposalGroup();
    protected CompletionProposalGroup classVariableCallCompletionProposalGroup = new ClassVariableCallCompletionProposalGroup();
    private static final PHPTagData[] phpTagDataArray = new PHPTagData[]{new PHPTagData()};
    protected CodeData[] extendedImplementCodeData;
    protected static CodeData[] implementCodeData;
    private static CodeData[] extendsCodeData;

    protected void initPreferences(String string) {
        if (string == null || "contentAssistShowVariablesFromOtherFiles".equals(string) || "contentAssistShowConstantsAssist".equals(string) || "contentAssistShowNonStrictOptions".equals(string) || "contentAssistShowClassNamesInGlobalCompletion".equals(string) || "contentAssistConstantsCaseSensitive".equals(string) || "contentAssistDetermineObjTypeFromOtherFiles".equals(string) || "contentAssistAutoactivationForClassNames".equals(string) || "contentAssistAutoactivationForFunctionsKeyWordsConstants".equals(string) || "contentAssistAutoactivationForVariables".equals(string) || "contentAssistCutPrefix".equals(string) || "contentAssistGroupOptions".equals(string) || "contentAssistAutoactivationTriggersPHP".equals(string)) {
            this.showVariablesFromOtherFiles = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowVariablesFromOtherFiles");
            this.groupCompletionOptions = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistGroupOptions");
            this.cutCommonPrefix = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistCutPrefix");
            this.disableConstants = !PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowConstantsAssist");
            this.showClassNamesInGlobalList = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowClassNamesInGlobalCompletion");
            this.showNonStrictOptions = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistShowNonStrictOptions");
            this.constantCaseSensitive = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistConstantsCaseSensitive");
            this.determineObjectTypeFromOtherFile = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistDetermineObjTypeFromOtherFiles");
            this.autoShowClassNames = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForClassNames");
            this.autoShowFunctionsKeywordsConstants = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForFunctionsKeyWordsConstants");
            this.autoShowVariables = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistAutoactivationForVariables");
            this.autoActivationTriggers = PreferenceConstants.getPreferenceStore().getString("contentAssistAutoactivationTriggersPHP").trim().toCharArray();
        }
    }

    public ContentAssistSupport() {
        this.initPreferences(null);
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this.prefChangeListener, (Object)PreferenceConstants.getPreferenceStore()));
    }

    public ICompletionProposal[] getCompletionOption(ITextViewer iTextViewer, DOMModelForPHP dOMModelForPHP, int n, boolean bl) throws BadLocationException {
        ICompletionProposal[] iCompletionProposalArray = this.getCodeCompletionOptions(iTextViewer, dOMModelForPHP, n, bl);
        if (iCompletionProposalArray == null) {
            return new ICompletionProposal[0];
        }
        return iCompletionProposalArray;
    }

    private ICompletionProposal[] getCodeCompletionOptions(ITextViewer iTextViewer, DOMModelForPHP dOMModelForPHP, int n, boolean bl) throws BadLocationException {
        this.completionProposalGroup = null;
        this.templateProposals = null;
        this.calcCompletionOption(dOMModelForPHP, n, iTextViewer, bl);
        if (this.completionProposalGroup == null) {
            return this.templateProposals;
        }
        this.completionProposalGroup.setGroupOptions(this.groupCompletionOptions);
        this.completionProposalGroup.setCutCommonPrefix(this.cutCommonPrefix);
        return this.merg(this.completionProposalGroup.getCompletionProposals(this.getProjectModel(dOMModelForPHP)), this.templateProposals);
    }

    protected ICompletionProposal[] getTemplates(ITextViewer iTextViewer, int n) {
        PHPTemplateCompletionProcessor pHPTemplateCompletionProcessor = this.getTemplateCompletionProcessor();
        ICompletionProposal[] iCompletionProposalArray = pHPTemplateCompletionProcessor.computeCompletionProposals(iTextViewer, n);
        return iCompletionProposalArray;
    }

    private PHPTemplateCompletionProcessor getTemplateCompletionProcessor() {
        if (this.templateCompletionProcessor == null) {
            this.templateCompletionProcessor = new PHPTemplateCompletionProcessor();
            String string = this.getTemplateContext();
            this.templateCompletionProcessor.setContextTypeId(string);
        }
        return this.templateCompletionProcessor;
    }

    protected String getTemplateContext() {
        return "php";
    }

    public char[] getAutoactivationTriggers() {
        return this.autoActivationTriggers;
    }

    protected void calcCompletionOption(DOMModelForPHP dOMModelForPHP, int n, ITextViewer iTextViewer, boolean bl) throws BadLocationException {
        boolean bl2;
        Object object;
        Object object2;
        ITextRegion iTextRegion;
        int n2;
        int n3 = iTextViewer.getSelectedRange().x;
        boolean bl3 = n3 != n;
        PHPProjectModel pHPProjectModel = this.getProjectModel(dOMModelForPHP);
        String string = null;
        PHPFileData pHPFileData = dOMModelForPHP.getFileData(true);
        if (pHPFileData == null) {
            return;
        }
        string = pHPFileData.getName();
        int n4 = ((TextSelection)iTextViewer.getSelectionProvider().getSelection()).getLength();
        IStructuredDocumentRegion iStructuredDocumentRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)iTextViewer, (int)n);
        ITextRegion iTextRegion2 = null;
        iTextRegion2 = n == dOMModelForPHP.getStructuredDocument().getLength() ? iStructuredDocumentRegion.getLastRegion() : iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion2 == null) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion2 = iStructuredDocumentRegion;
        if (iTextRegion2 instanceof ITextRegionContainer) {
            iStructuredDocumentRegion2 = (ITextRegionContainer)iTextRegion2;
            iTextRegion2 = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n);
        }
        if (iTextRegion2.getType() == "PHP_OPEN") {
            return;
        }
        if (iTextRegion2.getType() == "PHP_CLOSE") {
            if (iStructuredDocumentRegion2.getStartOffset(iTextRegion2) == n) {
                ITextRegion iTextRegion3 = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n - 1);
                if (iTextRegion3 instanceof IPhpScriptRegion) {
                    iTextRegion2 = iTextRegion3;
                }
            } else {
                return;
            }
        }
        if ((n2 = iStructuredDocumentRegion2.getStartOffset(iTextRegion2)) == n) {
            iTextRegion = iStructuredDocumentRegion2.getRegionAtCharacterOffset(n - 1);
            object2 = null;
            if (iTextRegion != null || (object2 = iStructuredDocumentRegion.getPrevious()) != null && (iTextRegion = object2.getRegionAtCharacterOffset(n - 1)) != null) {
                iTextRegion.getType();
            }
            n2 = iStructuredDocumentRegion.getStartOffset(iTextRegion2);
        }
        iTextRegion = null;
        object2 = null;
        int n5 = 0;
        ContextRegion contextRegion = null;
        if (iTextRegion2 instanceof IPhpScriptRegion) {
            iTextRegion = (IPhpScriptRegion)iTextRegion2;
            n5 = n - iStructuredDocumentRegion2.getStartOffset() - iTextRegion.getStart();
            object2 = iTextRegion.getPartition(n5);
            if (!(object2 != "org.eclipse.php.PHP_MULTI_LINE_COMMENT" && object2 != "org.eclipse.php.PHP_DOC" || (object = iTextRegion.getPhpToken(n5).getType()) != "PHP_COMMENT_START" && object != "PHPDOC_COMMENT_START" || iTextRegion.getPhpToken(n5).getStart() != n5)) {
                object2 = iTextRegion.getPartition(n5 - 1);
            }
            if (object2 != "org.eclipse.php.PHP_DEFAULT" && object2 != "org.eclipse.php.PHP_QUOTED_STRING" && object2 != "org.eclipse.php.PHP_SINGLE_LINE_COMMENT") {
                return;
            }
            contextRegion = (ContextRegion)iTextRegion.getPhpToken(n5);
        }
        object = iStructuredDocumentRegion.getParentDocument();
        if (pHPFileData == null || iTextRegion == null) {
            this.getRegularCompletion(iTextViewer, pHPProjectModel, "", "", n, n4, bl, (ITextRegionCollection)iStructuredDocumentRegion2, iTextRegion, contextRegion, (IStructuredDocument)object, bl3);
            return;
        }
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement((int)n, (IStructuredDocumentRegion)iStructuredDocumentRegion, (boolean)true);
        String string2 = contextRegion.getType();
        if (this.isInArrayOptionQuotes(pHPProjectModel, string, string2, n, n4, textSequence)) {
            return;
        }
        if (this.isPHPSingleQuote((ITextRegionCollection)iStructuredDocumentRegion2, (IPhpScriptRegion)iTextRegion, contextRegion, (IStructuredDocument)object, n) || this.isLineComment((ITextRegionCollection)iStructuredDocumentRegion2, (IPhpScriptRegion)iTextRegion, n)) {
            return;
        }
        if (this.isInFunctionDeclaration(pHPProjectModel, string, textSequence, n, n4, bl)) {
            return;
        }
        if (this.isInCatchStatement(pHPProjectModel, pHPFileData, textSequence, n, n4, bl)) {
            return;
        }
        int n6 = textSequence.length();
        int n7 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n6);
        int n8 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n7, (boolean)true);
        String string3 = textSequence.subSequence(n8, n7).toString();
        boolean bl4 = bl2 = n6 != n7;
        if (bl2 && this.isNewOrInstanceofStatement(pHPProjectModel, pHPFileData, string3, "", n, n4, bl, string2)) {
            return;
        }
        int n9 = object.getLineOfOffset(n);
        if (this.isClassFunctionCompletion(pHPProjectModel, string, textSequence, n, n9, n4, string3, n8, bl2, bl, bl3)) {
            return;
        }
        n7 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n8);
        n8 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n7, (boolean)true);
        String string4 = textSequence.subSequence(n8, n7).toString();
        if (!bl2 && this.isNewOrInstanceofStatement(pHPProjectModel, pHPFileData, string4, string3, n, n4, bl, string2)) {
            if (string3.startsWith("$")) {
                if (bl2) {
                    this.getRegularCompletion(iTextViewer, pHPProjectModel, string, "", n, n4, bl, (ITextRegionCollection)iStructuredDocumentRegion2, iTextRegion, contextRegion, (IStructuredDocument)object, bl3);
                } else {
                    this.getRegularCompletion(iTextViewer, pHPProjectModel, string, string3, n, n4, bl, (ITextRegionCollection)iStructuredDocumentRegion2, iTextRegion, contextRegion, (IStructuredDocument)object, bl3);
                }
            }
            return;
        }
        if (bl2 && ContentAssistSupport.isFunctionCall(pHPProjectModel, string3)) {
            return;
        }
        if (this.isInArrayOption(pHPProjectModel, string, bl2, string4, string3, n8, n, n4, textSequence, string2)) {
            return;
        }
        if (this.isInClassDeclaration(pHPProjectModel, textSequence, n, n4, bl)) {
            return;
        }
        if (bl2) {
            this.getRegularCompletion(iTextViewer, pHPProjectModel, string, "", n, n4, bl, (ITextRegionCollection)iStructuredDocumentRegion2, iTextRegion, contextRegion, (IStructuredDocument)object, bl3);
        } else {
            this.getRegularCompletion(iTextViewer, pHPProjectModel, string, string3, n, n4, bl, (ITextRegionCollection)iStructuredDocumentRegion2, iTextRegion, contextRegion, (IStructuredDocument)object, bl3);
        }
    }

    private PHPProjectModel getProjectModel(DOMModelForPHP dOMModelForPHP) {
        PHPProjectModel pHPProjectModel = dOMModelForPHP.getProjectModel();
        if (pHPProjectModel == null) {
            pHPProjectModel = PHPWorkspaceModelManager.getDefaultPHPProjectModel();
        }
        return pHPProjectModel;
    }

    protected static boolean isFunctionCall(PHPProjectModel pHPProjectModel, String string) {
        CodeData[] codeDataArray = pHPProjectModel.getFunction(string);
        return codeDataArray != null && codeDataArray.length > 0;
    }

    protected boolean isLineComment(ITextRegionCollection iTextRegionCollection, IPhpScriptRegion iPhpScriptRegion, int n) {
        int n2 = n - iTextRegionCollection.getStartOffset((ITextRegion)iPhpScriptRegion);
        try {
            return iPhpScriptRegion.isLineComment(n2);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
    }

    protected boolean isPHPSingleQuote(ITextRegionCollection iTextRegionCollection, IPhpScriptRegion iPhpScriptRegion, ContextRegion contextRegion, IStructuredDocument iStructuredDocument, int n) {
        if (PHPPartitionTypes.isPHPQuotesState((String)contextRegion.getType())) {
            char c;
            int n2;
            int n3;
            try {
                n3 = contextRegion.getStart() + iTextRegionCollection.getStartOffset((ITextRegion)iPhpScriptRegion);
                n2 = n3 + contextRegion.getTextLength();
                c = iStructuredDocument.get(n3, contextRegion.getTextLength()).charAt(0);
            }
            catch (BadLocationException badLocationException) {
                Logger.logException(badLocationException);
                return false;
            }
            return c == '\'' && n <= n2 - 1 && n3 < n;
        }
        return false;
    }

    protected boolean isInArrayOptionQuotes(PHPProjectModel pHPProjectModel, String string, String string2, int n, int n2, TextSequence textSequence) {
        if (!PHPPartitionTypes.isPHPQuotesState((String)string2)) {
            return false;
        }
        int n3 = textSequence.length();
        int n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n3);
        int n5 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n4, (boolean)false);
        if (n4 != n3 && n5 != n4) {
            return false;
        }
        String string3 = textSequence.subSequence(n5, n4).toString();
        n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n5);
        if (n4 == 0) {
            return false;
        }
        char c = textSequence.charAt(n4 - 1);
        if (c != '\"' && c != '\'') {
            return false;
        }
        --n4;
        if ((n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n4)) == 0 || textSequence.charAt(n4 - 1) != '[') {
            return false;
        }
        --n4;
        n5 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)(n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n4)), (boolean)true);
        String string4 = textSequence.subSequence(n5, n4).toString();
        if (string4.startsWith("$")) {
            string4 = string4.substring(1);
        }
        CodeData[] codeDataArray = pHPProjectModel.getArrayVariables(string, string4, string3, this.determineObjectTypeFromOtherFile);
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string3, n2);
        return true;
    }

    protected void getRegularCompletion(ITextViewer iTextViewer, PHPProjectModel pHPProjectModel, String string, String string2, int n, int n2, boolean bl, ITextRegionCollection iTextRegionCollection, ITextRegion iTextRegion, ContextRegion contextRegion, IStructuredDocument iStructuredDocument, boolean bl2) {
        CodeData[] codeDataArray;
        if (!bl && string2.length() == 0) {
            return;
        }
        boolean bl3 = false;
        PHPCodeData pHPCodeData = Utils.getCodeData((PHPFileData)pHPProjectModel.getFileData(string), (int)n);
        if (pHPCodeData.getUserData().getStopPosition() > n) {
            pHPCodeData = pHPCodeData.getContainer();
        }
        if (pHPCodeData instanceof PHPClassData) {
            bl3 = true;
        }
        if (contextRegion != null) {
            codeDataArray = contextRegion.getType();
            if (string2.startsWith("$") && !bl3) {
                IStructuredDocument iStructuredDocument2;
                if (!bl && !this.autoShowVariables) {
                    return;
                }
                try {
                    if (!bl && string2.equals("$") && iStructuredDocument.getLength() != n && Character.isLetter(iStructuredDocument.getChar(n))) {
                        return;
                    }
                }
                catch (BadLocationException badLocationException) {}
                if (PHPPartitionTypes.isPHPQuotesState((String)codeDataArray)) {
                    iStructuredDocument2 = iStructuredDocument;
                    try {
                        char c = iStructuredDocument2.get(n - 2, 1).charAt(0);
                        if (c == '\\') {
                            return;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException(badLocationException);
                    }
                }
                iStructuredDocument2 = this.getContext(pHPProjectModel, string, n - string2.length());
                string2 = string2.substring(1);
                CodeData[] codeDataArray2 = pHPProjectModel.getVariables(string, (PHPCodeContext)iStructuredDocument2, string2, this.showVariablesFromOtherFiles);
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                this.completionProposalGroup.setData(n, codeDataArray2, string2, n2, bl2);
                return;
            }
            if (PHPPartitionTypes.isPHPQuotesState((String)codeDataArray) || codeDataArray.equals("PHP_HEREDOC_TAG") && iTextRegionCollection.getStartOffset(iTextRegion) + iTextRegion.getLength() <= n) {
                this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
                this.completionProposalGroup.setData(n, new CodeData[0], string2, n2, bl2);
                return;
            }
        }
        codeDataArray = null;
        CodeData[] codeDataArray3 = null;
        CodeData[] codeDataArray4 = null;
        if ((bl || this.autoShowFunctionsKeywordsConstants) && !bl3) {
            codeDataArray = string2.length() == 0 ? pHPProjectModel.getFunctions() : pHPProjectModel.getFunctions(string2);
            if (!this.disableConstants) {
                codeDataArray3 = string2.length() == 0 ? pHPProjectModel.getConstants() : pHPProjectModel.getConstants(string2, this.constantCaseSensitive);
            }
        }
        codeDataArray4 = pHPProjectModel.getKeywordData();
        if (bl3) {
            codeDataArray4 = this.filterClassKeywords(codeDataArray4);
        }
        CodeData[] codeDataArray5 = null;
        if (!bl3 && this.showClassNamesInGlobalList && (bl || this.autoShowClassNames)) {
            codeDataArray5 = pHPProjectModel.getClasses();
        }
        Object[] objectArray = null;
        if (this.shouldAddPHPTag(iStructuredDocument, n, string2)) {
            objectArray = phpTagDataArray;
        }
        objectArray = ModelSupport.merge((CodeData[])codeDataArray4, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray5, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray3, (CodeData[])objectArray);
        objectArray = ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])objectArray);
        this.completionProposalGroup = this.regularPHPCompletionProposalGroup;
        this.completionProposalGroup.setData(n, (CodeData[])objectArray, string2, n2, bl2);
        this.templateProposals = this.getTemplates(iTextViewer, n);
    }

    private CodeData[] filterClassKeywords(CodeData[] codeDataArray) {
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>();
        int n = 0;
        int n2 = 0;
        while (n < codeDataArray.length && n2 < CLASS_KEYWORDS.length) {
            int n3 = codeDataArray[n].getName().compareTo(CLASS_KEYWORDS[n2]);
            if (n3 < 0) {
                ++n;
                continue;
            }
            if (n3 > 0) {
                ++n2;
                continue;
            }
            arrayList.add(codeDataArray[n]);
            ++n;
            ++n2;
        }
        return arrayList.toArray(new CodeData[arrayList.size()]);
    }

    private boolean shouldAddPHPTag(IStructuredDocument iStructuredDocument, int n, String string) {
        n -= string.length() + 2;
        try {
            String string2 = iStructuredDocument.get(n, 2);
            if (string2.equals("<?")) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean isClassFunctionCompletion(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, int n3, String string2, int n4, boolean bl, boolean bl2, boolean bl3) {
        String string3;
        if ((n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n4)) <= 2) {
            return false;
        }
        boolean bl4 = false;
        boolean bl5 = false;
        String string4 = textSequence.subSequence(n4 - 2, n4).toString();
        if (!string4.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string4.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl4 = true;
                if (n4 >= 8 && (string3 = textSequence.subSequence(n4 - 8, n4 - 2).toString()).equals("parent")) {
                    bl5 = true;
                }
            } else {
                return false;
            }
        }
        if ((string3 = this.getClassName(pHPProjectModel, string, textSequence, n4, n, n2)) == null) {
            string3 = "";
        }
        if (bl && string2.length() > 0) {
            return this.isClassFunctionCall(pHPProjectModel, string, string3, string2);
        }
        if (bl4) {
            if (bl5) {
                if (string3 != "") {
                    this.showClassStaticCall(pHPProjectModel, string, n, string3, string2, n3, bl2);
                }
            } else {
                this.showClassStaticCall(pHPProjectModel, string, n, string3, string2, n3, bl2);
            }
        } else {
            String string5 = textSequence.toString().substring(0, textSequence.toString().lastIndexOf(OBJECT_FUNCTIONS_TRIGGER)).trim();
            boolean bl6 = !string5.equals("$this");
            boolean bl7 = false;
            this.showClassCall(pHPProjectModel, string, n, string3, string2, n3, bl6, bl7, bl2, bl3);
        }
        return true;
    }

    protected String getClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, int n3) {
        int n4;
        int n5;
        n = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n);
        boolean bl = false;
        String string2 = textSequence.subSequence(n - 2, n).toString();
        if (!string2.equals(OBJECT_FUNCTIONS_TRIGGER)) {
            if (string2.equals(CLASS_FUNCTIONS_TRIGGER)) {
                bl = true;
            } else {
                return null;
            }
        }
        if ((n5 = PHPTextSequenceUtilities.getPrivousTriggerIndex((TextSequence)textSequence, (int)(n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)(n - 2))))) == -1) {
            return this.innerGetClassName(pHPProjectModel, string, textSequence, n4, bl, n2, n3);
        }
        int n6 = PHPTextSequenceUtilities.readForwardSpaces((TextSequence)textSequence, (int)(n5 + 2));
        String string3 = textSequence.subSequence(n6, n4).toString();
        String string4 = this.getClassName(pHPProjectModel, string, textSequence, n6, n2, n3);
        int n7 = string3.indexOf(40);
        if (n7 == -1) {
            return PHPModelUtil.getVarType((PHPProjectModel)pHPProjectModel, (String)string, (String)string4, (String)string3, (int)n2, (int)n3, (boolean)this.determineObjectTypeFromOtherFile);
        }
        String string5 = string3.substring(0, n7).trim();
        return PHPModelUtil.getFunctionReturnType((PHPProjectModel)pHPProjectModel, (String)string, (String)string4, (String)string5);
    }

    protected String getFunctionReturnType(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        return PHPModelUtil.getFunctionReturnType((PHPProjectModel)pHPProjectModel, (String)string, (String)string2, (String)string3);
    }

    protected String innerGetClassName(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, boolean bl, int n2, int n3) {
        String string2;
        String string3;
        Matcher matcher;
        int n4 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n, (boolean)true);
        String string4 = textSequence.subSequence(n4, n).toString();
        if (bl) {
            PHPClassData pHPClassData;
            if (string4.equals("self")) {
                PHPClassData pHPClassData2 = this.getContainerClassData(pHPProjectModel, string, n2 - 6);
                if (pHPClassData2 != null) {
                    return pHPClassData2.getName();
                }
            } else if (string4.equals("parent") && (pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2 - 8)) != null) {
                return pHPProjectModel.getSuperClassName(string, pHPClassData.getName());
            }
            return string4;
        }
        if (string4.length() == 0 && (matcher = globalPattern.matcher(string3 = textSequence.subSequence(0, n).toString().trim())).matches()) {
            string2 = string3.substring(string3.indexOf(91) + 1, string3.indexOf(93)).trim();
            string4 = "$" + string2.substring(1, string2.length() - 1);
        }
        if (string4.length() > 0 && string4.charAt(0) == '$') {
            int n5 = n2 - textSequence.length();
            return PHPFileDataUtilities.getVariableType((String)string, (String)string4, (int)n5, (int)n3, (IPhpModel)pHPProjectModel.getPHPUserModel(), (boolean)this.determineObjectTypeFromOtherFile);
        }
        if (textSequence.charAt(n - 1) == ')') {
            PHPFunctionData[] pHPFunctionDataArray;
            int n6 = this.getFunctionNameEndOffset(textSequence, n - 1);
            int n7 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n6, (boolean)false);
            string2 = textSequence.subSequence(n7, n6).toString();
            PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, n2);
            if (pHPClassData != null) {
                return PHPModelUtil.getFunctionReturnType((PHPProjectModel)pHPProjectModel, (String)string, (String)pHPClassData.getName(), (String)string2);
            }
            PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
            PHPFunctionData[] pHPFunctionDataArray2 = pHPFunctionDataArray = pHPFileData.getFunctions();
            int n8 = pHPFunctionDataArray.length;
            int n9 = 0;
            while (n9 < n8) {
                PHPFunctionData pHPFunctionData = pHPFunctionDataArray2[n9];
                if (pHPFunctionData.getName().equals(string2)) {
                    return pHPFunctionData.getReturnType();
                }
                ++n9;
            }
        }
        return null;
    }

    protected boolean isClassFunctionCall(PHPProjectModel pHPProjectModel, String string, String string2, String string3) {
        CodeData codeData = pHPProjectModel.getClassFunctionData(string, string2, string3);
        return codeData != null;
    }

    protected void showClassCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CodeData[] codeDataArray;
        String[] stringArray;
        CodeData[] codeDataArray2 = null;
        CodeData[] codeDataArray3 = null;
        String[] stringArray2 = stringArray = string2.split("\\|");
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            CodeData[] codeDataArray4;
            codeDataArray = stringArray2[n4];
            codeDataArray = codeDataArray.trim();
            if (bl3 || this.autoShowFunctionsKeywordsConstants) {
                codeDataArray4 = pHPProjectModel.getClassFunctions(string, (String)codeDataArray, string3.length() == 0 ? "" : string3);
                codeDataArray2 = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])codeDataArray4);
            }
            if (bl3 || this.autoShowVariables) {
                codeDataArray4 = ModelSupport.getFilteredCodeData((CodeData[])pHPProjectModel.getClassVariables(string, (String)codeDataArray, ""), (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
                codeDataArray3 = ModelSupport.merge((CodeData[])codeDataArray3, (CodeData[])codeDataArray4);
            }
            ++n4;
        }
        codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])codeDataArray3), (CodeDataFilter)this.getAccessLevelFilter(pHPProjectModel, string, string2, n, bl));
        this.completionProposalGroup = bl2 ? this.classVariableCallCompletionProposalGroup : this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string3, n2, bl4);
    }

    protected void showClassStaticCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, int n2, boolean bl) {
        Object object;
        CodeData[] codeDataArray = null;
        if (bl || this.autoShowFunctionsKeywordsConstants) {
            codeDataArray = pHPProjectModel.getClassFunctions(string, string2, "");
            object = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
            boolean bl2 = ((String)object).equals("php5");
            if (bl2 && !this.showNonStrictOptions) {
                codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)ModelSupport.STATIC_FUNCTIONS_FILTER);
            }
        }
        object = null;
        if (bl || this.autoShowVariables) {
            object = ModelSupport.merge((CodeData[])pHPProjectModel.getClassVariables(string, string2, ""), (CodeData[])pHPProjectModel.getClassConsts(string, string2, ""));
        }
        CodeData[] codeDataArray2 = ModelSupport.getFilteredCodeData((CodeData[])ModelSupport.merge((CodeData[])codeDataArray, (CodeData[])object), (CodeDataFilter)this.getAccessLevelFilter(pHPProjectModel, string, string2, n, false));
        this.completionProposalGroup = this.classStaticCallCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray2, string3, n2);
    }

    protected void showParentCall(PHPProjectModel pHPProjectModel, String string, int n, String string2, String string3, int n2, boolean bl, boolean bl2) {
        CodeData[] codeDataArray = null;
        if (bl || this.autoShowFunctionsKeywordsConstants) {
            codeDataArray = pHPProjectModel.getClassFunctions(string, string2, string3.length() == 0 ? "" : string3);
        }
        pHPProjectModel.getClass(string, string2);
        codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string3, n2, bl2);
    }

    protected PHPClassData getContainerClassData(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return PHPFileDataUtilities.getContainerClassData((PHPFileData)pHPFileData, (int)n);
    }

    protected int getFunctionNameEndOffset(TextSequence textSequence, int n) {
        if (textSequence.charAt(n) != ')') {
            return 0;
        }
        int n2 = n;
        int n3 = 1;
        char c = '\u0000';
        while (n3 != 0 && n2 >= 0) {
            char c2;
            if ((c2 = textSequence.charAt(--n2)) == '\'' || c2 == '\"') {
                char c3 = c == '\u0000' ? c2 : (c = c == c2 ? (char)'\u0000' : c);
            }
            if (c != '\u0000') continue;
            if (c2 == ')') {
                ++n3;
                continue;
            }
            if (c2 != '(') continue;
            --n3;
        }
        return n2;
    }

    protected CodeDataFilter getAccessLevelFilter(PHPProjectModel pHPProjectModel, String string, String string2, int n, boolean bl) {
        PHPCodeContext pHPCodeContext = this.getContext(pHPProjectModel, string, n);
        String string3 = pHPCodeContext.getContainerClassName();
        if (string3.equals(string2)) {
            return ModelSupport.PIRVATE_ACCESS_LEVEL_FILTER;
        }
        if (bl) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
        }
        if (string3.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        PHPClassData pHPClassData = pHPProjectModel.getClass(string, string3);
        String string4 = pHPClassData.getSuperClassData().getName();
        while (string4 != null) {
            if (string4.equals(string2)) {
                return ModelSupport.PROTECTED_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
            }
            pHPClassData = pHPProjectModel.getClass(string, string4);
            if (pHPClassData == null) break;
            string4 = pHPClassData.getSuperClassData().getName();
        }
        if (string4 == null && !string3.equals("")) {
            return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER_EXCLUDE_VARS_NOT_STATIC;
        }
        return ModelSupport.PUBLIC_ACCESS_LEVEL_FILTER;
    }

    protected PHPCodeContext getContext(PHPProjectModel pHPProjectModel, String string, int n) {
        PHPFileData pHPFileData = pHPProjectModel.getFileData(string);
        return ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
    }

    protected boolean isInFunctionDeclaration(PHPProjectModel pHPProjectModel, String string, TextSequence textSequence, int n, int n2, boolean bl) {
        String string2;
        int n3 = PHPTextSequenceUtilities.isInFunctionDeclaration((TextSequence)textSequence);
        if (n3 == -1) {
            return false;
        }
        int n4 = textSequence.length() - 1;
        while (n4 >= n3) {
            if (textSequence.charAt(n4) == '(') {
                boolean bl2 = true;
                int n5 = textSequence.length() - 1;
                while (n5 > n4) {
                    if (textSequence.charAt(n5) == '$') {
                        bl2 = false;
                        break;
                    }
                    if (textSequence.charAt(n5) == ',') break;
                    --n5;
                }
                if (bl2) {
                    CodeData[] codeDataArray = pHPProjectModel.getClasses();
                    this.completionProposalGroup = this.phpCompletionProposalGroup;
                    String string3 = textSequence.subTextSequence(n4 + 1, textSequence.length()).toString();
                    this.completionProposalGroup.setData(n, codeDataArray, string3, n2, false);
                }
                return true;
            }
            --n4;
        }
        PHPClassData pHPClassData = this.getContainerClassData(pHPProjectModel, string, textSequence.getOriginalOffset(n3));
        if (pHPClassData == null) {
            return true;
        }
        int n6 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)textSequence.length());
        int n7 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n6, (boolean)false);
        String string4 = textSequence.subSequence(n7, n6).toString();
        if (string4.equals("function")) {
            string2 = "";
        } else if (n6 == textSequence.length()) {
            string2 = string4;
        } else {
            return true;
        }
        String string5 = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl3 = string5.equals("php5");
        CodeData[] codeDataArray = PHPCodeDataFactory.createMagicMethods((PHPClassData)pHPClassData, (boolean)bl3);
        CodeData[] codeDataArray2 = PHPCodeDataFactory.createConstructors((PHPClassData)pHPClassData, (boolean)bl3);
        Object[] objectArray = new CodeData[codeDataArray.length + codeDataArray2.length];
        System.arraycopy(codeDataArray, 0, objectArray, 0, codeDataArray.length);
        System.arraycopy(codeDataArray2, 0, objectArray, codeDataArray.length, codeDataArray2.length);
        Arrays.sort(objectArray);
        this.completionProposalGroup = this.classConstructorCompletionProposalGroup;
        this.completionProposalGroup.setData(n, (CodeData[])objectArray, string2, n2);
        return true;
    }

    protected boolean isInClassDeclaration(PHPProjectModel pHPProjectModel, TextSequence textSequence, int n, int n2, boolean bl) {
        int n3 = PHPTextSequenceUtilities.isInClassDeclaration((TextSequence)textSequence);
        if (n3 == -1) {
            return false;
        }
        boolean bl2 = true;
        if (n3 >= 6) {
            String string = textSequence.subSequence(n3 - 6, n3 - 1).toString();
            bl2 = string.equals("class");
        }
        textSequence = textSequence.subTextSequence(n3, textSequence.length());
        int n4 = 0;
        while (n4 < textSequence.length()) {
            if (!Character.isLetterOrDigit(textSequence.charAt(n4))) break;
            ++n4;
        }
        if (n4 == textSequence.length()) {
            return true;
        }
        textSequence = textSequence.subTextSequence(n4, textSequence.length());
        int n5 = textSequence.length();
        int n6 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n5, (boolean)false);
        String string = textSequence.subSequence(n6, n5).toString();
        Matcher matcher = extendsPattern.matcher((CharSequence)textSequence);
        Matcher matcher2 = implementsPattern.matcher((CharSequence)textSequence);
        boolean bl3 = matcher.find();
        boolean bl4 = matcher2.find();
        if (!bl3 && !bl4) {
            if (bl || string.length() > 0) {
                if (bl2) {
                    this.showExtendsImplementsList(pHPProjectModel, string, n, n2, bl);
                } else {
                    this.showExtendsList(pHPProjectModel, string, n, n2, bl);
                }
            }
            return true;
        }
        n5 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n6);
        String string2 = textSequence.subSequence(n6 = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)n5, (boolean)true), n5).toString();
        if (string2.equalsIgnoreCase("extends")) {
            this.showBaseClassList(pHPProjectModel, string, n, n2, bl2, bl);
            return true;
        }
        if (string2.equalsIgnoreCase("implements")) {
            this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
            return true;
        }
        if (bl3 && bl4) {
            if (bl || string.length() > 0) {
                if (matcher.start() < matcher2.start()) {
                    this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
                } else {
                    this.showBaseClassList(pHPProjectModel, string, n, n2, bl2, bl);
                }
            }
            return true;
        }
        if (bl4 || !bl2) {
            if (bl) {
                this.showInterfaceList(pHPProjectModel, string, n, n2, bl);
            }
            return true;
        }
        if ((bl || string.length() > 0) && bl2) {
            this.showImplementsList(pHPProjectModel, string, n, n2, bl);
        }
        return true;
    }

    protected void showInterfaceList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        CodeData codeData;
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = pHPProjectModel.getClasses();
        ArrayList<CodeData> arrayList = new ArrayList<CodeData>(codeDataArray.length / 10);
        CodeData[] codeDataArray2 = codeDataArray;
        int n3 = codeDataArray.length;
        int n4 = 0;
        while (n4 < n3) {
            codeData = codeDataArray2[n4];
            if (PHPModifier.isInterface((int)((PHPClassData)codeData).getModifiers())) {
                arrayList.add(codeData);
            }
            ++n4;
        }
        codeData = new CodeData[arrayList.size()];
        Iterator iterator = arrayList.iterator();
        n3 = 0;
        while (n3 < ((CodeData)codeData).length) {
            codeData[n3] = (CodeData)iterator.next();
            ++n3;
        }
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, (CodeData[])codeData, string, n2);
    }

    protected void showExtendsImplementsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getExtendsImplementsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    protected CodeData[] getExtendsImplementsCodeData(PHPProjectModel pHPProjectModel) {
        if (this.extendedImplementCodeData == null) {
            String string;
            CodeData[] codeDataArray;
            String string2 = null;
            String string3 = null;
            CodeData[] codeDataArray2 = codeDataArray = pHPProjectModel.getKeywordData();
            int n = codeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                string = codeDataArray2[n2];
                if (string.getName().equals("extends")) {
                    string2 = string;
                }
                if (string.getName().equals("implements")) {
                    string3 = string;
                }
                ++n2;
            }
            string = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
            n2 = string.equals("php5") ? 1 : 0;
            this.extendedImplementCodeData = n2 != 0 ? new CodeData[]{string2, string3} : new CodeData[]{string2};
        }
        return this.extendedImplementCodeData;
    }

    protected void showImplementsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getImplementsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    protected CodeData[] getImplementsCodeData(PHPProjectModel pHPProjectModel) {
        String string = pHPProjectModel.getPHPLanguageModel().getPHPVersion();
        boolean bl = string.equals("php5");
        if (!bl) {
            return null;
        }
        if (implementCodeData == null) {
            CodeData[] codeDataArray;
            CodeData codeData = null;
            CodeData[] codeDataArray2 = codeDataArray = pHPProjectModel.getKeywordData();
            int n = codeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData codeData2 = codeDataArray2[n2];
                if (codeData2.getName().equals("implements")) {
                    codeData = codeData2;
                    break;
                }
                ++n2;
            }
            implementCodeData = new CodeData[]{codeData};
        }
        return implementCodeData;
    }

    private void showExtendsList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = ContentAssistSupport.getExtendsCodeData(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    private static CodeData[] getExtendsCodeData(PHPProjectModel pHPProjectModel) {
        if (extendsCodeData == null) {
            CodeData[] codeDataArray;
            CodeData codeData = null;
            CodeData[] codeDataArray2 = codeDataArray = pHPProjectModel.getKeywordData();
            int n = codeDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeData codeData2 = codeDataArray2[n2];
                if (codeData2.getName().equals("extends")) {
                    codeData = codeData2;
                    break;
                }
                ++n2;
            }
            extendsCodeData = new CodeData[]{codeData};
        }
        return extendsCodeData;
    }

    private void showBaseClassList(PHPProjectModel pHPProjectModel, String string, int n, int n2, boolean bl, boolean bl2) {
        if (!bl) {
            this.showInterfaceList(pHPProjectModel, string, n, n2, bl2);
            return;
        }
        if (!bl2 && !this.autoShowClassNames) {
            return;
        }
        CodeData[] codeDataArray = this.getOnlyClasses(pHPProjectModel);
        this.completionProposalGroup = this.phpCompletionProposalGroup;
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    private CodeData[] getOnlyClasses(PHPProjectModel pHPProjectModel) {
        CodeData[] codeDataArray;
        CodeData[] codeDataArray2 = pHPProjectModel.getClasses();
        int n = 0;
        CodeData[] codeDataArray3 = codeDataArray2;
        int n2 = codeDataArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            codeDataArray = codeDataArray3[n3];
            if (PHPModifier.isInterface((int)((PHPClassData)codeDataArray).getModifiers())) {
                ++n;
            }
            ++n3;
        }
        if (n == 0) {
            return codeDataArray2;
        }
        codeDataArray = new CodeData[codeDataArray2.length - n];
        n3 = 0;
        n2 = 0;
        while (n2 < codeDataArray2.length) {
            if (!PHPModifier.isInterface((int)((PHPClassData)codeDataArray2[n2]).getModifiers())) {
                codeDataArray[n3] = codeDataArray2[n2];
                ++n3;
            }
            ++n2;
        }
        return codeDataArray;
    }

    protected boolean isInCatchStatement(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, TextSequence textSequence, int n, int n2, boolean bl) {
        Matcher matcher = catchPattern.matcher((CharSequence)textSequence);
        int n3 = textSequence.length();
        while (matcher.find()) {
            if (textSequence.length() != matcher.end()) continue;
            n3 = matcher.start() + 1;
            break;
        }
        if (n3 == textSequence.length()) {
            return false;
        }
        int n4 = n3 + 5;
        textSequence = textSequence.subTextSequence(n4, textSequence.length());
        int n5 = 0;
        while (n5 < textSequence.length()) {
            if (textSequence.charAt(n5) == '(') break;
            ++n5;
        }
        if (n5 == textSequence.length()) {
            return true;
        }
        n5 = PHPTextSequenceUtilities.readForwardSpaces((TextSequence)textSequence, (int)(n5 + 1));
        int n6 = PHPTextSequenceUtilities.readIdentifierEndIndex((TextSequence)textSequence, (int)n5, (boolean)false);
        String string = textSequence.subSequence(n5, n6).toString();
        if (n6 == textSequence.length()) {
            this.showClassList(pHPProjectModel, pHPFileData, string, n, n2, States.CATCH, bl);
        }
        return true;
    }

    protected void showClassList(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, String string, int n, int n2, States states, boolean bl) {
        if (!bl && !this.autoShowClassNames) {
            return;
        }
        boolean bl2 = this.needToAddSelfKeyword(pHPFileData, n);
        CodeData[] codeDataArray = null;
        switch (states) {
            case NEW: {
                this.completionProposalGroup = this.newStatementCompletionProposalGroup;
                codeDataArray = this.getOnlyClasses(pHPProjectModel);
                if (!bl2) break;
                codeDataArray = this.addSelfKeywordToProposals(codeDataArray);
                break;
            }
            case INSTANCEOF: {
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                codeDataArray = pHPProjectModel.getClasses();
                if (!bl2) break;
                codeDataArray = this.addSelfKeywordToProposals(codeDataArray);
                break;
            }
            case CATCH: {
                this.completionProposalGroup = this.phpCompletionProposalGroup;
                codeDataArray = pHPProjectModel.getClasses();
                break;
            }
        }
        this.completionProposalGroup.setData(n, codeDataArray, string, n2);
    }

    private boolean needToAddSelfKeyword(PHPFileData pHPFileData, int n) {
        boolean bl = false;
        PHPCodeContext pHPCodeContext = ModelSupport.createContext((PHPFileData)pHPFileData, (int)n);
        String string = pHPCodeContext.getContainerClassName();
        String string2 = pHPCodeContext.getContainerFunctionName();
        if (string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0) {
            PHPClassData[] pHPClassDataArray;
            bl = true;
            PHPClassData[] pHPClassDataArray2 = pHPClassDataArray = pHPFileData.getClasses();
            int n2 = pHPClassDataArray.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4;
                PHPClassData pHPClassData = pHPClassDataArray2[n3];
                if (pHPClassData.getName().equals(string) && (PHPModifier.isAbstract((int)(n4 = pHPClassData.getModifiers())) || PHPModifier.isInterface((int)n4))) {
                    return false;
                }
                ++n3;
            }
        }
        return bl;
    }

    private CodeData[] addSelfKeywordToProposals(CodeData[] codeDataArray) {
        PHPKeywordData pHPKeywordData = PHPCodeDataFactory.createPHPKeywordData((String)"self", (String)CLASS_FUNCTIONS_TRIGGER, (int)2);
        Object[] objectArray = new CodeData[codeDataArray.length + 1];
        System.arraycopy(codeDataArray, 0, objectArray, 0, codeDataArray.length);
        objectArray[codeDataArray.length] = pHPKeywordData;
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected boolean isNewOrInstanceofStatement(PHPProjectModel pHPProjectModel, PHPFileData pHPFileData, String string, String string2, int n, int n2, boolean bl, String string3) {
        if (PHPPartitionTypes.isPHPQuotesState((String)string3)) {
            return false;
        }
        if (string.equalsIgnoreCase("instanceof")) {
            this.showClassList(pHPProjectModel, pHPFileData, string2, n, n2, States.INSTANCEOF, bl);
            return true;
        }
        if (string.equalsIgnoreCase("new")) {
            this.showClassList(pHPProjectModel, pHPFileData, string2, n, n2, States.NEW, bl);
            return true;
        }
        return false;
    }

    protected boolean isInArrayOption(PHPProjectModel pHPProjectModel, String string, boolean bl, String string2, String string3, int n, int n2, int n3, TextSequence textSequence, String string4) {
        CodeData[] codeDataArray;
        CodeData[] codeDataArray2;
        if (PHPPartitionTypes.isPHPQuotesState((String)string4)) {
            return false;
        }
        boolean bl2 = false;
        if (n > 0 && !string3.startsWith("$")) {
            if (bl) {
                if (string3.length() == 0 && string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                    bl2 = true;
                }
            } else if (string2.length() == 0 && textSequence.charAt(n - 1) == '[') {
                bl2 = true;
            }
        }
        if (!bl2) {
            return false;
        }
        int n4 = n - 1;
        n = PHPTextSequenceUtilities.readIdentifierStartIndex((TextSequence)textSequence, (int)(n4 = PHPTextSequenceUtilities.readBackwardSpaces((TextSequence)textSequence, (int)n4)), (boolean)true);
        String string5 = textSequence.subSequence(n, n4).toString();
        if (string5.startsWith("$")) {
            string5 = string5.substring(1);
        }
        CodeData[] codeDataArray3 = pHPProjectModel.getArrayVariables(string, string5, string3, this.determineObjectTypeFromOtherFile);
        if (string3.length() == 0) {
            codeDataArray2 = pHPProjectModel.getFunctions();
            codeDataArray = this.disableConstants ? null : pHPProjectModel.getConstants();
        } else {
            codeDataArray2 = pHPProjectModel.getFunctions(string3);
            codeDataArray = this.disableConstants ? null : pHPProjectModel.getConstants(string3, this.constantCaseSensitive);
        }
        CodeData[] codeDataArray4 = ModelSupport.merge((CodeData[])codeDataArray2, (CodeData[])ModelSupport.merge((CodeData[])codeDataArray3, (CodeData[])codeDataArray));
        this.completionProposalGroup = this.arrayCompletionProposalGroup;
        this.completionProposalGroup.setData(n2, codeDataArray4, string3, n3);
        return true;
    }

    protected ICompletionProposal[] merg(ICompletionProposal[] iCompletionProposalArray, ICompletionProposal[] iCompletionProposalArray2) {
        int n = iCompletionProposalArray == null ? 0 : iCompletionProposalArray.length;
        int n2 = iCompletionProposalArray2 == null ? 0 : iCompletionProposalArray2.length;
        ICompletionProposal[] iCompletionProposalArray3 = new ICompletionProposal[n + n2];
        int n3 = 0;
        if (iCompletionProposalArray != null) {
            System.arraycopy(iCompletionProposalArray, 0, iCompletionProposalArray3, 0, n);
            n3 = n;
        }
        if (iCompletionProposalArray2 != null) {
            System.arraycopy(iCompletionProposalArray2, 0, iCompletionProposalArray3, n3, n2);
        }
        Arrays.sort(iCompletionProposalArray3, proposalsComperator);
        return iCompletionProposalArray3;
    }

    private class ArrayCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ArrayCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            if (!(codeData instanceof PHPVariableData)) {
                return super.createProposal(pHPProjectModel, codeData);
            }
            ArrayCompletionProposal arrayCompletionProposal = new ArrayCompletionProposal(codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "'", "'", 1);
            return arrayCompletionProposal;
        }

        private class ArrayCompletionProposal
        extends CodeDataCompletionProposal {
            public ArrayCompletionProposal(CodeData codeData, int n, int n2, int n3, String string, String string2, int n4) {
                super(ArrayCompletionProposalGroup.this.projectModel, codeData, n, n2, n3, string, string2, n4, false);
            }

            public void apply(IDocument iDocument) {
                try {
                    char c;
                    boolean bl = PreferenceConstants.getPreferenceStore().getBoolean("contentAssistInsertCompletion");
                    if (!bl) {
                        this.removeTrailingCharacters(iDocument);
                    }
                    if ((c = iDocument.getChar(this.replacementOffset - 1)) == '\'' || c == '\"') {
                        --this.replacementOffset;
                        ++this.replacementLength;
                        int n = this.replacementOffset + this.replacementLength + this.selectionLength;
                        int n2 = iDocument.getLength();
                        int n3 = 0;
                        boolean bl2 = false;
                        while (n < n2) {
                            char c2 = iDocument.getChar(n);
                            if (c2 == c) {
                                ++n3;
                                bl2 = true;
                                break;
                            }
                            if (!Character.isWhitespace(c2)) break;
                            ++n3;
                            ++n;
                        }
                        if (bl2) {
                            this.replacementLength += n3;
                        }
                    }
                    iDocument.replace(this.replacementOffset, this.replacementLength + this.selectionLength, this.getReplacementString());
                }
                catch (BadLocationException badLocationException) {
                    super.apply(iDocument);
                }
            }
        }
    }

    private class ClassConstructorCompletionProposalGroup
    extends CompletionProposalGroup {
        private ClassConstructorCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            return new CodeDataCompletionProposal(pHPProjectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", 1, true);
        }
    }

    private class ClassStaticCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassStaticCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(pHPProjectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(pHPProjectModel, codeData);
        }

        protected ICompletionProposal[] calcCompletionProposals(PHPProjectModel pHPProjectModel) {
            CodeData[] codeDataArray;
            if (this.key.length() == 0) {
                return super.calcCompletionProposals(pHPProjectModel);
            }
            if (this.key.charAt(0) == '$') {
                codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])this.codeDataProposals, (CodeDataFilter)ModelSupport.STATIC_VARIABLES_FILTER);
                codeDataArray = ModelSupport.getCodeDataStartingWith((CodeData[])codeDataArray, (String)this.key.substring(1));
            } else {
                codeDataArray = ModelSupport.getCodeDataStartingWith((CodeData[])this.codeDataProposals, (String)this.key);
                codeDataArray = ModelSupport.getFilteredCodeData((CodeData[])codeDataArray, (CodeDataFilter)ModelSupport.NOT_STATIC_VARIABLES_FILTER);
            }
            ICompletionProposal[] iCompletionProposalArray = new CodeDataCompletionProposal[codeDataArray.length];
            int n = 0;
            while (n < codeDataArray.length) {
                iCompletionProposalArray[n] = this.createProposal(pHPProjectModel, codeDataArray[n]);
                ++n;
            }
            return iCompletionProposalArray;
        }
    }

    private class ClassVariableCallCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private ClassVariableCallCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            if (codeData instanceof PHPClassVarData) {
                return new CodeDataCompletionProposal(pHPProjectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "$", "", 0, false);
            }
            return super.createProposal(pHPProjectModel, codeData);
        }
    }

    private class NewStatementCompletionProposalGroup
    extends CompletionProposalGroup {
        private NewStatementCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            PHPCodeData pHPCodeData = (PHPCodeData)codeData;
            if (pHPCodeData instanceof PHPClassData) {
                PHPClassData pHPClassData = (PHPClassData)pHPCodeData;
                PHPFunctionData pHPFunctionData = pHPClassData.getUserData() != null ? PHPModelUtil.getRealConstructor((PHPProjectModel)pHPProjectModel, (String)pHPClassData.getUserData().getFileName(), (PHPClassData)pHPClassData) : null;
                int n = pHPFunctionData != null && pHPFunctionData.getParameters().length > 0 ? 1 : 2;
                return new CodeDataCompletionProposal(pHPProjectModel, (CodeData)pHPClassData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", n, true);
            }
            return new CodeDataCompletionProposal(pHPProjectModel, (CodeData)pHPCodeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", "()", 2, true);
        }
    }

    protected class PHPCompletionProposalGroup
    extends CompletionProposalGroup {
        protected PHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            String string = " ";
            int n = 1;
            boolean bl = false;
            if (codeData instanceof PHPKeywordData) {
                PHPKeywordData pHPKeywordData = (PHPKeywordData)codeData;
                string = pHPKeywordData.getSuffix();
                n = pHPKeywordData.getSuffixOffset();
            } else if (codeData instanceof PHPTagData) {
                string = "";
                n = 0;
            } else if (codeData instanceof PHPFunctionData) {
                String string2;
                boolean bl2;
                PHPFunctionData pHPFunctionData = (PHPFunctionData)codeData;
                string = "()";
                bl = true;
                n = 2;
                boolean bl3 = bl2 = pHPFunctionData.getParameters().length > 0;
                if (bl2) {
                    --n;
                }
                if ((string2 = pHPFunctionData.getReturnType()) != null && string2.compareToIgnoreCase("void") == 0) {
                    string = String.valueOf(string) + ";";
                    if (!bl2) {
                        ++n;
                    }
                }
            } else if (codeData instanceof PHPVariableData || codeData instanceof PHPConstantData || codeData instanceof PHPClassConstData) {
                string = "";
                n = 0;
            }
            return new CodeDataCompletionProposal(pHPProjectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", string, n, bl);
        }
    }

    static class PHPTagData
    extends PHPCodeDataFactory.PHPFunctionDataImp {
        PHPTagData() {
            super("php", 0, null, null, PHPCodeDataFactory.EMPTY_FUNCTION_PARAMETER_DATA_ARRAY, "");
        }

        public void accept(Visitor visitor) {
            if (visitor instanceof PHPCompletionRendererVisitor) {
                ((PHPCompletionRendererVisitor)visitor).visit(this);
            } else {
                super.accept(visitor);
            }
        }
    }

    private class RegularPHPCompletionProposalGroup
    extends PHPCompletionProposalGroup {
        private RegularPHPCompletionProposalGroup() {
        }

        protected CodeDataCompletionProposal createProposal(PHPProjectModel pHPProjectModel, CodeData codeData) {
            if (!(codeData instanceof PHPClassData)) {
                return super.createProposal(pHPProjectModel, codeData);
            }
            return new CodeDataCompletionProposal(pHPProjectModel, codeData, this.getOffset() - this.key.length(), this.key.length(), this.selectionLength, "", ContentAssistSupport.CLASS_FUNCTIONS_TRIGGER, 2, false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum States {
        CATCH,
        NEW,
        INSTANCEOF;

    }
}

