/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.project.PHPNature;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class PHPFileCreationWizardPage
extends WizardPage {
    protected Text containerText;
    protected Text fileText;
    private ISelection selection;
    protected IProject project;
    protected static final String UTF_8 = "UTF 8";
    protected static final String NO_TEMPLATE = "-- none -- ";
    protected Label targetResourceLabel;

    public PHPFileCreationWizardPage(ISelection iSelection) {
        super("wizardPage");
        this.setTitle(PHPUIMessages.getString("PHPFileCreationWizardPage.3"));
        this.setDescription(PHPUIMessages.getString("PHPFileCreationWizardPage.4"));
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_PHP_FILE);
        this.selection = iSelection;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        gridLayout.numColumns = 3;
        gridLayout.verticalSpacing = 9;
        Label label = new Label(composite2, 0);
        label.setText(PHPUIMessages.getString("PHPFileCreationWizardPage.5"));
        this.containerText = new Text(composite2, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 400;
        this.containerText.setLayoutData((Object)gridData);
        this.containerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        Button button = new Button(composite2, 8);
        button.setText(PHPUIMessages.getString("PHPFileCreationWizardPage.6"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PHPFileCreationWizardPage.this.handleBrowse();
            }
        });
        this.targetResourceLabel = new Label(composite2, 0);
        this.targetResourceLabel.setText(PHPUIMessages.getString("PHPFileCreationWizardPage.7"));
        this.fileText = new Text(composite2, 2052);
        this.fileText.setFocus();
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fileText.setLayoutData((Object)gridData);
        this.fileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                PHPFileCreationWizardPage.this.dialogChanged();
            }
        });
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)composite2);
    }

    private void initialize() {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.selection;
            if (iStructuredSelection.size() > 1) {
                return;
            }
            Object object = iStructuredSelection.getFirstElement();
            IContainer iContainer = null;
            if (object instanceof PHPCodeData) {
                object = PHPModelUtil.getResource((Object)object);
            } else if (object instanceof PHPNature) {
                object = ((PHPNature)object).getProject();
            } else if (object instanceof PHPProjectModel) {
                object = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (object instanceof IResource) {
                iContainer = object instanceof IContainer ? (IContainer)object : ((IResource)object).getParent();
            } else if (object instanceof PHPProjectModel) {
                iContainer = PHPWorkspaceModelManager.getInstance().getProjectForModel((PHPProjectModel)object);
            }
            if (iContainer != null) {
                this.containerText.setText(iContainer.getFullPath().toString());
                this.project = iContainer.getProject();
            }
        }
        this.setInitialFileName(PHPUIMessages.getString("PHPFileCreationWizardPage.8"));
    }

    protected void setInitialFileName(String string) {
        this.fileText.setText(string);
        this.fileText.setSelection(0, 7);
    }

    private void handleBrowse() {
        Object[] objectArray;
        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, PHPUIMessages.getString("PHPFileCreationWizardPage.9"));
        containerSelectionDialog.showClosedProjects(false);
        if (containerSelectionDialog.open() == 0 && (objectArray = containerSelectionDialog.getResult()).length == 1) {
            this.containerText.setText(((Path)objectArray[0]).toOSString());
        }
    }

    protected void dialogChanged() {
        Object object;
        String string = this.getContainerName();
        String string2 = this.getFileName();
        if (string.length() == 0) {
            this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.10"));
            return;
        }
        IContainer iContainer = this.getContainer(string);
        if (iContainer == null || !iContainer.exists()) {
            this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.11"));
            return;
        }
        if (!iContainer.getProject().isOpen()) {
            this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.12"));
            return;
        }
        if (string2 != null && !string2.equals("") && iContainer.getFile((IPath)new Path(string2)).exists()) {
            this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.14"));
            return;
        }
        int n = string2.lastIndexOf(46);
        if (string2.length() == 0 || n == 0) {
            this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.15"));
            return;
        }
        if (n != -1) {
            object = string2.substring(0, n);
            int n2 = 0;
            while (n2 < ((String)object).length()) {
                char c = ((String)object).charAt(n2);
                if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '-') {
                    this.updateStatus(PHPUIMessages.getString("PHPFileCreationWizardPage.16"));
                    return;
                }
                ++n2;
            }
        }
        if (!(object = Platform.getContentTypeManager().getContentType(ContentTypeIdForPHP.ContentTypeID_PHP)).isAssociatedWith(string2)) {
            String[] stringArray = object.getFileSpecs(8);
            StringBuffer stringBuffer = new StringBuffer(PHPUIMessages.getString("PHPFileCreationWizardPage.17"));
            stringBuffer.append(stringArray[0]);
            String[] stringArray2 = stringArray;
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = stringArray2[n4];
                stringBuffer.append(", ").append(string3);
                ++n4;
            }
            stringBuffer.append("]");
            this.updateStatus(stringBuffer.toString());
            return;
        }
        this.updateStatus(null);
    }

    protected IContainer getContainer(String string) {
        Path path = new Path(string);
        IResource iResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
        return iResource instanceof IContainer ? (IContainer)iResource : null;
    }

    protected void updateStatus(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(string == null);
    }

    public String getContainerName() {
        return this.containerText.getText();
    }

    public void setContainerName(String string) {
        this.containerText.setText(string);
    }

    public String getFileName() {
        return this.fileText.getText();
    }

    public IProject getProject() {
        return this.project;
    }
}

