/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.launching;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.core.debugger.parameters.IDebugParametersInitializer;
import org.eclipse.php.internal.core.resources.ExternalFilesRegistry;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.DebugSessionIdGenerator;
import org.eclipse.php.internal.debug.core.launching.PHPLaunch;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.phpIni.PHPINIUtil;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.core.zend.debugger.DebugParametersInitializersRegistry;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPExecutableDebuggerInitializer;
import org.eclipse.php.internal.debug.core.zend.debugger.PHPSessionLaunchMapper;
import org.eclipse.php.internal.debug.core.zend.debugger.ProcessCrashDetector;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class PHPExecutableLaunchDelegate
extends LaunchConfigurationDelegate {
    private static final boolean WINDOWS = File.separatorChar == '\\';
    public static final String SAVE_AUTOMATICALLY = "save_automatically";
    private static final String UNTITLED_FOLDER_PATH = "Untitled_Documents";
    protected Map<String, String> envVariables = null;

    public ILaunch getLaunch(ILaunchConfiguration iLaunchConfiguration, String string) throws CoreException {
        return new PHPLaunch(iLaunchConfiguration, string, null);
    }

    public void debugPHPExecutable(ILaunch iLaunch, String string, String string2) throws DebugException {
        try {
            iLaunch.setAttribute("executable_launch", Boolean.toString(true));
            IDebugParametersInitializer iDebugParametersInitializer = DebugParametersInitializersRegistry.getBestMatchDebugParametersInitializer(iLaunch);
            PHPExecutableDebuggerInitializer pHPExecutableDebuggerInitializer = new PHPExecutableDebuggerInitializer(iLaunch);
            String string3 = new File(string).getAbsolutePath();
            String string4 = new File(string2).getAbsolutePath();
            String string5 = iDebugParametersInitializer.generateQuery(iLaunch);
            String string6 = iLaunch.getAttribute("PHPIniLocation");
            String string7 = new File(string2).getParentFile().getAbsolutePath();
            pHPExecutableDebuggerInitializer.initializeDebug(string3, string4, string7, string5, this.envVariables, string6);
        }
        catch (IOException iOException) {
            Logger.logException("PHPDebugTarget: Debugger didn't find file to debug.", iOException);
            String string8 = PHPDebugCoreMessages.DebuggerFileNotFound_1;
            throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, string8, (Throwable)iOException));
        }
    }

    public void launch(ILaunchConfiguration iLaunchConfiguration, String string, ILaunch iLaunch, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        Object object2;
        if (!DaemonPlugin.getDefault().validateCommunicationDaemons("org.eclipse.php.debug.core.zendDebugger")) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        if (!PHPLaunchUtilities.notifyPreviousLaunches(iLaunch)) {
            iProgressMonitor.setCanceled(true);
            iProgressMonitor.done();
            return;
        }
        PHPLaunchUtilities.showDebugView();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        String string2 = iLaunchConfiguration.getAttribute("ATTR_LOCATION", null);
        String string3 = iLaunchConfiguration.getAttribute("ATTR_INI_LOCATION", null);
        String string4 = iLaunchConfiguration.getAttribute("ATTR_WORKING_DIRECTORY", null);
        String string5 = iLaunchConfiguration.getAttribute("ATTR_FILE", null);
        boolean bl = iLaunchConfiguration.getAttribute("org.eclipse.php.debug.core.RunWithDebugInfo", true);
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (string5 == null || string5.equals("")) {
            this.displayErrorMessage("Please set a valid PHP file for this launch.");
            return;
        }
        if (string2 == null) {
            this.displayErrorMessage("Please set a valid PHP executable for this launch.");
            return;
        }
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(string5);
        IProject iProject = null;
        IProject iProject2 = null;
        String string6 = null;
        if (string4 == null) {
            object2 = iWorkspaceRoot.findMember((IPath)path);
            if (object2 == null && (!WINDOWS || ExternalFilesRegistry.getInstance().isEntryExist(path.toOSString()))) {
                iProject = iProject2 = ExternalFilesRegistry.getInstance().getExternalFilesProject();
                string6 = path.makeAbsolute().toOSString();
            } else if (object2 == null || !object2.isAccessible()) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_ResourceNotFound, (Object)path));
                return;
            }
            if (iProject == null) {
                iProject = object2.getProject();
                object = object2.getLocation();
                string6 = object != null ? object.toOSString() : object2.getFullPath().toString();
            }
            if (iProject == null) {
                this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
                return;
            }
        } else {
            try {
                object2 = new Path(string4);
                iProject = iWorkspaceRoot.getProject(object2.lastSegment());
                string6 = path.makeAbsolute().toString();
            }
            catch (Exception exception) {}
        }
        if (iProject == null || !iProject.isAccessible() && iProject != iProject2) {
            this.displayErrorMessage(NLS.bind((String)PHPDebugCoreMessages.Debugger_InvalidDebugResource, (Object)path));
            return;
        }
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
        object2 = string3 != null && new File(string3).exists() ? new File(string3) : PHPINIUtil.findPHPIni(string2);
        object = PHPINIUtil.prepareBeforeDebug((File)object2, string2, iProject);
        iLaunch.setAttribute("PHPIniLocation", ((File)object).getAbsolutePath());
        if (string.equals("debug") || bl) {
            boolean bl2 = iLaunchConfiguration.getAttribute("firstLineBreakpoint", PHPProjectPreferences.getStopAtFirstLine(iProject));
            int n = PHPDebugPlugin.getDebugPort("org.eclipse.php.debug.core.zendDebugger");
            String string7 = iProject.getFullPath().toString();
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfiguration.isWorkingCopy() ? (ILaunchConfigurationWorkingCopy)iLaunchConfiguration : iLaunchConfiguration.getWorkingCopy();
            iLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.php.debug.core.PHP_Project", string7);
            iLaunchConfigurationWorkingCopy.setAttribute("debugTransferEncoding", PHPProjectPreferences.getTransferEncoding(iProject));
            iLaunchConfigurationWorkingCopy.setAttribute("debugOutputEncoding", PHPProjectPreferences.getOutputEncoding(iProject));
            iLaunchConfigurationWorkingCopy.setAttribute("php_debug_type", "php_exe_script_debug");
            iLaunchConfigurationWorkingCopy.doSave();
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            int n2 = DebugSessionIdGenerator.generateSessionID();
            PHPSessionLaunchMapper.put(n2, iLaunch);
            iLaunch.setAttribute("port", Integer.toString(n));
            iLaunch.setAttribute("firstLineBreakpoint", Boolean.toString(bl2));
            iLaunch.setAttribute("debugSessionID", Integer.toString(n2));
            this.debugPHPExecutable(iLaunch, string2, string6);
        } else {
            Object object3;
            Path path2 = new Path(string2);
            IPath iPath = iProject.getRawLocation();
            if (iPath == null) {
                iPath = iProject.getLocation();
            }
            Path path3 = new Path(string5);
            if (string5.startsWith("/")) {
                path3 = path3.removeFirstSegments(1);
            }
            Object object4 = DebugPlugin.getDefault().getLaunchManager().getEnvironment(iLaunchConfiguration);
            File file = new File(string2);
            String string8 = iLaunch.getAttribute("PHPIniLocation");
            String string9 = file.getParent();
            if (string8 != null && !string8.equals("")) {
                string9 = new File(string8).getParent();
            }
            IResource iResource = iWorkspaceRoot.findMember((IPath)path);
            String string10 = null;
            string10 = iResource != null ? iResource.getLocation().toOSString() : path.toString();
            String string11 = null;
            PHPexeItem[] pHPexeItemArray = PHPexes.getInstance().getAllItems();
            Object object5 = pHPexeItemArray;
            int n = pHPexeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                object3 = object5[n3];
                if (((PHPexeItem)object3).getExecutable().equals(file)) {
                    string11 = ((PHPexeItem)object3).getSapiType();
                    break;
                }
                ++n3;
            }
            object3 = PHPLaunchUtilities.getProgramArguments(iLaunch.getLaunchConfiguration());
            String[] stringArray = PHPLaunchUtilities.getCommandLine(iLaunch.getLaunchConfiguration(), path2.toOSString(), string9, string10, (String[])(string11 == "CLI" ? object3 : null));
            if (!WINDOWS) {
                StringBuffer stringBuffer = new StringBuffer();
                if (System.getProperty("os.name").startsWith("Mac")) {
                    stringBuffer.append("DYLD_LIBRARY_PATH");
                } else {
                    stringBuffer.append("LD_LIBRARY_PATH");
                }
                stringBuffer.append('=');
                stringBuffer.append(file.getParent());
                object5 = new String[object4 == null ? 1 : ((String[])object4).length + 1];
                if (object4 != null) {
                    System.arraycopy(object4, 0, object5, 0, ((String[])object4).length);
                }
                object5[((PHPexeItem[])object5).length - 1] = stringBuffer.toString();
                object4 = object5;
            }
            if (iProgressMonitor.isCanceled()) {
                return;
            }
            File file2 = new File(string10).getParentFile();
            object5 = file2.exists() ? DebugPlugin.exec((String[])stringArray, (File)file2, (String[])object4) : DebugPlugin.exec((String[])stringArray, null, (String[])object4);
            new Thread(new ProcessCrashDetector((Process)object5)).start();
            IProcess iProcess = null;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string12 = path2.lastSegment();
            String string13 = path2.getFileExtension();
            if (string13 != null) {
                string12 = string12.substring(0, string12.length() - (string13.length() + 1));
            }
            string12 = string12.toLowerCase();
            hashMap.put(IProcess.ATTR_PROCESS_TYPE, string12);
            if (object5 != null) {
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 80);
                subProgressMonitor.beginTask(MessageFormat.format("start launch", iLaunchConfiguration.getName()), -1);
                iProcess = DebugPlugin.newProcess((ILaunch)iLaunch, (Process)object5, (String)path2.toOSString(), hashMap);
                if (iProcess == null) {
                    ((Process)object5).destroy();
                    throw new CoreException((IStatus)new Status(4, PHPDebugPlugin.getID(), 0, null, null));
                }
                subProgressMonitor.done();
            }
            iProcess.setAttribute(IProcess.ATTR_CMDLINE, string5);
            if (!CommonTab.isLaunchInBackground((ILaunchConfiguration)iLaunchConfiguration)) {
                while (!iProcess.isTerminated()) {
                    try {
                        if (iProgressMonitor.isCanceled()) {
                            iProcess.terminate();
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 10);
                RefreshTab.refreshResources((ILaunchConfiguration)iLaunchConfiguration, (IProgressMonitor)subProgressMonitor);
            }
        }
    }

    private void displayErrorMessage(final String string) {
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)display.getActiveShell(), (String)PHPDebugCoreMessages.Debugger_LaunchError_title, (String)string);
            }
        });
    }

    protected boolean saveBeforeLaunch(ILaunchConfiguration iLaunchConfiguration, String string, IProgressMonitor iProgressMonitor) throws CoreException {
        String string2 = iLaunchConfiguration.getAttribute("ATTR_FILE", "");
        if ("".equals(string2)) {
            return super.saveBeforeLaunch(iLaunchConfiguration, string, iProgressMonitor);
        }
        IPath iPath = Path.fromOSString((String)string2);
        if (iPath.segmentCount() > 1 && UNTITLED_FOLDER_PATH.equals(iPath.segment(iPath.segmentCount() - 2))) {
            return true;
        }
        return super.saveBeforeLaunch(iLaunchConfiguration, string, iProgressMonitor);
    }
}

