/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.workingset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetEditWizard;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;
import org.eclipse.ui.dialogs.SelectionDialog;

public class WorkingSetConfigurationDialog
extends SelectionDialog {
    private List fElements;
    private CheckboxTableViewer fTableViewer;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fUpButton;
    private Button fDownButton;
    private Button fSelectAll;
    private Button fDeselectAll;
    private IWorkingSet[] fResult;
    private List fAddedWorkingSets;
    private List fRemovedWorkingSets;
    private Map fEditedWorkingSets;
    private List fRemovedMRUWorkingSets;
    private int nextButtonId = 1025;

    public WorkingSetConfigurationDialog(Shell shell, IWorkingSet[] iWorkingSetArray) {
        super(shell);
        this.setTitle(PHPUIMessages.getString("WorkingSetConfigurationDialog_title"));
        this.setMessage(PHPUIMessages.getString("WorkingSetConfigurationDialog_message"));
        this.fElements = new ArrayList(iWorkingSetArray.length);
        Filter filter = new Filter();
        int n = 0;
        while (n < iWorkingSetArray.length) {
            if (filter.select(null, null, iWorkingSetArray[n])) {
                this.fElements.add(iWorkingSetArray[n]);
            }
            ++n;
        }
    }

    public IWorkingSet[] getSelection() {
        return this.fResult;
    }

    public void setSelection(IWorkingSet[] iWorkingSetArray) {
        this.fResult = iWorkingSetArray;
        this.setInitialSelections(iWorkingSetArray);
    }

    protected Control createContents(Composite composite) {
        Control control = super.createContents(composite);
        this.setInitialSelection();
        this.updateButtonAvailability();
        return control;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        this.createMessageArea(composite2);
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        composite3.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.createTableViewer(composite3);
        this.createOrderButtons(composite3);
        this.createModifyButtons(composite2);
        this.fTableViewer.setInput((Object)this.fElements);
        return composite2;
    }

    private void createTableViewer(Composite composite) {
        this.fTableViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2050);
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                WorkingSetConfigurationDialog.this.updateButtonAvailability();
            }
        });
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        gridData.widthHint = this.convertWidthInCharsToPixels(50);
        this.fTableViewer.getTable().setLayoutData((Object)gridData);
        this.fTableViewer.getTable().setFont(composite.getFont());
        this.fTableViewer.addFilter((ViewerFilter)new Filter());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new WorkingSetLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                return ((List)object).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                WorkingSetConfigurationDialog.this.handleSelectionChanged();
            }
        });
    }

    private void createModifyButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 131072);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(640);
        gridData.grabExcessHorizontalSpace = true;
        composite.setData((Object)gridData);
        this.fNewButton = this.createButton(composite2, this.nextButtonId++, PHPUIMessages.getString("WorkingSetConfigurationDialog_new_label"), false);
        this.fNewButton.setFont(composite.getFont());
        this.fNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.createWorkingSet();
            }
        });
        this.fEditButton = this.createButton(composite2, this.nextButtonId++, PHPUIMessages.getString("WorkingSetConfigurationDialog_edit_label"), false);
        this.fEditButton.setFont(composite.getFont());
        this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.editSelectedWorkingSet();
            }
        });
        this.fRemoveButton = this.createButton(composite2, this.nextButtonId++, PHPUIMessages.getString("WorkingSetConfigurationDialog_remove_label"), false);
        this.fRemoveButton.setFont(composite.getFont());
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.removeSelectedWorkingSets();
            }
        });
    }

    private void createOrderButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData((Object)new GridData(1040));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fUpButton = new Button(composite2, 8);
        this.fUpButton.setText(PHPUIMessages.getString("WorkingSetConfigurationDialog_up_label"));
        this.fUpButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.fUpButton);
        this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.moveUp(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fDownButton = new Button(composite2, 8);
        this.fDownButton.setText(PHPUIMessages.getString("WorkingSetConfigurationDialog_down_label"));
        this.fDownButton.setFont(composite.getFont());
        this.setButtonLayoutData(this.fDownButton);
        this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.moveDown(((IStructuredSelection)WorkingSetConfigurationDialog.this.fTableViewer.getSelection()).toList());
            }
        });
        this.fSelectAll = new Button(composite2, 8);
        this.fSelectAll.setText(PHPUIMessages.getString("WorkingSetConfigurationDialog_selectAll_label"));
        this.fSelectAll.setFont(composite.getFont());
        this.setButtonLayoutData(this.fSelectAll);
        this.fSelectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.selectAll();
            }
        });
        this.fDeselectAll = new Button(composite2, 8);
        this.fDeselectAll.setText(PHPUIMessages.getString("WorkingSetConfigurationDialog_deselectAll_label"));
        this.fDeselectAll.setFont(composite.getFont());
        this.setButtonLayoutData(this.fDeselectAll);
        this.fDeselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                WorkingSetConfigurationDialog.this.deselectAll();
            }
        });
    }

    protected void okPressed() {
        List list = this.getResultWorkingSets();
        this.fResult = list.toArray(new IWorkingSet[list.size()]);
        this.setResult(list);
        super.okPressed();
    }

    private List getResultWorkingSets() {
        Object[] objectArray = this.fTableViewer.getCheckedElements();
        return new ArrayList(Arrays.asList(objectArray));
    }

    protected void cancelPressed() {
        this.restoreAddedWorkingSets();
        this.restoreChangedWorkingSets();
        this.restoreRemovedWorkingSets();
        super.cancelPressed();
    }

    private void setInitialSelection() {
        List list = this.getInitialElementSelections();
        if (!list.isEmpty()) {
            this.fTableViewer.setCheckedElements(list.toArray());
        }
    }

    private void createWorkingSet() {
        IWorkingSet iWorkingSet;
        Filter filter;
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetNewWizard iWorkingSetNewWizard = iWorkingSetManager.createWorkingSetNewWizard(new String[]{"org.eclipse.php.ui.workingset.PHPWorkingSetPage"});
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)iWorkingSetNewWizard);
        wizardDialog.create();
        if (wizardDialog.open() == 0 && (filter = new Filter()).select(null, null, iWorkingSet = iWorkingSetNewWizard.getSelection())) {
            this.fElements.add(iWorkingSet);
            this.fTableViewer.add((Object)iWorkingSet);
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)iWorkingSet), true);
            this.fTableViewer.setChecked((Object)iWorkingSet, true);
            iWorkingSetManager.addWorkingSet(iWorkingSet);
            this.fAddedWorkingSets.add(iWorkingSet);
        }
    }

    private void editSelectedWorkingSet() {
        boolean bl;
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSet iWorkingSet = (IWorkingSet)((IStructuredSelection)this.fTableViewer.getSelection()).getFirstElement();
        IWorkingSetEditWizard iWorkingSetEditWizard = iWorkingSetManager.createWorkingSetEditWizard(iWorkingSet);
        WizardDialog wizardDialog = new WizardDialog(this.getShell(), (IWizard)iWorkingSetEditWizard);
        IWorkingSet iWorkingSet2 = (IWorkingSet)this.fEditedWorkingSets.get(iWorkingSet);
        boolean bl2 = bl = iWorkingSet2 == null;
        if (bl) {
            iWorkingSet2 = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet(iWorkingSet.getName(), iWorkingSet.getElements());
        } else {
            this.fEditedWorkingSets.remove(iWorkingSet);
        }
        wizardDialog.create();
        if (wizardDialog.open() == 0) {
            iWorkingSet = iWorkingSetEditWizard.getSelection();
            this.fTableViewer.update((Object)iWorkingSet, null);
            this.updateButtonAvailability();
        }
        this.fEditedWorkingSets.put(iWorkingSet, iWorkingSet2);
    }

    void handleSelectionChanged() {
        this.updateButtonAvailability();
    }

    public int open() {
        this.fAddedWorkingSets = new ArrayList();
        this.fRemovedWorkingSets = new ArrayList();
        this.fEditedWorkingSets = new HashMap();
        this.fRemovedMRUWorkingSets = new ArrayList();
        return super.open();
    }

    private void removeSelectedWorkingSets() {
        ISelection iSelection = this.fTableViewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
            for (IWorkingSet iWorkingSet : (IStructuredSelection)iSelection) {
                if (this.fAddedWorkingSets.contains(iWorkingSet)) {
                    this.fAddedWorkingSets.remove(iWorkingSet);
                } else {
                    IWorkingSet[] iWorkingSetArray = iWorkingSetManager.getRecentWorkingSets();
                    int n = 0;
                    while (n < iWorkingSetArray.length) {
                        if (iWorkingSet.equals(iWorkingSetArray[n])) {
                            this.fRemovedMRUWorkingSets.add(iWorkingSet);
                            break;
                        }
                        ++n;
                    }
                    this.fRemovedWorkingSets.add(iWorkingSet);
                }
                this.fElements.remove(iWorkingSet);
                iWorkingSetManager.removeWorkingSet(iWorkingSet);
            }
            this.fTableViewer.remove(((IStructuredSelection)iSelection).toArray());
        }
    }

    private void restoreAddedWorkingSets() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator iterator = this.fAddedWorkingSets.iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.removeWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void restoreChangedWorkingSets() {
        for (IWorkingSet iWorkingSet : this.fEditedWorkingSets.keySet()) {
            IWorkingSet iWorkingSet2 = (IWorkingSet)this.fEditedWorkingSets.get(iWorkingSet);
            if (!iWorkingSet.getName().equals(iWorkingSet2.getName())) {
                iWorkingSet.setName(iWorkingSet2.getName());
            }
            if (iWorkingSet.getElements().equals(iWorkingSet2.getElements())) continue;
            iWorkingSet.setElements(iWorkingSet2.getElements());
        }
    }

    private void restoreRemovedWorkingSets() {
        IWorkingSetManager iWorkingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        Iterator iterator = this.fRemovedWorkingSets.iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.addWorkingSet((IWorkingSet)iterator.next());
        }
        iterator = this.fRemovedMRUWorkingSets.iterator();
        while (iterator.hasNext()) {
            iWorkingSetManager.addRecentWorkingSet((IWorkingSet)iterator.next());
        }
    }

    private void updateButtonAvailability() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fTableViewer.getSelection();
        boolean bl = !iStructuredSelection.isEmpty();
        boolean bl2 = iStructuredSelection.size() == 1;
        this.fRemoveButton.setEnabled(bl && this.areAllGlobalWorkingSets(iStructuredSelection));
        this.fEditButton.setEnabled(bl2 && ((IWorkingSet)iStructuredSelection.getFirstElement()).isEditable());
        if (this.fUpButton != null) {
            this.fUpButton.setEnabled(this.canMoveUp());
        }
        if (this.fDownButton != null) {
            this.fDownButton.setEnabled(this.canMoveDown());
        }
    }

    private boolean areAllGlobalWorkingSets(IStructuredSelection iStructuredSelection) {
        HashSet hashSet = new HashSet(Arrays.asList(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSets()));
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            if (hashSet.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private void moveUp(List list) {
        if (list.size() > 0) {
            this.setElements(this.moveUp(this.fElements, list));
            this.fTableViewer.reveal(list.get(0));
        }
    }

    private void moveDown(List list) {
        if (list.size() > 0) {
            this.setElements(this.reverse(this.moveUp(this.reverse(this.fElements), list)));
            this.fTableViewer.reveal(list.get(list.size() - 1));
        }
    }

    private void setElements(List list) {
        this.fElements = list;
        this.fTableViewer.setInput((Object)this.fElements);
        this.updateButtonAvailability();
    }

    private List moveUp(List list, List list2) {
        int n = list.size();
        ArrayList arrayList = new ArrayList(n);
        Object e = null;
        int n2 = 0;
        while (n2 < n) {
            Object e2 = list.get(n2);
            if (list2.contains(e2)) {
                arrayList.add(e2);
            } else {
                if (e != null) {
                    arrayList.add(e);
                }
                e = e2;
            }
            ++n2;
        }
        if (e != null) {
            arrayList.add(e);
        }
        return arrayList;
    }

    private List reverse(List list) {
        ArrayList arrayList = new ArrayList(list.size());
        int n = list.size() - 1;
        while (n >= 0) {
            arrayList.add(list.get(n));
            --n;
        }
        return arrayList;
    }

    private boolean canMoveUp() {
        int[] nArray = this.fTableViewer.getTable().getSelectionIndices();
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != n) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean canMoveDown() {
        int[] nArray = this.fTableViewer.getTable().getSelectionIndices();
        int n = this.fElements.size() - 1;
        int n2 = nArray.length - 1;
        while (n2 >= 0) {
            if (nArray[n2] != n) {
                return true;
            }
            --n2;
            --n;
        }
        return false;
    }

    private void selectAll() {
        this.fTableViewer.setAllChecked(true);
    }

    private void deselectAll() {
        this.fTableViewer.setAllChecked(false);
    }

    private static class Filter
    extends ViewerFilter {
        private Filter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            IWorkingSet iWorkingSet = (IWorkingSet)object2;
            String string = iWorkingSet.getId();
            return "org.eclipse.php.ui.HistoryWorkingSet".equals(string) || "org.eclipse.php.ui.OthersWorkingSet".equals(string) || "org.eclipse.php.ui.workingset.PHPWorkingSetPage".equals(string);
        }
    }

    private static class WorkingSetLabelProvider
    extends LabelProvider {
        private Map fIcons = new Hashtable();

        public void dispose() {
            for (Image image : this.fIcons.values()) {
                image.dispose();
            }
            super.dispose();
        }

        public Image getImage(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            ImageDescriptor imageDescriptor = iWorkingSet.getImage();
            if (imageDescriptor == null) {
                return null;
            }
            Image image = (Image)this.fIcons.get(imageDescriptor);
            if (image == null) {
                image = imageDescriptor.createImage();
                this.fIcons.put(imageDescriptor, image);
            }
            return image;
        }

        public String getText(Object object) {
            Assert.isTrue((boolean)(object instanceof IWorkingSet));
            IWorkingSet iWorkingSet = (IWorkingSet)object;
            return iWorkingSet.getName();
        }
    }
}

