/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.launcher.ITestKind;
import org.eclipse.jdt.internal.junit.model.ITestRunSessionListener;
import org.eclipse.jdt.internal.junit.model.ITestSessionListener;
import org.eclipse.jdt.internal.junit.model.JUnitModel;
import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.internal.junit.ui.CounterPanel;
import org.eclipse.jdt.internal.junit.ui.FailureTrace;
import org.eclipse.jdt.internal.junit.ui.JUnitCopyAction;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.JUnitProgressBar;
import org.eclipse.jdt.internal.junit.ui.ProgressImages;
import org.eclipse.jdt.internal.junit.ui.ScrollLockAction;
import org.eclipse.jdt.internal.junit.ui.ShowNextFailureAction;
import org.eclipse.jdt.internal.junit.ui.ShowPreviousFailureAction;
import org.eclipse.jdt.internal.junit.ui.TestViewer;
import org.eclipse.jdt.internal.ui.viewsupport.ViewHistory;
import org.eclipse.jdt.junit.model.ITestElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.UIJob;

public class TestRunnerViewPart
extends ViewPart {
    public static final String NAME = "org.eclipse.jdt.junit.ResultView";
    private static final String RERUN_LAST_COMMAND = "org.eclipse.jdt.junit.junitShortcut.rerunLast";
    private static final String RERUN_FAILED_FIRST_COMMAND = "org.eclipse.jdt.junit.junitShortcut.rerunFailedFirst";
    static final int REFRESH_INTERVAL = 200;
    static final int LAYOUT_FLAT = 0;
    static final int LAYOUT_HIERARCHICAL = 1;
    protected boolean fAutoScroll = true;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    private int fLayout = 1;
    protected JUnitProgressBar fProgressBar;
    protected ProgressImages fProgressImages;
    protected Image fViewImage;
    protected CounterPanel fCounterPanel;
    protected boolean fShowOnErrorOnly = false;
    protected Clipboard fClipboard;
    protected volatile String fInfoMessage;
    private FailureTrace fFailureTrace;
    private TestViewer fTestViewer;
    private boolean fIsDisposed = false;
    private Action fNextAction;
    private Action fPreviousAction;
    private StopAction fStopAction;
    private JUnitCopyAction fCopyAction;
    private Action fRerunLastTestAction;
    private IHandlerActivation fRerunLastActivation;
    private Action fRerunFailedFirstAction;
    private IHandlerActivation fRerunFailedFirstActivation;
    private Action fFailuresOnlyFilterAction;
    private ScrollLockAction fScrollLockAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ShowTestHierarchyAction fShowTestHierarchyAction;
    private ActivateOnErrorAction fActivateOnErrorAction;
    private IMenuListener fViewMenuListener;
    private TestRunSession fTestRunSession;
    private TestSessionListener fTestSessionListener;
    private RunnerViewHistory fViewHistory;
    private TestRunSessionListener fTestRunSessionListener;
    final Image fStackViewIcon = TestRunnerViewPart.createImage("eview16/stackframe.gif");
    final Image fTestRunOKIcon = TestRunnerViewPart.createImage("eview16/junitsucc.gif");
    final Image fTestRunFailIcon = TestRunnerViewPart.createImage("eview16/juniterr.gif");
    final Image fTestRunOKDirtyIcon = TestRunnerViewPart.createImage("eview16/junitsuccq.gif");
    final Image fTestRunFailDirtyIcon = TestRunnerViewPart.createImage("eview16/juniterrq.gif");
    final Image fTestIcon = TestRunnerViewPart.createImage("obj16/test.gif");
    final Image fTestOkIcon = TestRunnerViewPart.createImage("obj16/testok.gif");
    final Image fTestErrorIcon = TestRunnerViewPart.createImage("obj16/testerr.gif");
    final Image fTestFailIcon = TestRunnerViewPart.createImage("obj16/testfail.gif");
    final Image fTestRunningIcon = TestRunnerViewPart.createImage("obj16/testrun.gif");
    final Image fTestIgnoredIcon = TestRunnerViewPart.createImage("obj16/testignored.gif");
    final ImageDescriptor fSuiteIconDescriptor = JUnitPlugin.getImageDescriptor("obj16/tsuite.gif");
    final ImageDescriptor fSuiteOkIconDescriptor = JUnitPlugin.getImageDescriptor("obj16/tsuiteok.gif");
    final ImageDescriptor fSuiteErrorIconDescriptor = JUnitPlugin.getImageDescriptor("obj16/tsuiteerror.gif");
    final ImageDescriptor fSuiteFailIconDescriptor = JUnitPlugin.getImageDescriptor("obj16/tsuitefail.gif");
    final ImageDescriptor fSuiteRunningIconDescriptor = JUnitPlugin.getImageDescriptor("obj16/tsuiterun.gif");
    final Image fSuiteIcon = this.fSuiteIconDescriptor.createImage();
    final Image fSuiteOkIcon = this.fSuiteOkIconDescriptor.createImage();
    final Image fSuiteErrorIcon = this.fSuiteErrorIconDescriptor.createImage();
    final Image fSuiteFailIcon = this.fSuiteFailIconDescriptor.createImage();
    final Image fSuiteRunningIcon = this.fSuiteRunningIconDescriptor.createImage();
    static final String TAG_PAGE = "page";
    static final String TAG_RATIO = "ratio";
    static final String TAG_TRACEFILTER = "tracefilter";
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SCROLL = "scroll";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_FAILURES_ONLY = "failuresOnly";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private IMemento fMemento;
    Image fOriginalViewImage;
    IElementChangedListener fDirtyListener;
    private SashForm fSashForm;
    private Composite fCounterComposite;
    private Composite fParent;
    private UpdateUIJob fUpdateJob;
    private JUnitIsRunningJob fJUnitIsRunningJob;
    private ILock fJUnitIsRunningLock;
    public static final Object FAMILY_JUNIT_RUN = new Object();
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestRunnerViewPart.this.getSite().getId().equals(ref.getId())) {
                TestRunnerViewPart.this.fPartIsVisible = false;
            }
        }
    };
    protected boolean fPartIsVisible = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_JUNIT_RUN);
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = iWorkbenchPartSite.getAdapter((Class)clazz)) != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        if (this.fSashForm == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        memento.putString(TAG_SCROLL, this.fScrollLockAction.isChecked() ? "true" : "false");
        int[] weigths = this.fSashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        memento.putString(TAG_FAILURES_ONLY, this.fFailuresOnlyFilterAction.isChecked() ? "true" : "false");
        memento.putInteger(TAG_LAYOUT, this.fLayout);
    }

    private void restoreLayoutState(IMemento memento) {
        Integer orientation;
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fSashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        String scrollLock = memento.getString(TAG_SCROLL);
        if (scrollLock != null) {
            this.fScrollLockAction.setChecked(scrollLock.equals("true"));
            this.setAutoScroll(!this.fScrollLockAction.isChecked());
        }
        Integer layout = memento.getInteger(TAG_LAYOUT);
        int layoutValue = 1;
        if (layout != null) {
            layoutValue = layout;
        }
        String failuresOnly = memento.getString(TAG_FAILURES_ONLY);
        boolean showFailuresOnly = false;
        if (failuresOnly != null) {
            showFailuresOnly = failuresOnly.equals("true");
        }
        this.setFilterAndLayout(showFailuresOnly, layoutValue);
    }

    public void stopTest() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                this.setContentDescription(JUnitMessages.TestRunnerViewPart_message_stopping);
            }
            this.fTestRunSession.stopTestRun();
        }
    }

    private void startUpdateJobs() {
        this.postSyncProcessChanges();
        if (this.fUpdateJob != null) {
            return;
        }
        this.fJUnitIsRunningJob = new JUnitIsRunningJob(JUnitMessages.TestRunnerViewPart_wrapperJobName);
        this.fJUnitIsRunningLock = Job.getJobManager().newLock();
        this.fJUnitIsRunningLock.acquire();
        this.getProgressService().schedule((Job)this.fJUnitIsRunningJob);
        this.fUpdateJob = new UpdateUIJob(JUnitMessages.TestRunnerViewPart_jobName);
        this.fUpdateJob.schedule(200L);
    }

    private void stopUpdateJobs() {
        if (this.fUpdateJob != null) {
            this.fUpdateJob.stop();
            this.fUpdateJob = null;
        }
        if (this.fJUnitIsRunningJob != null && this.fJUnitIsRunningLock != null) {
            this.fJUnitIsRunningLock.release();
            this.fJUnitIsRunningJob = null;
        }
        this.postSyncProcessChanges();
    }

    private void processChangesInUI() {
        if (this.fSashForm.isDisposed()) {
            return;
        }
        this.doShowInfoMessage();
        this.refreshCounters();
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        } else {
            this.updateViewIcon();
        }
        boolean hasErrorsOrFailures = this.hasErrorsOrFailures();
        this.fNextAction.setEnabled(hasErrorsOrFailures);
        this.fPreviousAction.setEnabled(hasErrorsOrFailures);
        this.fTestViewer.processChangesInUI();
    }

    public void rerunTestRun() {
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_terminate_title, (String)JUnitMessages.TestRunnerViewPart_terminate_message)) {
            this.stopTest();
        }
        if (this.fTestRunSession == null) {
            return;
        }
        ILaunch launch = this.fTestRunSession.getLaunch();
        if (launch == null) {
            return;
        }
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration == null) {
            return;
        }
        ILaunchConfiguration configuration = this.prepareLaunchConfigForRelaunch(launchConfiguration);
        DebugUITools.launch((ILaunchConfiguration)configuration, (String)launch.getLaunchMode());
    }

    private ILaunchConfiguration prepareLaunchConfigForRelaunch(ILaunchConfiguration configuration) {
        try {
            String attribute = configuration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
            if (attribute.length() != 0) {
                String configName = Messages.format(JUnitMessages.TestRunnerViewPart_configName, configuration.getName());
                ILaunchConfigurationWorkingCopy tmp = configuration.copy(configName);
                tmp.setAttribute("org.eclipse.jdt.junit.FAILURENAMES", "");
                return tmp;
            }
        }
        catch (CoreException coreException) {}
        return configuration;
    }

    public void rerunTestFailedFirst() {
        ILaunch launch;
        if (this.lastLaunchIsKeptAlive() && MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_terminate_title, (String)JUnitMessages.TestRunnerViewPart_terminate_message) && this.fTestRunSession != null) {
            this.fTestRunSession.stopTestRun();
        }
        if ((launch = this.fTestRunSession.getLaunch()) != null && launch.getLaunchConfiguration() != null) {
            ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
            if (launchConfiguration != null) {
                try {
                    String oldName = launchConfiguration.getName();
                    String oldFailuresFilename = launchConfiguration.getAttribute("org.eclipse.jdt.junit.FAILURENAMES", null);
                    String configName = oldFailuresFilename != null ? oldName : Messages.format(JUnitMessages.TestRunnerViewPart_rerunFailedFirstLaunchConfigName, oldName);
                    ILaunchConfigurationWorkingCopy tmp = launchConfiguration.copy(configName);
                    tmp.setAttribute("org.eclipse.jdt.junit.FAILURENAMES", this.createFailureNamesFile());
                    tmp.launch(launch.getLaunchMode(), null);
                    return;
                }
                catch (CoreException e) {
                    ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_error_cannotrerun, (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_cannotrerun_title, (String)JUnitMessages.TestRunnerViewPart_cannotrerurn_message);
        }
    }

    private String createFailureNamesFile() throws CoreException {
        try {
            File file = File.createTempFile("testFailures", ".txt");
            file.deleteOnExit();
            TestElement[] failures = this.fTestRunSession.getAllFailedTestElements();
            BufferedWriter bw = null;
            try {
                bw = new BufferedWriter(new FileWriter(file));
                int i = 0;
                while (i < failures.length) {
                    TestElement testElement = failures[i];
                    bw.write(testElement.getTestName());
                    bw.newLine();
                    ++i;
                }
            }
            finally {
                if (bw != null) {
                    bw.close();
                }
            }
            return file.getAbsolutePath();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.junit", 4, "", (Throwable)e));
        }
    }

    public void setAutoScroll(boolean scroll) {
        this.fAutoScroll = scroll;
    }

    public boolean isAutoScroll() {
        return this.fAutoScroll;
    }

    public void selectNextFailure() {
        this.fTestViewer.selectFailure(true);
    }

    public void selectPreviousFailure() {
        this.fTestViewer.selectFailure(false);
    }

    protected void selectFirstFailure() {
        this.fTestViewer.selectFirstFailure();
    }

    private boolean hasErrorsOrFailures() {
        return this.getErrorsPlusFailures() > 0;
    }

    private int getErrorsPlusFailures() {
        if (this.fTestRunSession == null) {
            return 0;
        }
        return this.fTestRunSession.getErrorCount() + this.fTestRunSession.getFailureCount();
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    private void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.resetViewIcon();
                TestRunnerViewPart.this.fStopAction.setEnabled(false);
                TestRunnerViewPart.this.updateRerunFailedFirstAction();
            }
        });
        this.stopUpdateJobs();
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    private void updateViewIcon() {
        this.fViewImage = this.fTestRunSession == null || this.fTestRunSession.isStopped() || this.fTestRunSession.isRunning() || this.fTestRunSession.getStartedCount() == 0 ? this.fOriginalViewImage : (this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon);
        this.firePropertyChange(1);
    }

    private void updateViewTitleProgress() {
        if (this.fTestRunSession != null) {
            if (this.fTestRunSession.isRunning()) {
                Image progress = this.fProgressImages.getImage(this.fTestRunSession.getStartedCount(), this.fTestRunSession.getTotalCount(), this.fTestRunSession.getErrorCount(), this.fTestRunSession.getFailureCount());
                if (progress != this.fViewImage) {
                    this.fViewImage = progress;
                    this.firePropertyChange(1);
                }
            } else {
                this.updateViewIcon();
            }
        } else {
            this.resetViewIcon();
        }
    }

    private TestRunSession setActiveTestRunSession(TestRunSession testRunSession) {
        if (this.fTestRunSession == testRunSession) {
            return null;
        }
        if (this.fTestRunSession != null && this.fTestSessionListener != null) {
            this.fTestRunSession.removeTestSessionListener(this.fTestSessionListener);
            this.fTestSessionListener = null;
        }
        TestRunSession deactivatedSession = this.fTestRunSession;
        this.fTestRunSession = testRunSession;
        this.fTestViewer.registerActiveSession(testRunSession);
        if (this.fSashForm.isDisposed()) {
            this.stopUpdateJobs();
            return deactivatedSession;
        }
        if (testRunSession == null) {
            this.setTitleToolTip(null);
            this.resetViewIcon();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(" ");
            this.stopUpdateJobs();
            this.fStopAction.setEnabled(false);
            this.fRerunFailedFirstAction.setEnabled(false);
            this.fRerunLastTestAction.setEnabled(false);
        } else {
            this.fTestSessionListener = new TestSessionListener();
            this.fTestRunSession.addTestSessionListener(this.fTestSessionListener);
            this.setTitleToolTip();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(this.fTestRunSession.getTestRunName());
            this.updateRerunFailedFirstAction();
            this.fRerunLastTestAction.setEnabled(this.fTestRunSession.getLaunch() != null);
            if (this.fTestRunSession.isRunning()) {
                this.startUpdateJobs();
                this.fStopAction.setEnabled(true);
            } else {
                this.stopUpdateJobs();
                this.fStopAction.setEnabled(this.fTestRunSession.isKeptAlive());
                this.fTestViewer.expandFirstLevel();
            }
        }
        return deactivatedSession;
    }

    private void updateRerunFailedFirstAction() {
        boolean state = this.isJUnit3() && this.hasErrorsOrFailures() && this.fTestRunSession.getLaunch() != null;
        this.fRerunFailedFirstAction.setEnabled(state);
    }

    private boolean isJUnit3() {
        if (this.fTestRunSession == null) {
            return true;
        }
        return "org.eclipse.jdt.junit.loader.junit3".equals(this.fTestRunSession.getTestRunnerKind().getId());
    }

    public String getTestKindDisplayName() {
        ITestKind kind = this.fTestRunSession.getTestRunnerKind();
        if (!kind.isNull()) {
            return kind.getDisplayName();
        }
        return null;
    }

    private void setTitleToolTip() {
        String testKindDisplayStr = this.getTestKindDisplayName();
        if (testKindDisplayStr != null) {
            this.setTitleToolTip(MessageFormat.format(JUnitMessages.TestRunnerViewPart_titleToolTip, this.fTestRunSession.getTestRunName(), testKindDisplayStr));
        } else {
            this.setTitleToolTip(this.fTestRunSession.getTestRunName());
        }
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        if (this.fTestRunSessionListener != null) {
            JUnitPlugin.getModel().removeTestRunSessionListener(this.fTestRunSessionListener);
        }
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchWindow.getService((Class)clazz);
        handlerService.deactivateHandler(this.fRerunLastActivation);
        handlerService.deactivateHandler(this.fRerunFailedFirstActivation);
        this.setActiveTestRunSession(null);
        if (this.fProgressImages != null) {
            this.fProgressImages.dispose();
        }
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.disposeImages();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
        if (this.fViewMenuListener != null) {
            this.getViewSite().getActionBars().getMenuManager().removeMenuListener(this.fViewMenuListener);
        }
    }

    private void disposeImages() {
        this.fTestRunOKIcon.dispose();
        this.fTestRunFailIcon.dispose();
        this.fStackViewIcon.dispose();
        this.fTestRunOKDirtyIcon.dispose();
        this.fTestRunFailDirtyIcon.dispose();
        this.fTestIcon.dispose();
        this.fTestRunningIcon.dispose();
        this.fTestOkIcon.dispose();
        this.fTestErrorIcon.dispose();
        this.fTestFailIcon.dispose();
        this.fTestIgnoredIcon.dispose();
        this.fSuiteIcon.dispose();
        this.fSuiteOkIcon.dispose();
        this.fSuiteRunningIcon.dispose();
        this.fSuiteErrorIcon.dispose();
        this.fSuiteFailIcon.dispose();
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void refreshCounters() {
        boolean stopped;
        boolean hasErrorsOrFailures;
        int failureCount;
        int errorCount;
        int totalCount;
        int ignoredCount;
        int startedCount;
        if (this.fTestRunSession != null) {
            startedCount = this.fTestRunSession.getStartedCount();
            ignoredCount = this.fTestRunSession.getIgnoredCount();
            totalCount = this.fTestRunSession.getTotalCount();
            errorCount = this.fTestRunSession.getErrorCount();
            hasErrorsOrFailures = errorCount + (failureCount = this.fTestRunSession.getFailureCount()) > 0;
            stopped = this.fTestRunSession.isStopped();
        } else {
            startedCount = 0;
            ignoredCount = 0;
            totalCount = 0;
            errorCount = 0;
            failureCount = 0;
            hasErrorsOrFailures = false;
            stopped = false;
        }
        this.fCounterPanel.setTotal(totalCount);
        this.fCounterPanel.setRunValue(startedCount, ignoredCount);
        this.fCounterPanel.setErrorValue(errorCount);
        this.fCounterPanel.setFailureValue(failureCount);
        int ticksDone = startedCount == 0 ? 0 : (startedCount == totalCount && !this.fTestRunSession.isRunning() ? totalCount : startedCount - 1);
        this.fProgressBar.reset(hasErrorsOrFailures, stopped, ticksDone, totalCount);
    }

    protected void postShowTestResultsView() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.showTestResultsView();
            }
        });
    }

    public void showTestResultsView() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        TestRunnerViewPart testRunner = null;
        if (page != null) {
            try {
                testRunner = (TestRunnerViewPart)page.findView(NAME);
                if (testRunner == null) {
                    IWorkbenchPart activePart = page.getActivePart();
                    testRunner = (TestRunnerViewPart)page.showView(NAME);
                    page.activate(activePart);
                } else {
                    page.bringToTop((IWorkbenchPart)testRunner);
                }
            }
            catch (PartInitException pie) {
                JUnitPlugin.log(pie);
            }
        }
    }

    protected void doShowInfoMessage() {
        if (this.fInfoMessage != null) {
            this.setContentDescription(this.fInfoMessage);
            this.fInfoMessage = null;
        }
    }

    protected void registerInfoMessage(String message) {
        this.fInfoMessage = message;
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTestViewer = new TestViewer((Composite)top, this.fClipboard, this);
        top.setContent(this.fTestViewer.getTestViewerControl());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText(JUnitMessages.TestRunnerViewPart_label_failure);
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)bottom, this.fClipboard, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        if (this.fTestViewer != null) {
            this.fTestViewer.getTestViewerControl().setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.fViewHistory = new RunnerViewHistory();
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new JUnitCopyAction(this.fFailureTrace, this.fClipboard);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fOriginalViewImage = this.getTitleImage();
        this.fProgressImages = new ProgressImages();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.junit.results_view_context");
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.setFilterAndLayout(false, 1);
        if (this.fMemento != null) {
            this.restoreLayoutState(this.fMemento);
        }
        this.fMemento = null;
        this.fTestRunSessionListener = new TestRunSessionListener();
        JUnitPlugin.getModel().addTestRunSessionListener(this.fTestRunSessionListener);
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestRunnerViewPart.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fNextAction = new ShowNextFailureAction(this);
        this.fNextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fPreviousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        this.fStopAction = new StopAction();
        this.fStopAction.setEnabled(false);
        this.fRerunLastTestAction = new RerunLastAction();
        IWorkbenchWindow iWorkbenchWindow = this.getSite().getWorkbenchWindow();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IHandlerService handlerService = (IHandlerService)iWorkbenchWindow.getService((Class)clazz);
        AbstractHandler handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.fRerunLastTestAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.fRerunLastTestAction.isEnabled();
            }
        };
        this.fRerunLastActivation = handlerService.activateHandler(RERUN_LAST_COMMAND, (IHandler)handler);
        this.fRerunFailedFirstAction = new RerunLastFailedFirstAction();
        handler = new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                TestRunnerViewPart.this.fRerunFailedFirstAction.run();
                return null;
            }

            public boolean isEnabled() {
                return TestRunnerViewPart.this.fRerunFailedFirstAction.isEnabled();
            }
        };
        this.fRerunFailedFirstActivation = handlerService.activateHandler(RERUN_FAILED_FIRST_COMMAND, (IHandler)handler);
        this.fFailuresOnlyFilterAction = new FailuresOnlyFilterAction();
        this.fScrollLockAction = new ScrollLockAction(this);
        this.fScrollLockAction.setChecked(!this.fAutoScroll);
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(this, 0), new ToggleOrientationAction(this, 1), new ToggleOrientationAction(this, 2)};
        this.fShowTestHierarchyAction = new ShowTestHierarchyAction();
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fFailuresOnlyFilterAction);
        toolBar.add((IAction)this.fScrollLockAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fRerunLastTestAction);
        toolBar.add((IAction)this.fRerunFailedFirstAction);
        toolBar.add((IAction)this.fStopAction);
        toolBar.add(this.fViewHistory.createHistoryDropDownAction());
        viewMenu.add((IAction)this.fShowTestHierarchyAction);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager(JUnitMessages.TestRunnerViewPart_layout_menu);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fFailuresOnlyFilterAction);
        this.fActivateOnErrorAction = new ActivateOnErrorAction();
        viewMenu.add((IAction)this.fActivateOnErrorAction);
        this.fViewMenuListener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TestRunnerViewPart.this.fActivateOnErrorAction.update();
            }
        };
        viewMenu.addMenuListener(this.fViewMenuListener);
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        this.fProgressBar = new JUnitProgressBar(composite);
        this.fProgressBar.setLayoutData(new GridData(768));
        return composite;
    }

    public void handleTestSelected(TestElement test) {
        this.showFailure(test);
        this.fCopyAction.handleTestSelected(test);
    }

    private void showFailure(final TestElement test) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestRunnerViewPart.this.isDisposed()) {
                    TestRunnerViewPart.this.fFailureTrace.showFailure(test);
                }
            }
        });
    }

    public IJavaProject getLaunchedProject() {
        return this.fTestRunSession == null ? null : this.fTestRunSession.getLaunchedProject();
    }

    public static Image createImage(String path) {
        return JUnitPlugin.getImageDescriptor(path).createImage();
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    void codeHasChanged() {
        if (this.fDirtyListener != null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this.fDirtyListener);
            this.fDirtyListener = null;
        }
        if (this.fViewImage == this.fTestRunOKIcon) {
            this.fViewImage = this.fTestRunOKDirtyIcon;
        } else if (this.fViewImage == this.fTestRunFailIcon) {
            this.fViewImage = this.fTestRunFailDirtyIcon;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (TestRunnerViewPart.this.isDisposed()) {
                    return;
                }
                TestRunnerViewPart.this.firePropertyChange(1);
            }
        };
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    public boolean isCreated() {
        return this.fCounterPanel != null;
    }

    public void rerunTest(String testId, String className, String testName, String launchMode) {
        DebugUITools.saveAndBuildBeforeLaunch();
        try {
            boolean couldLaunch = this.fTestRunSession.rerunTest(testId, className, testName, launchMode);
            if (!couldLaunch) {
                MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_cannotrerun_title, (String)JUnitMessages.TestRunnerViewPart_cannotrerurn_message);
            } else if (this.fTestRunSession.isKeptAlive()) {
                TestCaseElement testCaseElement = (TestCaseElement)this.fTestRunSession.getTestElement(testId);
                testCaseElement.setStatus(TestElement.Status.RUNNING, null, null, null);
                this.fTestViewer.registerViewerUpdate(testCaseElement);
                this.postSyncProcessChanges();
            }
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)JUnitMessages.TestRunnerViewPart_error_cannotrerun, (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    private void postSyncProcessChanges() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                TestRunnerViewPart.this.processChangesInUI();
            }
        });
    }

    public void warnOfContentChange() {
        IWorkbenchSiteProgressService service = this.getProgressService();
        if (service != null) {
            service.warnOfContentChange();
        }
    }

    public boolean lastLaunchIsKeptAlive() {
        return this.fTestRunSession != null && this.fTestRunSession.isKeptAlive();
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    private static boolean getShowOnErrorOnly() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.jdt.junit.show_on_error");
    }

    public FailureTrace getFailureTrace() {
        return this.fFailureTrace;
    }

    void setShowFailuresOnly(boolean failuresOnly) {
        this.setFilterAndLayout(failuresOnly, this.fLayout);
    }

    private void setLayoutMode(int mode) {
        this.setFilterAndLayout(this.fFailuresOnlyFilterAction.isChecked(), mode);
    }

    private void setFilterAndLayout(boolean failuresOnly, int layoutMode) {
        this.fShowTestHierarchyAction.setChecked(layoutMode == 1);
        this.fLayout = layoutMode;
        this.fFailuresOnlyFilterAction.setChecked(failuresOnly);
        this.fTestViewer.setShowFailuresOnly(failuresOnly, layoutMode);
    }

    TestElement[] getAllFailures() {
        return this.fTestRunSession.getAllFailedTestElements();
    }

    static /* synthetic */ boolean access$13(TestRunnerViewPart testRunnerViewPart) {
        return testRunnerViewPart.hasErrorsOrFailures();
    }

    private class ActivateOnErrorAction
    extends Action {
        public ActivateOnErrorAction() {
            super(JUnitMessages.TestRunnerViewPart_activate_on_failure_only, 2);
            this.update();
        }

        public void update() {
            this.setChecked(TestRunnerViewPart.getShowOnErrorOnly());
        }

        public void run() {
            boolean checked;
            TestRunnerViewPart.this.fShowOnErrorOnly = checked = this.isChecked();
            IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.jdt.junit.show_on_error", checked);
        }
    }

    private class ClearAction
    extends Action {
        public ClearAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_clear_history_label);
            boolean enabled = false;
            List testRunSessions = JUnitPlugin.getModel().getTestRunSessions();
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                TestRunSession testRunSession = (TestRunSession)iter.next();
                if (testRunSession.isRunning()) continue;
                enabled = true;
                break;
            }
            this.setEnabled(enabled);
        }

        public void run() {
            List testRunSessions = this.getRunningSessions();
            Object first = testRunSessions.isEmpty() ? null : testRunSessions.get(0);
            TestRunnerViewPart.this.fViewHistory.setHistoryEntries(testRunSessions, first);
        }

        private List getRunningSessions() {
            List testRunSessions = JUnitPlugin.getModel().getTestRunSessions();
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                TestRunSession testRunSession = (TestRunSession)iter.next();
                if (testRunSession.isRunning()) continue;
                iter.remove();
            }
            return testRunSessions;
        }
    }

    private class DirtyListener
    implements IElementChangedListener {
        private DirtyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    TestRunnerViewPart.this.codeHasChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private static class ExportTestRunSessionAction
    extends Action {
        private final TestRunSession fTestRunSession;
        private final Shell fShell;

        public ExportTestRunSessionAction(Shell shell, TestRunSession testRunSession) {
            super(JUnitMessages.TestRunnerViewPart_ExportTestRunSessionAction_name);
            this.fShell = shell;
            this.fTestRunSession = testRunSession;
        }

        public void run() {
            FileDialog exportDialog = new FileDialog(this.fShell, 8192);
            exportDialog.setText(JUnitMessages.TestRunnerViewPart_ExportTestRunSessionAction_title);
            exportDialog.setFileName(this.getFileName());
            exportDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
            String path = exportDialog.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            try {
                JUnitModel.exportTestRunSession(this.fTestRunSession, file);
            }
            catch (CoreException e) {
                JUnitPlugin.log(e);
                ErrorDialog.openError((Shell)this.fShell, (String)JUnitMessages.TestRunnerViewPart_ExportTestRunSessionAction_error_title, (String)e.getStatus().getMessage(), (IStatus)e.getStatus());
            }
        }

        private String getFileName() {
            String testRunName = this.fTestRunSession.getTestRunName();
            long startTime = this.fTestRunSession.getStartTime();
            if (startTime == 0L) {
                return testRunName;
            }
            String isoTime = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date(startTime));
            return String.valueOf(testRunName) + " " + isoTime + ".xml";
        }
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super(JUnitMessages.TestRunnerViewPart_show_failures_only, 2);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_show_failures_only);
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("obj16/failures.gif"));
        }

        public void run() {
            TestRunnerViewPart.this.setShowFailuresOnly(this.isChecked());
        }
    }

    private static class ImportTestRunSessionAction
    extends Action {
        private final Shell fShell;

        public ImportTestRunSessionAction(Shell shell) {
            super(JUnitMessages.TestRunnerViewPart_ImportTestRunSessionAction_name);
            this.fShell = shell;
        }

        public void run() {
            FileDialog importDialog = new FileDialog(this.fShell, 4096);
            importDialog.setText(JUnitMessages.TestRunnerViewPart_ImportTestRunSessionAction_title);
            importDialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
            String path = importDialog.open();
            if (path == null) {
                return;
            }
            File file = new File(path);
            try {
                JUnitModel.importTestRunSession(file);
            }
            catch (CoreException e) {
                JUnitPlugin.log(e);
                ErrorDialog.openError((Shell)this.fShell, (String)JUnitMessages.TestRunnerViewPart_ImportTestRunSessionAction_error_title, (String)e.getStatus().getMessage(), (IStatus)e.getStatus());
            }
        }
    }

    private class JUnitIsRunningJob
    extends Job {
        public JUnitIsRunningJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus run(IProgressMonitor monitor) {
            TestRunnerViewPart.this.fJUnitIsRunningLock.acquire();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY_JUNIT_RUN;
        }
    }

    private class RerunLastAction
    extends Action {
        public RerunLastAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_rerunaction_label);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_rerunaction_tooltip);
            JUnitPlugin.setLocalImageDescriptors((IAction)this, "relaunch.gif");
            this.setEnabled(false);
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_LAST_COMMAND);
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestRun();
        }
    }

    private class RerunLastFailedFirstAction
    extends Action {
        public RerunLastFailedFirstAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_rerunfailuresaction_label);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_rerunfailuresaction_tooltip);
            JUnitPlugin.setLocalImageDescriptors((IAction)this, "relaunchf.gif");
            this.setEnabled(false);
            this.setActionDefinitionId(TestRunnerViewPart.RERUN_FAILED_FIRST_COMMAND);
        }

        public void run() {
            TestRunnerViewPart.this.rerunTestFailedFirst();
        }
    }

    private class RunnerViewHistory
    extends ViewHistory {
        private RunnerViewHistory() {
        }

        public void configureHistoryListAction(IAction action) {
            action.setText(JUnitMessages.TestRunnerViewPart_history);
        }

        public void configureHistoryDropDownAction(IAction action) {
            action.setToolTipText(JUnitMessages.TestRunnerViewPart_test_run_history);
            JUnitPlugin.setLocalImageDescriptors(action, "history_list.gif");
        }

        public Action getClearAction() {
            return new ClearAction();
        }

        public String getHistoryListDialogTitle() {
            return JUnitMessages.TestRunnerViewPart_test_runs;
        }

        public String getHistoryListDialogMessage() {
            return JUnitMessages.TestRunnerViewPart_select_test_run;
        }

        public Shell getShell() {
            return TestRunnerViewPart.this.fParent.getShell();
        }

        public List getHistoryEntries() {
            return JUnitPlugin.getModel().getTestRunSessions();
        }

        public Object getCurrentEntry() {
            return TestRunnerViewPart.this.fTestRunSession;
        }

        public void setActiveEntry(Object entry) {
            TestRunSession deactivatedSession = TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)entry);
            if (deactivatedSession != null) {
                deactivatedSession.swapOut();
            }
        }

        public void setHistoryEntries(List remainingEntries, Object activeEntry) {
            TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)activeEntry);
            List testRunSessions = JUnitPlugin.getModel().getTestRunSessions();
            testRunSessions.removeAll(remainingEntries);
            Iterator iter = testRunSessions.iterator();
            while (iter.hasNext()) {
                JUnitPlugin.getModel().removeTestRunSession((TestRunSession)iter.next());
            }
            iter = remainingEntries.iterator();
            while (iter.hasNext()) {
                TestRunSession remaining = (TestRunSession)iter.next();
                remaining.swapOut();
            }
        }

        public ImageDescriptor getImageDescriptor(Object element) {
            TestRunSession session = (TestRunSession)element;
            if (session.isStopped()) {
                return TestRunnerViewPart.this.fSuiteIconDescriptor;
            }
            if (session.isRunning()) {
                return TestRunnerViewPart.this.fSuiteRunningIconDescriptor;
            }
            ITestElement.Result result = session.getTestResult(true);
            if (result == ITestElement.Result.OK) {
                return TestRunnerViewPart.this.fSuiteOkIconDescriptor;
            }
            if (result == ITestElement.Result.ERROR) {
                return TestRunnerViewPart.this.fSuiteErrorIconDescriptor;
            }
            if (result == ITestElement.Result.FAILURE) {
                return TestRunnerViewPart.this.fSuiteFailIconDescriptor;
            }
            return TestRunnerViewPart.this.fSuiteIconDescriptor;
        }

        public String getText(Object element) {
            TestRunSession session = (TestRunSession)element;
            if (session.getStartTime() == 0L) {
                return session.getTestRunName();
            }
            String startTime = DateFormat.getDateTimeInstance().format(new Date(session.getStartTime()));
            return Messages.format(JUnitMessages.TestRunnerViewPart_testName_startTime, new Object[]{session.getTestRunName(), startTime});
        }

        public void addMenuEntries(MenuManager manager) {
            manager.appendToGroup("additions", (IAction)new ImportTestRunSessionAction(TestRunnerViewPart.this.fParent.getShell()));
            if (TestRunnerViewPart.this.fTestRunSession != null) {
                manager.appendToGroup("additions", (IAction)new ExportTestRunSessionAction(TestRunnerViewPart.this.fParent.getShell(), TestRunnerViewPart.this.fTestRunSession));
            }
        }

        public String getMaxEntriesMessage() {
            return JUnitMessages.TestRunnerViewPart_max_remembered;
        }

        public int getMaxEntries() {
            IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
            return store.getInt("org.eclipse.jdt.junit.max_test_runs");
        }

        public void setMaxEntries(int maxEntries) {
            IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
            store.setValue("org.eclipse.jdt.junit.max_test_runs", maxEntries);
        }
    }

    private class ShowTestHierarchyAction
    extends Action {
        public ShowTestHierarchyAction() {
            super(JUnitMessages.TestRunnerViewPart_hierarchical_layout, 2);
            this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/hierarchicalLayout.gif"));
        }

        public void run() {
            int mode = this.isChecked() ? 1 : 0;
            TestRunnerViewPart.this.setLayoutMode(mode);
        }
    }

    private class StopAction
    extends Action {
        public StopAction() {
            this.setText(JUnitMessages.TestRunnerViewPart_stopaction_text);
            this.setToolTipText(JUnitMessages.TestRunnerViewPart_stopaction_tooltip);
            JUnitPlugin.setLocalImageDescriptors((IAction)this, "stop.gif");
        }

        public void run() {
            TestRunnerViewPart.this.stopTest();
            this.setEnabled(false);
        }
    }

    private class TestRunSessionListener
    implements ITestRunSessionListener {
        private TestRunSessionListener() {
        }

        public void sessionAdded(TestRunSession testRunSession) {
            if (TestRunnerViewPart.this.getSite().getWorkbenchWindow() == JUnitPlugin.getActiveWorkbenchWindow()) {
                TestRunSession deactivatedSession = TestRunnerViewPart.this.setActiveTestRunSession(testRunSession);
                if (deactivatedSession != null) {
                    deactivatedSession.swapOut();
                }
                String testRunName = TestRunnerViewPart.this.fTestRunSession.getTestRunName();
                String msg = testRunSession.getLaunch() != null ? Messages.format(JUnitMessages.TestRunnerViewPart_Launching, new Object[]{testRunName}) : testRunName;
                TestRunnerViewPart.this.setContentDescription(msg);
            }
        }

        public void sessionRemoved(TestRunSession testRunSession) {
            List testRunSessions;
            TestRunSession deactivatedSession;
            if (testRunSession.equals(TestRunnerViewPart.this.fTestRunSession) && (deactivatedSession = !(testRunSessions = JUnitPlugin.getModel().getTestRunSessions()).isEmpty() ? TestRunnerViewPart.this.setActiveTestRunSession((TestRunSession)testRunSessions.get(0)) : TestRunnerViewPart.this.setActiveTestRunSession(null)) != null) {
                deactivatedSession.swapOut();
            }
        }
    }

    private class TestSessionListener
    implements ITestSessionListener {
        private TestSessionListener() {
        }

        public void sessionStarted() {
            TestRunnerViewPart.this.fTestViewer.registerViewersRefresh();
            TestRunnerViewPart.this.fShowOnErrorOnly = TestRunnerViewPart.getShowOnErrorOnly();
            TestRunnerViewPart.this.startUpdateJobs();
            TestRunnerViewPart.this.fStopAction.setEnabled(true);
            TestRunnerViewPart.this.fRerunLastTestAction.setEnabled(true);
        }

        public void sessionEnded(long elapsedTime) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            Object[] keys = new String[]{TestRunnerViewPart.this.elapsedTimeAsString(elapsedTime)};
            String msg = Messages.format(JUnitMessages.TestRunnerViewPart_message_finish, keys);
            TestRunnerViewPart.this.registerInfoMessage(msg);
            TestRunnerViewPart.this.postSyncRunnable(new Runnable(this){
                final /* synthetic */ TestSessionListener this$1;
                {
                    this.this$1 = testSessionListener;
                }

                public void run() {
                    if (TestRunnerViewPart.access$10(TestSessionListener.access$1(this.this$1))) {
                        return;
                    }
                    TestRunnerViewPart.access$7(TestSessionListener.access$1(this.this$1)).setEnabled(TestSessionListener.access$1(this.this$1).lastLaunchIsKeptAlive());
                    TestRunnerViewPart.access$11(TestSessionListener.access$1(this.this$1));
                    TestRunnerViewPart.access$12(TestSessionListener.access$1(this.this$1));
                    if (TestRunnerViewPart.access$13(TestSessionListener.access$1(this.this$1))) {
                        TestSessionListener.access$1(this.this$1).selectFirstFailure();
                    }
                    if (TestSessionListener.access$1((TestSessionListener)this.this$1).fDirtyListener == null) {
                        TestSessionListener.access$1((TestSessionListener)this.this$1).fDirtyListener = TestSessionListener.access$1(this.this$1).new DirtyListener();
                        JavaCore.addElementChangedListener((IElementChangedListener)TestSessionListener.access$1((TestSessionListener)this.this$1).fDirtyListener);
                    }
                    TestSessionListener.access$1(this.this$1).warnOfContentChange();
                }
            });
            TestRunnerViewPart.this.stopUpdateJobs();
        }

        public void sessionStopped(long elapsedTime) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            TestRunnerViewPart.this.registerInfoMessage(JUnitMessages.TestRunnerViewPart_message_stopped);
            TestRunnerViewPart.this.handleStopped();
        }

        public void sessionTerminated() {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(null);
            TestRunnerViewPart.this.registerInfoMessage(JUnitMessages.TestRunnerViewPart_message_terminated);
            TestRunnerViewPart.this.handleStopped();
        }

        public void runningBegins() {
            if (!TestRunnerViewPart.this.fShowOnErrorOnly) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        public void testStarted(TestCaseElement testCaseElement) {
            TestRunnerViewPart.this.fTestViewer.registerAutoScrollTarget(testCaseElement);
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
            String className = testCaseElement.getClassName();
            String method = testCaseElement.getTestMethodName();
            String status = Messages.format(JUnitMessages.TestRunnerViewPart_message_started, new String[]{className, method});
            TestRunnerViewPart.this.registerInfoMessage(status);
        }

        public void testFailed(TestElement testElement, TestElement.Status status, String trace, String expected, String actual) {
            if (TestRunnerViewPart.this.isAutoScroll()) {
                TestRunnerViewPart.this.fTestViewer.registerFailedForAutoScroll(testElement);
            }
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testElement);
            if (TestRunnerViewPart.this.fShowOnErrorOnly && TestRunnerViewPart.this.getErrorsPlusFailures() == 1) {
                TestRunnerViewPart.this.postShowTestResultsView();
            }
        }

        public void testEnded(TestCaseElement testCaseElement) {
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
        }

        public void testReran(TestCaseElement testCaseElement, TestElement.Status status, String trace, String expectedResult, String actualResult) {
            TestRunnerViewPart.this.fTestViewer.registerViewerUpdate(testCaseElement);
            TestRunnerViewPart.this.postSyncProcessChanges();
            TestRunnerViewPart.this.showFailure(testCaseElement);
        }

        public void testAdded(TestElement testElement) {
            TestRunnerViewPart.this.fTestViewer.registerTestAdded(testElement);
        }

        public boolean acceptsSwapToDisk() {
            return false;
        }

        static /* synthetic */ TestRunnerViewPart access$1(TestSessionListener testSessionListener) {
            return testSessionListener.TestRunnerViewPart.this;
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(TestRunnerViewPart v, int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_horizontal_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_vertical_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText(JUnitMessages.TestRunnerViewPart_toggle_automatic_label);
                this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.junit.results_view_toggle_call_mode_action_context");
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestRunnerViewPart.this.fOrientation = this.fActionOrientation;
                TestRunnerViewPart.this.computeOrientation();
            }
        }
    }

    private class UpdateUIJob
    extends UIJob {
        private boolean fRunning = true;

        public UpdateUIJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (!TestRunnerViewPart.this.isDisposed()) {
                TestRunnerViewPart.this.processChangesInUI();
            }
            this.schedule(200L);
            return Status.OK_STATUS;
        }

        public void stop() {
            this.fRunning = false;
        }

        public boolean shouldSchedule() {
            return this.fRunning;
        }
    }
}

