/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.page;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jst.jsf.facesconfig.emf.ApplicationType;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.emf.FactoryType;
import org.eclipse.jst.jsf.facesconfig.emf.LifecycleType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.FacesConfigEditor;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.ApplicationSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.FactorySection;
import org.eclipse.jst.jsf.facesconfig.ui.section.LifecycleSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.LocaleConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.OthersPageBaseSection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class OthersPage
extends FormPage
implements IFacesConfigPage,
ISelectionProvider,
ISelectionChangedListener,
IEditingDomainProvider {
    public static final String PAGE_ID = "org.eclipse.jst.jsf.facesconfig.ui.page.OthersPage";
    private static final Image BANNER_IMAGE = EditorPlugin.getDefault().getImage("form_banner.gif");
    private List leftSections;
    private List rightSections;
    private Object input;
    private List selectionChangedListeners = new ArrayList();
    private IPropertySheetPage propertySheetPage;
    private IContentOutlinePage contentOutlinePage;
    private ISelection currentSelection;

    public OthersPage(FacesConfigEditor editor) {
        super((FormEditor)editor, "OthersPage", EditorMessages.FacesConfigEditor_Others_TabName);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setText(EditorMessages.OthersPage_Title);
        form.setBackgroundImage(BANNER_IMAGE);
        this.fillBody(managedForm, managedForm.getToolkit());
        managedForm.refresh();
    }

    private void initSection(OthersPageBaseSection section, String name, String description, ArrayList list) {
        section.getSection().setText(name);
        section.getSection().setDescription(description);
        section.initialize();
        section.addSelectionChangedListener(this);
        section.getSection().setExpanded(false);
        section.getSection().setLayoutData((Object)new GridData(768));
        list.add(section);
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)new GridLayout());
        SashForm sashForm = new SashForm(body, 0);
        managedForm.getToolkit().adapt((Control)sashForm, false, false);
        sashForm.setMenu(body.getMenu());
        sashForm.setLayoutData((Object)new GridData(1808));
        Composite leftContainer = toolkit.createComposite((Composite)sashForm);
        leftContainer.setLayout((Layout)new GridLayout());
        ArrayList sectionList = new ArrayList();
        OthersPageBaseSection section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getActionListenerType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.ActionListenerSection_Name, EditorMessages.ActionListenerSection_Description, sectionList);
        section.getSection().setLayoutData((Object)new GridData(1808));
        section.getSection().setExpanded(true);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.DefaultRenderKitIDSection_Name, EditorMessages.DefaultRenderKitIDSection_Description, sectionList);
        section = new LocaleConfigSection(FacesConfigPackage.eINSTANCE.getSupportedLocaleType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.LocaleConfigSection_Name, EditorMessages.LocaleConfigSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getMessageBundleType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.MessageBundleSection_Name, EditorMessages.MessageBundleSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getNavigationHandlerType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.NavigationHandlerSection_Name, EditorMessages.NavigationHandlerSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getPropertyResolverType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.PropertyResolverSection_Name, EditorMessages.PropertyResolverSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getStateManagerType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.StateManagerSection_Name, EditorMessages.StateManagerSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getVariableResolverType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.VariableResolverSection_Name, EditorMessages.VariableResolverSection_Description, sectionList);
        section = new ApplicationSection(FacesConfigPackage.eINSTANCE.getViewHandlerType(), leftContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.ViewHandlerSection_Name, EditorMessages.ViewHandlerSection_Description, sectionList);
        this.leftSections = sectionList;
        sectionList = new ArrayList();
        Composite rightContainer = toolkit.createComposite((Composite)sashForm);
        rightContainer.setLayout((Layout)new GridLayout());
        rightContainer.setLayoutData((Object)new GridData(1808));
        section = new FactorySection(FacesConfigPackage.eINSTANCE.getApplicationFactoryType(), rightContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.ApplicationFactorySection_Name, EditorMessages.ApplicationFactorySection_Description, sectionList);
        section.getSection().setLayoutData((Object)new GridData(1808));
        section.getSection().setExpanded(true);
        section = new FactorySection(FacesConfigPackage.eINSTANCE.getFacesContextFactoryType(), rightContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.FacesContextFactorySection_Name, EditorMessages.FacesContextFactorySection_Description, sectionList);
        section = new FactorySection(FacesConfigPackage.eINSTANCE.getLifecycleFactoryType(), rightContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.LifecycleFactorySection_Name, EditorMessages.LifecycleFactorySection_Description, sectionList);
        section = new FactorySection(FacesConfigPackage.eINSTANCE.getRenderKitFactoryType(), rightContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.RenderKitFactorySection_Name, EditorMessages.RenderKitFactorySection_Description, sectionList);
        section = new LifecycleSection(FacesConfigPackage.eINSTANCE.getPhaseListenerType(), rightContainer, managedForm, this, toolkit);
        this.initSection(section, EditorMessages.PhaseListenerSection_Name, EditorMessages.PhaseListenerSection_Description, sectionList);
        this.rightSections = sectionList;
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            if (this.getInput() != ((FacesConfigEditor)this.getEditor()).getFacesConfig()) {
                this.setInput(((FacesConfigEditor)this.getEditor()).getFacesConfig());
            } else {
                this.refresh();
            }
        }
    }

    public void setInput(Object input) {
        if (input instanceof FacesConfigType) {
            this.input = input;
            FacesConfigType facesConfig = (FacesConfigType)input;
            facesConfig.eAdapters().add((Object)new FacesConfigOthersAdapter());
            this.setInputForApplicationSections(facesConfig);
            this.setInputForFactorySections(facesConfig);
            this.setInputForLifecycleSections(facesConfig);
        }
    }

    public boolean isEditor() {
        return true;
    }

    public void resetApplicationInput() {
        if (this.getInput() instanceof FacesConfigType) {
            this.setInputForApplicationSections((FacesConfigType)this.getInput());
        }
    }

    public void resetFactoryInput() {
        if (this.getInput() instanceof FacesConfigType) {
            this.setInputForFactorySections((FacesConfigType)this.getInput());
        }
    }

    public void resetLifecycleInput() {
        if (this.getInput() instanceof FacesConfigType) {
            this.setInputForLifecycleSections((FacesConfigType)this.getInput());
        }
    }

    protected void setInputForApplicationSections(FacesConfigType facesConfig) {
        ApplicationType application = facesConfig.getApplication().size() > 0 ? (ApplicationType)facesConfig.getApplication().get(0) : null;
        for (ApplicationSection section : this.leftSections) {
            section.setInput(application);
        }
    }

    protected void setInputForFactorySections(FacesConfigType facesConfig) {
        FactoryType factory = facesConfig.getFactory().size() > 0 ? (FactoryType)facesConfig.getFactory().get(0) : null;
        for (Object section : this.rightSections) {
            if (!(section instanceof FactorySection)) continue;
            ((FactorySection)section).setInput(factory);
        }
    }

    protected void setInputForLifecycleSections(FacesConfigType facesConfig) {
        LifecycleType lifecycle = facesConfig.getLifecycle().size() > 0 ? (LifecycleType)facesConfig.getLifecycle().get(0) : null;
        for (Object section : this.rightSections) {
            if (!(section instanceof LifecycleSection)) continue;
            ((LifecycleSection)section).setInput(lifecycle);
        }
    }

    public Object getInput() {
        return this.input;
    }

    public void refresh() {
        OthersPageBaseSection section;
        int i = 0;
        int n = this.leftSections.size();
        while (i < n) {
            section = (OthersPageBaseSection)this.leftSections.get(i);
            if (section.getSection().isExpanded()) {
                section.refresh();
            }
            ++i;
        }
        i = 0;
        n = this.rightSections.size();
        while (i < n) {
            section = (OthersPageBaseSection)this.leftSections.get(i);
            if (section.getSection().isExpanded()) {
                section.refresh();
            }
            ++i;
        }
    }

    public void closeOtherSections(AbstractFacesConfigSection section) {
        OthersPageBaseSection[] sections = this.leftSections.contains(section) ? this.leftSections.toArray(new OthersPageBaseSection[this.leftSections.size()]) : this.rightSections.toArray(new OthersPageBaseSection[this.rightSections.size()]);
        int i = 0;
        int n = sections.length;
        while (i < n) {
            OthersPageBaseSection aSection = sections[i];
            if (aSection != section && aSection.getSection().isExpanded()) {
                aSection.getSection().setExpanded(false);
                GridData gd = new GridData(768);
                aSection.getSection().setLayoutData((Object)gd);
            }
            ++i;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public ISelection getSelection() {
        if (this.currentSelection != null) {
            return this.currentSelection;
        }
        return StructuredSelection.EMPTY;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        OthersPageBaseSection source;
        this.currentSelection = event.getSelection();
        if (event.getSource() instanceof OthersPageBaseSection && (source = (OthersPageBaseSection)event.getSource()).getSection().isExpanded()) {
            int i = 0;
            int n = this.selectionChangedListeners.size();
            while (i < n) {
                ((ISelectionChangedListener)this.selectionChangedListeners.get(i)).selectionChanged(event);
                ++i;
            }
        }
    }

    protected OthersPageBaseSection getActiveSection() {
        OthersPageBaseSection section;
        int i = 0;
        int n = this.leftSections.size();
        while (i < n) {
            section = (OthersPageBaseSection)this.leftSections.get(i);
            if (section.getSection().isExpanded()) {
                return section;
            }
            ++i;
        }
        i = 0;
        n = this.rightSections.size();
        while (i < n) {
            section = (OthersPageBaseSection)this.leftSections.get(i);
            if (section.getSection().isExpanded()) {
                return section;
            }
            ++i;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        return super.getAdapter(adapter);
    }

    private IPropertySheetPage getPropertySheetPage() {
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)this.getEditor().getAdapter(EditingDomain.class);
        AdapterFactory adapterFactory = (AdapterFactory)this.getEditor().getAdapter(AdapterFactory.class);
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new ExtendedPropertySheetPage(editingDomain){

                public void setSelectionToViewer(List selection) {
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                }
            };
            ((ExtendedPropertySheetPage)this.propertySheetPage).setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(adapterFactory));
        }
        return this.propertySheetPage;
    }

    private IContentOutlinePage getOutlinePage() {
        if (this.contentOutlinePage == null) {
            class OthersContentOutlinePage
            extends ContentOutlinePage {
                OthersContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    TreeViewer contentOutlineViewer = this.getTreeViewer();
                    contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    AdapterFactory adapterFactory = (AdapterFactory)OthersPage.this.getEditor().getAdapter(AdapterFactory.class);
                    contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(adapterFactory));
                    contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(adapterFactory));
                    contentOutlineViewer.addFilter(new ViewerFilter(){

                        public boolean select(Viewer viewer, Object parentElement, Object element) {
                            return FacesConfigPackage.eINSTANCE.getApplicationType().isInstance(element) || FacesConfigPackage.eINSTANCE.getFactoryType().isInstance(element) || FacesConfigPackage.eINSTANCE.getLifecycleType().isInstance(element) || FacesConfigPackage.eINSTANCE.getActionListenerType().isInstance(element) || FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType().isInstance(element) || FacesConfigPackage.eINSTANCE.getLocaleConfigType().isInstance(element) || FacesConfigPackage.eINSTANCE.getDefaultLocaleType().isInstance(element) || FacesConfigPackage.eINSTANCE.getSupportedLocaleType().isInstance(element) || FacesConfigPackage.eINSTANCE.getMessageBundleType().isInstance(element) || FacesConfigPackage.eINSTANCE.getNavigationHandlerType().isInstance(element) || FacesConfigPackage.eINSTANCE.getPropertyResolverType().isInstance(element) || FacesConfigPackage.eINSTANCE.getStateManagerType().isInstance(element) || FacesConfigPackage.eINSTANCE.getVariableResolverType().isInstance(element) || FacesConfigPackage.eINSTANCE.getViewHandlerType().isInstance(element) || FacesConfigPackage.eINSTANCE.getApplicationFactoryType().isInstance(element) || FacesConfigPackage.eINSTANCE.getFacesContextFactoryType().isInstance(element) || FacesConfigPackage.eINSTANCE.getLifecycleFactoryType().isInstance(element) || FacesConfigPackage.eINSTANCE.getRenderKitFactoryType().isInstance(element) || FacesConfigPackage.eINSTANCE.getPhaseListenerType().isInstance(element);
                        }
                    });
                    contentOutlineViewer.setSorter(new ViewerSorter());
                    contentOutlineViewer.setInput(OthersPage.this.getInput());
                }
            }
            this.contentOutlinePage = new OthersContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    OthersPage.this.setSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.isEmpty()) {
                return;
            }
            EObject object = (EObject)ss.getFirstElement();
            OthersPageBaseSection section = null;
            if (FacesConfigPackage.eINSTANCE.getActionListenerType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(0);
            } else if (FacesConfigPackage.eINSTANCE.getDefaultRenderKitIdType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(1);
            } else if (FacesConfigPackage.eINSTANCE.getLocaleConfigType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(2);
            } else if (FacesConfigPackage.eINSTANCE.getDefaultLocaleType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(2);
            } else if (FacesConfigPackage.eINSTANCE.getSupportedLocaleType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(2);
            } else if (FacesConfigPackage.eINSTANCE.getMessageBundleType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(3);
            } else if (FacesConfigPackage.eINSTANCE.getNavigationHandlerType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(4);
            } else if (FacesConfigPackage.eINSTANCE.getPropertyResolverType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(5);
            } else if (FacesConfigPackage.eINSTANCE.getStateManagerType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(6);
            } else if (FacesConfigPackage.eINSTANCE.getVariableResolverType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(7);
            } else if (FacesConfigPackage.eINSTANCE.getViewHandlerType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.leftSections.get(8);
            } else if (FacesConfigPackage.eINSTANCE.getApplicationFactoryType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.rightSections.get(0);
            } else if (FacesConfigPackage.eINSTANCE.getFacesContextFactoryType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.rightSections.get(1);
            } else if (FacesConfigPackage.eINSTANCE.getLifecycleFactoryType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.rightSections.get(2);
            } else if (FacesConfigPackage.eINSTANCE.getRenderKitFactoryType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.rightSections.get(3);
            } else if (FacesConfigPackage.eINSTANCE.getPhaseListenerType().isInstance((Object)object)) {
                section = (OthersPageBaseSection)this.rightSections.get(4);
            }
            if (section != null) {
                if (!section.getSection().isExpanded()) {
                    this.closeOtherSections(section);
                    GridData gd = new GridData(1808);
                    section.getSection().setLayoutData((Object)gd);
                    section.getSection().setExpanded(true);
                }
                StructuredSelection newselection = new StructuredSelection((Object)object);
                section.getTableViewer().setSelection((ISelection)newselection);
            }
        }
    }

    public EditingDomain getEditingDomain() {
        return ((FacesConfigEditor)this.getEditor()).getEditingDomain();
    }

    class FacesConfigOthersAdapter
    extends AdapterImpl {
        FacesConfigOthersAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (msg.getEventType() == 4 || msg.getEventType() == 3) {
                if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getFacesConfigType_Application()) {
                    OthersPage.this.resetApplicationInput();
                } else if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getFacesConfigType_Factory()) {
                    OthersPage.this.resetFactoryInput();
                } else if (msg.getFeature() == FacesConfigPackage.eINSTANCE.getFacesConfigType_Lifecycle()) {
                    OthersPage.this.resetLifecycleInput();
                }
            }
        }
    }
}

