/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.ws.internal.common.J2EEActionAdapterFactory;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.Arguments;
import org.eclipse.jst.ws.internal.consumption.ui.wsil.TableViewerEditor;
import org.eclipse.jst.ws.internal.ui.common.DialogResourceBrowser;
import org.eclipse.jst.ws.internal.ui.common.FileExtensionFilter;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;
import org.eclipse.wst.wsdl.internal.impl.ServiceImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class ImportWSILWidget
extends SimpleWidgetDataContributor {
    private final String INFOPOP_WSIL_IMPORT_PAGE = "org.eclipse.jst.ws.consumption.ui.WSIL0001";
    private final String INFOPOP_WSIL_TEXT_WSIL = "org.eclipse.jst.ws.consumption.ui.WSIL0002";
    private final String INFOPOP_WSIL_BUTTON_BROWSE_WSIL = "org.eclipse.jst.ws.consumption.ui.WSIL0003";
    private final String INFOPOP_WSIL_TABLE_WSDL = "org.eclipse.jst.ws.consumption.ui.WSIL0004";
    private final String INSPECTION_WSIL = "inspection.wsil";
    private Text wsil_;
    private Button browse_;
    private TableViewerEditor wsdls_;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        parent.setToolTipText(ConsumptionUIMessages.TOOLTIP_WSIL_IMPORT_PAGE);
        helpSystem.setHelp((Control)parent, "org.eclipse.jst.ws.consumption.ui.WSIL0001");
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        composite.setLayout((Layout)gl);
        GridData gd = new GridData(1794);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        Label label = new Label(composite, 64);
        label.setText(ConsumptionUIMessages.LABEL_WSIL_URI);
        label.setLayoutData((Object)new GridData(256));
        this.wsil_ = new Text(composite, 2116);
        gd = new GridData(768);
        gd.widthHint = 256;
        this.wsil_.setLayoutData((Object)gd);
        this.wsil_.addListener(24, statusListener);
        this.wsil_.setToolTipText(ConsumptionUIMessages.TOOLTIP_WSIL_TEXT_WSIL);
        helpSystem.setHelp((Control)this.wsil_, "org.eclipse.jst.ws.consumption.ui.WSIL0002");
        this.browse_ = new Button(composite, 8);
        this.browse_.setText(ConsumptionUIMessages.LABEL_BROWSE);
        this.browse_.setLayoutData((Object)new GridData(256));
        this.browse_.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ImportWSILWidget.this.handleBrowseEvent(event);
            }
        });
        this.browse_.setToolTipText(ConsumptionUIMessages.TOOLTIP_WSIL_BUTTON_BROWSE_WSIL);
        helpSystem.setHelp((Control)this.browse_, "org.eclipse.jst.ws.consumption.ui.WSIL0003");
        Composite wsdlComposite = new Composite(composite, 0);
        wsdlComposite.setLayout((Layout)new GridLayout());
        gd = new GridData(1808);
        gd.horizontalSpan = 3;
        wsdlComposite.setLayoutData((Object)gd);
        label = new Label(wsdlComposite, 64);
        label.setText(ConsumptionUIMessages.LABEL_WSDL);
        label.setLayoutData((Object)new GridData(256));
        String[] columns = new String[]{ConsumptionUIMessages.LABEL_WSDL_URI};
        this.wsdls_ = new TableViewerEditor(wsdlComposite, columns, new ArrayList(), "http://");
        this.wsdls_.setToolTipText(ConsumptionUIMessages.TOOLTIP_WSIL_TABLE_WSDL);
        this.wsdls_.setInfopop("org.eclipse.jst.ws.consumption.ui.WSIL0004");
        return this;
    }

    public void handleBrowseEvent(Event event) {
        DialogResourceBrowser dialog = new DialogResourceBrowser(this.browse_.getShell(), null, (IFilter)new FileExtensionFilter(new String[]{"wsil"}));
        dialog.open();
        IResource res = dialog.getFirstSelection();
        if (res != null) {
            if (res instanceof IFile) {
                this.wsil_.setText(res.getFullPath().toString());
            } else {
                this.wsil_.setText(res.getFullPath().addTrailingSeparator().append("inspection.wsil").toString());
            }
        }
    }

    public IStatus getStatus() {
        if (!this.wsil_.getText().endsWith(".wsil")) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.PAGE_MSG_INVALID_WSIL_FILE_NAME);
        }
        return Status.OK_STATUS;
    }

    public void setInitialSelection(IStructuredSelection selection) {
        ArrayList<String> list = new ArrayList<String>();
        if (selection != null && !selection.isEmpty()) {
            for (Object object : selection) {
                if (object instanceof IFile && ((IFile)object).getFileExtension() != null && ((IFile)object).getFileExtension().equals("wsdl")) {
                    list.add(((IFile)object).getFullPath().toString());
                }
                if (object instanceof ServiceImpl) {
                    list.add(J2EEActionAdapterFactory.getWSILPath((ServiceImpl)((ServiceImpl)object)));
                }
                if (object instanceof ServiceRef) {
                    list.add(J2EEActionAdapterFactory.getWSILPath((ServiceRef)((ServiceRef)object)));
                }
                if (!(object instanceof WSDLResourceImpl)) continue;
                list.add(J2EEActionAdapterFactory.getWSILPath((WSDLResourceImpl)((WSDLResourceImpl)object)));
            }
        }
        this.wsdls_.setInput(list);
        this.wsdls_.refresh();
        if (list.size() > 0) {
            StringBuffer path = new StringBuffer(list.get(0).toString());
            int length = path.length();
            path = path.replace(length - 4, length, "wsil");
            this.wsil_.setText(path.toString());
        }
    }

    public Arguments getGenWSILArguments() {
        Arguments args = new Arguments();
        String wsilPath = this.wsil_.getText();
        if (wsilPath.indexOf(58) < 0) {
            args.add("-wsil", URI.createPlatformResourceURI((String)this.wsil_.getText()).toString());
        } else {
            args.add("-wsil", wsilPath);
        }
        TableItem[] items = this.wsdls_.getItems();
        int i = 0;
        while (i < items.length) {
            IResource res;
            String uri = items[i].getText(0);
            if (uri.indexOf(58) < 0 && (res = ResourceUtils.findResource((String)uri)) != null) {
                try {
                    uri = res.getLocation().toFile().toURL().toString();
                }
                catch (MalformedURLException murle) {
                    murle.getMessage();
                }
            }
            args.add("-wsdl", uri);
            ++i;
        }
        args.add("-resolvewsdl", null);
        return args;
    }
}

