/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.ui.designsession;

import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetParameters;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.OutputElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.ParameterDefinition;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.Properties;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ValueFormatHints;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignSessionUtilBase;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIExtensionManifest;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class DesignSessionUtil
extends DesignSessionUtilBase {
    private static final String sm_className;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DesignSessionUtil() {
    }

    public static Properties createDataSourcePublicProperties(String odaDataSourceId, java.util.Properties utilProps) throws OdaException {
        Property[] publicPropDefns = DesignSessionUtil.getDataSourcePublicPropertiesDefn(odaDataSourceId);
        return DesignSessionUtil.createPublicProperties(publicPropDefns, utilProps);
    }

    public static Properties createDataSetPublicProperties(String odaDataSourceId, String odaDataSetId, java.util.Properties utilProps) throws OdaException {
        Property[] publicPropDefns = DesignSessionUtil.getDataSetPublicPropertiesDefn(odaDataSourceId, odaDataSetId);
        return DesignSessionUtil.createPublicProperties(publicPropDefns, utilProps);
    }

    public static Properties createPublicProperties(Property[] publicPropDefns, java.util.Properties utilProps) {
        if (publicPropDefns == null || publicPropDefns.length == 0) {
            return null;
        }
        Properties designProps = DesignFactory.eINSTANCE.createProperties();
        for (int i = 0; i < publicPropDefns.length; ++i) {
            String propName = publicPropDefns[i].getName();
            String propValue = utilProps != null ? utilProps.getProperty(propName) : null;
            designProps.setProperty(propName, propValue);
        }
        return designProps;
    }

    public static Properties createDataSourceNonPublicProperties(String odaDataSourceId, java.util.Properties utilProps) throws OdaException {
        Property[] publicPropDefns = DesignSessionUtil.getDataSourcePublicPropertiesDefn(odaDataSourceId);
        return DesignSessionUtil.createNonPublicProperties(publicPropDefns, utilProps);
    }

    public static Properties createDataSetNonPublicProperties(String odaDataSourceId, String odaDataSetId, java.util.Properties utilProps) throws OdaException {
        Property[] publicPropDefns = DesignSessionUtil.getDataSetPublicPropertiesDefn(odaDataSourceId, odaDataSetId);
        return DesignSessionUtil.createNonPublicProperties(publicPropDefns, utilProps);
    }

    public static Properties createNonPublicProperties(Property[] publicPropDefns, java.util.Properties utilProps) {
        Properties designProps = null;
        Iterator<Object> iter = utilProps.keySet().iterator();
        while (iter.hasNext()) {
            String utilPropName = (String)iter.next();
            boolean isPublicProp = false;
            for (int i = 0; i < publicPropDefns.length; ++i) {
                if (!utilPropName.equalsIgnoreCase(publicPropDefns[i].getName())) continue;
                isPublicProp = true;
                break;
            }
            if (isPublicProp) continue;
            if (designProps == null) {
                designProps = DesignFactory.eINSTANCE.createProperties();
            }
            String propValue = utilProps.getProperty(utilPropName);
            designProps.setProperty(utilPropName, propValue);
        }
        return designProps;
    }

    public static OdaDesignSession createNewDataSetRequestSession(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        return DesignSessionUtilBase.createNewDataSetRequestSession(newDataSetName, odaDataSetId, dataSourceDesign);
    }

    public static IConnectionProfile getLinkedProfile(DataSourceDesign dataSourceDesign) throws OdaException {
        if (!dataSourceDesign.hasLinkToProfile()) {
            return null;
        }
        String linkedProfileName = dataSourceDesign.getLinkedProfileName();
        IConnectionProfile profile = OdaProfileExplorer.getInstance().getProfileByName(linkedProfileName, dataSourceDesign.getLinkedProfileStoreFile());
        if (profile == null) {
            throw new OdaException(Messages.bind((String)Messages.designSession_invalidProfileName, (Object)linkedProfileName));
        }
        return profile;
    }

    public static java.util.Properties getEffectiveDataSourceProperties(DataSourceDesign dataSourceDesign) throws OdaException {
        return DesignSessionUtilBase.getEffectiveDataSourceProperties(dataSourceDesign);
    }

    public static boolean hasValidOdaDesignUIExtension(String odaDataSourceId) {
        UIExtensionManifest manifest;
        try {
            manifest = UIManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
        }
        catch (OdaException ex) {
            manifest = null;
        }
        return manifest != null;
    }

    public static Map getProfileIdentifiers(String odaDataSourceId, File storageFile) throws OdaException {
        if (storageFile == null) {
            return OdaProfileExplorer.getInstance().getProfiles(odaDataSourceId);
        }
        return OdaProfileExplorer.getInstance().getProfiles(odaDataSourceId, storageFile);
    }

    static String validateRequestSession(DesignSessionRequest requestSession) throws OdaException {
        return DesignSessionUtil.validateRequestSessionImpl(requestSession);
    }

    static void validateDataSourceDesign(DataSourceDesign dataSourceDesign) throws OdaException {
        DesignSessionUtil.validateDataSourceDesignImpl(dataSourceDesign);
    }

    public static ResultSetColumns toResultSetColumnsDesign(IResultSetMetaData md) throws OdaException {
        String methodName = "toResultSetColumnsDesign( IResultSetMetaData )";
        if (md == null || md.getColumnCount() == 0) {
            return null;
        }
        ResultSetColumns rsColumns = DesignFactory.eINSTANCE.createResultSetColumns();
        int columnCount = md.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            DesignerLogger logger;
            ColumnDefinition columnDef = DesignFactory.eINSTANCE.createColumnDefinition();
            DataElementAttributes columnAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
            columnAttrs.setPosition(i);
            columnAttrs.setNativeDataTypeCode(md.getColumnType(i));
            ValueFormatHints formatHints = DesignFactory.eINSTANCE.createValueFormatHints();
            OutputElementAttributes outAttrs = DesignFactory.eINSTANCE.createOutputElementAttributes();
            try {
                columnAttrs.setName(md.getColumnName(i));
                columnAttrs.setNullability(DesignSessionUtil.convertResultColumnNullability(md.isNullable(i)));
                columnAttrs.setPrecision(md.getPrecision(i));
                columnAttrs.setScale(md.getScale(i));
                String columnLabel = md.getColumnLabel(i);
                outAttrs.setLabel(columnLabel);
                formatHints.setDisplaySize(md.getColumnDisplayLength(i));
                if (columnLabel != null) {
                    columnAttrs.setUiDisplayName(columnLabel);
                }
            }
            catch (UnsupportedOperationException ex) {
                logger = DesignerLogger.getInstance();
                logger.info(sm_className, "toResultSetColumnsDesign( IResultSetMetaData )", "Some optional metadata of column " + i + " are not available.", ex);
            }
            catch (OdaException odaEx) {
                logger = DesignerLogger.getInstance();
                logger.warning(sm_className, "toResultSetColumnsDesign( IResultSetMetaData )", "Some optional metadata of column " + i + " are not available.", odaEx);
            }
            columnDef.setAttributes(columnAttrs);
            outAttrs.setFormattingHints(formatHints);
            columnDef.setUsageHints(outAttrs);
            rsColumns.getResultColumnDefinitions().add((Object)columnDef);
        }
        return rsColumns;
    }

    public static DataSetParameters toDataSetParametersDesign(IParameterMetaData pmd) throws OdaException {
        return DesignSessionUtil.toDataSetParametersDesign(pmd, null);
    }

    public static DataSetParameters toDataSetParametersDesign(IParameterMetaData pmd, ParameterMode defaultMode) throws OdaException {
        if (pmd == null || pmd.getParameterCount() == 0) {
            return null;
        }
        DataSetParameters dataSetParams = DesignFactory.eINSTANCE.createDataSetParameters();
        int paramCount = pmd.getParameterCount();
        for (int i = 1; i <= paramCount; ++i) {
            ParameterDefinition paramDefn = DesignFactory.eINSTANCE.createParameterDefinition();
            ParameterMode designMode = DesignSessionUtil.toParameterModeDesign(pmd.getParameterMode(i), defaultMode);
            if (designMode != null) {
                paramDefn.setInOutMode(designMode);
            }
            DataElementAttributes paramAttrs = DesignFactory.eINSTANCE.createDataElementAttributes();
            paramAttrs.setPosition(i);
            paramAttrs.setNativeDataTypeCode(pmd.getParameterType(i));
            DesignSessionUtil.toElementOptionalAttributes(paramAttrs, pmd, i);
            paramDefn.setAttributes(paramAttrs);
            DesignSessionUtil.adjustParameterDefaultAttributes(paramDefn);
            dataSetParams.getParameterDefinitions().add((Object)paramDefn);
        }
        return dataSetParams;
    }

    public static ParameterMode toParameterModeDesign(int runtimeParamMode) {
        return DesignSessionUtil.toParameterModeDesign(runtimeParamMode, null);
    }

    public static ParameterMode toParameterModeDesign(int runtimeParamMode, ParameterMode defaultMode) {
        ParameterMode designMode = null;
        switch (runtimeParamMode) {
            case 1: {
                designMode = ParameterMode.IN_LITERAL;
                break;
            }
            case 2: {
                designMode = ParameterMode.IN_OUT_LITERAL;
                break;
            }
            case 3: {
                designMode = ParameterMode.OUT_LITERAL;
                break;
            }
            default: {
                designMode = defaultMode;
            }
        }
        return designMode;
    }

    public static ElementNullability toElementNullability(int odaNullability) {
        return DesignSessionUtil.convertResultColumnNullability(odaNullability);
    }

    public static ElementNullability convertResultColumnNullability(int columnNullability) {
        return DesignSessionUtilBase.convertResultColumnNullability(columnNullability);
    }

    public static ElementNullability convertParameterNullability(int parameterNullability) {
        return DesignSessionUtilBase.convertParameterNullability(parameterNullability);
    }

    private static void adjustParameterDefaultAttributes(ParameterDefinition paramDefn) {
        if (!$assertionsDisabled && paramDefn == null) {
            throw new AssertionError();
        }
        DataElementAttributes basicAttrs = paramDefn.getAttributes();
        if (basicAttrs == null) {
            return;
        }
        if (paramDefn.isInput() && basicAttrs.allowsNull()) {
            InputElementAttributes inputAttributes = paramDefn.getEditableInputElementAttributes();
            inputAttributes.setOptional(true);
        }
    }

    static {
        $assertionsDisabled = !DesignSessionUtil.class.desiredAssertionStatus();
        sm_className = DesignSessionUtil.class.getName();
    }
}

