/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSet;
import org.eclipse.datatools.enablement.oda.xml.impl.ResultSetMetaData;
import org.eclipse.datatools.enablement.oda.xml.util.RelationInformation;
import org.eclipse.datatools.enablement.oda.xml.util.XMLCreatorContent;

public class Query
implements IQuery {
    public static final String QUERYTEXT_TABLE_NAME_DEFN_DELIMITER = "#-TNAME-#";
    private RelationInformation relationInformation;
    private String tableName = null;
    private int maxRows = 0;
    private boolean isClosed = false;
    private XMLCreatorContent xmlContent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.impl.Query");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public Query(XMLCreatorContent xmlContent) {
        this.xmlContent = xmlContent;
    }

    public void prepare(String queryText) throws OdaException {
        this.testClosed();
        if (queryText == null) {
            throw new OdaException(Messages.getString("Query.InvalidQueryText"));
        }
        String[] temp = queryText.trim().split(QUERYTEXT_TABLE_NAME_DEFN_DELIMITER);
        if (!$assertionsDisabled && temp.length != 2) {
            throw new AssertionError();
        }
        if (temp.length != 2) {
            throw new OdaException(Messages.getString("Query.InvalidQueryText"));
        }
        this.tableName = temp[0];
        this.relationInformation = new RelationInformation(temp[1]);
    }

    public void setProperty(String name, String value) throws OdaException {
    }

    public void close() throws OdaException {
        this.isClosed = true;
    }

    public void setMaxRows(int max) throws OdaException {
        this.testClosed();
        this.maxRows = max > 0 ? max : 0;
    }

    public int getMaxRows() throws OdaException {
        this.testClosed();
        return this.maxRows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.testClosed();
        return new ResultSetMetaData(this.relationInformation, this.tableName);
    }

    public IResultSet executeQuery() throws OdaException {
        this.testClosed();
        if (this.tableName == null || this.tableName.trim().length() == 0) {
            throw new OdaException(Messages.getString("Query.QueryHasNotBeenPrepared"));
        }
        ResultSet result = new ResultSet(this.xmlContent, this.relationInformation, this.tableName, this.getMaxRows());
        return result;
    }

    public void clearInParameters() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setInt(int parameterId, int value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(String parameterName, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setString(int parameterId, String value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int findInParameter(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec() throws OdaException {
        throw new UnsupportedOperationException();
    }

    RelationInformation getRelationInformation() {
        return this.relationInformation;
    }

    public void setAppContext(Object context) throws OdaException {
        throw new UnsupportedOperationException();
    }

    private void testClosed() throws OdaException {
        if (this.isClosed) {
            throw new OdaException(Messages.getString("Query.ResultSetClosed"));
        }
    }
}

