/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.php.internal.core.documentModel.DOMModelForPHP;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.core.util.text.TextSequenceUtilities;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.FileDropAction;

public class IncludeDropAction
extends FileDropAction {
    public boolean run(DropTargetEvent dropTargetEvent, IEditorPart iEditorPart) {
        if (!(iEditorPart instanceof PHPStructuredEditor)) {
            return super.run(dropTargetEvent, iEditorPart);
        }
        PHPStructuredEditor pHPStructuredEditor = (PHPStructuredEditor)iEditorPart;
        final String[] stringArray = (String[])dropTargetEvent.data;
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < stringArray.length) {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(stringArray[n]));
            PHPFileData pHPFileData = null;
            pHPFileData = iFile != null ? PHPWorkspaceModelManager.getInstance().getModelForFile(iFile, false) : PHPWorkspaceModelManager.getInstance().getModelForFile(stringArray[n], false);
            if (pHPFileData != null) {
                arrayList.add(pHPFileData.getName());
            }
            ++n;
        }
        if (arrayList.size() != 0 && this.insert(arrayList, pHPStructuredEditor)) {
            return true;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                EditorUtility.openFilesInEditor(Arrays.asList(stringArray));
            }
        });
        return true;
    }

    private static String getPartitionType(IStructuredDocument iStructuredDocument, int n) {
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        if (iStructuredDocumentRegion == null) {
            return null;
        }
        TextSequence textSequence = PHPTextSequenceUtilities.getStatement((int)n, (IStructuredDocumentRegion)iStructuredDocumentRegion, (boolean)false);
        if (textSequence == null) {
            return null;
        }
        String string = TextSequenceUtilities.getTypeByAbsoluteOffset((TextSequence)textSequence, (int)n);
        return string;
    }

    protected boolean insert(List list, PHPStructuredEditor pHPStructuredEditor) {
        Object object;
        ISelection iSelection = pHPStructuredEditor.getSelectionProvider().getSelection();
        if (!(iSelection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection iTextSelection = (ITextSelection)iSelection;
        int n = iTextSelection.getOffset();
        boolean bl = false;
        IStructuredDocument iStructuredDocument = (IStructuredDocument)pHPStructuredEditor.getDocumentProvider().getDocument((Object)pHPStructuredEditor.getEditorInput());
        IStructuredModel iStructuredModel = StructuredModelManager.getModelManager().getModelForRead(iStructuredDocument);
        if (!(iStructuredModel instanceof DOMModelForPHP)) {
            iStructuredModel.releaseFromRead();
            return false;
        }
        int n2 = iStructuredDocument.getLineOfOffset(n);
        int n3 = -1;
        try {
            object = iStructuredDocument.getLineInformation(n2);
            String string = iStructuredDocument.get(object.getOffset(), object.getLength()).replaceAll("[\n\r]+", "");
            n3 = object.getOffset() + string.length();
        }
        catch (BadLocationException badLocationException) {}
        if (n3 > 0 && n == n3 - 1 && iStructuredDocument.getLength() >= n) {
            ++n;
        }
        boolean bl2 = bl = PHPPartitionTypes.isPHPRegularState((String)(object = IncludeDropAction.getPartitionType(iStructuredDocument, n))) || PHPPartitionTypes.isPHPQuotesState((String)object);
        if (!bl) {
            return false;
        }
        this.insert(list, iStructuredDocument, n, (DOMModelForPHP)iStructuredModel);
        iStructuredModel.releaseFromRead();
        return true;
    }

    private void insert(List list, IStructuredDocument iStructuredDocument, int n, DOMModelForPHP dOMModelForPHP) {
        PHPFileData pHPFileData = dOMModelForPHP.getFileData();
        IFile iFile = (IFile)PHPModelUtil.getResource((Object)pHPFileData);
        boolean bl = iFile != null && iFile.exists();
        IProject iProject = iFile.getProject();
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : list) {
            if (bl) {
                string = PHPModelUtil.getRelativeLocation((IProject)iProject, (String)string);
            }
            stringBuffer.append(MessageFormat.format("include_once ''{0}'';", string));
            stringBuffer.append(iStructuredDocument.getLineDelimiter());
        }
        try {
            iStructuredDocument.replace(n, 0, stringBuffer.toString());
        }
        catch (BadLocationException badLocationException) {
            PHPUiPlugin.log(badLocationException);
        }
    }
}

