/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.preferences.IStatusChangeListener;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathBlock;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class IncludePathPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.php.ui.propertyPages.IncludePathPropertyPage";
    private static final String PAGE_SETTINGS = "IncludePathPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_REVEAL_ENTRY = "select_includepath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_includepath_attribute_key";
    private IncludePathBlock fIncludePathsBlock;

    protected Control createContents(Composite composite) {
        this.noDefaultAndApplyButton();
        IProject iProject = this.getProject();
        Control control = iProject == null || !this.isPHPProject(iProject) ? this.createWithoutPHP(composite) : (!iProject.isOpen() ? this.createForClosedProject(composite) : this.createWithPHP(composite, iProject));
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    public void createControl(Composite composite) {
        super.createControl(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.include_paths");
    }

    private IDialogSettings getSettings() {
        IDialogSettings iDialogSettings = PHPUiPlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(PAGE_SETTINGS);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(PAGE_SETTINGS);
            iDialogSettings2.put(INDEX, 0);
        }
        return iDialogSettings2;
    }

    public void setVisible(boolean bl) {
        if (this.fIncludePathsBlock != null && !bl && this.fIncludePathsBlock.hasChangesInDialog()) {
            String string = PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_title");
            String string2 = PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_message");
            String[] stringArray = new String[]{PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_save"), PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_discard"), PHPUIMessages.getString("IncludePathsPropertyPage_unsavedchanges_button_ignore")};
            MessageDialog messageDialog = new MessageDialog(this.getShell(), string, null, string2, 3, stringArray, 0);
            int n = messageDialog.open();
            if (n == 0) {
                this.performOk();
            } else if (n == 1) {
                this.fIncludePathsBlock.init(this.getProject(), null);
            }
        }
        super.setVisible(bl);
    }

    private Control createWithPHP(Composite composite, IProject iProject) {
        IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer = null;
        IPreferencePageContainer iPreferencePageContainer = this.getContainer();
        if (iPreferencePageContainer instanceof IWorkbenchPreferenceContainer) {
            iWorkbenchPreferenceContainer = (IWorkbenchPreferenceContainer)iPreferencePageContainer;
        }
        this.fIncludePathsBlock = new IncludePathBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt(INDEX), false, iWorkbenchPreferenceContainer);
        this.fIncludePathsBlock.init(iProject, null);
        return this.fIncludePathsBlock.createControl(composite);
    }

    private Control createWithoutPHP(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PHPUIMessages.getString("IncludePathsPropertyPage_no_php_project_message"));
        this.fIncludePathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite composite) {
        Label label = new Label(composite, 16384);
        label.setText(PHPUIMessages.getString("IncludePathsPropertyPage_closed_project_message"));
        this.fIncludePathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable != null && iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        return null;
    }

    private boolean isPHPProject(IProject iProject) {
        try {
            return iProject.hasNature("org.eclipse.php.core.PHPNature");
        }
        catch (CoreException coreException) {
            PHPCorePlugin.log((Throwable)coreException);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fIncludePathsBlock != null) {
            this.getSettings().put(INDEX, this.fIncludePathsBlock.getPageIndex());
            if (this.fIncludePathsBlock.hasChangesInDialog()) {
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
                        IncludePathPropertyPage.this.fIncludePathsBlock.configurePHPProject(iProgressMonitor);
                    }
                };
                WorkbenchRunnableAdapter workbenchRunnableAdapter = new WorkbenchRunnableAdapter(iWorkspaceRunnable);
                workbenchRunnableAdapter.runAsUserJob(PHPUIMessages.getString("IncludePathsPropertyPage_job_title"), null);
            }
        }
        return true;
    }

    public void statusChanged(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        IncludePathPropertyPage.applyToStatusLine((DialogPage)this, iStatus);
    }

    public static void applyToStatusLine(DialogPage dialogPage, IStatus iStatus) {
        String string = iStatus.getMessage();
        switch (iStatus.getSeverity()) {
            case 0: {
                dialogPage.setMessage(string, 0);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 2: {
                dialogPage.setMessage(string, 2);
                dialogPage.setErrorMessage(null);
                break;
            }
            case 1: {
                dialogPage.setMessage(string, 1);
                dialogPage.setErrorMessage(null);
                break;
            }
            default: {
                if (string.length() == 0) {
                    string = null;
                }
                dialogPage.setMessage(null);
                dialogPage.setErrorMessage(string);
            }
        }
    }

    public void applyData(Object object) {
        Map map;
        Object v;
        if (object instanceof Map && (v = (map = (Map)object).get(DATA_REVEAL_ENTRY)) instanceof IIncludePathEntry) {
            String string;
            IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)v;
            Object v2 = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
            String string2 = string = v2 instanceof String ? (String)v2 : null;
            if (this.fIncludePathsBlock != null) {
                this.fIncludePathsBlock.setElementToReveal(iIncludePathEntry, string);
            }
        }
    }

    public void dispose() {
        this.fIncludePathsBlock.dispose();
    }
}

