/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPManualConfig;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigSerializer;
import org.eclipse.php.internal.ui.preferences.PHPManualConfigurationBlock;
import org.eclipse.php.internal.ui.preferences.PreferenceConstants;
import org.eclipse.php.internal.ui.util.PHPManual;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.php.internal.ui.util.PHPManualSiteDescriptor;

public class PHPManualFactory {
    private static PHPManual manual = null;
    private static PHPManualConfig fStoredConfig;

    private static PHPManual createManual(PHPManualSiteDescriptor pHPManualSiteDescriptor) {
        PHPManualSite pHPManualSite = pHPManualSiteDescriptor.createSite();
        return new PHPManual(pHPManualSite);
    }

    private static PHPManual createManual(PHPManualConfig pHPManualConfig) {
        PHPManualSite pHPManualSite = new PHPManualSite(pHPManualConfig.getUrl(), pHPManualConfig.getExtension());
        return new PHPManual(pHPManualSite);
    }

    public static PHPManual getManual() {
        String string = PreferenceConstants.getPreferenceStore().getString("phpManualSite");
        PHPManualConfig pHPManualConfig = PHPManualConfigSerializer.fromString(string);
        if (manual == null || !fStoredConfig.equals(string)) {
            manual = null;
            fStoredConfig = pHPManualConfig;
            PHPManualSiteDescriptor[] pHPManualSiteDescriptorArray = PHPUiPlugin.getDefault().getPHPManualSiteDescriptors();
            int n = 0;
            while (n < pHPManualSiteDescriptorArray.length) {
                if (pHPManualConfig != null && pHPManualConfig.getUrl().equals(pHPManualSiteDescriptorArray[n].getURL())) {
                    manual = PHPManualFactory.createManual(pHPManualSiteDescriptorArray[n]);
                    break;
                }
                ++n;
            }
            if (manual == null) {
                ArrayList<PHPManualConfig> arrayList = new ArrayList<PHPManualConfig>();
                PHPManualConfigurationBlock.initFromPreferences(PreferenceConstants.getPreferenceStore(), arrayList);
                if (arrayList.size() > 0) {
                    PHPManualConfig pHPManualConfig2 = PHPManualConfigurationBlock.getActiveManualSite(PreferenceConstants.getPreferenceStore(), arrayList);
                    manual = pHPManualConfig2 != null ? PHPManualFactory.createManual(pHPManualConfig2) : PHPManualFactory.createManual((PHPManualConfig)arrayList.get(0));
                } else if (pHPManualSiteDescriptorArray.length > 0) {
                    manual = PHPManualFactory.createManual(pHPManualSiteDescriptorArray[0]);
                }
            }
        }
        Assert.isNotNull((Object)manual);
        return manual;
    }
}

