/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.pathmapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathVariableManager;
import org.eclipse.php.internal.debug.core.pathmapper.BestMatchPathComparator;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.util.PHPUILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PathEntrySelectionDialog
extends TrayDialog {
    private static final Object[] EMPTY = new Object[0];
    private static final Object EXTERNAL_CONTAINER = new Object();
    private VirtualPath path;
    private PathEntry[] pathEntries;
    private PathEntry result;
    private VirtualPath ignorePathResult;
    private Font boldFont;
    protected Button selectMappingBtn;
    private TreeViewer entriesViewer;
    protected Button ignoreMappingBtn;
    private Text ignorePathText;
    private Button configurePathBtn;

    public PathEntrySelectionDialog(Shell shell, VirtualPath virtualPath, PathEntry[] pathEntryArray) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.path = virtualPath;
        this.pathEntries = pathEntryArray;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Path Mapping - Select Local Resource");
        shell.setImage(PHPDebugUIImages.get("IMG_OBJ_PATH_MAPPING"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.help.path_mapping");
    }

    protected Control createDialogArea(Composite composite) {
        FontData fontData;
        FontData[] fontDataArray;
        composite = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite.getLayout();
        gridLayout.numColumns = 2;
        this.initializeDialogUnits((Control)composite);
        FontData[] fontDataArray2 = fontDataArray = composite.getFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            fontData = fontDataArray2[n2];
            fontData.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font(composite.getFont().getDevice(), fontDataArray);
        this.selectMappingBtn = new Button(composite, 16);
        this.selectMappingBtn.setSelection(true);
        this.selectMappingBtn.setText("Select the local resource that matches the following server path:");
        fontData = new GridData();
        fontData.horizontalSpan = 2;
        this.selectMappingBtn.setLayoutData((Object)fontData);
        this.selectMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PathEntrySelectionDialog.this.selectMappingBtn.getSelection();
                PathEntrySelectionDialog.this.entriesViewer.getControl().setEnabled(bl);
                PathEntrySelectionDialog.this.ignorePathText.setEnabled(!bl);
                PathEntrySelectionDialog.this.configurePathBtn.setEnabled(!bl);
                PathEntrySelectionDialog.this.validate();
            }
        });
        Label label = new Label(composite, 0);
        fontData = new GridData();
        fontData.horizontalSpan = 2;
        fontData.horizontalIndent = this.convertWidthInCharsToPixels(4);
        fontData.verticalAlignment = 1;
        label.setLayoutData((Object)fontData);
        label.setFont(this.boldFont);
        label.setText(this.path.toString());
        this.entriesViewer = new TreeViewer(composite, 2820);
        fontData = new GridData(1808);
        fontData.horizontalSpan = 2;
        fontData.verticalIndent = this.convertHeightInCharsToPixels(1);
        fontData.horizontalIndent = this.convertWidthInCharsToPixels(2);
        fontData.heightHint = this.convertHeightInCharsToPixels(20);
        fontData.widthHint = this.convertWidthInCharsToPixels(70);
        this.entriesViewer.getControl().setLayoutData((Object)fontData);
        this.entriesViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.entriesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.entriesViewer.setSorter((ViewerSorter)new Sorter());
        this.entriesViewer.setInput((Object)this);
        this.entriesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PathEntrySelectionDialog.this.validate();
            }
        });
        this.entriesViewer.expandAll();
        this.ignoreMappingBtn = new Button(composite, 16);
        this.ignoreMappingBtn.setText("Do not map the following server path to a local resource:");
        fontData = new GridData();
        fontData.horizontalSpan = 2;
        this.ignoreMappingBtn.setLayoutData((Object)fontData);
        this.ignoreMappingBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean bl = PathEntrySelectionDialog.this.ignoreMappingBtn.getSelection();
                PathEntrySelectionDialog.this.entriesViewer.getControl().setEnabled(!bl);
                PathEntrySelectionDialog.this.ignorePathText.setEnabled(bl);
                PathEntrySelectionDialog.this.configurePathBtn.setEnabled(bl);
                PathEntrySelectionDialog.this.validate();
            }
        });
        this.ignorePathText = new Text(composite, 2056);
        this.ignorePathText.setEnabled(false);
        fontData = new GridData(768);
        fontData.horizontalIndent = this.convertWidthInCharsToPixels(2);
        fontData.widthHint = this.convertWidthInCharsToPixels(70);
        this.ignorePathText.setLayoutData((Object)fontData);
        this.ignorePathResult = this.path.clone();
        this.ignorePathText.setText(this.getIgnorePathString(this.ignorePathResult));
        this.configurePathBtn = new Button(composite, 8);
        this.configurePathBtn.setEnabled(false);
        this.configurePathBtn.setText("&Configure...");
        this.configurePathBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConfigurePathDialog configurePathDialog = new ConfigurePathDialog(PathEntrySelectionDialog.this.ignorePathResult);
                if (configurePathDialog.open() == 0) {
                    PathEntrySelectionDialog.this.ignorePathResult = configurePathDialog.getResult();
                    PathEntrySelectionDialog.this.ignorePathText.setText(PathEntrySelectionDialog.this.getIgnorePathString(PathEntrySelectionDialog.this.ignorePathResult));
                    PathEntrySelectionDialog.this.validate();
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite composite) {
        Button button = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        button.setEnabled(false);
        this.createButton(composite, 1, "&Stop Debugger", false);
    }

    private String getIgnorePathString(VirtualPath virtualPath) {
        if (virtualPath.getSegmentsCount() == this.path.getSegmentsCount()) {
            return virtualPath.toString();
        }
        return virtualPath.toString() + virtualPath.getSeparatorChar() + '*';
    }

    public PathEntry getResult() {
        return this.result;
    }

    public VirtualPath getIgnoreResult() {
        return this.ignorePathResult;
    }

    protected void validate() {
        Button button = this.getButton(0);
        button.setEnabled(false);
        this.result = null;
        if (this.selectMappingBtn.getSelection()) {
            Object object = ((IStructuredSelection)this.entriesViewer.getSelection()).getFirstElement();
            if (object instanceof PathEntry) {
                button.setEnabled(true);
                this.result = (PathEntry)object;
            }
        } else {
            button.setEnabled(true);
        }
    }

    class ConfigurePathDialog
    extends Dialog {
        private VirtualPath result;
        private Text pathText;

        protected ConfigurePathDialog(VirtualPath virtualPath) {
            super(PathEntrySelectionDialog.this.getShell());
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.result = virtualPath;
        }

        public VirtualPath getResult() {
            return this.result;
        }

        protected Control createDialogArea(Composite composite) {
            composite = (Composite)super.createDialogArea(composite);
            this.initializeDialogUnits((Control)composite);
            this.getShell().setText("Select the Path");
            this.getShell().setImage(PHPDebugUIImages.get("IMG_OBJ_PATH_MAPPING"));
            TreeViewer treeViewer = new TreeViewer(composite, 2820);
            GridData gridData = new GridData(1808);
            gridData.heightHint = this.convertHeightInCharsToPixels(15);
            gridData.widthHint = this.convertWidthInCharsToPixels(60);
            treeViewer.getControl().setLayoutData((Object)gridData);
            treeViewer.setContentProvider((IContentProvider)new ContentProvider());
            treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
            treeViewer.setInput((Object)0);
            treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                    Integer n = (Integer)((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                    if (n != null) {
                        ConfigurePathDialog.this.result = PathEntrySelectionDialog.this.path.clone();
                        int n2 = PathEntrySelectionDialog.this.path.getSegmentsCount();
                        while (n2 > n) {
                            ConfigurePathDialog.this.result.removeLastSegment();
                            --n2;
                        }
                        ConfigurePathDialog.this.pathText.setText(PathEntrySelectionDialog.this.getIgnorePathString(ConfigurePathDialog.this.result));
                    }
                }
            });
            this.pathText = new Text(composite, 2056);
            gridData = new GridData(768);
            this.pathText.setLayoutData((Object)gridData);
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.result.getSegmentsCount()));
            treeViewer.expandAll();
            return composite;
        }

        class ContentProvider
        implements ITreeContentProvider {
            ContentProvider() {
            }

            public Object[] getChildren(Object object) {
                Integer n = (Integer)object;
                if (n < PathEntrySelectionDialog.this.path.getSegmentsCount()) {
                    return new Object[]{n + 1};
                }
                return EMPTY;
            }

            public Object getParent(Object object) {
                Integer n = (Integer)object;
                if (n > 0) {
                    return n - 1;
                }
                return null;
            }

            public boolean hasChildren(Object object) {
                Integer n = (Integer)object;
                return n < PathEntrySelectionDialog.this.path.getSegmentsCount();
            }

            public Object[] getElements(Object object) {
                return this.getChildren(object);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
            }
        }

        class LabelProvider
        extends org.eclipse.jface.viewers.LabelProvider {
            private Map<String, Image> images = new HashMap<String, Image>();

            LabelProvider() {
            }

            public Image getImage(Object object) {
                Integer n = (Integer)object;
                if (n < PathEntrySelectionDialog.this.path.getSegmentsCount()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                String string = PathEntrySelectionDialog.this.path.getLastSegment();
                int n2 = string.lastIndexOf(46);
                if (n2 != -1) {
                    ImageData imageData;
                    String string2 = string.substring(n2);
                    if (this.images.containsKey(string2)) {
                        return this.images.get(string2);
                    }
                    Program program = Program.findProgram((String)string2);
                    if (program != null && (imageData = program.getImageData()) != null) {
                        Image image = new Image((Device)Display.getDefault(), imageData);
                        this.images.put(string2, image);
                        return image;
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
            }

            public String getText(Object object) {
                Integer n = (Integer)object;
                return PathEntrySelectionDialog.this.path.getSegments()[n - 1];
            }

            public void dispose() {
                Iterator<Image> iterator = this.images.values().iterator();
                while (iterator.hasNext()) {
                    iterator.next().dispose();
                }
            }
        }
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object object) {
            if (object == PathEntrySelectionDialog.this) {
                HashSet<Object> hashSet = new HashSet<Object>();
                PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
                int n = pathEntryArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PathEntry pathEntry = pathEntryArray[n2];
                    if (pathEntry.getType() == PathEntry.Type.EXTERNAL) {
                        hashSet.add(EXTERNAL_CONTAINER);
                    } else if (pathEntry.getType() == PathEntry.Type.INCLUDE_VAR || pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                        hashSet.add(pathEntry.getContainer());
                    } else if (pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                        hashSet.add(((IResource)pathEntry.getContainer()).getProject());
                    }
                    ++n2;
                }
                return hashSet.toArray();
            }
            if (object instanceof PathEntry) {
                return EMPTY;
            }
            HashSet<PathEntry> hashSet = new HashSet<PathEntry>();
            PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n3 = 0;
            while (n3 < n) {
                PathEntry pathEntry = pathEntryArray[n3];
                if (pathEntry.getType() == PathEntry.Type.EXTERNAL && object == EXTERNAL_CONTAINER) {
                    hashSet.add(pathEntry);
                } else if ((pathEntry.getType() == PathEntry.Type.INCLUDE_VAR || pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER) && pathEntry.getContainer() == object) {
                    hashSet.add(pathEntry);
                } else if (pathEntry.getType() == PathEntry.Type.WORKSPACE && ((IResource)pathEntry.getContainer()).getProject() == object) {
                    hashSet.add(pathEntry);
                }
                ++n3;
            }
            return hashSet.toArray();
        }

        public Object getParent(Object object) {
            PathEntry pathEntry;
            if (object == PathEntrySelectionDialog.this) {
                return null;
            }
            if (object instanceof PathEntry) {
                pathEntry = (PathEntry)object;
                if (pathEntry.getType() == PathEntry.Type.EXTERNAL) {
                    return EXTERNAL_CONTAINER;
                }
                if (pathEntry.getType() == PathEntry.Type.INCLUDE_VAR || pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER) {
                    return pathEntry.getContainer();
                }
                if (pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                    return ((IResource)pathEntry.getContainer()).getProject();
                }
            }
            PathEntry[] pathEntryArray = PathEntrySelectionDialog.this.pathEntries;
            int n = pathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                pathEntry = pathEntryArray[n2];
                if (pathEntry.getType() == PathEntry.Type.EXTERNAL && object == EXTERNAL_CONTAINER) {
                    return pathEntry;
                }
                if (pathEntry.getType() == PathEntry.Type.INCLUDE_VAR || pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER && pathEntry.getContainer() == object) {
                    return pathEntry;
                }
                if (pathEntry.getType() == PathEntry.Type.WORKSPACE && ((IResource)pathEntry.getContainer()).getProject() == object) {
                    return pathEntry;
                }
                ++n2;
            }
            return null;
        }

        public boolean hasChildren(Object object) {
            return !(object instanceof PathEntry);
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class LabelProvider
    extends PHPUILabelProvider {
        LabelProvider() {
        }

        public Image getImage(Object object) {
            if (object instanceof IIncludePathEntry) {
                IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                if (iIncludePathEntry.getEntryKind() == 4) {
                    return PHPPluginImages.get((String)"org.eclipse.php.ui.envvar_obj.gif");
                }
                return PHPPluginImages.get((String)"org.eclipse.php.ui.library_obj.gif");
            }
            if (object instanceof PathEntry) {
                return PHPPluginImages.get((String)"org.eclipse.php.ui.phpfile.gif");
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            VirtualPath virtualPath;
            if (object == EXTERNAL_CONTAINER) {
                return "External Files";
            }
            if (object instanceof IIncludePathEntry) {
                IIncludePathEntry iIncludePathEntry = (IIncludePathEntry)object;
                return iIncludePathEntry.getPath().toOSString();
            }
            if (!(object instanceof PathEntry)) {
                return super.getText(object);
            }
            PathEntry pathEntry = (PathEntry)object;
            String string = pathEntry.getResolvedPath();
            if (pathEntry.getType() == PathEntry.Type.WORKSPACE) {
                virtualPath = pathEntry.getAbstractPath().clone();
                virtualPath.removeFirstSegment();
                string = virtualPath.toString();
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
            }
            if (pathEntry.getType() == PathEntry.Type.INCLUDE_FOLDER || pathEntry.getType() == PathEntry.Type.INCLUDE_VAR) {
                IPath iPath;
                virtualPath = (IIncludePathEntry)pathEntry.getContainer();
                String string2 = virtualPath.getPath().toString();
                if (virtualPath.getEntryKind() == 4 && (iPath = IncludePathVariableManager.instance().resolveVariablePath(string2)) != null) {
                    string2 = iPath.toOSString();
                }
                if (string2 != null && string.startsWith(string2)) {
                    string = string.substring(string2.length());
                }
                if (string.startsWith("/")) {
                    string = string.substring(1);
                }
            }
            return string;
        }
    }

    class Sorter
    extends ViewerSorter {
        private BestMatchPathComparator comparator;

        public Sorter() {
            this.comparator = new BestMatchPathComparator(PathEntrySelectionDialog.this.path);
        }

        public int compare(Viewer viewer, Object object, Object object2) {
            if (object instanceof PathEntry && object2 instanceof PathEntry) {
                return this.comparator.compare((PathEntry)object, (PathEntry)object2);
            }
            if (object == EXTERNAL_CONTAINER) {
                return 1;
            }
            if (object instanceof IResource) {
                return -1;
            }
            return 0;
        }
    }
}

